/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import com.loox.jloox.Dimension2DDouble;
import com.loox.jloox.LooxCollapsableEdit;
import com.loox.jloox.LooxUndoableEdit;
import com.loox.jloox.LxAbstractAction;
import com.loox.jloox.LxAbstractGraph;
import com.loox.jloox.LxAbstractToggleAction;
import com.loox.jloox.LxComponent;
import com.loox.jloox.LxComponentAdapter;
import com.loox.jloox.LxComponentEvent;
import com.loox.jloox.LxContainer;
import com.loox.jloox.LxElement;
import com.loox.jloox.LxLayers;
import com.loox.jloox.Point2DDouble;
import com.loox.jloox.Resources;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public abstract class LxNonVectorial
extends LxElement
implements Serializable {
    static final String CLASS_NAME = "LxNonVectorial";
    private static final double ANGLE_360 = Math.toRadians(360.0);
    private static final double ANGLE_90 = Math.toRadians(90.0);
    private static final double THRESHOLD = 0.001;
    private static final double NO_SCALE = 1.0;
    private static boolean _sizeLimited = false;
    public static final String UNROTATE_ACTION = "un-rotate";
    public static final String SKEW_ACTION = "toggle-draw-skew";
    public static final String FIT_ACTION = "fit-to-content";
    public static final String UNSCALE_ACTION = "un-scale";
    public static final String UNSCALE_X_ACTION = "un-scale-x";
    public static final String UNSCALE_Y_ACTION = "un-scale-y";
    private static boolean acions_inited = false;
    private Metrics _metrics;
    static /* synthetic */ Class class$com$loox$jloox$LxNonVectorial$UnrotateAction;
    static /* synthetic */ Class class$com$loox$jloox$LxNonVectorial;
    static /* synthetic */ Class class$com$loox$jloox$LxNonVectorial$FitAction;
    static /* synthetic */ Class class$com$loox$jloox$LxNonVectorial$UnscaleAction;
    static /* synthetic */ Class class$com$loox$jloox$LxNonVectorial$UnscaleXAction;
    static /* synthetic */ Class class$com$loox$jloox$LxNonVectorial$UnscaleYAction;
    static /* synthetic */ Class class$com$loox$jloox$LxNonVectorial$ToggleDrawSkewAction;

    public LxNonVectorial() {
        this(CLASS_NAME, null, null, true);
    }

    LxNonVectorial(String string, LxContainer lxContainer, Rectangle2D rectangle2D, boolean bl) {
        super(string, lxContainer, rectangle2D, false);
        if (!acions_inited) {
            acions_inited = true;
            LxComponent.registerActionClass(UNROTATE_ACTION, class$com$loox$jloox$LxNonVectorial$UnrotateAction == null ? (class$com$loox$jloox$LxNonVectorial$UnrotateAction = LxNonVectorial.class$("com.loox.jloox.LxNonVectorial$UnrotateAction")) : class$com$loox$jloox$LxNonVectorial$UnrotateAction, class$com$loox$jloox$LxNonVectorial == null ? (class$com$loox$jloox$LxNonVectorial = LxNonVectorial.class$("com.loox.jloox.LxNonVectorial")) : class$com$loox$jloox$LxNonVectorial);
            LxComponent.registerActionClass(FIT_ACTION, class$com$loox$jloox$LxNonVectorial$FitAction == null ? (class$com$loox$jloox$LxNonVectorial$FitAction = LxNonVectorial.class$("com.loox.jloox.LxNonVectorial$FitAction")) : class$com$loox$jloox$LxNonVectorial$FitAction, class$com$loox$jloox$LxNonVectorial == null ? (class$com$loox$jloox$LxNonVectorial = LxNonVectorial.class$("com.loox.jloox.LxNonVectorial")) : class$com$loox$jloox$LxNonVectorial);
            LxComponent.registerActionClass(UNSCALE_ACTION, class$com$loox$jloox$LxNonVectorial$UnscaleAction == null ? (class$com$loox$jloox$LxNonVectorial$UnscaleAction = LxNonVectorial.class$("com.loox.jloox.LxNonVectorial$UnscaleAction")) : class$com$loox$jloox$LxNonVectorial$UnscaleAction, class$com$loox$jloox$LxNonVectorial == null ? (class$com$loox$jloox$LxNonVectorial = LxNonVectorial.class$("com.loox.jloox.LxNonVectorial")) : class$com$loox$jloox$LxNonVectorial);
            LxComponent.registerActionClass(UNSCALE_X_ACTION, class$com$loox$jloox$LxNonVectorial$UnscaleXAction == null ? (class$com$loox$jloox$LxNonVectorial$UnscaleXAction = LxNonVectorial.class$("com.loox.jloox.LxNonVectorial$UnscaleXAction")) : class$com$loox$jloox$LxNonVectorial$UnscaleXAction, class$com$loox$jloox$LxNonVectorial == null ? (class$com$loox$jloox$LxNonVectorial = LxNonVectorial.class$("com.loox.jloox.LxNonVectorial")) : class$com$loox$jloox$LxNonVectorial);
            LxComponent.registerActionClass(UNSCALE_Y_ACTION, class$com$loox$jloox$LxNonVectorial$UnscaleYAction == null ? (class$com$loox$jloox$LxNonVectorial$UnscaleYAction = LxNonVectorial.class$("com.loox.jloox.LxNonVectorial$UnscaleYAction")) : class$com$loox$jloox$LxNonVectorial$UnscaleYAction, class$com$loox$jloox$LxNonVectorial == null ? (class$com$loox$jloox$LxNonVectorial = LxNonVectorial.class$("com.loox.jloox.LxNonVectorial")) : class$com$loox$jloox$LxNonVectorial);
            LxComponent.registerActionClass(SKEW_ACTION, class$com$loox$jloox$LxNonVectorial$ToggleDrawSkewAction == null ? (class$com$loox$jloox$LxNonVectorial$ToggleDrawSkewAction = LxNonVectorial.class$("com.loox.jloox.LxNonVectorial$ToggleDrawSkewAction")) : class$com$loox$jloox$LxNonVectorial$ToggleDrawSkewAction, class$com$loox$jloox$LxNonVectorial == null ? (class$com$loox$jloox$LxNonVectorial = LxNonVectorial.class$("com.loox.jloox.LxNonVectorial")) : class$com$loox$jloox$LxNonVectorial);
        }
        this._metrics = null;
        this._initObjectVariables();
        if (bl) {
            this._postInitialize();
        }
    }

    public Object clone() {
        LxNonVectorial lxNonVectorial = (LxNonVectorial)super.clone();
        if (lxNonVectorial == null) {
            return null;
        }
        lxNonVectorial._initObjectVariables();
        lxNonVectorial._setMetrics(lxNonVectorial._createMetrics());
        lxNonVectorial.setSkewEnabled(this.isSkewEnabled());
        lxNonVectorial.setRotation(this.getRotation());
        return lxNonVectorial;
    }

    public void readFromJLX(InputStream inputStream, String string) throws IOException {
        super.readFromJLX(inputStream, string);
    }

    public void saveAsJLX(OutputStream outputStream) throws IOException {
        super.saveAsJLX(outputStream);
    }

    public Rectangle2D getStrokedBounds2D(Rectangle2D rectangle2D) {
        return this.getBounds2D(rectangle2D);
    }

    public static void setSizeLimited(boolean bl) {
        _sizeLimited = bl;
    }

    public static boolean isSizeLimited() {
        return _sizeLimited;
    }

    abstract Metrics _createMetrics();

    Metrics _getMetrics() {
        return this._metrics;
    }

    boolean _intersects(double d, double d2, double d3, double d4, LxLayers lxLayers, boolean bl, double d5) {
        if (this.isGhost()) {
            return false;
        }
        if (lxLayers != null && !lxLayers.intersects(this._getLayers())) {
            return false;
        }
        if (super._intersects(d, d2, d3, d4, lxLayers, bl, d5)) {
            return true;
        }
        Rectangle2D rectangle2D = this.getBounds2D();
        return rectangle2D.intersects(d, d2, d3, d4);
    }

    void _setMetrics(Metrics metrics) {
        this._metrics = metrics;
    }

    protected double getRotation() {
        if (this._metrics == null) {
            return 0.0;
        }
        return this._metrics._rotation;
    }

    protected double getScaleX() {
        if (this._metrics != null) {
            return this._metrics._scale_x;
        }
        return 1.0;
    }

    protected double getScaleY() {
        if (this._metrics != null) {
            return this._metrics._scale_y;
        }
        return 1.0;
    }

    protected boolean isSkewEnabled() {
        if (this._metrics != null) {
            return this._metrics._skew_on;
        }
        return false;
    }

    private boolean _isZoomable(LxComponent lxComponent) {
        LxContainer lxContainer = lxComponent.getParent();
        if (lxContainer == null || lxContainer instanceof LxAbstractGraph) {
            return lxComponent.isZoomable();
        }
        return this._isZoomable((LxComponent)((Object)lxContainer));
    }

    void _paint(Graphics2D graphics2D, AffineTransform affineTransform, LxLayers lxLayers, double d, boolean bl) {
        Object object;
        if (this._metrics == null) {
            return;
        }
        if (this._isZoomable(this)) {
            object = graphics2D.getTransform();
            if (!(Math.abs(((AffineTransform)object).getScaleX() * this.getWidth()) >= 2.0 && Math.abs(((AffineTransform)object).getScaleY() * this.getHeight()) >= 2.0 || Math.abs(((AffineTransform)object).getShearX() * this.getWidth()) >= 2.0 && Math.abs(((AffineTransform)object).getShearY() * this.getHeight()) >= 2.0)) {
                return;
            }
            if (LxNonVectorial.isSizeLimited() && Math.abs(((AffineTransform)object).getScaleX() * this.getWidth()) + Math.abs(((AffineTransform)object).getScaleY() * this.getHeight()) >= 16000.0) {
                return;
            }
        }
        object = this.getPaint() != null ? this.getPaint() : this.getLineColor();
        Composite composite = graphics2D.getComposite();
        float f = this.getTransparency();
        boolean bl2 = this.getPaint() instanceof TexturePaint;
        if (f == 1.0f && bl2) {
            f = 0.99f;
        }
        if (f == 0.99f && !bl2) {
            f = 1.0f;
        }
        if (f != 1.0f) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, f));
        }
        graphics2D.setPaint((Paint)object);
        try {
            this._metrics.paint(graphics2D, affineTransform);
        }
        catch (Exception exception) {
            System.err.println("Paint exception:  " + this + ":  " + exception);
        }
        if (f != 1.0f) {
            graphics2D.setComposite(composite);
        }
    }

    protected void paintElement(Graphics2D graphics2D) {
        this._metrics.draw(graphics2D);
    }

    protected void rotate(double d) {
        if (this._metrics != null) {
            this._metrics.rotate(d);
        }
    }

    protected void rotate(double d, double d2, double d3) {
        if (this._metrics != null) {
            this._metrics.rotate(d, d2, d3);
        }
    }

    public void setRotation(double d) {
        this._metrics.rotate(d - this._metrics._rotation);
    }

    protected void setScale(double d, double d2) {
        if (this._metrics != null) {
            this._metrics.setScale(d, d2);
        }
    }

    protected void setSkewEnabled(boolean bl) {
        if (this._metrics != null && bl != this.isSkewEnabled()) {
            this._metrics.toggleDrawSkew();
        }
    }

    private void _initObjectVariables() {
        this._metrics = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class UnscaleYAction
    extends LxAbstractAction
    implements Serializable {
        UnscaleYAction() {
            super(LxNonVectorial.UNSCALE_Y_ACTION, "Un-scale Y", "Remove Y scaling.", null, false);
            this._setEnabled();
            LxNonVectorial.this.addComponentListener(new LxComponentAdapter(this){
                private final /* synthetic */ UnscaleYAction this$1;
                {
                    this.this$1 = unscaleYAction;
                }

                public void componentResized(LxComponentEvent lxComponentEvent) {
                    UnscaleYAction.access$700(this.this$1);
                }
            });
        }

        public void processAction(ActionEvent actionEvent) {
            LxNonVectorial.this.setScale(LxNonVectorial.this.getScaleX(), 1.0);
        }

        private void _setEnabled() {
            this.setEnabled(Math.abs(LxNonVectorial.this.getScaleY() - 1.0) > 0.001);
        }

        static /* synthetic */ void access$700(UnscaleYAction unscaleYAction) {
            unscaleYAction._setEnabled();
        }
    }

    private final class UnscaleXAction
    extends LxAbstractAction
    implements Serializable {
        UnscaleXAction() {
            super(LxNonVectorial.UNSCALE_X_ACTION, "Un-scale X", "Remove X scaling.", null, false);
            this._setEnabled();
            LxNonVectorial.this.addComponentListener(new LxComponentAdapter(this){
                private final /* synthetic */ UnscaleXAction this$1;
                {
                    this.this$1 = unscaleXAction;
                }

                public void componentResized(LxComponentEvent lxComponentEvent) {
                    UnscaleXAction.access$600(this.this$1);
                }
            });
        }

        public void processAction(ActionEvent actionEvent) {
            LxNonVectorial.this.setScale(1.0, LxNonVectorial.this.getScaleY());
        }

        private void _setEnabled() {
            this.setEnabled(Math.abs(LxNonVectorial.this.getScaleX() - 1.0) > 0.001);
        }

        static /* synthetic */ void access$600(UnscaleXAction unscaleXAction) {
            unscaleXAction._setEnabled();
        }
    }

    private final class UnscaleAction
    extends LxAbstractAction
    implements Serializable {
        UnscaleAction() {
            super(LxNonVectorial.UNSCALE_ACTION, "Un-scale", "Remove all scaling.", null, false);
            this._setEnabled();
            LxNonVectorial.this.addComponentListener(new LxComponentAdapter(this){
                private final /* synthetic */ UnscaleAction this$1;
                {
                    this.this$1 = unscaleAction;
                }

                public void componentResized(LxComponentEvent lxComponentEvent) {
                    UnscaleAction.access$500(this.this$1);
                }
            });
        }

        public void processAction(ActionEvent actionEvent) {
            LxNonVectorial.this.setScale(1.0, 1.0);
        }

        private void _setEnabled() {
            this.setEnabled(Math.abs(LxNonVectorial.this.getScaleX() - 1.0) > 0.001 || Math.abs(LxNonVectorial.this.getScaleY() - 1.0) > 0.001);
        }

        static /* synthetic */ void access$500(UnscaleAction unscaleAction) {
            unscaleAction._setEnabled();
        }
    }

    private final class UnrotateAction
    extends LxAbstractAction
    implements Serializable {
        UnrotateAction() {
            super(LxNonVectorial.UNROTATE_ACTION, "Unrotate", "Undo the rotation.", null, false);
            this.setEnabled(Math.abs(LxNonVectorial.this.getRotation()) > 0.001);
        }

        public void processAction(ActionEvent actionEvent) {
            LxNonVectorial.this.rotate(-LxNonVectorial.this._metrics._rotation);
        }
    }

    private static final class ToggleDrawSkewEdit
    extends LooxUndoableEdit {
        private static final String DRAW_SKEW_UNDO = "toggle-draw-skewUndo";

        public ToggleDrawSkewEdit(LxNonVectorial lxNonVectorial) {
            super(lxNonVectorial, Resources.get(DRAW_SKEW_UNDO, "draw skew"));
        }

        void _undoEdit(boolean bl) {
            LxNonVectorial lxNonVectorial = (LxNonVectorial)this._getHost();
            lxNonVectorial._metrics.toggleDrawSkew(false);
        }
    }

    private final class ToggleDrawSkewAction
    extends LxAbstractToggleAction
    implements Serializable {
        ToggleDrawSkewAction() {
            super(LxNonVectorial.SKEW_ACTION, "Draw skewed", "Draw with skew when possible", null, "Draw skewed", "Draw without skew", null, false, true);
        }

        public void processAction(ActionEvent actionEvent) {
            LxNonVectorial.this.setSkewEnabled(!LxNonVectorial.this.isSkewEnabled());
        }
    }

    private static final class RotateEdit
    extends LooxCollapsableEdit {
        private static final String ROTATION_UNDO = "rotationUndo";
        private double _value;
        private double _cx;
        private double _cy;

        public RotateEdit(LxNonVectorial lxNonVectorial, double d, double d2, double d3) {
            super(lxNonVectorial, Resources.get(ROTATION_UNDO, "rotation"));
            this._value = d;
            this._cx = d2;
            this._cy = d3;
        }

        void _setValue(LooxCollapsableEdit looxCollapsableEdit) {
            this._value = ((RotateEdit)looxCollapsableEdit)._value;
        }

        void _undoEdit(boolean bl) {
            LxNonVectorial lxNonVectorial = (LxNonVectorial)this._getHost();
            double d = lxNonVectorial._metrics._rotation;
            lxNonVectorial._metrics.rotate(this._value - d, this._cx, this._cy, false);
            this._value = d;
        }
    }

    abstract class Metrics
    implements Serializable {
        private double _rotation = 0.0;
        private double _offset_x = 0.0;
        private double _offset_y = 0.0;
        private double _scale_x = 1.0;
        private double _scale_y = 1.0;
        private boolean _skew_on = false;

        public Metrics() {
            LxNonVectorial.this.addComponentListener(new LxComponentAdapter(this){
                private final /* synthetic */ Metrics this$1;
                {
                    this.this$1 = metrics;
                }

                public void componentResized(LxComponentEvent lxComponentEvent) {
                    this.this$1.recalcScale();
                }
            });
        }

        public void recalcScale() {
            Dimension2D dimension2D = this.getUnskewedSize(this._scale_x, this._scale_y);
            if (dimension2D.getWidth() == 0.0 || dimension2D.getHeight() == 0.0) {
                this._scale_y = 1.0;
                this._scale_x = 1.0;
                LxNonVectorial.this._setActionEnabled(LxNonVectorial.UNSCALE_ACTION, false);
                LxNonVectorial.this._setActionEnabled(LxNonVectorial.UNSCALE_X_ACTION, false);
                LxNonVectorial.this._setActionEnabled(LxNonVectorial.UNSCALE_Y_ACTION, false);
                return;
            }
            double d = LxNonVectorial.this.getWidth();
            double d2 = LxNonVectorial.this.getHeight();
            double d3 = d / dimension2D.getWidth();
            double d4 = d2 / dimension2D.getHeight();
            if (d3 == 1.0 && d4 == 1.0) {
                return;
            }
            if (Math.abs(this._rotation) % ANGLE_90 < 0.001) {
                AffineTransform affineTransform = new AffineTransform();
                Point2DDouble point2DDouble = new Point2DDouble(d3, d4);
                affineTransform.rotate(this._rotation);
                affineTransform.transform(point2DDouble, point2DDouble);
                this._scale_x *= Math.abs(point2DDouble.getX());
                this._scale_y *= Math.abs(point2DDouble.getY());
            } else {
                double d5 = (d - dimension2D.getWidth()) / dimension2D.getWidth();
                double d6 = (d2 - dimension2D.getHeight()) / dimension2D.getHeight();
                double d7 = Math.min(d5, d6) + 1.0;
                this._scale_x *= d7;
                this._scale_y *= d7;
            }
            this._scale_x = this._scale_x != 0.0 ? this._scale_x : 1.0;
            this._scale_y = this._scale_y != 0.0 ? this._scale_y : 1.0;
            LxNonVectorial.this._setActionEnabled(LxNonVectorial.UNSCALE_ACTION, this._scale_x != 1.0 || this._scale_y != 1.0);
            LxNonVectorial.this._setActionEnabled(LxNonVectorial.UNSCALE_X_ACTION, this._scale_x != 1.0);
            LxNonVectorial.this._setActionEnabled(LxNonVectorial.UNSCALE_Y_ACTION, this._scale_y != 1.0);
        }

        public abstract void draw(Graphics2D var1);

        public void extraScale(AffineTransform affineTransform) {
        }

        public abstract Rectangle2D getNormalBounds();

        public Dimension2D getUnskewedSize(double d, double d2) {
            Rectangle2D rectangle2D = this.getNormalBounds();
            this.updateOffset(rectangle2D);
            rectangle2D.setRect(-rectangle2D.getWidth() / 2.0, -rectangle2D.getHeight() / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight());
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.rotate(this._rotation);
            affineTransform.scale(d, d2);
            rectangle2D = affineTransform.createTransformedShape(rectangle2D).getBounds2D();
            return new Dimension2DDouble(rectangle2D.getWidth(), rectangle2D.getHeight());
        }

        public void paint(Graphics2D graphics2D, AffineTransform affineTransform) {
            Shape shape;
            Cloneable cloneable;
            if (LxNonVectorial.this.getClipComponent() != null) {
                cloneable = LxNonVectorial.this.getClipComponent();
                Shape shape2 = ((LxComponent)cloneable).getTrajectoryShape();
                if (shape2 != null) {
                    shape = graphics2D.getClip();
                    AffineTransform affineTransform2 = new AffineTransform(affineTransform);
                    affineTransform2.translate(((LxComponent)cloneable).getCenterX() - LxNonVectorial.this.getCenterX(), ((LxComponent)cloneable).getCenterY() - LxNonVectorial.this.getCenterY());
                    graphics2D.clip(affineTransform2.createTransformedShape(shape2));
                } else {
                    shape = null;
                }
            } else {
                shape = null;
            }
            this.setPaintTransform(affineTransform);
            cloneable = graphics2D.getTransform();
            graphics2D.transform(affineTransform);
            if (LxNonVectorial.this.prepaint(graphics2D)) {
                LxNonVectorial.this.paintElement(graphics2D);
            }
            LxNonVectorial.this.postpaint(graphics2D);
            graphics2D.setTransform((AffineTransform)cloneable);
            if (shape != null) {
                graphics2D.setClip(shape);
            }
        }

        public void rotate(double d, double d2, double d3) {
            this.rotate(d, d2, d3, true);
        }

        public void rotate(double d) {
            this.rotate(d, LxNonVectorial.this.getCenterX(), LxNonVectorial.this.getCenterY(), true);
        }

        public void rotate(double d, double d2, double d3, boolean bl) {
            if ((d %= ANGLE_360) == 0.0) {
                return;
            }
            if (bl && LxNonVectorial.this._undoOn()) {
                LxNonVectorial.this.startUndoEdit("rotate");
            }
            Dimension2D dimension2D = this.getUnskewedSize(this._scale_x, this._scale_y);
            this._rotation += d;
            this._rotation %= ANGLE_360;
            if (Math.abs(this._rotation % ANGLE_90) < 0.001) {
                dimension2D.setSize(0.0, 0.0);
            } else {
                dimension2D.setSize(LxNonVectorial.this.getWidth() - dimension2D.getWidth(), LxNonVectorial.this.getHeight() - dimension2D.getHeight());
            }
            Dimension2D dimension2D2 = this.getUnskewedSize(this._scale_x, this._scale_y);
            LxNonVectorial.this._setActionEnabled(LxNonVectorial.UNROTATE_ACTION, Math.abs(this._rotation) > 0.001);
            dimension2D2.setSize(dimension2D2.getWidth() + dimension2D.getWidth(), dimension2D2.getHeight() + dimension2D.getHeight());
            if (d2 != LxNonVectorial.this.getCenterX() || d3 != LxNonVectorial.this.getCenterY()) {
                double[] dArray = new double[]{LxNonVectorial.this.getCenterX(), LxNonVectorial.this.getCenterY()};
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.rotate(d, d2, d3);
                affineTransform.transform(dArray, 0, dArray, 0, 1);
                LxNonVectorial.this.setCenter(dArray[0], dArray[1]);
            }
            if (bl) {
                LxNonVectorial.this.setBounds(LxNonVectorial.this.getCenterX() - dimension2D2.getWidth() / 2.0, LxNonVectorial.this.getCenterY() - dimension2D2.getHeight() / 2.0, dimension2D2.getWidth(), dimension2D2.getHeight());
                if (LxNonVectorial.this._undoOn()) {
                    LxNonVectorial.this.addUndoEdit(new RotateEdit(LxNonVectorial.this, this._rotation - d, d2, d3));
                    LxNonVectorial.this.finishUndoEdit();
                }
            }
        }

        public void setPaintTransform(AffineTransform affineTransform) {
            if (this._skew_on) {
                Dimension2D dimension2D = this.getUnskewedSize(this._scale_x, this._scale_y);
                affineTransform.scale(LxNonVectorial.this.getWidth() / dimension2D.getWidth(), LxNonVectorial.this.getHeight() / dimension2D.getHeight());
            }
            affineTransform.rotate(this._rotation);
            affineTransform.scale(this._scale_x, this._scale_y);
            this.extraScale(affineTransform);
            affineTransform.translate(this._offset_x, this._offset_y);
        }

        public void setScale(double d, double d2) {
            if (d == this._scale_x && d2 == this._scale_y) {
                return;
            }
            Dimension2D dimension2D = this.getUnskewedSize(this._scale_x, this._scale_y);
            Dimension2D dimension2D2 = this.getUnskewedSize(d, d2);
            this._scale_x = d;
            this._scale_y = d2;
            LxNonVectorial.this.setSize(dimension2D2.getWidth() * LxNonVectorial.this.getWidth() / dimension2D.getWidth(), dimension2D2.getHeight() * LxNonVectorial.this.getHeight() / dimension2D.getHeight());
        }

        public void toggleDrawSkew() {
            this.toggleDrawSkew(true);
        }

        public void toggleDrawSkew(boolean bl) {
            Dimension2D dimension2D;
            Rectangle2D rectangle2D = LxNonVectorial.this.getStrokedBounds2D();
            this._skew_on = !this._skew_on;
            LxNonVectorial.this._setActionState(LxNonVectorial.SKEW_ACTION, this._skew_on);
            if (bl && LxNonVectorial.this._undoOn()) {
                LxNonVectorial.this.addUndoEdit(new ToggleDrawSkewEdit(LxNonVectorial.this));
            }
            if ((dimension2D = this.getUnskewedSize(this._scale_x, this._scale_y)).getWidth() != LxNonVectorial.this.getWidth() || dimension2D.getHeight() != LxNonVectorial.this.getHeight()) {
                LxNonVectorial.this.fireComponentMorphed(rectangle2D);
            }
        }

        public void unskew() {
            LxNonVectorial.this.setSize(this.getUnskewedSize(this._scale_x, this._scale_y));
        }

        public void updateOffset(Rectangle2D rectangle2D) {
            this._offset_x = -rectangle2D.getWidth() / 2.0 - rectangle2D.getX();
            this._offset_y = -rectangle2D.getHeight() / 2.0 - rectangle2D.getY();
        }
    }

    private final class FitAction
    extends LxAbstractAction
    implements Serializable {
        FitAction() {
            super(LxNonVectorial.FIT_ACTION, "Fit to content", "Resize object to content size.", null, false);
            this._setEnabled();
            LxNonVectorial.this.addComponentListener(new LxComponentAdapter(this){
                private final /* synthetic */ FitAction this$1;
                {
                    this.this$1 = fitAction;
                }

                public void componentResized(LxComponentEvent lxComponentEvent) {
                    FitAction.access$000(this.this$1);
                }
            });
        }

        public void processAction(ActionEvent actionEvent) {
            LxNonVectorial.this._metrics.unskew();
        }

        private void _setEnabled() {
            Dimension2D dimension2D = LxNonVectorial.this._metrics.getUnskewedSize(LxNonVectorial.this.getScaleX(), LxNonVectorial.this.getScaleY());
            this.setEnabled(Math.abs(dimension2D.getWidth() - LxNonVectorial.this.getWidth()) > 0.001 || Math.abs(dimension2D.getHeight() - LxNonVectorial.this.getHeight()) > 0.001);
        }

        static /* synthetic */ void access$000(FitAction fitAction) {
            fitAction._setEnabled();
        }
    }
}

