/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox;

import java.io.Serializable;
import java.util.NoSuchElementException;

final class Storage
implements Serializable {
    private int _last_index = 0;
    private Object[] _data;
    private int _count;
    private final int _increment;

    public Storage(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this._data = new Object[n];
        this._increment = n2;
    }

    public Storage(int n) {
        this(n, 0);
    }

    public Storage() {
        this(10);
    }

    public void addElement(Object object) {
        this.ensureCapacity(this._count + 1);
        this._data[this._count++] = object;
    }

    public int capacity() {
        return this._data.length;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    public void copyInto(Object[] objectArray) {
        System.arraycopy(this._data, 0, objectArray, 0, this._count);
    }

    public Object elementAt(int n) {
        if (n >= this._count) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this._count);
        }
        try {
            return this._data[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n + " < 0");
        }
    }

    public void ensureCapacity(int n) {
        int n2 = this._data.length;
        if (n > n2) {
            int n3;
            Object[] objectArray = this._data;
            int n4 = n3 = this._increment > 0 ? n2 + this._increment : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this._data = new Object[n3];
            System.arraycopy(objectArray, 0, this._data, 0, this._count);
        }
    }

    public Object firstElement() {
        if (this._count == 0) {
            throw new NoSuchElementException();
        }
        return this._data[0];
    }

    public int indexOf(Object object) {
        int n;
        int n2 = this._count;
        Object[] objectArray = this._data;
        int n3 = -2;
        while (n3 < 3) {
            n = this._last_index + n3;
            if (n >= 0 && n < n2 && object == objectArray[n]) {
                this._last_index = n;
                return n;
            }
            ++n3;
        }
        n = 0;
        while (n < n2) {
            if (object == objectArray[n]) {
                this._last_index = n;
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void insertElementAt(Object object, int n) {
        if (n >= this._count + 1) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this._count);
        }
        this.ensureCapacity(this._count + 1);
        System.arraycopy(this._data, n, this._data, n + 1, this._count - n);
        this._data[n] = object;
        ++this._count;
    }

    public boolean isEmpty() {
        return this._count == 0;
    }

    public Object lastElement() {
        if (this._count == 0) {
            throw new NoSuchElementException();
        }
        return this._data[this._count - 1];
    }

    public void removeElementAt(int n) {
        if (n >= this._count) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this._count);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this._count - n - 1;
        if (n2 > 0) {
            System.arraycopy(this._data, n + 1, this._data, n, n2);
        }
        --this._count;
        this._data[this._count] = null;
    }

    public boolean removeElement(Object object) {
        int n = this.indexOf(object);
        if (n >= 0) {
            this.removeElementAt(n);
            return true;
        }
        return false;
    }

    public void removeAllElements() {
        int n = 0;
        while (n < this._count) {
            this._data[n] = null;
            ++n;
        }
        this._count = 0;
    }

    public int size() {
        return this._count;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this._count];
        System.arraycopy(this._data, 0, objectArray, 0, this._count);
        return objectArray;
    }
}

