/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox.layout;

import com.loox.jloox.LxAbstractLink;
import com.loox.jloox.LxAbstractStyle;
import com.loox.jloox.LxComponent;
import com.loox.jloox.LxContainer;
import com.loox.jloox.LxLayoutManager;
import com.loox.jloox.LxSaveUtils;
import com.loox.jloox.layout.LxTierNode;
import com.loox.jloox.layout.Resources;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LxTierLayout
extends LxLayoutManager {
    private static final int NOT_ROUTED = -1;
    static final String CLASS_NAME = "LxTierLayout";
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int NONE = 0;
    public static final int INTRA_TIER = 1;
    public static final int ADJACENT_TIER = 2;
    public static final int SKIP_TIER = 3;
    public final double[] WEIGHT_PRIORITY = new double[]{5.0, 3.0, 1.0};
    private int _orientation = 0;
    private double _interTierGap = 50.0;
    private double _interNodeGap = 50.0;
    private int _niters = 5;
    private boolean _useObjectsSizes = false;
    private boolean _beautifySpacing = false;
    private double _skipLinkSpacing = 4.0;
    private double _intraLinkSpacing = 4.0;
    private boolean _fitToBounds = false;
    private int[] _priorities = new int[]{0, 0, 0};
    private double[] _prioritiesWeight = new double[]{1.0, 1.0, 1.0};
    private LxAbstractStyle[] _linkStyles = new LxAbstractStyle[4];
    private Tier[] _tiers;
    Rectangle _nodesBounds = null;
    private final Hashtable _nodes = new Hashtable();
    private Comparator _xComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            LxTierNode lxTierNode = (LxTierNode)object;
            LxTierNode lxTierNode2 = (LxTierNode)object2;
            return (int)(lxTierNode.getComponentCenterX() - lxTierNode2.getComponentCenterX());
        }
    };
    private Comparator _wComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            LxTierNode lxTierNode = (LxTierNode)object;
            LxTierNode lxTierNode2 = (LxTierNode)object2;
            double d = lxTierNode.getWeight() - lxTierNode2.getWeight();
            if (d < 0.0) {
                return -1;
            }
            if (d > 0.0) {
                return 1;
            }
            return 0;
        }
    };
    private static final String ACTION = "tier-settings-dialog";
    private static final String DIALOG_TITLE = "tier-settings-dialogTitle";
    private static final String DIALOG_INTER_TIER_GAP_LABEL = "tier-settings-dialogInterTierLabel";
    private static final String DIALOG_INTER_NODE_GAP_LABEL = "tier-settings-dialogInterNodeLabel";
    private static final String DIALOG_ITERATIONS_LABEL = "tier-settings-dialogIterationsLabel";
    private static final String DIALOG_USE_OBECTS_SIZES_LABEL = "tier-settings-dialogUseObjectsSizesLabel";
    private static final String DIALOG_BEAUTIFY_SPACING_LABEL = "tier-settings-dialogBeautifySpacingLabel";
    private static final String DIALOG_FIT_TO_BOUNDS_LABEL = "tier-settings-dialogFitToBoundsLabel";
    private static final String DIALOG_PRIORITIES_TITLE_LABEL = "tier-settings-dialogPrioritiesLabel";
    private static final String DIALOG_PRIORITY1_LABEL = "tier-settings-dialogPriority1Label";
    private static final String DIALOG_PRIORITY2_LABEL = "tier-settings-dialogPriority2Label";
    private static final String DIALOG_PRIORITY3_LABEL = "tier-settings-dialogPriority3Label";
    private static final String DIALOG_ORIENTATION_LABEL = "tier-settings-dialogOrientationLabel";
    private static final String DIALOG_INTRA_LINK_SPACING_LABEL = "tier-settings-dialogIntraLinkSpacingLabel";
    private static final String DIALOG_SKIP_LINK_SPACING_LABEL = "tier-settings-dialogSkipLinkSpacingLabel";

    private double getWidth(Rectangle rectangle) {
        if (this.getOrientation() == 0) {
            return rectangle.getWidth();
        }
        return rectangle.getHeight();
    }

    private double getHeight(Rectangle rectangle) {
        if (this.getOrientation() == 0) {
            return rectangle.getHeight();
        }
        return rectangle.getWidth();
    }

    private double getX(Rectangle rectangle) {
        if (this.getOrientation() == 0) {
            return rectangle.getX();
        }
        return rectangle.getY();
    }

    private double getY(Rectangle rectangle) {
        if (this.getOrientation() == 0) {
            return rectangle.getY();
        }
        return rectangle.getX();
    }

    public void setOrientation(int n) {
        this._orientation = n;
    }

    public int getOrientation() {
        return this._orientation;
    }

    public void setInterTierGap(double d) {
        this._interTierGap = d;
    }

    public double getInterTierGap() {
        return this._interTierGap;
    }

    public void setIntraLinkSpacing(double d) {
        this._intraLinkSpacing = d;
    }

    public double getIntraLinkSpacing() {
        return this._intraLinkSpacing;
    }

    public void setSkipLinkSpacing(double d) {
        this._skipLinkSpacing = d;
    }

    public double getSkipLinkSpacing() {
        return this._skipLinkSpacing;
    }

    public void setInterNodeGap(double d) {
        this._interNodeGap = d;
    }

    public double getIterationCount() {
        return this._niters;
    }

    public void setIterationCount(int n) {
        this._niters = n;
    }

    public double getInterNodeGap() {
        return this._interNodeGap;
    }

    public void setUseObjectsSizes(boolean bl) {
        this._useObjectsSizes = bl;
    }

    public boolean isUseObjectsSizes() {
        return this._useObjectsSizes;
    }

    public void setBeautifySpacing(boolean bl) {
        this._beautifySpacing = bl;
    }

    public boolean isBeautifySpacing() {
        return this._beautifySpacing;
    }

    public void setFitToBounds(boolean bl) {
        this._fitToBounds = bl;
    }

    public boolean isFitToBounds() {
        return this._fitToBounds;
    }

    public void setPriority(int n, int n2) {
        int n3 = 0;
        boolean bl = true;
        if (n < this._priorities.length && n >= 0) {
            if (n2 == 0) {
                n3 = n;
                while (n3 < this._priorities.length) {
                    this._priorities[n3] = 0;
                    this._prioritiesWeight[n3] = 1.0;
                    ++n3;
                }
            }
            n3 = 0;
            while (n3 < n) {
                if (this._priorities[n3] == 0) {
                    bl = false;
                }
                ++n3;
            }
            if (bl) {
                this._priorities[n] = n2;
                this._prioritiesWeight[n] = this.WEIGHT_PRIORITY[n];
            } else {
                this._priorities[n] = 0;
                this._prioritiesWeight[n] = 1.0;
            }
            n3 = 0;
            while (n3 < n) {
                if (this._priorities[n3] == n2) {
                    this.setPriority(n3, 0);
                }
                ++n3;
            }
        } else {
            throw new IllegalArgumentException("Wrong Priority number - must be between 0 and 2");
        }
    }

    public String priorityToString(int n) {
        String string = "";
        if (n == 1) {
            string = "intra";
        } else if (n == 2) {
            string = "adjacent";
        } else if (n == 3) {
            string = "skip";
        } else if (n == 0) {
            string = "none";
        }
        return string;
    }

    public int getPriority(int n) {
        if (n < this._priorities.length && n >= 0) {
            return this._priorities[n];
        }
        throw new IllegalArgumentException("Wrong Priority number - must be between 0 and 2");
    }

    public double getPriorityWeight(int n) {
        double d = 1.0;
        int n2 = 0;
        while (n2 < this._priorities.length) {
            if (this._priorities[n2] == n) {
                d = this._prioritiesWeight[n2];
                break;
            }
            d = 1.0;
            ++n2;
        }
        return d;
    }

    public void setPriorityWeight(int n, double d) {
        int n2 = 0;
        while (n2 < this._priorities.length) {
            if (this._priorities[n2] == n) {
                this._prioritiesWeight[n2] = d;
            }
            ++n2;
        }
    }

    public void setLinkStyle(int n, LxAbstractStyle lxAbstractStyle) {
        if (n > 0 && n < 4) {
            this._linkStyles[n] = lxAbstractStyle;
        }
    }

    public LxAbstractStyle getLinkStyle(int n) {
        if (n > 0 && n < 4) {
            return this._linkStyles[n];
        }
        return null;
    }

    public LxTierLayout() {
    }

    public LxTierLayout(LxContainer lxContainer) {
        super(lxContainer);
    }

    public LxTierLayout(Rectangle2D rectangle2D) {
        super(rectangle2D);
    }

    public LxTierLayout(LxContainer lxContainer, Rectangle2D rectangle2D) {
        super(lxContainer, rectangle2D);
    }

    public void add(LxComponent lxComponent, int n) {
        super.add(lxComponent);
        LxTierNode lxTierNode = new LxTierNode(this, lxComponent, n);
        this._nodes.put(lxComponent, lxTierNode);
    }

    public void remove(LxComponent lxComponent) {
        this._nodes.remove(lxComponent);
        try {
            super.remove(lxComponent);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void removeAll() {
        super.removeAll();
        this._tiers = null;
        this._nodes.clear();
    }

    public LxTierNode getNode(LxComponent lxComponent) {
        if (lxComponent == null) {
            return null;
        }
        return (LxTierNode)this._nodes.get(lxComponent);
    }

    public void add(LxComponent lxComponent) {
        throw new IllegalArgumentException("Use the add(LxComponent,int) method");
    }

    public double getMaxWidthTier() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        while (n < this._tiers.length) {
            Tier tier = this._tiers[n];
            d = 0.0;
            if (tier.size() > 0) {
                if (!this.isUseObjectsSizes()) {
                    d3 = tier.getNode(0).getComponentWidth();
                    d4 = tier.getNode(tier.size() - 1).getComponentWidth();
                    d = (double)(tier.size() - 1) * this._interNodeGap + d3 / 2.0 + d4 / 2.0;
                } else {
                    int n2 = 0;
                    while (n2 < tier.size()) {
                        LxTierNode lxTierNode = tier.getNode(n2);
                        d += lxTierNode.getComponentWidth() + this._interNodeGap;
                        ++n2;
                    }
                    d -= this._interNodeGap;
                }
                if (d2 < d) {
                    d2 = d;
                }
            }
            ++n;
        }
        return d2;
    }

    private double getYTier(Tier tier) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        int n2 = 0;
        while (n2 < this._tiers.length) {
            if (this._tiers[n2] == tier) {
                n = n2;
            }
            d2 += this._tiers[n2].getMaxHeight();
            ++n2;
        }
        if (this.isFitToBounds()) {
            if (this._tiers.length == 1) {
                d = this.getHeight(this.getBounds()) / 2.0;
            } else {
                double d3 = (this.getHeight(this.getBounds()) - d2) / (double)(this._tiers.length - 1);
                if (n == 0) {
                    d = this.getY(this.getBounds()) + tier.getMaxHeight() / 2.0;
                } else {
                    Tier tier2 = this._tiers[n - 1];
                    d = this.getYTier(tier2) + tier2.getMaxHeight() / 2.0 + d3 + tier.getMaxHeight() / 2.0;
                }
            }
        } else if (!this.isUseObjectsSizes()) {
            d = this.getY(this.getBounds()) + (double)n * this._interTierGap + this._tiers[0].getMaxHeight() / 2.0;
        } else if (n == 0) {
            d = this.getY(this.getBounds()) + tier.getMaxHeight() / 2.0;
        } else {
            Tier tier3 = this._tiers[n - 1];
            d = this.getYTier(tier3) + tier3.getMaxHeight() / 2.0 + this._interTierGap + tier.getMaxHeight() / 2.0;
        }
        return d;
    }

    private void placeNodes(Tier tier, double d) {
        Object object;
        int n;
        double d2 = this.getY(this.getBounds());
        double d3 = this.getX(this.getBounds());
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        if (tier.size() == 0) {
            return;
        }
        if (this.isFitToBounds()) {
            d7 = tier.getNode(0).getComponentWidth();
        } else {
            n = 0;
            while (n < this._tiers.length) {
                LxTierNode lxTierNode;
                object = this._tiers[n];
                if (((Tier)object).size() > 0 && d7 < (lxTierNode = ((Tier)object).getNode(0)).getComponentWidth()) {
                    d7 = lxTierNode.getComponentWidth();
                }
                ++n;
            }
        }
        d5 = this.getYTier(tier);
        n = 0;
        while (n < tier.size()) {
            object = tier.getNode(n);
            d6 = ((LxTierNode)object).getComponentWidth();
            if (!this.isUseObjectsSizes()) {
                d4 = d3 + (double)n * d + d7 / 2.0;
                if (!((LxTierNode)object).isFixedLocation()) {
                    ((LxTierNode)object).setComponentCenterX(d4);
                }
            } else if (n == 0) {
                d4 = d3 + d7 / 2.0;
                if (!((LxTierNode)object).isFixedLocation()) {
                    ((LxTierNode)object).setComponentCenterX(d4);
                }
                d6 = ((LxTierNode)object).getComponentWidth();
                d4 += d6 / 2.0 + d;
            } else {
                if (!((LxTierNode)object).isFixedLocation()) {
                    ((LxTierNode)object).setComponentX(d4);
                }
                d6 = ((LxTierNode)object).getComponentWidth();
                d4 += d + d6;
            }
            if (!((LxTierNode)object).isFixedLocation()) {
                ((LxTierNode)object).setComponentCenterY(d5);
            }
            ++n;
        }
    }

    private double computesInterNodeGap(Tier tier, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n = 0;
        while (n < tier.size()) {
            LxTierNode lxTierNode = tier.getNode(n);
            d2 += lxTierNode.getComponentWidth();
            ++n;
        }
        if (tier.size() > 1) {
            if (!this.isUseObjectsSizes()) {
                d4 = tier.getNode(0).getComponentWidth();
                d5 = tier.getNode(tier.size() - 1).getComponentWidth();
                d3 = (d - d4 / 2.0 - d5 / 2.0) / (double)(tier.size() - 1);
            } else {
                d3 = (d - d2) / (double)(tier.size() - 1);
            }
        } else if (tier.size() == 1) {
            d3 = 0.0;
        }
        return d3;
    }

    void arrangeNodes(Tier tier) {
        double d = 0.0;
        if (this.isFitToBounds()) {
            d = this.computesInterNodeGap(tier, this.getWidth(this.getBounds()));
            this.placeNodes(tier, d);
        } else if (this.isBeautifySpacing()) {
            d = this.computesInterNodeGap(tier, this.getMaxWidthTier());
            this.placeNodes(tier, d);
        } else {
            this.placeNodes(tier, this._interNodeGap);
        }
        this.updateNodeBounds();
    }

    private void clearRouting(Tier tier) {
        int n = 0;
        while (n < tier.size()) {
            LxTierNode lxTierNode = tier.getNode(n);
            int n2 = 0;
            while (n2 < lxTierNode.getLinkCount()) {
                NodeLink nodeLink = lxTierNode.getLink(n2);
                nodeLink.setRouteMeter(-1);
                ++n2;
            }
            ++n;
        }
    }

    private int routIntraTierLink(NodeLink nodeLink, Tier tier) {
        int n = nodeLink.getStartIndex();
        int n2 = nodeLink.getEndIndex();
        LxAbstractLink lxAbstractLink = nodeLink.getComponent();
        if (nodeLink.isRouted()) {
            return nodeLink.getRouteMeter();
        }
        int n3 = 0;
        int n4 = nodeLink.getMinIndex();
        while (n4 < nodeLink.getMaxIndex()) {
            if (n4 != 0) {
                LxTierNode lxTierNode = tier.getNode(n4 - 1);
                int n5 = 0;
                while (n5 < lxTierNode.getLinkCount()) {
                    NodeLink nodeLink2 = lxTierNode.getLink(n5);
                    if (nodeLink2.getType() == 1) {
                        if (nodeLink2.isRouted()) {
                            if (nodeLink2.hasSameNodes(nodeLink) || nodeLink2.isInside(nodeLink) || nodeLink2.intersects(nodeLink)) {
                                n3 = Math.max(nodeLink2.getRouteMeter() + 1, n3);
                            }
                        } else if (nodeLink2.isInside(nodeLink) && !nodeLink2.hasSameNodes(nodeLink)) {
                            n3 = Math.max(this.routIntraTierLink(nodeLink2, tier) + 1, n3);
                        }
                    }
                    ++n5;
                }
            }
            ++n4;
        }
        nodeLink.setRouteMeter(n3);
        return nodeLink.getRouteMeter();
    }

    public void routeLinks() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this._tiers.length) {
            Tier tier = this._tiers[n3];
            this.clearRouting(tier);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this._tiers.length) {
            Tier tier = this._tiers[n4];
            int n5 = 0;
            while (n5 < tier.size()) {
                LxTierNode lxTierNode = tier.getNode(n5);
                int n6 = 0;
                while (n6 < lxTierNode.getLinkCount()) {
                    NodeLink nodeLink = lxTierNode.getLink(n6);
                    if (nodeLink.getType() == 1 && !nodeLink.isRouted()) {
                        this.routIntraTierLink(nodeLink, tier);
                    } else if (nodeLink.getType() == 3 && !nodeLink.isRouted()) {
                        if (nodeLink.isLeft()) {
                            nodeLink.setRouteMeter(++n);
                        } else {
                            nodeLink.setRouteMeter(++n2);
                        }
                    } else if (nodeLink.getType() == 2 && !nodeLink.isRouted()) {
                        nodeLink.setRouteMeter(0);
                    }
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
    }

    private void setAllIndexes(Tier tier) {
        int n = 0;
        while (n < tier.size()) {
            LxTierNode lxTierNode = tier.getNode(n);
            int n2 = lxTierNode.getIndex();
            if (lxTierNode.isFixedOrder() || lxTierNode.isFixedLocation()) {
                tier.removeNode(lxTierNode);
                tier.insertNode(n2 - 1, lxTierNode);
            } else {
                tier.setNode(n, lxTierNode);
                lxTierNode.setIndex(n + 1);
            }
            ++n;
        }
    }

    public int computeAllCrossings() {
        int n = 0;
        int n2 = 0;
        while (n2 < this._tiers.length) {
            Tier tier = this._tiers[n2];
            int n3 = this.computeCrossings(tier);
            n += n3;
            ++n2;
        }
        return n / 2;
    }

    private int intraIntraCrossings(NodeLink nodeLink, NodeLink nodeLink2) {
        int n = 0;
        int n2 = nodeLink.getMinIndex();
        int n3 = nodeLink.getMaxIndex();
        int n4 = nodeLink2.getMinIndex();
        int n5 = nodeLink2.getMaxIndex();
        if (n3 - n2 == 1 || n5 - n4 == 1) {
            n = 0;
        } else if (n2 < n4 && n3 > n4 && n3 < n5) {
            n = 1;
        }
        return n;
    }

    private int intraAdjacentCrossings(NodeLink nodeLink, NodeLink nodeLink2) {
        int n = 0;
        int n2 = -1;
        int n3 = nodeLink.getMinIndex();
        int n4 = nodeLink.getMaxIndex();
        if (nodeLink2.getStart().getTier() == nodeLink.getStart().getTier()) {
            n2 = nodeLink2.getStartIndex();
        } else if (nodeLink2.getEnd().getTier() == nodeLink.getStart().getTier()) {
            n2 = nodeLink2.getEndIndex();
        }
        if (n2 != n3 && n2 != n4 && n2 > n3 && n2 < n4) {
            n = 1;
        }
        return n;
    }

    private int adjacentAdjacentCrossings(int n, NodeLink nodeLink, NodeLink nodeLink2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        if (nodeLink.getStart().getTier() == n) {
            n5 = nodeLink.getStartIndex();
            n4 = nodeLink.getEndIndex();
        } else {
            n5 = nodeLink.getEndIndex();
            n4 = nodeLink.getStartIndex();
        }
        if (nodeLink2.getStart().getTier() == n) {
            n3 = nodeLink2.getStartIndex();
            n2 = nodeLink2.getEndIndex();
        } else {
            n3 = nodeLink2.getEndIndex();
            n2 = nodeLink2.getStartIndex();
        }
        if (n5 < n3 && n2 < n4 || n3 < n5 && n4 < n2) {
            n6 = 1;
        }
        return n6;
    }

    private int skipSkipCrossings(int n, NodeLink nodeLink, NodeLink nodeLink2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        if (nodeLink.getStart().getTier() == n) {
            n5 = nodeLink.getStartIndex();
            n4 = nodeLink.getEndIndex();
        } else {
            n5 = nodeLink.getEndIndex();
            n4 = nodeLink.getStartIndex();
        }
        if (nodeLink2.getStart().getTier() == n) {
            n3 = nodeLink2.getStartIndex();
            n2 = nodeLink2.getEndIndex();
        } else {
            n3 = nodeLink2.getEndIndex();
            n2 = nodeLink2.getStartIndex();
        }
        if (n3 > n5 && n2 < n4 || n5 > n3 && n4 < n2) {
            n6 = 1;
        }
        return n6;
    }

    private int computeCrossings(Tier tier) {
        int n = 0;
        Vector<NodeLink> vector = new Vector<NodeLink>();
        int n2 = -1;
        int n3 = 0;
        this.setAllIndexes(tier);
        int n4 = 0;
        while (n4 < tier.size()) {
            LxTierNode lxTierNode = tier.getNode(n4);
            int n5 = 0;
            while (n5 < lxTierNode.getLinkCount()) {
                vector.add(lxTierNode.getLink(n5));
                ++n5;
            }
            n2 = lxTierNode.getTier();
            ++n4;
        }
        int n6 = 0;
        while (n6 < vector.size()) {
            NodeLink nodeLink = (NodeLink)vector.get(n6);
            int n7 = nodeLink.getType();
            switch (n7) {
                case 1: {
                    int n8;
                    NodeLink nodeLink2;
                    n3 = 0;
                    while (n3 < vector.size()) {
                        nodeLink2 = (NodeLink)vector.get(n3);
                        n8 = nodeLink2.getType();
                        if (nodeLink2 != nodeLink) {
                            switch (n8) {
                                case 1: {
                                    n = (int)((double)n + (double)this.intraIntraCrossings(nodeLink, nodeLink2) * this.getPriorityWeight(1) * this.getPriorityWeight(1));
                                    break;
                                }
                                case 2: {
                                    n = (int)((double)n + (double)this.intraAdjacentCrossings(nodeLink, nodeLink2) * this.getPriorityWeight(1) * this.getPriorityWeight(2));
                                    break;
                                }
                                case 3: {
                                    break;
                                }
                            }
                        }
                        ++n3;
                    }
                    break;
                }
                case 2: {
                    int n8;
                    NodeLink nodeLink2;
                    n3 = 0;
                    while (n3 < vector.size()) {
                        nodeLink2 = (NodeLink)vector.get(n3);
                        n8 = nodeLink.getType();
                        if (nodeLink2 != nodeLink) {
                            switch (n8) {
                                case 1: {
                                    n = (int)((double)n + (double)this.intraAdjacentCrossings(nodeLink2, nodeLink) * this.getPriorityWeight(1) * this.getPriorityWeight(2));
                                    break;
                                }
                                case 2: {
                                    n = (int)((double)n + (double)this.adjacentAdjacentCrossings(n2, nodeLink, nodeLink2) * this.getPriorityWeight(2) * this.getPriorityWeight(2));
                                    break;
                                }
                                case 3: {
                                    break;
                                }
                            }
                        }
                        ++n3;
                    }
                    break;
                }
                case 3: {
                    int n8;
                    NodeLink nodeLink2;
                    n3 = 0;
                    while (n3 < vector.size()) {
                        nodeLink2 = (NodeLink)vector.get(n3);
                        n8 = nodeLink.getType();
                        if (nodeLink2 != nodeLink) {
                            switch (n8) {
                                case 1: {
                                    break;
                                }
                                case 2: {
                                    break;
                                }
                                case 3: {
                                    n = (int)((double)n + (double)this.skipSkipCrossings(n2, nodeLink, nodeLink2) * this.getPriorityWeight(3) * this.getPriorityWeight(3));
                                    break;
                                }
                            }
                        }
                        ++n3;
                    }
                    break;
                }
            }
            ++n6;
        }
        return n / 2;
    }

    void updateNodeBounds() {
        this._nodesBounds = null;
        Enumeration enumeration = this._nodes.elements();
        while (enumeration.hasMoreElements()) {
            LxTierNode lxTierNode = (LxTierNode)enumeration.nextElement();
            LxComponent lxComponent = lxTierNode.getComponent();
            if (this._nodesBounds == null) {
                this._nodesBounds = new Rectangle(lxComponent.getBounds());
                continue;
            }
            this._nodesBounds.add(lxComponent.getBounds());
        }
    }

    private Tier sortTier(Tier tier, Comparator comparator) {
        Tier tier2 = new Tier(this);
        int n = 0;
        while (n < tier.size()) {
            tier2.addNode(tier.getNode(n));
            ++n;
        }
        tier2.sort(comparator);
        return tier2;
    }

    public void updatePositions() {
        int n = 0;
        while (n < this._tiers.length) {
            Tier tier = this._tiers[n];
            this.arrangeNodes(tier);
            ++n;
        }
        this.routeLinks();
    }

    public void updateWeight() {
        int n = 0;
        while (n < this._tiers.length) {
            Tier tier = this._tiers[n];
            this.setAllIndexes(tier);
            ++n;
        }
        int n2 = 0;
        while (n2 < this._tiers.length) {
            Tier tier = this._tiers[n2];
            int n3 = 0;
            while (n3 < tier.size()) {
                LxTierNode lxTierNode = tier.getNode(n3);
                lxTierNode.computeWeight();
                ++n3;
            }
            ++n2;
        }
    }

    boolean isOrdered(Tier tier) {
        double d = 0.0;
        int n = 0;
        while (n < tier.size() - 1) {
            LxTierNode lxTierNode = tier.getNode(n);
            if (lxTierNode.getWeight() < d) {
                return false;
            }
            d = lxTierNode.getWeight();
            ++n;
        }
        return true;
    }

    private boolean reverseSameWeight(Tier tier) {
        boolean bl = false;
        int n = 0;
        while (n < tier.size() - 1) {
            LxTierNode lxTierNode = tier.getNode(n);
            LxTierNode lxTierNode2 = tier.getNode(n + 1);
            if (lxTierNode.getWeight() == lxTierNode2.getWeight()) {
                tier.setNode(n, lxTierNode2);
                tier.setNode(n + 1, lxTierNode);
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private void layout() {
        Thread thread = new Thread(){

            public void run() {
                boolean bl = false;
                int n = 0;
                LxTierLayout.this.updateWeight();
                int n2 = 0;
                while (n2 < LxTierLayout.this._niters) {
                    int n3;
                    int n4;
                    int n5;
                    do {
                        bl = false;
                        n5 = 0;
                        while (n5 < LxTierLayout.this._tiers.length) {
                            Tier tier = LxTierLayout.this._tiers[n5];
                            Tier tier2 = LxTierLayout.this.sortTier(tier, LxTierLayout.this._wComparator);
                            n4 = LxTierLayout.this.computeAllCrossings();
                            ((LxTierLayout)LxTierLayout.this)._tiers[n5] = tier2;
                            LxTierLayout.this.updateWeight();
                            n3 = LxTierLayout.this.computeAllCrossings();
                            if (n3 < n4) {
                                bl = true;
                            } else {
                                ((LxTierLayout)LxTierLayout.this)._tiers[n5] = tier;
                                LxTierLayout.this.updateWeight();
                            }
                            ++n5;
                        }
                    } while (bl && ++n < LxTierLayout.this._niters);
                    n5 = 0;
                    int n6 = 0;
                    while (n6 < LxTierLayout.this._tiers.length) {
                        int n7 = LxTierLayout.this.computeAllCrossings();
                        n4 = 0;
                        n4 = LxTierLayout.this.reverseSameWeight(LxTierLayout.this._tiers[n6]) ? 1 : 0;
                        LxTierLayout.this.updateWeight();
                        n3 = LxTierLayout.this.computeAllCrossings();
                        if (n3 <= n7) {
                            n4 = 1;
                        } else {
                            LxTierLayout.this.reverseSameWeight(LxTierLayout.this._tiers[n6]);
                            LxTierLayout.this.updateWeight();
                            n4 = 0;
                        }
                        if (n4 != 0) {
                            int n8 = 0;
                            while (n8 < LxTierLayout.this._tiers.length) {
                                if (n8 != n6 && !LxTierLayout.this.isOrdered(LxTierLayout.this._tiers[n8])) {
                                    n5 = 1;
                                }
                                ++n8;
                            }
                            if (n5 != 0) break;
                        }
                        ++n6;
                    }
                    if (n5 == 0) break;
                    ++n2;
                }
                LxTierLayout.this.updatePositions();
            }
        };
        thread.start();
    }

    public int run() {
        Object object;
        int n = 0;
        int n2 = 0;
        if (this._nodes.size() <= 0) {
            return 0;
        }
        Enumeration enumeration = this._nodes.elements();
        while (enumeration.hasMoreElements()) {
            LxTierNode lxTierNode = (LxTierNode)enumeration.nextElement();
            int n3 = lxTierNode.getTier();
            if (n3 < n2) continue;
            n2 = n3 + 1;
        }
        if (n2 == 0) {
            return 0;
        }
        this._tiers = new Tier[n2];
        int n4 = 0;
        while (n4 < this._tiers.length) {
            this._tiers[n4] = new Tier(this);
            ++n4;
        }
        Enumeration enumeration2 = this._nodes.elements();
        while (enumeration2.hasMoreElements()) {
            object = (LxTierNode)enumeration2.nextElement();
            this._tiers[((LxTierNode)object).getTier()].addNode((LxTierNode)object);
            ((LxTierNode)object).removeAllLinks();
        }
        object = this._nodes.elements();
        LxTierNode lxTierNode = (LxTierNode)object.nextElement();
        LxComponent[] lxComponentArray = lxTierNode.getComponent().getGraph().getComponents();
        int n5 = 0;
        while (n5 < lxComponentArray.length) {
            LxComponent lxComponent = lxComponentArray[n5];
            if (lxComponent != null && lxComponent instanceof LxAbstractLink) {
                LxAbstractLink lxAbstractLink = (LxAbstractLink)lxComponent;
                LxComponent lxComponent2 = lxAbstractLink.getHandle1().getComponent();
                LxComponent lxComponent3 = lxAbstractLink.getHandle2().getComponent();
                LxTierNode lxTierNode2 = (LxTierNode)this._nodes.get(lxComponent2);
                LxTierNode lxTierNode3 = (LxTierNode)this._nodes.get(lxComponent3);
                if (lxTierNode2 != null && lxTierNode3 != null) {
                    NodeLink nodeLink = new NodeLink(lxAbstractLink, lxTierNode2, lxTierNode3);
                    lxTierNode2.addLink(nodeLink);
                    lxTierNode3.addLink(nodeLink);
                }
            }
            ++n5;
        }
        int n6 = 0;
        while (n6 < this._tiers.length) {
            this._tiers[n6] = this.sortTier(this._tiers[n6], this._xComparator);
            ++n6;
        }
        this.layout();
        return n;
    }

    protected LxLayoutManager.SettingsDialog createSettingsDialog() {
        LxLayoutManager.SettingsDialog settingsDialog = super.createSettingsDialog();
        settingsDialog.setTitle(Resources.get(DIALOG_TITLE, "Tier layout settings"));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(LxLayoutManager.SettingsDialog.stdHalfBorder);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(LxLayoutManager.SettingsDialog.stdHalfBorder);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = LxLayoutManager.SettingsDialog.stdInsets;
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        final JCheckBox jCheckBox = new JCheckBox(" " + Resources.get(DIALOG_USE_OBECTS_SIZES_LABEL, "Use objects' sizes"), this._useObjectsSizes);
        final JCheckBox jCheckBox2 = new JCheckBox(" " + Resources.get(DIALOG_BEAUTIFY_SPACING_LABEL, "Beautify Spacing"), this._beautifySpacing);
        final JCheckBox jCheckBox3 = new JCheckBox(" " + Resources.get(DIALOG_FIT_TO_BOUNDS_LABEL, "Fit to bounds"), this._fitToBounds);
        JLabel jLabel = new JLabel(Resources.get(DIALOG_INTER_TIER_GAP_LABEL, "Inter-tier gap"));
        final LxLayoutManager.SettingsDialog.JDoubleField jDoubleField = new LxLayoutManager.SettingsDialog.JDoubleField(settingsDialog, this._interTierGap);
        JLabel jLabel2 = new JLabel(Resources.get(DIALOG_INTER_NODE_GAP_LABEL, "Inter-node gap"));
        final LxLayoutManager.SettingsDialog.JDoubleField jDoubleField2 = new LxLayoutManager.SettingsDialog.JDoubleField(settingsDialog, this._interNodeGap);
        JLabel jLabel3 = new JLabel(Resources.get(DIALOG_INTRA_LINK_SPACING_LABEL, "Intra-link spacing"));
        final LxLayoutManager.SettingsDialog.JDoubleField jDoubleField3 = new LxLayoutManager.SettingsDialog.JDoubleField(settingsDialog, this.getIntraLinkSpacing());
        JLabel jLabel4 = new JLabel(Resources.get(DIALOG_SKIP_LINK_SPACING_LABEL, "Skip-link spacing"));
        final LxLayoutManager.SettingsDialog.JDoubleField jDoubleField4 = new LxLayoutManager.SettingsDialog.JDoubleField(settingsDialog, this.getSkipLinkSpacing());
        JLabel jLabel5 = new JLabel(Resources.get(DIALOG_ITERATIONS_LABEL, "Iteration count"));
        final LxLayoutManager.SettingsDialog.JDoubleField jDoubleField5 = new LxLayoutManager.SettingsDialog.JDoubleField(settingsDialog, (double)this._niters);
        Object[] objectArray = new Object[]{"Horizontal", "Vertical"};
        JLabel jLabel6 = new JLabel(Resources.get(DIALOG_ORIENTATION_LABEL, "Orientation"));
        final JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setSelectedIndex(this.getOrientation());
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jCheckBox, gridBagConstraints);
        jPanel.add(jCheckBox);
        gridBagLayout.setConstraints(jCheckBox2, gridBagConstraints);
        jPanel.add(jCheckBox2);
        gridBagLayout.setConstraints(jCheckBox3, gridBagConstraints);
        jPanel.add(jCheckBox3);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel6, gridBagConstraints);
        jPanel.add(jLabel6);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jComboBox, gridBagConstraints);
        jPanel.add(jComboBox);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jDoubleField, gridBagConstraints);
        jPanel.add(jDoubleField);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jDoubleField2, gridBagConstraints);
        jPanel.add(jDoubleField2);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jDoubleField3, gridBagConstraints);
        jPanel.add(jDoubleField3);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        jPanel.add(jLabel4);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jDoubleField4, gridBagConstraints);
        jPanel.add(jDoubleField4);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel5, gridBagConstraints);
        jPanel.add(jLabel5);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jDoubleField5, gridBagConstraints);
        jPanel.add(jDoubleField5);
        jPanel2.setLayout(gridBagLayout2);
        Object[] objectArray2 = new Object[]{"NONE", "INTRA", "ADJACENT", "SKIP"};
        JLabel jLabel7 = new JLabel(Resources.get(DIALOG_PRIORITY1_LABEL, "Priority 1"));
        final JComboBox<Object> jComboBox2 = new JComboBox<Object>(objectArray2);
        jComboBox2.setSelectedIndex(this.getPriority(0));
        JLabel jLabel8 = new JLabel(Resources.get(DIALOG_PRIORITY2_LABEL, "Priority 2"));
        final JComboBox<Object> jComboBox3 = new JComboBox<Object>(objectArray2);
        jComboBox3.setSelectedIndex(this.getPriority(1));
        JLabel jLabel9 = new JLabel(Resources.get(DIALOG_PRIORITY3_LABEL, "Priority 3"));
        final JComboBox<Object> jComboBox4 = new JComboBox<Object>(objectArray2);
        jComboBox4.setSelectedIndex(this.getPriority(2));
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout2.setConstraints(jLabel7, gridBagConstraints);
        jPanel2.add(jLabel7);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout2.setConstraints(jComboBox2, gridBagConstraints);
        jPanel2.add(jComboBox2);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout2.setConstraints(jLabel8, gridBagConstraints);
        jPanel2.add(jLabel8);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout2.setConstraints(jComboBox3, gridBagConstraints);
        jPanel2.add(jComboBox3);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout2.setConstraints(jLabel9, gridBagConstraints);
        jPanel2.add(jLabel9);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout2.setConstraints(jComboBox4, gridBagConstraints);
        jPanel2.add(jComboBox4);
        JPanel jPanel3 = settingsDialog.getMainPanel();
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        settingsDialog.addApplyListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LxTierLayout.this.setUseObjectsSizes(jCheckBox.isSelected());
                LxTierLayout.this.setBeautifySpacing(jCheckBox2.isSelected());
                LxTierLayout.this.setFitToBounds(jCheckBox3.isSelected());
                double d = jDoubleField2.getValue();
                if (Double.isNaN(d)) {
                    return;
                }
                LxTierLayout.this.setInterNodeGap(d);
                d = jDoubleField.getValue();
                if (Double.isNaN(d)) {
                    return;
                }
                LxTierLayout.this.setInterTierGap(d);
                d = jDoubleField3.getValue();
                if (Double.isNaN(d)) {
                    return;
                }
                LxTierLayout.this.setIntraLinkSpacing(d);
                d = jDoubleField4.getValue();
                if (Double.isNaN(d)) {
                    return;
                }
                LxTierLayout.this.setSkipLinkSpacing(d);
                d = jDoubleField5.getValue();
                if (Double.isNaN(d)) {
                    return;
                }
                LxTierLayout.this.setIterationCount((int)d);
                jDoubleField5.setText("" + (double)((int)d));
                LxTierLayout.this.setPriority(0, jComboBox2.getSelectedIndex());
                LxTierLayout.this.setPriority(1, jComboBox3.getSelectedIndex());
                LxTierLayout.this.setPriority(2, jComboBox4.getSelectedIndex());
                jComboBox2.setSelectedIndex(LxTierLayout.this.getPriority(0));
                jComboBox3.setSelectedIndex(LxTierLayout.this.getPriority(1));
                jComboBox4.setSelectedIndex(LxTierLayout.this.getPriority(2));
                LxTierLayout.this.setOrientation(jComboBox.getSelectedIndex());
                LxTierLayout.this.updatePositions();
            }
        });
        settingsDialog.pack();
        this._dialog = settingsDialog;
        return settingsDialog;
    }

    public void readFromJLX(InputStream inputStream, String string) throws IOException {
        super.readFromJLX(inputStream, string);
        this._orientation = LxSaveUtils.readInt(inputStream);
        this._interTierGap = LxSaveUtils.readDouble(inputStream);
        this._interNodeGap = LxSaveUtils.readDouble(inputStream);
        this._niters = LxSaveUtils.readInt(inputStream);
        this._useObjectsSizes = LxSaveUtils.readBoolean(inputStream);
        this._beautifySpacing = LxSaveUtils.readBoolean(inputStream);
        this._skipLinkSpacing = LxSaveUtils.readDouble(inputStream);
        this._intraLinkSpacing = LxSaveUtils.readDouble(inputStream);
        this._fitToBounds = LxSaveUtils.readBoolean(inputStream);
        LxSaveUtils.readEndOfPart(inputStream);
    }

    public void saveAsJLX(OutputStream outputStream) throws IOException {
        super.saveAsJLX(outputStream);
        LxSaveUtils.writeInt(outputStream, this._orientation);
        LxSaveUtils.writeDouble(outputStream, this._interTierGap);
        LxSaveUtils.writeDouble(outputStream, this._interNodeGap);
        LxSaveUtils.writeInt(outputStream, this._niters);
        LxSaveUtils.writeBoolean(outputStream, this._useObjectsSizes);
        LxSaveUtils.writeBoolean(outputStream, this._beautifySpacing);
        LxSaveUtils.writeDouble(outputStream, this._skipLinkSpacing);
        LxSaveUtils.writeDouble(outputStream, this._intraLinkSpacing);
        LxSaveUtils.writeBoolean(outputStream, this._fitToBounds);
        LxSaveUtils.writeEndOfPart(outputStream);
    }

    class Tier {
        private Vector _n = new Vector();
        private double _maxHeight = 0.0;
        private double _maxWidth = 0.0;
        private LxTierLayout _layout = null;

        Tier(LxTierLayout lxTierLayout2) {
            this._layout = lxTierLayout2;
        }

        double getMaxWidth() {
            if (this._layout.getOrientation() == 0) {
                return this._maxWidth;
            }
            return this._maxHeight;
        }

        double getMaxHeight() {
            if (this._layout.getOrientation() == 0) {
                return this._maxHeight;
            }
            return this._maxWidth;
        }

        LxTierNode getNode(int n) {
            return (LxTierNode)this._n.get(n);
        }

        void addNode(LxTierNode lxTierNode) {
            this._n.add(lxTierNode);
            if (lxTierNode.getComponentHeight() > this._maxHeight) {
                this._maxHeight = lxTierNode.getComponentHeight();
            }
            if (lxTierNode.getComponentWidth() > this._maxWidth) {
                this._maxWidth = lxTierNode.getComponentWidth();
            }
        }

        void removeNode(LxTierNode lxTierNode) {
            this._n.remove(lxTierNode);
        }

        void setNode(int n, LxTierNode lxTierNode) {
            this._n.set(n, lxTierNode);
        }

        int size() {
            return this._n.size();
        }

        void insertNode(int n, LxTierNode lxTierNode) {
            this._n.insertElementAt(lxTierNode, n);
        }

        void sort(Comparator comparator) {
            Collections.sort(this._n, comparator);
        }
    }

    class NodeLink {
        private LxTierNode _ns;
        private LxTierNode _ne;
        private LxAbstractLink _lk;
        private int _routeMeter = -1;

        NodeLink(LxAbstractLink lxAbstractLink, LxTierNode lxTierNode, LxTierNode lxTierNode2) {
            this._ns = lxTierNode;
            this._ne = lxTierNode2;
            this._lk = lxAbstractLink;
        }

        LxAbstractLink getComponent() {
            return this._lk;
        }

        LxTierNode getStart() {
            return this._ns;
        }

        LxTierNode getEnd() {
            return this._ne;
        }

        int getMinIndex() {
            return Math.min(this.getStartIndex(), this.getEndIndex());
        }

        int getMaxIndex() {
            return Math.max(this.getStartIndex(), this.getEndIndex());
        }

        int getStartIndex() {
            return this.getStart().getIndex();
        }

        int getEndIndex() {
            return this.getEnd().getIndex();
        }

        boolean isInside(NodeLink nodeLink) {
            int n = this.getMinIndex();
            int n2 = this.getMaxIndex();
            int n3 = nodeLink.getMinIndex();
            int n4 = nodeLink.getMaxIndex();
            return n4 >= n2 && n3 <= n;
        }

        boolean hasSameNodes(NodeLink nodeLink) {
            int n = this.getMinIndex();
            int n2 = this.getMaxIndex();
            int n3 = nodeLink.getMinIndex();
            int n4 = nodeLink.getMaxIndex();
            return n4 == n2 && n3 == n;
        }

        boolean intersects(NodeLink nodeLink) {
            int n = this.getMinIndex();
            int n2 = this.getMaxIndex();
            int n3 = nodeLink.getMinIndex();
            int n4 = nodeLink.getMaxIndex();
            if (n4 > n && n4 < n2) {
                return true;
            }
            return n3 > n && n3 < n2;
        }

        public String toString() {
            return "L:" + this.getStartIndex() + "->" + this.getEndIndex();
        }

        int getType() {
            int n = Math.abs(this.getStart().getTier() - this.getEnd().getTier());
            if (n == 0) {
                return 1;
            }
            if (n == 1) {
                return 2;
            }
            return 3;
        }

        boolean isRouted() {
            return this._routeMeter != -1;
        }

        void setRouteMeter(int n) {
            this._routeMeter = n;
            if (this.isRouted()) {
                if (this.getType() == 1) {
                    this.updatePathIntra();
                } else if (this.getType() == 3) {
                    this.updatePathSkip();
                } else if (this.getType() == 2) {
                    this.updatePathAdjacent();
                }
            }
        }

        int getRouteMeter() {
            return this._routeMeter;
        }

        boolean isLeft() {
            LxTierNode lxTierNode;
            LxTierNode lxTierNode2;
            if (this.getStart().getTier() < this.getEnd().getTier()) {
                lxTierNode2 = this.getStart();
                lxTierNode = this.getEnd();
            } else {
                lxTierNode2 = this.getEnd();
                lxTierNode = this.getStart();
            }
            double d = LxTierLayout.this.getWidth(LxTierLayout.this._nodesBounds) + LxTierLayout.this.getX(LxTierLayout.this._nodesBounds) - lxTierNode2.getComponentCenterX() + LxTierLayout.this.getWidth(LxTierLayout.this._nodesBounds) + LxTierLayout.this.getX(LxTierLayout.this._nodesBounds) - lxTierNode.getComponentCenterX();
            double d2 = lxTierNode2.getComponentCenterX() - LxTierLayout.this.getX(LxTierLayout.this._nodesBounds) + lxTierNode.getComponentCenterX() - LxTierLayout.this.getX(LxTierLayout.this._nodesBounds);
            boolean bl = d2 < d;
            return bl;
        }

        void updatePathIntra() {
            int n;
            boolean bl = this.getStart().getTier() == LxTierLayout.this._tiers.length - 1;
            int n2 = this.getStartIndex();
            if (Math.abs(n2 - (n = this.getEndIndex())) == 1 && this.getRouteMeter() == 0) {
                this._lk.removeAllPathPoints();
                this._lk.addPath(this.getStart().getComponentCenterX(), this.getStart().getComponentCenterY());
                this._lk.addPath(this.getEnd().getComponentCenterX(), this.getEnd().getComponentCenterY());
            } else {
                double[] dArray = new double[8];
                dArray[0] = this.getStart().getComponentCenterX();
                dArray[1] = this.getStart().getComponentCenterY();
                dArray[6] = this.getEnd().getComponentCenterX();
                dArray[7] = this.getEnd().getComponentCenterY();
                double d = LxTierLayout.this._tiers[this.getStart().getTier()].getMaxHeight() / 2.0 + (double)this.getRouteMeter() * LxTierLayout.this._intraLinkSpacing;
                dArray[3] = !bl ? dArray[1] + d : dArray[1] - d;
                dArray[5] = dArray[3];
                if (dArray[6] > dArray[0]) {
                    dArray[2] = dArray[0] + d;
                    dArray[4] = dArray[6] - d;
                } else {
                    dArray[2] = dArray[0] - d;
                    dArray[4] = dArray[6] + d;
                }
                if (LxTierLayout.this.getOrientation() == 1) {
                    int n3 = 0;
                    while (n3 < 4) {
                        double d2 = dArray[2 * n3 + 1];
                        dArray[2 * n3 + 1] = dArray[2 * n3];
                        dArray[2 * n3] = d2;
                        ++n3;
                    }
                }
                this._lk.removeAllPathPoints();
                this._lk.setPath(dArray);
            }
            if (LxTierLayout.this.getLinkStyle(1) != null) {
                this._lk.setStyle(LxTierLayout.this._linkStyles[1]);
            }
        }

        void updatePathAdjacent() {
            if (LxTierLayout.this.getLinkStyle(2) != null) {
                this._lk.setStyle(LxTierLayout.this._linkStyles[2]);
            }
        }

        void updatePathSkip() {
            double d = (double)(this.getRouteMeter() + 1) * LxTierLayout.this._skipLinkSpacing;
            double d2 = (double)(this.getRouteMeter() + 1) * LxTierLayout.this._skipLinkSpacing;
            double[] dArray = new double[12];
            double[] dArray2 = new double[12];
            if (this.getStart().getTier() < this.getEnd().getTier()) {
                dArray[0] = this.getStart().getComponentCenterX();
                dArray[1] = this.getStart().getComponentCenterY();
                dArray[10] = this.getEnd().getComponentCenterX();
                dArray[11] = this.getEnd().getComponentCenterY();
            } else {
                dArray[0] = this.getEnd().getComponentCenterX();
                dArray[1] = this.getEnd().getComponentCenterY();
                dArray[10] = this.getStart().getComponentCenterX();
                dArray[11] = this.getStart().getComponentCenterY();
            }
            dArray[2] = dArray[0];
            dArray[3] = LxTierLayout.this.getY(LxTierLayout.this._nodesBounds) - d;
            dArray[4] = this.isLeft() ? LxTierLayout.this.getX(LxTierLayout.this._nodesBounds) - d2 : LxTierLayout.this.getX(LxTierLayout.this._nodesBounds) + LxTierLayout.this.getWidth(LxTierLayout.this._nodesBounds) + d2;
            dArray[7] = LxTierLayout.this.getY(LxTierLayout.this._nodesBounds) + LxTierLayout.this.getHeight(LxTierLayout.this._nodesBounds) + d;
            dArray[5] = dArray[3];
            dArray[6] = dArray[4];
            dArray[8] = dArray[10];
            dArray[9] = dArray[7];
            this._lk.removeAllPathPoints();
            if (LxTierLayout.this.getOrientation() == 1) {
                int n = 0;
                while (n < 6) {
                    double d3 = dArray[2 * n + 1];
                    dArray[2 * n + 1] = dArray[2 * n];
                    dArray[2 * n] = d3;
                    ++n;
                }
            }
            if (this.getStart().getTier() > this.getEnd().getTier()) {
                dArray2[0] = dArray[10];
                dArray2[1] = dArray[11];
                dArray2[2] = dArray[8];
                dArray2[3] = dArray[9];
                dArray2[4] = dArray[6];
                dArray2[5] = dArray[7];
                dArray2[6] = dArray[4];
                dArray2[7] = dArray[5];
                dArray2[8] = dArray[2];
                dArray2[9] = dArray[3];
                dArray2[10] = dArray[0];
                dArray2[11] = dArray[1];
                this._lk.setPath(dArray2);
            } else {
                this._lk.setPath(dArray);
            }
            if (LxTierLayout.this.getLinkStyle(3) != null) {
                this._lk.setStyle(LxTierLayout.this._linkStyles[3]);
            }
        }
    }
}

