/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox.layout;

import com.loox.jloox.LxComponent;
import com.loox.jloox.layout.LxTierLayout;
import java.util.Vector;

public class LxTierNode {
    static final String CLASS_NAME = "LxTierNode";
    private LxTierLayout _layout = null;
    private static final int NOT_INDEXED = -1;
    private LxComponent _component;
    private final int _tier;
    private int _index = -1;
    private boolean _fixedLocation = false;
    private boolean _fixedOrder = false;
    private double _weight;
    private Vector _links;

    public int getTier() {
        return this._tier;
    }

    public void setIndex(int n) {
        this._index = n;
    }

    public int getIndex() {
        return this._index;
    }

    public void setFixedLocation(boolean bl) {
        if (this._index == -1) {
            throw new IllegalStateException("Can not set fixedLocation for this node : the node is not indexed\n");
        }
        this._fixedLocation = bl;
    }

    public boolean isFixedLocation() {
        return this._fixedLocation;
    }

    public void setFixedOrder(boolean bl) {
        if (this._index == -1) {
            throw new IllegalStateException("Can not set fixedOrder for this node : the node is not indexed\n");
        }
        this._fixedOrder = bl;
    }

    public boolean isFixedOrder() {
        return this._fixedOrder;
    }

    public void setComponentCenterX(double d) {
        if (this._layout.getOrientation() == 0) {
            this._component.setCenterX(d);
        } else {
            this._component.setCenterY(d);
        }
    }

    public void setComponentCenterY(double d) {
        if (this._layout.getOrientation() == 0) {
            this._component.setCenterY(d);
        } else {
            this._component.setCenterX(d);
        }
    }

    public void setComponentX(double d) {
        if (this._layout.getOrientation() == 0) {
            this._component.setX(d);
        } else {
            this._component.setY(d);
        }
    }

    public void setComponentY(double d) {
        if (this._layout.getOrientation() == 0) {
            this._component.setY(d);
        } else {
            this._component.setX(d);
        }
    }

    public double getComponentCenterX() {
        if (this._layout.getOrientation() == 0) {
            return this._component.getCenterX();
        }
        return this._component.getCenterY();
    }

    public double getComponentCenterY() {
        if (this._layout.getOrientation() == 0) {
            return this._component.getCenterY();
        }
        return this._component.getCenterX();
    }

    public double getComponentX() {
        if (this._layout.getOrientation() == 0) {
            return this._component.getX();
        }
        return this._component.getY();
    }

    public double getComponentY() {
        if (this._layout.getOrientation() == 0) {
            return this._component.getY();
        }
        return this._component.getX();
    }

    public double getComponentWidth() {
        if (this._layout.getOrientation() == 0) {
            return this._component.getWidth();
        }
        return this._component.getHeight();
    }

    public double getComponentHeight() {
        if (this._layout.getOrientation() == 0) {
            return this._component.getHeight();
        }
        return this._component.getWidth();
    }

    public double getWeight() {
        return this._weight;
    }

    public LxComponent getComponent() {
        return this._component;
    }

    void addLink(LxTierLayout.NodeLink nodeLink) {
        this._links.add(nodeLink);
    }

    void removeLink(LxTierLayout.NodeLink nodeLink) {
        this._links.remove(nodeLink);
    }

    void removeAllLinks() {
        this._links.clear();
    }

    public int getLinkCount() {
        return this._links.size();
    }

    LxTierLayout.NodeLink getLink(int n) {
        return (LxTierLayout.NodeLink)this._links.get(n);
    }

    public LxTierNode(LxTierLayout lxTierLayout, LxComponent lxComponent, int n) {
        this._component = lxComponent;
        this._tier = n;
        this._links = new Vector();
        this._weight = 0.0;
        this._layout = lxTierLayout;
    }

    public void computeWeight() {
        double d = 0.0;
        int n = 0;
        if (this.getLinkCount() > 0) {
            int n2 = 0;
            while (n2 < this.getLinkCount()) {
                LxTierLayout.NodeLink nodeLink = this.getLink(n2);
                LxTierNode lxTierNode = nodeLink.getStart();
                LxTierNode lxTierNode2 = nodeLink.getEnd();
                LxTierNode lxTierNode3 = null;
                if (nodeLink.getType() != 1) {
                    lxTierNode3 = lxTierNode == this ? lxTierNode2 : lxTierNode;
                    d += (double)lxTierNode3.getIndex();
                    ++n;
                } else {
                    d += (double)lxTierNode.getIndex();
                    ++n;
                    d += (double)lxTierNode2.getIndex();
                    ++n;
                }
                ++n2;
            }
            d /= (double)n;
        }
        this._weight = d;
    }
}

