/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox.layout.hierarchical;

import com.loox.jloox.LxAbstractLink;
import com.loox.jloox.LxComponent;
import com.loox.jloox.LxHandle;
import com.loox.jloox.layout.hierarchical.DPoint3;
import com.loox.jloox.layout.hierarchical.Edge;
import com.loox.jloox.layout.hierarchical.Node;
import com.loox.jloox.layout.hierarchical.NodeList;
import com.loox.jloox.layout.hierarchical.Set;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public class Graph
implements Cloneable {
    private NodeList nodeList_ = new NodeList();
    private Hashtable idHash_ = new Hashtable();
    private int lastTopId_ = 0;
    private Hashtable edges_ = new Hashtable();
    private int direction_;
    private boolean straightenPaths_ = false;
    private boolean orthogonalizePaths_ = false;

    public Graph(int n, boolean bl, boolean bl2) {
        this.direction_ = n;
        this.straightenPaths_ = bl;
        this.orthogonalizePaths_ = bl2;
    }

    public Object clone() {
        try {
            Object object;
            Graph graph = (Graph)super.clone();
            graph.nodeList_ = (NodeList)this.nodeList_.clone();
            graph.idHash_ = new Hashtable();
            graph.edges_ = new Hashtable();
            graph.lastTopId_ = this.lastTopId_;
            Enumeration enumeration = this.edges_.elements();
            while (enumeration.hasMoreElements()) {
                object = (Edge)enumeration.nextElement();
                Node node = graph.nodeList_.nodeFromIndex(((Edge)object).tail_.getIndex());
                Node node2 = graph.nodeList_.nodeFromIndex(((Edge)object).head_.getIndex());
                Edge edge = new Edge(node, node2, (Edge)object);
                graph.edges_.put(new Point(node.index_, node2.index_), edge);
            }
            object = graph.firstNode();
            while (object != null) {
                graph.idHash_.put(new Integer(((Node)object).getId()), object);
                object = graph.nextNode((Node)object);
            }
            return graph;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void copy(Graph graph) {
        this.nodeList_ = graph.nodeList_;
        this.idHash_ = graph.idHash_;
        this.edges_ = graph.edges_;
        this.lastTopId_ = graph.lastTopId_;
    }

    public int insertNode() {
        return this.insertNode(false);
    }

    public int insertNode(boolean bl) {
        return this.insertNode(null, bl);
    }

    public int insertNode(LxComponent lxComponent, boolean bl) {
        Node node = new Node(bl);
        this.nodeList_.addNode(node);
        node.setLxComponent(lxComponent);
        node.haveId_ = true;
        node.id_ = this.lastTopId_;
        this.idHash_.put(new Integer(this.lastTopId_), node);
        do {
            ++this.lastTopId_;
        } while (this.idHash_.containsKey(new Integer(this.lastTopId_)));
        return node.index_;
    }

    public void removeNode(int n) {
        int n2;
        Set set = new Set();
        Set set2 = new Set();
        Node node = this.nodeList_.nodeFromIndex(n);
        if (node.isGroup()) {
            n2 = node.firstChild();
            while (n2 != -1) {
                this.removeNode(n2);
                n2 = node.nextChild();
            }
        } else {
            n2 = node.firstChild();
            while (n2 != -1) {
                this.removeEdge(n, n2);
                n2 = node.nextChild();
            }
            Node node2 = this.nodeList_.firstNode();
            while (node2 != null) {
                if (node2.hasChild(n)) {
                    this.removeEdge(node2.getIndex(), n);
                }
                node2 = this.nodeList_.nextNode(node2);
            }
        }
        this.nodeList_.removeNodeAt(n);
        Integer n3 = node.getIdObject();
        this.idHash_.remove(n3);
        if (n3 < this.lastTopId_) {
            this.lastTopId_ = n3;
        }
        if (node.inGroup()) {
            node.groupNode_.clearChild(node.getIndex());
            if (node.groupNode_.firstChild() == -1) {
                this.removeNode(node.groupNode_.getIndex());
            }
        }
    }

    public void removeNode(Node node) {
        this.removeNode(node.getIndex());
    }

    public void insertEdge(LxComponent lxComponent, int n, int n2) {
        this.insertEdge(lxComponent, new Edge(this.nodeList_.nodeFromIndex(n), this.nodeList_.nodeFromIndex(n2), new DPoint3[0], false));
    }

    public void insertEdge(LxComponent lxComponent, int n, int n2, DPoint3[] dPoint3Array) {
        this.insertEdge(lxComponent, new Edge(this.nodeList_.nodeFromIndex(n), this.nodeList_.nodeFromIndex(n2), dPoint3Array, false));
    }

    public void insertEdge(LxComponent lxComponent, Node node, Node node2) {
        this.insertEdge(lxComponent, new Edge(node, node2, new DPoint3[0], false));
    }

    public void insertEdge(LxComponent lxComponent, Edge edge) {
        int n = edge.tail().getIndex();
        int n2 = edge.head().getIndex();
        this.edges_.remove(new Point(n, n2));
        edge.setLxComponent(lxComponent);
        edge.tail().setChild(n2);
        this.edges_.put(new Point(n, n2), edge);
        DPoint3[] dPoint3Array = edge.points();
    }

    public DPoint3[] getEdgePathPoints(int n, int n2) {
        Edge edge = (Edge)this.edges_.get(new Point(n, n2));
        if (edge == null) {
            return null;
        }
        return edge.points();
    }

    public Edge getEdge(int n, int n2) {
        return (Edge)this.edges_.get(new Point(n, n2));
    }

    public LxComponent removeEdge(int n, int n2) {
        Node node = this.nodeList_.nodeFromIndex(n);
        node.clearChild(n2);
        Edge edge = this.getEdge(n, n2);
        LxComponent lxComponent = edge.getLxComponent();
        this.edges_.remove(new Point(n, n2));
        return lxComponent;
    }

    public LxComponent removeEdge(Edge edge) {
        return this.removeEdge(edge.tail().getIndex(), edge.head().getIndex());
    }

    public Set parents(int n) {
        Set set = new Set();
        Node node = this.nodeList_.firstNode();
        while (node != null) {
            if (node.hasChild(n)) {
                set.includeElement(node.index_);
            }
            node = this.nodeList_.nextNode(node);
        }
        return set;
    }

    public Set children(int n) {
        return this.nodeList_.nodeFromIndex(n).getChildren();
    }

    public int numberOfNodes() {
        return this.nodeList_.count();
    }

    public Node firstNode() {
        return this.nodeList_.firstNode();
    }

    public Node nextNode(Node node) {
        return this.nodeList_.nextNode(node);
    }

    public int getIndexFromNode(Node node) {
        return node.index_;
    }

    public Node getNodeFromIndex(int n) {
        return this.nodeList_.nodeFromIndex(n);
    }

    public Node getNodeFromId(int n) {
        return (Node)this.idHash_.get(new Integer(n));
    }

    public void removeEdgePaths() {
        Enumeration enumeration = this.edges_.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            edge.points_ = new DPoint3[0];
        }
    }

    public void dummysToEdgePaths() {
        Node node = this.firstNode();
        while (node != null) {
            if (!node.isDummy_) {
                int n = node.firstChild();
                while (n != -1) {
                    Node node2;
                    Node node3 = node2 = this.getNodeFromIndex(n);
                    int n2 = 0;
                    while (node3 != null && node3.isDummy_) {
                        ++n2;
                        node3 = this.getNodeFromIndex(node3.firstChild());
                    }
                    if (n2 > 0 && node3 != null) {
                        DPoint3[] dPoint3Array = new DPoint3[n2];
                        node3 = node2;
                        int n3 = 0;
                        LxComponent lxComponent = null;
                        while (node3.isDummy_) {
                            if (lxComponent == null) {
                                lxComponent = node3.getLxComponent();
                            }
                            dPoint3Array[n3++] = new DPoint3(node3.getPosition3());
                            node3 = this.getNodeFromIndex(node3.firstChild());
                        }
                        this.insertEdge(lxComponent, node.index_, node3.index_, dPoint3Array);
                    }
                    n = node.nextChild();
                }
            }
            node = this.nextNode(node);
        }
        node = this.firstNode();
        while (node != null) {
            if (node.isDummy_) {
                this.removeNode(node);
            }
            node = this.nextNode(node);
        }
    }

    public Enumeration getEdges() {
        return this.edges_.elements();
    }

    public Node nodeFromIndex(int n) {
        return this.nodeList_.nodeFromIndex(n);
    }

    public NodeList getNodeList() {
        return this.nodeList_;
    }

    private LxComponent[] getChildren(LxComponent lxComponent, LxAbstractLink[] lxAbstractLinkArray) {
        Vector<LxComponent> vector = new Vector<LxComponent>();
        int n = 0;
        while (n < lxAbstractLinkArray.length) {
            if (lxAbstractLinkArray[n].getHandle1().getComponent() == lxComponent) {
                vector.add(lxAbstractLinkArray[n].getHandle2().getComponent());
            }
            ++n;
        }
        LxComponent[] lxComponentArray = new LxComponent[vector.size()];
        int n2 = 0;
        while (n2 < lxComponentArray.length) {
            lxComponentArray[n2] = (LxComponent)vector.elementAt(n2);
            ++n2;
        }
        return lxComponentArray;
    }

    private void computeDistance(LxComponent lxComponent, HashMap hashMap, HashMap hashMap2, LxAbstractLink[] lxAbstractLinkArray) {
        hashMap2.put(lxComponent, null);
        LxComponent[] lxComponentArray = this.getChildren(lxComponent, lxAbstractLinkArray);
        int n = (Integer)hashMap.get(lxComponent);
        int n2 = 0;
        while (n2 < lxComponentArray.length) {
            int n3 = (Integer)hashMap.get(lxComponentArray[n2]);
            if (n3 != -1) {
                if (!hashMap2.containsKey(lxComponentArray[n2])) {
                    hashMap.put(lxComponentArray[n2], new Integer(Math.max(n3, n + 1)));
                    if (Math.max(n3, n + 1) != n3) {
                        this.computeDistance(lxComponentArray[n2], hashMap, hashMap2, lxAbstractLinkArray);
                    }
                }
            } else {
                hashMap.put(lxComponentArray[n2], new Integer(n + 1));
                this.computeDistance(lxComponentArray[n2], hashMap, hashMap2, lxAbstractLinkArray);
            }
            ++n2;
        }
        hashMap2.remove(lxComponent);
    }

    public void initAlgorithm(LxComponent[] lxComponentArray, LxAbstractLink[] lxAbstractLinkArray, Vector vector, LxComponent[] lxComponentArray2) {
        int n;
        int n2;
        HashMap<LxComponent, Node> hashMap = new HashMap<LxComponent, Node>();
        HashMap<LxComponent, Integer> hashMap2 = new HashMap<LxComponent, Integer>();
        HashMap hashMap3 = new HashMap();
        int n3 = 0;
        while (n3 < lxComponentArray.length) {
            hashMap2.put(lxComponentArray[n3], new Integer(-1));
            ++n3;
        }
        if (lxComponentArray2 != null) {
            n2 = 0;
            while (n2 < lxComponentArray2.length) {
                if ((Integer)hashMap2.get(lxComponentArray2[n2]) == -1) {
                    hashMap2.put(lxComponentArray2[n2], new Integer(0));
                    this.computeDistance(lxComponentArray2[n2], hashMap2, hashMap3, lxAbstractLinkArray);
                }
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < lxComponentArray.length) {
            n = this.insertNode(lxComponentArray[n2], false);
            this.getNodeFromIndex(n).initSize(this.direction_);
            hashMap.put(lxComponentArray[n2], this.getNodeFromIndex(n));
            ++n2;
        }
        n = 0;
        while (n < lxAbstractLinkArray.length) {
            LxAbstractLink lxAbstractLink = lxAbstractLinkArray[n];
            LxComponent lxComponent = lxAbstractLink.getHandle1().getComponent();
            LxComponent lxComponent2 = lxAbstractLink.getHandle2().getComponent();
            LxComponent lxComponent3 = null;
            if (lxComponentArray2 != null && (Integer)hashMap2.get(lxComponent2) < (Integer)hashMap2.get(lxComponent)) {
                lxComponent3 = lxComponent2;
                lxComponent2 = lxComponent;
                lxComponent = lxComponent3;
                vector.add(lxAbstractLink);
            }
            this.insertEdge((LxComponent)lxAbstractLink, (Node)hashMap.get(lxComponent), (Node)hashMap.get(lxComponent2));
            ++n;
        }
    }

    public void adjustObjects(Rectangle2D rectangle2D, int n, double d, double d2, Vector vector) {
        Object object;
        Node node = this.nodeList_.firstNode();
        Rectangle2D.Double double_ = null;
        double d3 = 0.0;
        double d4 = 0.0;
        while (node != null) {
            if (this.direction_ == 1) {
                if (double_ == null) {
                    double_ = new Rectangle2D.Double(node.getX() - node.getWidth() / 2.0, node.getY() - node.getHeight() / 2.0, node.getWidth(), node.getHeight());
                } else {
                    double_.add(new Rectangle2D.Double(node.getX() - node.getWidth() / 2.0, node.getY() - node.getHeight() / 2.0, node.getWidth(), node.getHeight()));
                }
            } else if (this.direction_ == 3) {
                if (double_ == null) {
                    double_ = new Rectangle2D.Double(node.getY() - node.getHeight() / 2.0, node.getX() - node.getHeight() / 2.0, node.getWidth(), node.getHeight());
                } else {
                    double_.add(new Rectangle2D.Double(node.getY() - node.getHeight() / 2.0, node.getX() - node.getHeight() / 2.0, node.getWidth(), node.getHeight()));
                }
            } else if (this.direction_ == 0) {
                if (double_ == null) {
                    double_ = new Rectangle2D.Double(node.getX() - node.getWidth() / 2.0, -node.getY() - node.getHeight() / 2.0, node.getWidth(), node.getHeight());
                } else {
                    double_.add(new Rectangle2D.Double(node.getX() - node.getWidth() / 2.0, -node.getY() - node.getHeight() / 2.0, node.getWidth(), node.getHeight()));
                }
            } else if (this.direction_ == 2) {
                if (double_ == null) {
                    double_ = new Rectangle2D.Double(-node.getY() - node.getHeight() / 2.0, -node.getX() - node.getHeight() / 2.0, node.getWidth(), node.getHeight());
                } else {
                    double_.add(new Rectangle2D.Double(-node.getY() - node.getHeight() / 2.0, -node.getX() - node.getHeight() / 2.0, node.getWidth(), node.getHeight()));
                }
            }
            node = this.nodeList_.nextNode(node);
        }
        if (n == 0) {
            d3 = rectangle2D.getX() - double_.getX() + d;
            d4 = rectangle2D.getY() - double_.getY() + d2;
        }
        if (n == 1) {
            d3 = rectangle2D.getCenterX() - double_.getCenterX();
            d4 = rectangle2D.getCenterY() - double_.getCenterY();
        }
        node = this.nodeList_.firstNode();
        while (node != null) {
            object = node.getLxComponent();
            if (this.direction_ == 0 || this.direction_ == 1) {
                ((LxComponent)object).setSize(node.getWidth(), node.getHeight());
            } else {
                ((LxComponent)object).setSize(node.getHeight(), node.getWidth());
            }
            if (this.direction_ == 0) {
                ((LxComponent)object).setCenter(node.getX() + d3, -node.getY() + d4);
            } else if (this.direction_ == 3) {
                ((LxComponent)object).setCenter(node.getY() + d3, node.getX() + d4);
            } else if (this.direction_ == 2) {
                ((LxComponent)object).setCenter(-node.getY() + d3, -node.getX() + d4);
            } else if (this.direction_ == 1) {
                ((LxComponent)object).setCenter(node.getX() + d3, node.getY() + d4);
            }
            node = this.nodeList_.nextNode(node);
        }
        object = this.getEdges();
        while (object.hasMoreElements()) {
            int n2;
            Edge edge = (Edge)object.nextElement();
            LxAbstractLink lxAbstractLink = (LxAbstractLink)edge.getLxComponent();
            DPoint3[] dPoint3Array = edge.points();
            double[] dArray = null;
            LxHandle lxHandle = lxAbstractLink.getHandle1();
            LxComponent lxComponent = lxHandle.getComponent();
            LxHandle lxHandle2 = lxAbstractLink.getHandle2();
            LxComponent lxComponent2 = lxHandle2.getComponent();
            double d5 = lxHandle.getCenterX() * lxComponent.getWidth() + lxComponent.getCenterX();
            double d6 = lxHandle.getCenterY() * lxComponent.getHeight() + lxComponent.getCenterY();
            double d7 = lxHandle2.getCenterX() * lxComponent2.getWidth() + lxComponent2.getCenterX();
            double d8 = lxHandle2.getCenterY() * lxComponent2.getHeight() + lxComponent2.getCenterY();
            if (dPoint3Array != null && dPoint3Array.length != 0 && !this.straightenPaths_) {
                dArray = new double[2 * (dPoint3Array.length + 2)];
                dArray[0] = d5;
                dArray[1] = d6;
                dArray[2 * (dPoint3Array.length + 2) - 2] = d7;
                dArray[2 * (dPoint3Array.length + 2) - 1] = d8;
                n2 = 0;
                while (n2 < dPoint3Array.length) {
                    if (this.direction_ == 0 || this.direction_ == 1) {
                        dArray[2 * n2 + 2] = dPoint3Array[n2].x + d3;
                    } else if (this.direction_ == 2) {
                        dArray[2 * n2 + 2] = -dPoint3Array[n2].y + d3;
                    } else if (this.direction_ == 3) {
                        dArray[2 * n2 + 2] = dPoint3Array[n2].y + d3;
                    }
                    if (this.direction_ == 0) {
                        dArray[2 * n2 + 3] = -dPoint3Array[n2].y + d4;
                    } else if (this.direction_ == 1) {
                        dArray[2 * n2 + 3] = dPoint3Array[n2].y + d4;
                    } else if (this.direction_ == 2) {
                        dArray[2 * n2 + 3] = -dPoint3Array[n2].x + d4;
                    } else if (this.direction_ == 3) {
                        dArray[2 * n2 + 3] = dPoint3Array[n2].x + d4;
                    }
                    ++n2;
                }
            } else {
                dArray = new double[]{d5, d6, d7, d8};
            }
            if (vector.contains(lxAbstractLink)) {
                n2 = dArray.length;
                double[] dArray2 = new double[n2];
                dArray2[0] = dArray[0];
                dArray2[1] = dArray[1];
                dArray2[n2 - 2] = dArray[n2 - 2];
                dArray2[n2 - 1] = dArray[n2 - 1];
                int n3 = 1;
                while (n3 <= n2 / 2 - 2) {
                    dArray2[2 * n3] = dArray[2 * (n2 / 2 - 1 - n3)];
                    dArray2[2 * n3 + 1] = dArray[2 * (n2 / 2 - 1 - n3) + 1];
                    ++n3;
                }
                dArray = dArray2;
            }
            lxAbstractLink.setPath(dArray);
        }
    }
}

