/*
 * Decompiled with CFR 0.152.
 */
package com.loox.jloox.layout.hierarchical;

import com.loox.jloox.LxComponent;
import com.loox.jloox.layout.hierarchical.Clan;
import com.loox.jloox.layout.hierarchical.ClanTree;
import com.loox.jloox.layout.hierarchical.DDimension;
import com.loox.jloox.layout.hierarchical.DPoint;
import com.loox.jloox.layout.hierarchical.Graph;
import com.loox.jloox.layout.hierarchical.GraphAlgorithm;
import com.loox.jloox.layout.hierarchical.Node;
import com.loox.jloox.layout.hierarchical.Partition;
import com.loox.jloox.layout.hierarchical.Set;

public class Hierarchical
implements GraphAlgorithm {
    private Set[] childRelation_;
    private Set[] descendentRelation_;
    private Set[] parentRelation_;
    private Set[] ancestorRelation_;
    private int numNodes_;
    private int numNodesOriginal_;
    private Graph graph_;
    private Clan firstClan_;
    private Set[] ccNodes_;
    private int ccComponents_;
    private int[] topOOrder_;
    private int[] height_;
    private ClanTree root_;
    private double vSpacing_ = 30.0;
    private double hSpacing_ = 30.0;
    private boolean showTree_;
    private int lastIndex_;
    private ClanTree[] treeLookup_;
    private static final int debug_ = 0;
    private int id_;
    private int numClans_;

    public Hierarchical() {
        this.showTree_ = false;
    }

    public Hierarchical(boolean bl) {
        this.showTree_ = bl;
    }

    public String compute(Graph graph) {
        int n;
        this.graph_ = graph;
        Graph graph2 = (Graph)graph.clone();
        if (this.graph_.numberOfNodes() < 2) {
            return "Graph must have at least two nodes.";
        }
        this.makeChildRelation_();
        this.numNodesOriginal_ = this.numNodes_;
        Set[] setArray = new Set[this.numNodes_];
        int n2 = 0;
        while (n2 < this.numNodes_) {
            setArray[n2] = (Set)this.childRelation_[n2].clone();
            ++n2;
        }
        this.transitiveReduction_();
        int n3 = 0;
        n2 = 0;
        while (n2 < this.numNodes_) {
            n = setArray[n2].first();
            while (n != -1) {
                if (!this.childRelation_[n2].isElement(n)) {
                    ++n3;
                }
                n = setArray[n2].next();
            }
            ++n2;
        }
        this.numNodes_ += n3;
        Object object = new Set[this.numNodes_];
        n2 = 0;
        while (n2 < this.numNodes_) {
            object[n2] = new Set();
            ++n2;
        }
        n2 = 0;
        while (n2 < this.numNodesOriginal_) {
            n = this.childRelation_[n2].first();
            while (n != -1) {
                object[n2].includeElement(n);
                n = this.childRelation_[n2].next();
            }
            ++n2;
        }
        this.lastIndex_ = this.numNodesOriginal_;
        n2 = 0;
        while (n2 < this.numNodesOriginal_) {
            n = setArray[n2].first();
            while (n != -1) {
                if (!this.childRelation_[n2].isElement(n)) {
                    LxComponent lxComponent = graph.removeEdge(n2, n);
                    int n4 = graph.insertNode(lxComponent, true);
                    graph.insertEdge(lxComponent, n2, n4);
                    graph.insertEdge(lxComponent, n4, n);
                    object[n2].includeElement(n4);
                    object[n4].includeElement(n);
                }
                n = setArray[n2].next();
            }
            ++n2;
        }
        this.childRelation_ = object;
        setArray = new Set[this.numNodes_];
        n2 = 0;
        while (n2 < this.numNodes_) {
            setArray[n2] = (Set)this.childRelation_[n2].clone();
            ++n2;
        }
        this.transitiveClosure_();
        this.descendentRelation_ = new Set[this.numNodes_];
        n2 = 0;
        while (n2 < this.numNodes_) {
            this.descendentRelation_[n2] = (Set)this.childRelation_[n2].clone();
            ++n2;
        }
        this.childRelation_ = setArray;
        n2 = 0;
        while (n2 < this.numNodes_) {
            if (this.descendentRelation_[n2].isElement(n2)) {
                this.graph_.copy(graph2);
                return "Graph contains cycles.";
            }
            ++n2;
        }
        this.parentRelation_ = new Set[this.numNodes_];
        this.ancestorRelation_ = new Set[this.numNodes_];
        n2 = 0;
        while (n2 < this.numNodes_) {
            this.parentRelation_[n2] = new Set();
            this.ancestorRelation_[n2] = new Set();
            ++n2;
        }
        n2 = 0;
        while (n2 < this.numNodes_) {
            n = this.childRelation_[n2].first();
            while (n != -1) {
                this.parentRelation_[n].includeElement(n2);
                n = this.childRelation_[n2].next();
            }
            n = this.descendentRelation_[n2].first();
            while (n != -1) {
                this.ancestorRelation_[n].includeElement(n2);
                n = this.descendentRelation_[n2].next();
            }
            ++n2;
        }
        this.assignHeights_();
        this.topOOrder_ = new int[this.numNodes_];
        n3 = this.fillTopOOrder_() ? 1 : 0;
        if (n3 == 0) {
            return "Graph contains cycles.";
        }
        object = new Set();
        ((Set)object).fill(this.numNodes_);
        this.root_ = null;
        this.parseSet_((Set)object);
        this.breakPrimitives_(this.root_);
        this.reduce_(this.root_);
        this.id_ = this.numNodes_;
        this.setId_(this.root_);
        this.numClans_ = this.id_ - this.numNodes_;
        this.setPositions_(this.root_);
        this.reOrder_(this.root_);
        this.graph_.removeEdgePaths();
        this.attributeGraph_();
        graph.dummysToEdgePaths();
        return null;
    }

    private void breakPrimitives_(ClanTree clanTree) {
        ClanTree clanTree2;
        if (clanTree.clan.clanType == 3) {
            ClanTree clanTree3;
            clanTree.clan.clanType = 2;
            clanTree2 = new ClanTree();
            clanTree2.clan = new Clan(4, new Set(), clanTree.clan.sources, new Set(), clanTree.clan.order);
            Set set = (Set)clanTree.clan.nodes.clone();
            int n = 0;
            int n2 = clanTree.clan.sources.first();
            while (n2 != -1) {
                if (this.height_[n2] > n) {
                    n = this.height_[n2];
                }
                n2 = clanTree.clan.sources.next();
            }
            while ((clanTree3 = clanTree.firstChild) != null) {
                clanTree.firstChild = clanTree.firstChild.nextSibling;
                if (!clanTree.clan.sources.intersects(clanTree3.clan.sources)) continue;
                if (this.height_[clanTree3.clan.sources.first()] >= n) {
                    clanTree2.clan.nodes.union(clanTree3.clan.nodes);
                    clanTree2.clan.sinks.union(clanTree3.clan.sinks);
                    this.addChild_(clanTree2, clanTree3);
                    set.difference(clanTree3.clan.nodes);
                    continue;
                }
                if (this.parentRelation_[clanTree3.clan.sources.first()].isEmpty()) continue;
                clanTree2.clan.nodes.union(clanTree3.clan.nodes);
                clanTree2.clan.sinks.union(clanTree3.clan.sinks);
                this.addChild_(clanTree2, clanTree3);
                set.difference(clanTree3.clan.nodes);
            }
            this.addChild_(clanTree, clanTree2);
            if (!set.isEmpty()) {
                this.addChild_(clanTree, this.parseSet_(set));
            }
        }
        clanTree2 = clanTree.firstChild;
        while (clanTree2 != null) {
            this.breakPrimitives_(clanTree2);
            clanTree2 = clanTree2.nextSibling;
        }
    }

    private ClanTree parseSet_(Set set) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        int n;
        Partition partition = new Partition(0, this.childRelation_, this.parentRelation_, this.descendentRelation_, this.ancestorRelation_, this.numNodes_, set);
        Partition partition2 = new Partition(1, this.childRelation_, this.parentRelation_, this.descendentRelation_, this.ancestorRelation_, this.numNodes_, set);
        this.firstClan_ = null;
        int n2 = 0;
        while (n2 < partition.size()) {
            int n3 = 0;
            while (n3 < partition2.size()) {
                Set set2 = (Set)partition.star(n2).clone();
                set2.intersect(partition2.star(n3));
                if (set2.numberOfElements() > 1) {
                    Object object9;
                    this.makeConnectedComponents_(set2);
                    n = 0;
                    object8 = new Set();
                    Object object10 = null;
                    int n4 = 0;
                    while (n4 < this.ccComponents_) {
                        if (this.ccNodes_[n4].numberOfElements() > 1) {
                            object7 = (Set)partition.members(n2).clone();
                            ((Set)object7).intersect(this.ccNodes_[n4]);
                            object9 = (Set)partition2.members(n3).clone();
                            ((Set)object9).intersect(this.ccNodes_[n4]);
                            object6 = (Set)((Set)object7).clone();
                            object5 = (Set)((Set)object9).clone();
                            ((Set)object6).indexedUnion(this.descendentRelation_, (Set)object7);
                            ((Set)object5).indexedUnion(this.ancestorRelation_, (Set)object9);
                            object4 = (Set)((Set)object6).clone();
                            object3 = (Set)((Set)object5).clone();
                            ((Set)object4).indexedUnion(this.ancestorRelation_, (Set)object7);
                            ((Set)object3).indexedUnion(this.descendentRelation_, (Set)object9);
                            ((Set)object6).intersect(set);
                            ((Set)object5).intersect(set);
                            ((Set)object4).intersect(set);
                            ((Set)object3).intersect(set);
                            if (((Set)object3).isSubset((Set)object6) && ((Set)object4).isSubset((Set)object5)) {
                                object2 = new Clan(0, this.ccNodes_[n4], (Set)object7, (Set)object9, this.nodeOrder_(this.ccNodes_[n4]));
                                ((Clan)object2).next = object10;
                                object10 = object2;
                                ++n;
                                ((Set)object8).union(this.ccNodes_[n4]);
                            }
                        } else {
                            ++n;
                            ((Set)object8).union(this.ccNodes_[n4]);
                        }
                        ++n4;
                    }
                    if (n > 1) {
                        object7 = (Set)((Set)object8).clone();
                        object9 = (Set)((Set)object8).clone();
                        ((Set)object7).intersect(partition.members(n2));
                        ((Set)object9).intersect(partition2.members(n3));
                        object6 = new Clan(1, (Set)object8, (Set)object7, (Set)object9, this.nodeOrder_((Set)object7));
                        ((Clan)object6).next = object10;
                        object10 = object6;
                    }
                    while (object10 != null) {
                        object9 = object10;
                        object10 = ((Clan)object10).next;
                        object6 = ((Clan)object9).nodes;
                        object4 = null;
                        object5 = this.firstClan_;
                        while (object5 != null) {
                            object3 = ((Clan)object5).nodes;
                            if (((Set)object6).equals((Set)object3)) {
                                if (((Clan)object9).clanType != 0) {
                                    ((Clan)object5).clanType = ((Clan)object9).clanType;
                                }
                                object9 = null;
                                break;
                            }
                            if (((Set)object6).intersects((Set)object3) && !((Set)object3).isSubset((Set)object6) && !((Set)object6).isSubset((Set)object3)) {
                                ((Set)object6).union((Set)object3);
                                ((Clan)object9).size = ((Set)object6).numberOfElements();
                                ((Clan)object9).clanType = 2;
                                if (object4 != null) {
                                    ((Clan)object4).listnext = ((Clan)object5).listnext;
                                } else {
                                    this.firstClan_ = ((Clan)object5).listnext;
                                }
                            }
                            object4 = object5;
                            object5 = ((Clan)object5).listnext;
                        }
                        if (object9 == null) continue;
                        if (((Clan)object9).clanType == 0) {
                            ((Clan)object9).clanType = 3;
                        }
                        this.addToClanList_((Clan)object9);
                    }
                }
                ++n3;
            }
            ++n2;
        }
        if (this.firstClan_ == null) {
            int n5 = 0;
            while (n5 < partition.size()) {
                n = 0;
                while (n < partition2.size()) {
                    object8 = (Set)partition.star(n5).clone();
                    ((Set)object8).intersect(partition2.star(n));
                    if (((Set)object8).numberOfElements() >= 1) {
                        Set set3;
                        this.makeConnectedComponents_((Set)object8);
                        int n6 = 0;
                        Set set4 = new Set();
                        object7 = null;
                        int n7 = 0;
                        while (n7 < this.ccComponents_) {
                            if (this.ccNodes_[n7].numberOfElements() >= 1) {
                                object6 = (Set)partition.members(n5).clone();
                                ((Set)object6).intersect(this.ccNodes_[n7]);
                                object5 = (Set)partition2.members(n).clone();
                                ((Set)object5).intersect(this.ccNodes_[n7]);
                                object4 = (Set)((Set)object6).clone();
                                object3 = (Set)((Set)object5).clone();
                                ((Set)object4).indexedUnion(this.descendentRelation_, (Set)object6);
                                ((Set)object3).indexedUnion(this.ancestorRelation_, (Set)object5);
                                object2 = (Set)((Set)object4).clone();
                                set3 = (Set)((Set)object3).clone();
                                ((Set)object2).indexedUnion(this.ancestorRelation_, (Set)object6);
                                set3.indexedUnion(this.descendentRelation_, (Set)object5);
                                ((Set)object4).intersect(set);
                                ((Set)object3).intersect(set);
                                ((Set)object2).intersect(set);
                                set3.intersect(set);
                                if (set3.isSubset((Set)object4) && ((Set)object2).isSubset((Set)object3)) {
                                    Clan clan = new Clan(0, this.ccNodes_[n7], (Set)object6, (Set)object5, this.nodeOrder_(this.ccNodes_[n7]));
                                    clan.next = object7;
                                    object7 = clan;
                                    ++n6;
                                    set4.union(this.ccNodes_[n7]);
                                }
                            } else {
                                ++n6;
                                set4.union(this.ccNodes_[n7]);
                            }
                            ++n7;
                        }
                        if (n6 > 1) {
                            object6 = (Set)set4.clone();
                            object5 = (Set)set4.clone();
                            ((Set)object6).intersect(partition.members(n5));
                            ((Set)object5).intersect(partition2.members(n));
                            object4 = new Clan(1, set4, (Set)object6, (Set)object5, this.nodeOrder_((Set)object6));
                            ((Clan)object4).next = object7;
                            object7 = object4;
                        }
                        while (object7 != null) {
                            object5 = object7;
                            object7 = ((Clan)object7).next;
                            object4 = ((Clan)object5).nodes;
                            object2 = null;
                            object3 = this.firstClan_;
                            while (object3 != null) {
                                set3 = ((Clan)object3).nodes;
                                if (((Set)object4).equals(set3)) {
                                    if (((Clan)object5).clanType != 0) {
                                        ((Clan)object3).clanType = ((Clan)object5).clanType;
                                    }
                                    object5 = null;
                                    break;
                                }
                                if (((Set)object4).intersects(set3) && !set3.isSubset((Set)object4) && !((Set)object4).isSubset(set3)) {
                                    ((Set)object4).union(set3);
                                    ((Clan)object5).size = ((Set)object4).numberOfElements();
                                    ((Clan)object5).clanType = 2;
                                    if (object2 != null) {
                                        ((Clan)object2).listnext = ((Clan)object3).listnext;
                                    } else {
                                        this.firstClan_ = ((Clan)object3).listnext;
                                    }
                                }
                                object2 = object3;
                                object3 = ((Clan)object3).listnext;
                            }
                            if (object5 == null) continue;
                            if (((Clan)object5).clanType == 0) {
                                ((Clan)object5).clanType = 3;
                            }
                            this.addToClanList_((Clan)object5);
                        }
                    }
                    ++n;
                }
                ++n5;
            }
        }
        if (this.firstClan_ == null) {
            return null;
        }
        this.firstClan_.next = null;
        object8 = this.firstClan_;
        while (((Clan)object8).listnext != null) {
            ((Clan)object8).listnext.next = object8;
            object8 = ((Clan)object8).listnext;
        }
        ClanTree clanTree = new ClanTree();
        if (this.root_ == null) {
            this.root_ = clanTree;
        }
        clanTree.clan = object8;
        object8 = ((Clan)object8).next;
        while ((object = object8) != null) {
            object8 = ((Clan)object8).next;
            this.addClan_(clanTree, (Clan)object);
        }
        int n8 = set.first();
        while (n8 != -1) {
            Set set5 = new Set();
            set5.includeElement(n8);
            object6 = new Clan(5, set5, set5, set5, this.topOOrder_[n8]);
            this.addClan_(clanTree, (Clan)object6);
            n8 = set.next();
        }
        clanTree.fixLinear(set, this.childRelation_, this.parentRelation_);
        return clanTree;
    }

    private void addToClanList_(Clan clan) {
        if (this.firstClan_ == null) {
            this.firstClan_ = clan;
            return;
        }
        if (this.firstClan_.size > clan.size) {
            clan.listnext = this.firstClan_;
            this.firstClan_ = clan;
            return;
        }
        Clan clan2 = this.firstClan_;
        while (clan2.listnext != null && clan2.listnext.size < clan.size) {
            clan2 = clan2.listnext;
        }
        clan.listnext = clan2.listnext;
        clan2.listnext = clan;
    }

    private void transitiveClosure_() {
        int n = 0;
        while (n < this.numNodes_) {
            int n2 = 0;
            while (n2 < this.numNodes_) {
                if (this.childRelation_[n2].isElement(n)) {
                    this.childRelation_[n2].union(this.childRelation_[n]);
                }
                ++n2;
            }
            ++n;
        }
    }

    private void transitiveReduction_() {
        this.transitiveClosure_();
        int n = 0;
        while (n < this.numNodes_) {
            int n2 = 0;
            while (n2 < this.numNodes_) {
                if (this.childRelation_[n2].isElement(n)) {
                    this.childRelation_[n2].difference(this.childRelation_[n]);
                }
                ++n2;
            }
            ++n;
        }
    }

    private void makeChildRelation_() {
        this.numNodes_ = 0;
        Node node = this.graph_.firstNode();
        while (node != null) {
            if (node.getIndex() > this.numNodes_ - 1) {
                this.numNodes_ = node.getIndex() + 1;
            }
            node = this.graph_.nextNode(node);
        }
        this.childRelation_ = new Set[this.numNodes_];
        int n = 0;
        while (n < this.numNodes_) {
            this.childRelation_[n] = new Set();
            ++n;
        }
        node = this.graph_.firstNode();
        while (node != null) {
            int n2 = node.firstChild();
            while (n2 != -1) {
                this.childRelation_[node.getIndex()].includeElement(n2);
                n2 = node.nextChild();
            }
            node = this.graph_.nextNode(node);
        }
    }

    void makeConnectedComponents_(Set set) {
        int n;
        this.ccComponents_ = 0;
        this.ccNodes_ = new Set[set.numberOfElements()];
        while ((n = set.first()) != -1) {
            this.ccNodes_[this.ccComponents_] = new Set();
            Set set2 = this.ccNodes_[this.ccComponents_];
            set2.includeElement(n);
            Set set3 = (Set)this.ancestorRelation_[n].clone();
            set3.union(this.descendentRelation_[n]);
            set3.intersect(set);
            set2.union(set3);
            int n2 = -1;
            while (set2.numberOfElements() != n2) {
                n2 = set2.numberOfElements();
                set3 = new Set();
                set3.indexedUnion(this.ancestorRelation_, set2);
                set3.indexedUnion(this.descendentRelation_, set2);
                set3.intersect(set);
                set2.union(set3);
            }
            set.difference(set2);
            ++this.ccComponents_;
        }
    }

    private boolean fillTopOOrder_() {
        int[] nArray = new int[this.numNodes_];
        int n = 0;
        while (n < this.numNodes_) {
            this.topOOrder_[n] = this.height_[n];
            ++n;
        }
        return true;
    }

    private int nodeOrder_(Set set) {
        int n = this.numNodes_;
        int n2 = set.first();
        while (n2 != -1) {
            if (this.topOOrder_[n2] < n) {
                n = this.topOOrder_[n2];
            }
            n2 = set.next();
        }
        return n;
    }

    private void addClan_(ClanTree clanTree, Clan clan) {
        ClanTree clanTree2 = new ClanTree();
        clanTree2.clan = clan;
        this.addChild_(clanTree, clanTree2);
    }

    private void addChild_(ClanTree clanTree, ClanTree clanTree2) {
        ClanTree clanTree3;
        Clan clan = clanTree2.clan;
        int n = clan.order;
        block0: do {
            if (clanTree.firstChild == null) {
                clanTree.firstChild = clanTree2;
                clanTree2.parent = clanTree;
                clanTree2.nextSibling = null;
                return;
            }
            clanTree3 = clanTree.firstChild;
            while (clanTree3 != null) {
                if (clanTree3.clan.nodes.isSubset(clan.nodes)) {
                    clanTree = clanTree3;
                    continue block0;
                }
                clanTree3 = clanTree3.nextSibling;
            }
        } while (clanTree3 != null);
        if (clanTree.firstChild.clan.order > n) {
            clanTree2.nextSibling = clanTree.firstChild;
            clanTree.firstChild = clanTree2;
            clanTree2.parent = clanTree;
            return;
        }
        ClanTree clanTree4 = clanTree.firstChild;
        while (clanTree4.nextSibling != null && clanTree4.nextSibling.clan.order <= n) {
            clanTree4 = clanTree4.nextSibling;
        }
        clanTree2.nextSibling = clanTree4.nextSibling;
        clanTree4.nextSibling = clanTree2;
        clanTree2.parent = clanTree;
    }

    private void moveChild_(ClanTree clanTree, ClanTree clanTree2) {
        Clan clan = clanTree2.clan;
        int n = clan.order;
        if (clanTree.firstChild == null) {
            clanTree.firstChild = clanTree2;
            clanTree2.parent = clanTree;
            clanTree2.nextSibling = null;
            return;
        }
        if (clanTree.firstChild.clan.order > n) {
            clanTree2.nextSibling = clanTree.firstChild;
            clanTree.firstChild = clanTree2;
            clanTree2.parent = clanTree;
            return;
        }
        ClanTree clanTree3 = clanTree.firstChild;
        while (clanTree3.nextSibling != null && clanTree3.nextSibling.clan.order <= n) {
            clanTree3 = clanTree3.nextSibling;
        }
        clanTree2.nextSibling = clanTree3.nextSibling;
        clanTree3.nextSibling = clanTree2;
        clanTree2.parent = clanTree;
    }

    private void assignHeights_() {
        Set set = new Set();
        int n = 0;
        while (n < this.numNodes_) {
            if (this.parentRelation_[n].isEmpty()) {
                set.includeElement(n);
            }
            ++n;
        }
        this.height_ = new int[this.numNodes_];
        n = 0;
        while (n < this.numNodes_) {
            this.height_[n] = -1;
            ++n;
        }
        n = set.first();
        while (n != -1) {
            this.assignHeights_(n, 0);
            n = set.next();
        }
    }

    private void assignHeights_(int n, int n2) {
        if (n2 > this.height_[n]) {
            this.height_[n] = n2;
            Set set = this.childRelation_[n];
            int n3 = set.first();
            while (n3 != -1) {
                this.assignHeights_(n3, n2 + 1);
                n3 = set.next();
            }
        }
    }

    private void reduce_(ClanTree clanTree) {
        int n = 0;
        ClanTree clanTree2 = clanTree.firstChild;
        while (clanTree2 != null) {
            ++n;
            clanTree2 = clanTree2.nextSibling;
        }
        ClanTree[] clanTreeArray = new ClanTree[n];
        clanTree2 = clanTree.firstChild;
        int n2 = 0;
        while (clanTree2 != null) {
            clanTreeArray[n2] = clanTree2;
            clanTree2 = clanTree2.nextSibling;
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            this.reduce_(clanTreeArray[n2]);
            ++n2;
        }
        int n3 = clanTree.parent != null ? clanTree.parent.clan.clanType : 0;
        int n4 = clanTree.clan.clanType;
        if (clanTree.parent != null && (n3 == n4 || n3 == 4 && n4 == 1 || n3 == 1 && n4 == 4)) {
            ClanTree clanTree3;
            if (n4 == 4) {
                clanTree.parent.clan.clanType = 4;
            }
            while (clanTree.firstChild != null) {
                clanTree3 = clanTree.firstChild;
                clanTree.firstChild = clanTree.firstChild.nextSibling;
                this.moveChild_(clanTree.parent, clanTree3);
            }
            if (clanTree.parent.firstChild == clanTree) {
                clanTree.parent.firstChild = clanTree.nextSibling;
            } else {
                clanTree3 = clanTree.parent.firstChild;
                while (clanTree3.nextSibling != clanTree) {
                    clanTree3 = clanTree3.nextSibling;
                }
                clanTree3.nextSibling = clanTree.nextSibling;
            }
        }
    }

    private void printRelation_(Set[] setArray) {
        System.out.println();
        int n = 0;
        while (n < this.numNodes_) {
            int n2 = 0;
            while (n2 < this.numNodes_) {
                if (setArray[n].isElement(n2)) {
                    System.out.print("1 ");
                } else {
                    System.out.print("0 ");
                }
                ++n2;
            }
            System.out.println();
            ++n;
        }
    }

    private void setId_(ClanTree clanTree) {
        clanTree.clan.id = clanTree.clan.clanType == 5 ? clanTree.clan.nodes.first() : this.id_++;
        ClanTree clanTree2 = clanTree.firstChild;
        while (clanTree2 != null) {
            this.setId_(clanTree2);
            clanTree2 = clanTree2.nextSibling;
        }
    }

    void attributeGraph_() {
        this.bbSizeAttribute_(this.root_, false);
        this.fillLeftSiblings_(this.root_);
        this.bbCornerAttribute_(this.root_);
        this.treeLookup_ = new ClanTree[this.numNodes_];
        this.setLookup_(this.root_);
        this.setHeightInTree_(this.root_, 0);
        this.longEdgeHeuristic_();
        this.treeLookup_ = new ClanTree[this.numNodes_];
        this.setLookup_(this.root_);
        this.bbSizeAttribute_(this.root_, true);
        this.bbCornerAttribute_(this.root_);
        this.realSizes_(this.root_);
        this.angleFix_();
        this.angleFix_();
        Node node = this.graph_.getNodeFromIndex(0);
        int n = 0;
        while (n < this.numNodes_) {
            if (this.parentRelation_[n].isEmpty()) {
                node = this.graph_.getNodeFromIndex(n);
                break;
            }
            ++n;
        }
        DPoint dPoint = node.getPosition();
        this.copyCorner_(this.root_);
        this.removeBends_();
        DPoint dPoint2 = node.getPosition();
        dPoint.x -= dPoint2.x;
        dPoint.y -= dPoint2.y;
        Node node2 = this.graph_.firstNode();
        while (node2 != null) {
            dPoint2 = node2.getPosition();
            node2.setPosition(dPoint2.x + dPoint.x, dPoint2.y + dPoint.y);
            node2 = this.graph_.nextNode(node2);
        }
    }

    private void copyCorner_(ClanTree clanTree) {
        if (clanTree == null) {
            return;
        }
        if (clanTree.clan.clanType == 5) {
            DPoint dPoint = new DPoint(clanTree.position.x, clanTree.position.y);
            dPoint.x += clanTree.size.width / 2.0;
            dPoint.y -= clanTree.size.height / 2.0;
            this.graph_.getNodeFromIndex(clanTree.clan.id).setPosition(dPoint);
        }
        this.copyCorner_(clanTree.firstChild);
        this.copyCorner_(clanTree.nextSibling);
    }

    private void bbCornerAttribute_(ClanTree clanTree) {
        if (clanTree == null) {
            return;
        }
        if (clanTree.parent == null) {
            clanTree.position.x = 0.0;
            clanTree.position.y = 0.0;
        } else if (clanTree.parent.clan.clanType == 2) {
            clanTree.position.x = clanTree.parent.position.x + (clanTree.parent.size.width - clanTree.size.width) / 2.0;
            clanTree.position.y = clanTree.leftSibling != null ? clanTree.leftSibling.position.y - clanTree.leftSibling.size.height - clanTree.parent.extraheight : clanTree.parent.position.y;
        } else {
            clanTree.position.y = clanTree.parent.position.y - (clanTree.parent.size.height - clanTree.size.height) / 2.0;
            clanTree.position.x = clanTree.leftSibling != null ? clanTree.leftSibling.position.x + clanTree.leftSibling.size.width : clanTree.parent.position.x;
        }
        this.bbCornerAttribute_(clanTree.firstChild);
        this.bbCornerAttribute_(clanTree.nextSibling);
    }

    private void realSizes_(ClanTree clanTree) {
        if (clanTree == null) {
            return;
        }
        if (clanTree.parent != null) {
            if (clanTree.parent.clan.clanType == 2) {
                clanTree.size.width = clanTree.parent.size.width;
                clanTree.position.x = clanTree.parent.position.x;
            } else {
                clanTree.size.height = clanTree.parent.size.height;
                clanTree.position.y = clanTree.parent.position.y;
            }
        }
        this.realSizes_(clanTree.firstChild);
        this.realSizes_(clanTree.nextSibling);
    }

    private void fillLeftSiblings_(ClanTree clanTree) {
        ClanTree clanTree2 = clanTree.firstChild;
        ClanTree clanTree3 = null;
        while (clanTree2 != null) {
            clanTree2.leftSibling = clanTree3;
            clanTree3 = clanTree2;
            clanTree2 = clanTree2.nextSibling;
        }
        clanTree2 = clanTree.firstChild;
        while (clanTree2 != null) {
            this.fillLeftSiblings_(clanTree2);
            clanTree2 = clanTree2.nextSibling;
        }
    }

    private void bbSizeAttribute_(ClanTree clanTree, boolean bl) {
        if (clanTree == null) {
            return;
        }
        this.bbSizeAttribute_(clanTree.firstChild, bl);
        clanTree.extraheight = 0.0;
        clanTree.size = this.bbSize_(clanTree, bl);
        this.bbSizeAttribute_(clanTree.nextSibling, bl);
    }

    private DDimension bbSize_(ClanTree clanTree, boolean bl) {
        DDimension dDimension = new DDimension(0.0, 0.0);
        if (clanTree.clan.clanType == 2) {
            dDimension.width = this.childMax_(clanTree, 1);
            dDimension.height = this.childSum_(clanTree, 2);
        } else if (clanTree.clan.clanType == 5) {
            if (!bl) {
                dDimension = this.graph_.getNodeFromIndex(clanTree.clan.id).getBoundingBox();
                dDimension.width += this.hSpacing_;
                dDimension.height += this.vSpacing_;
            } else {
                dDimension.width = clanTree.size.width;
                dDimension.height = clanTree.size.height;
            }
        } else {
            dDimension.height = clanTree.size.height < this.childMax_(clanTree, 2) ? this.childMax_(clanTree, 2) : clanTree.size.height;
            this.setExtras_(clanTree, dDimension.height);
            dDimension.width = this.childSum_(clanTree, 1);
        }
        return dDimension;
    }

    private double childMax_(ClanTree clanTree, int n) {
        double d = 0.0;
        ClanTree clanTree2 = clanTree.firstChild;
        while (clanTree2 != null) {
            if (n == 1 && clanTree2.size.width > d || n == 2 && clanTree2.size.height > d) {
                d = n == 1 ? clanTree2.size.width : clanTree2.size.height;
            }
            clanTree2 = clanTree2.nextSibling;
        }
        return d;
    }

    private double childSum_(ClanTree clanTree, int n) {
        double d = 0.0;
        ClanTree clanTree2 = clanTree.firstChild;
        while (clanTree2 != null) {
            d += n == 1 ? clanTree2.size.width : clanTree2.size.height;
            clanTree2 = clanTree2.nextSibling;
        }
        return d;
    }

    private void setExtras_(ClanTree clanTree, double d) {
        double d2 = 0.0;
        ClanTree clanTree2 = clanTree.firstChild;
        while (clanTree2 != null) {
            if (clanTree2.clan.clanType == 2 && clanTree2.size.height < d) {
                int n = 0;
                ClanTree clanTree3 = clanTree2.firstChild;
                while (clanTree3 != null) {
                    ++n;
                    clanTree3 = clanTree3.nextSibling;
                }
                if (n > 1) {
                    clanTree2.extraheight = (d - clanTree2.size.height) / (double)(n - 1);
                    clanTree2.size.height = d;
                }
            }
            clanTree2 = clanTree2.nextSibling;
        }
    }

    private void setPositions_(ClanTree clanTree) {
        clanTree.dummy = false;
        if (clanTree.clan.clanType == 5) {
            int n = clanTree.clan.nodes.first();
            if (n < this.numNodesOriginal_) {
                clanTree.maxx = clanTree.centerx = this.graph_.getNodeFromIndex((int)n).getPosition().x;
                clanTree.minx = clanTree.centerx;
            } else {
                clanTree.dummy = true;
            }
        } else {
            boolean bl = true;
            ClanTree clanTree2 = clanTree.firstChild;
            while (clanTree2 != null) {
                this.setPositions_(clanTree2);
                if (!clanTree2.dummy) {
                    if (bl) {
                        clanTree.minx = clanTree2.minx;
                        clanTree.maxx = clanTree2.maxx;
                    } else {
                        if (clanTree2.minx < clanTree.minx) {
                            clanTree.minx = clanTree2.minx;
                        }
                        if (clanTree2.maxx > clanTree.maxx) {
                            clanTree.maxx = clanTree2.maxx;
                        }
                    }
                    bl = false;
                }
                clanTree2 = clanTree2.nextSibling;
            }
            if (bl) {
                clanTree.dummy = true;
            } else {
                clanTree.centerx = (clanTree.minx + clanTree.maxx) / 2.0;
            }
        }
    }

    private void reOrder_(ClanTree clanTree) {
        if (clanTree.clan.clanType == 5) {
            return;
        }
        int n = 0;
        int n2 = 0;
        ClanTree clanTree2 = clanTree.firstChild;
        while (clanTree2 != null) {
            this.reOrder_(clanTree2);
            ++n;
            if (clanTree2.dummy) {
                ++n2;
            }
            clanTree2 = clanTree2.nextSibling;
        }
        if (n < 2 || clanTree.clan.clanType != 1 && clanTree.clan.clanType != 4) {
            return;
        }
        ClanTree[] clanTreeArray = new ClanTree[n];
        int n3 = 0;
        clanTree2 = clanTree.firstChild;
        while (clanTree2 != null) {
            clanTreeArray[n3++] = clanTree2;
            clanTree2 = clanTree2.nextSibling;
        }
        n3 = 0;
        while (n3 < n - 1) {
            int n4 = n3 + 1;
            while (n4 < n) {
                if (!clanTreeArray[n3].dummy && !clanTreeArray[n4].dummy && clanTreeArray[n4].centerx < clanTreeArray[n3].centerx || !clanTreeArray[n3].dummy && clanTreeArray[n4].dummy) {
                    ClanTree clanTree3 = clanTreeArray[n3];
                    clanTreeArray[n3] = clanTreeArray[n4];
                    clanTreeArray[n4] = clanTree3;
                }
                ++n4;
            }
            ++n3;
        }
        if (n2 > 0) {
            int n5 = (n - n2) / 2;
            n3 = 0;
            while (n3 < n5) {
                ClanTree clanTree4 = clanTreeArray[n3];
                clanTreeArray[n3] = clanTreeArray[n3 + n2];
                clanTreeArray[n3 + n2] = clanTree4;
                ++n3;
            }
        }
        clanTree.firstChild = clanTreeArray[0];
        n3 = 0;
        while (n3 < n - 1) {
            clanTreeArray[n3].nextSibling = clanTreeArray[n3 + 1];
            ++n3;
        }
        clanTreeArray[n3].nextSibling = null;
    }

    private void setLookup_(ClanTree clanTree) {
        if (clanTree == null) {
            return;
        }
        if (clanTree.clan.clanType == 5) {
            this.treeLookup_[clanTree.clan.id] = clanTree;
        }
        this.setLookup_(clanTree.firstChild);
        this.setLookup_(clanTree.nextSibling);
    }

    private void setHeightInTree_(ClanTree clanTree, int n) {
        if (clanTree == null) {
            return;
        }
        clanTree.heightInTree = n;
        this.setHeightInTree_(clanTree.firstChild, n + 1);
        this.setHeightInTree_(clanTree.nextSibling, n);
    }

    private void longEdgeHeuristic_() {
        int n = this.numNodes_;
        int n2 = 0;
        while (n2 < n) {
            Set set = (Set)this.graph_.children(n2).clone();
            int n3 = set.first();
            while (n3 != -1) {
                ClanTree clanTree = this.treeLookup_[n2];
                ClanTree clanTree2 = this.treeLookup_[n3];
                int n4 = n2;
                int n5 = n3;
                ClanTree clanTree3 = clanTree.parent;
                ClanTree clanTree4 = clanTree2.parent;
                while (clanTree3 != null && clanTree3.clan.clanType != 2) {
                    clanTree3 = clanTree3.parent;
                }
                while (clanTree4 != null && clanTree4.clan.clanType != 2) {
                    clanTree4 = clanTree4.parent;
                }
                if (clanTree3 != null && clanTree4 != null) {
                    ClanTree clanTree5;
                    ClanTree clanTree6;
                    ClanTree clanTree7;
                    ClanTree clanTree8 = clanTree;
                    ClanTree clanTree9 = clanTree2;
                    while (clanTree8.parent != clanTree9.parent) {
                        if (clanTree8.heightInTree >= clanTree9.heightInTree) {
                            clanTree8 = clanTree8.parent;
                        }
                        if (clanTree8.heightInTree >= clanTree9.heightInTree) continue;
                        clanTree9 = clanTree9.parent;
                    }
                    while (clanTree9 != null && clanTree9 != clanTree8) {
                        clanTree9 = clanTree9.nextSibling;
                    }
                    if (clanTree9 == null) {
                        clanTree7 = clanTree;
                        clanTree6 = clanTree2;
                    } else {
                        clanTree7 = clanTree2;
                        clanTree6 = clanTree;
                    }
                    clanTree8 = clanTree8.parent;
                    while (clanTree7.parent != clanTree8) {
                        if (clanTree7.parent.clan.clanType == 2) {
                            clanTree5 = clanTree7.nextSibling;
                            while (clanTree5 != null) {
                                n4 = this.addDummy_(clanTree5, n4, n5, clanTree, clanTree2);
                                clanTree5 = clanTree5.nextSibling;
                            }
                        }
                        clanTree7 = clanTree7.parent;
                    }
                    while (clanTree6.parent != clanTree8) {
                        if (clanTree6.parent.clan.clanType == 2) {
                            clanTree5 = clanTree6.leftSibling;
                            while (clanTree5 != null) {
                                n5 = this.addDummy_(clanTree5, n4, n5, clanTree, clanTree2);
                                clanTree5 = clanTree5.leftSibling;
                            }
                        }
                        clanTree6 = clanTree6.parent;
                    }
                    clanTree7 = clanTree7.nextSibling;
                    while (clanTree7 != clanTree6) {
                        n4 = this.addDummy_(clanTree7, n4, n5, clanTree, clanTree2);
                        clanTree7 = clanTree7.nextSibling;
                    }
                }
                n3 = set.next();
            }
            ++n2;
        }
    }

    private void angleFix_() {
        int n = 0;
        while (n < this.numNodes_) {
            ClanTree clanTree = this.treeLookup_[n];
            int n2 = 0;
            while (n2 < 2) {
                Set set = n2 == 0 ? this.graph_.parents(n) : this.graph_.children(n);
                int n3 = set.first();
                while (n3 != -1) {
                    double d;
                    double d2;
                    Object object;
                    if (n3 < this.numNodes_) {
                        object = this.treeLookup_[n3];
                        d2 = ((ClanTree)object).position.x + ((ClanTree)object).size.width / 2.0;
                        d = ((ClanTree)object).position.y - ((ClanTree)object).size.height / 2.0;
                    } else {
                        object = this.graph_.getNodeFromIndex(n3).getPosition();
                        d2 = ((DPoint)object).x;
                        d = ((DPoint)object).y;
                    }
                    double d3 = clanTree.position.x + clanTree.size.width / 2.0;
                    double d4 = clanTree.position.y - clanTree.size.height / 2.0;
                    double d5 = Math.abs(d3 - d2);
                    if (d5 != 0.0) {
                        double d6 = Math.abs(d4 - d);
                        double d7 = d6 / d5 * clanTree.size.width / 2.0;
                        double d8 = clanTree.size.height / 2.0;
                        if (!((d8 -= d7) <= this.vSpacing_ / 2.0)) {
                            double d9 = d6 * d6 / (d5 * d5 + d6 * d6);
                            d9 = Math.sqrt(d9);
                            d9 *= clanTree.size.width / 2.0;
                            if (d2 > d3) {
                                d9 = clanTree.size.width - d9;
                            }
                            LxComponent lxComponent = n2 == 0 ? this.graph_.removeEdge(n3, n) : this.graph_.removeEdge(n, n3);
                            int n4 = this.graph_.insertNode(lxComponent, true);
                            Node node = this.graph_.getNodeFromIndex(n4);
                            if (n2 == 0) {
                                this.graph_.insertEdge(lxComponent, n3, n4);
                                this.graph_.insertEdge(lxComponent, n4, n);
                                node.setPosition(clanTree.position.x + d9, clanTree.position.y - this.vSpacing_ / 4.0);
                            } else {
                                this.graph_.insertEdge(lxComponent, n, n4);
                                this.graph_.insertEdge(lxComponent, n4, n3);
                                node.setPosition(clanTree.position.x + d9, clanTree.position.y - clanTree.size.height + this.vSpacing_ / 4.0);
                            }
                        }
                    }
                    n3 = set.next();
                }
                ++n2;
            }
            ++n;
        }
    }

    private void removeBends_() {
        Node node = this.graph_.firstNode();
        while (node != null) {
            if (node.getIndex() >= this.numNodesOriginal_) {
                Object object;
                boolean bl = false;
                int n = node.getIndex();
                Node node2 = this.graph_.getNodeFromIndex(this.graph_.parents(n).first());
                Node node3 = this.graph_.getNodeFromIndex(node.firstChild());
                DPoint dPoint = node2.getPosition();
                DPoint dPoint2 = node3.getPosition();
                double d = (dPoint2.x - dPoint.x) / (dPoint2.y - dPoint.y);
                double d2 = Math.min(dPoint.x, dPoint2.x);
                double d3 = Math.min(dPoint.y, dPoint2.y);
                double d4 = Math.max(dPoint.x, dPoint2.x);
                double d5 = Math.max(dPoint.y, dPoint2.y);
                Node node4 = this.graph_.firstNode();
                while (node4 != null) {
                    if (node4.getIndex() < this.numNodesOriginal_ && node4 != node2 && node4 != node3) {
                        object = node4.getPosition();
                        DDimension dDimension = node4.getBoundingBox();
                        double d6 = ((DPoint)object).x - dDimension.width / 2.0 - this.hSpacing_ / 10.0;
                        double d7 = ((DPoint)object).x + dDimension.width / 2.0 + this.hSpacing_ / 10.0;
                        double d8 = ((DPoint)object).y - dDimension.height / 2.0 - this.vSpacing_ / 10.0;
                        double d9 = ((DPoint)object).y + dDimension.height / 2.0 + this.vSpacing_ / 10.0;
                        if (!(d6 <= d2 && d7 <= d2 || d6 >= d4 && d7 >= d4 || d8 <= d3 && d9 <= d3 || d8 >= d5 && d9 >= d5)) {
                            double d10;
                            if (d8 > d3 && d8 < d5 && d6 <= (d10 = dPoint.x + d * (d8 - dPoint.y)) && d10 <= d7) {
                                bl = true;
                                break;
                            }
                            if (d9 > d3 && d9 < d5 && d6 <= (d10 = dPoint.x + d * (d9 - dPoint.y)) && d10 <= d7) {
                                bl = true;
                                break;
                            }
                            if (d6 > d2 && d6 < d4 && d8 <= (d10 = dPoint.y + (d6 - dPoint.x) / d) && d10 <= d9) {
                                bl = true;
                                break;
                            }
                            if (d7 > d2 && d7 < d4 && d8 <= (d10 = dPoint.y + (d7 - dPoint.x) / d) && d10 <= d9) {
                                bl = true;
                                break;
                            }
                        }
                    }
                    node4 = this.graph_.nextNode(node4);
                }
                if (!bl) {
                    this.graph_.removeEdge(node2.getIndex(), n);
                    object = this.graph_.removeEdge(n, node3.getIndex());
                    this.graph_.insertEdge((LxComponent)object, node2.getIndex(), node3.getIndex());
                }
            }
            node = this.graph_.nextNode(node);
        }
    }

    public int addDummy_(ClanTree clanTree, int n, int n2, ClanTree clanTree2, ClanTree clanTree3) {
        Object object;
        ClanTree clanTree4;
        ++this.numNodes_;
        LxComponent lxComponent = this.graph_.removeEdge(n, n2);
        int n3 = this.graph_.insertNode(lxComponent, true);
        this.graph_.insertEdge(lxComponent, n, n3);
        this.graph_.insertEdge(lxComponent, n3, n2);
        if (clanTree.clan.clanType == 5) {
            clanTree4 = new ClanTree();
            clanTree4.clan = clanTree.clan;
            clanTree4.size.setTo(clanTree.size);
            clanTree4.position.move(clanTree.position);
            clanTree4.parent = clanTree;
            clanTree.clan = new Clan(1, new Set(), null, null, 0);
            clanTree.firstChild = clanTree4;
        }
        clanTree4 = new ClanTree();
        clanTree4.clan = new Clan(5, new Set(n3), null, null, 0);
        clanTree4.clan.id = n3;
        clanTree4.parent = clanTree;
        double d = clanTree2.position.x + clanTree2.size.width / 2.0;
        double d2 = clanTree2.position.y + clanTree2.size.height / 2.0;
        double d3 = clanTree3.position.x + clanTree3.size.width / 2.0;
        double d4 = clanTree3.position.y + clanTree3.size.height / 2.0;
        double d5 = clanTree.position.y + clanTree.size.height / 2.0;
        double d6 = d3 + (d - d3) / (d2 - d4) * (d5 - d4);
        int n4 = 0;
        int n5 = 1;
        double d7 = Math.abs(clanTree.position.x - d6);
        ClanTree clanTree5 = clanTree.firstChild;
        while (clanTree5 != null) {
            if (Math.abs(clanTree5.position.x + clanTree5.size.width - d6) <= d7) {
                d7 = Math.abs(clanTree5.position.x + clanTree5.size.width - d6);
                n4 = n5;
            }
            ++n5;
            clanTree5 = clanTree5.nextSibling;
        }
        if (n4 == 0) {
            clanTree4.nextSibling = clanTree.firstChild;
            clanTree.firstChild = clanTree4;
        } else {
            object = clanTree.firstChild;
            n5 = 1;
            while (n5 < n4) {
                object = ((ClanTree)object).nextSibling;
                ++n5;
            }
            clanTree4.nextSibling = ((ClanTree)object).nextSibling;
            ((ClanTree)object).nextSibling = clanTree4;
            clanTree4.leftSibling = object;
        }
        if (clanTree4.nextSibling != null) {
            clanTree4.nextSibling.leftSibling = clanTree4;
        }
        clanTree4.size.setTo(this.hSpacing_, this.vSpacing_);
        object = this.graph_.getNodeFromIndex(n3);
        ((Node)object).setBoundingBox(this.hSpacing_, this.vSpacing_);
        return n3;
    }

    public void setVSpacing(double d) {
        this.vSpacing_ = d;
    }

    public void setHSpacing(double d) {
        this.hSpacing_ = d;
    }

    public double getVSpacing() {
        return this.vSpacing_;
    }

    public double getHSpacing() {
        return this.hSpacing_;
    }
}

