/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dm;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dm.RediscoverException;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Color;
import java.awt.Image;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public abstract class AbstractPort
extends PhysicalElement
implements ActionListener {
    public static final int REASON_UNMANAGABLE = 0;
    public static final int REASON_NONE = 2;
    public static final int REASON_hwFailure = 3;
    public static final int REASON_loopbackDiagFailure = 4;
    public static final int REASON_linkFailure = 7;
    public static final int REASON_ADMINDOWN = 12;
    public static final int REASON_FCOTNOTPRESENT = 29;
    public static final int REASON_LOSS_SIGNAL = 83;
    public static final int REASON_LOSS_SYNC = 84;
    public static final int REASON_NOS_RCVD = 85;
    public static final int REASON_OLS_RCVD = 86;
    public static final int REASON_CREDIT_LOSS = 89;
    public static final int REASON_LIPF8_RCVD = 96;
    public static final int REASON_TRUNK_INCOMPLETE = 108;
    public static final int REASON_OUT_OF_SERVICE = 122;
    public static final int REASON_SFPINVALID = 154;
    public static final int REASON_SFPABSENT = 155;
    public static final int UP = 0;
    public static final int DOWN = 1;
    public static final int FAIL = 2;
    public static final int MINOR = 3;
    public static final int UNMANAGABLE = 4;
    public static final int OUTOFSERVICE = 5;
    public static final int UP_STATUS = 1;
    public static final int DOWN_STATUS = 2;
    public static final int PORT_DISPLAY_LEN = 60;
    public int _cause;
    public int _mode;
    public String _modeString;
    protected String _toolTipText;
    protected static MibEnum[] _OperStatusReasons;
    protected static JPopupMenu _Menu;
    public static final Color[] _Colors;
    static final String[] _StatusLabel;
    public int _status;
    public String _description;
    protected Image _errorImage;
    protected Image _okImage;

    @Override
    public void setStatus(VarBindList varBindList, int offset, PhysicalView view) throws RediscoverException {
        SnmpVar v = varBindList.get(offset).getVar();
        if (v.getType() == 2) {
            this.setStatus(((SnmpInt)v).getValue(), view);
        } else {
            this.disable();
        }
    }

    public void setPortNotPresent(PhysicalView view) {
        if (this._okImage == null) {
            view.updateImage(this._image, this._rect.x, this._rect.y, Color.black);
        } else {
            view.updateImage(this._okImage, this._rect.x, this._rect.y, Color.black);
        }
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    protected void setStatus(int oper, PhysicalView view) {
        this._status = oper;
        switch (this._status) {
            case 1: {
                if (this._image == this._errorImage) {
                    this._image = this._okImage;
                }
                view.updateImage(this._image, this._rect.x, this._rect.y, _Colors[0]);
                return;
            }
            case 2: {
                if (this._image == this._errorImage) {
                    this._image = this._okImage;
                }
                view.updateImage(this._image, this._rect.x, this._rect.y, _Colors[1]);
                return;
            }
        }
        if (this.getErrorBitmap() != null) {
            if (this._errorImage == null) {
                try {
                    this._errorImage = Discover.getInstance().getImage(this.getErrorBitmap());
                }
                catch (Exception ex) {
                    this._errorImage = this._image;
                }
            }
            if (this._image != this._errorImage) {
                this._okImage = this._image;
                this._image = this._errorImage;
            }
        }
        view.updateImage(this._image, this._rect.x, this._rect.y, _Colors[2]);
    }

    public void linkTrap(boolean up, VarBindList vbl, PhysicalView view) {
        this.setStatus(up ? 1 : 2, view);
        view.repaint();
    }

    protected int getImageXOffset() {
        return this._rect.x;
    }

    protected int getImageYOffset() {
        return this._rect.y;
    }

    protected void setCrossImage(PhysicalView view, Color color) {
        if (this._errorImage == null) {
            try {
                this._errorImage = Discover.getInstance().getImage(this.getErrorBitmap());
            }
            catch (Exception ex) {
                this._errorImage = this._image;
            }
        }
        if (this._image != this._errorImage) {
            this._okImage = this._image;
            this._image = this._errorImage;
        }
        view.updateImage(this._image, this.getImageXOffset(), this.getImageYOffset(), color);
    }

    public JPopupMenu buildMenu() {
        JPopupMenu menu = super.buildMenu(this);
        menu.addSeparator();
        String[][] menuItems = new String[][]{{"Enable", "enableAction"}, {"Disable", "disableAction"}};
        this.addMenuItems(menu, menuItems, this);
        return menu;
    }

    public void enableAction(PhysicalElement[] selected) {
        this.applyAll(selected, "ifAdminStatus", (SnmpVar)new SnmpInt(1));
    }

    public void disableAction(PhysicalElement[] selected) {
        StringBuffer sb = null;
        Array list = new Array();
        int count = 0;
        for (int i = 0; i < selected.length; ++i) {
            if (selected[i] instanceof AbstractPort && ((AbstractPort)selected[i])._status == 1) {
                if (sb == null) {
                    sb = new StringBuffer("Please confirm disabling:\n");
                } else {
                    sb.append(",");
                }
                String msg = Discover.getRoot().ifIndexToName(selected[i].getIndex()[0]);
                sb.append(msg);
                if ((count += msg.length()) > 60) {
                    count = 0;
                    sb.append("\n");
                }
            }
            list.addElement((Object)selected[i]);
        }
        if (sb != null && JOptionPane.showConfirmDialog(DeviceManager.getInstance(), sb.toString(), DeviceManager.getInstance().getTitle(), 0) != 0) {
            return;
        }
        PhysicalElement[] disableList = new PhysicalElement[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            disableList[i] = (PhysicalElement)list.elementAt(i);
        }
        this.applyAll(disableList, "ifAdminStatus", (SnmpVar)new SnmpInt(2));
    }

    public String getErrorBitmap() {
        return null;
    }

    public int getStatus() {
        return this._status;
    }

    public String toString() {
        return "Port " + this.getIndex()[0];
    }

    public boolean isExternalPort() {
        return false;
    }

    static {
        _Colors = new Color[]{Color.green, new Color(160, 132, 32), Color.red, Color.orange, Color.lightGray, Color.blue};
        _StatusLabel = new String[]{"Up", "Down", "Fail", "Minor", "Unreachable", "OutOfService"};
    }
}

