/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dm;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.lib.jnm.SnmpIdList;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.GroupButtonPanel;
import com.cisco.dcbu.lib.ui.ToolBarSeparator;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.TableModelEvent;

public class EditFormTable
extends EditTable {
    protected String _formPos = "North";
    protected JComponent[] _formVars;

    public EditFormTable(String[] vars, String[] formVariables) {
        super(vars);
        this._formVariables = formVariables;
        this._formVars = formVariables == null ? null : new JComponent[this._formVariables.length];
        this._isFormEditable = false;
    }

    @Override
    protected void build() {
        this.buildForm();
        super.build();
    }

    protected void buildForm() {
        if (this._formVariables == null) {
            return;
        }
        for (int i = 0; i < this._formVariables.length; ++i) {
            this._formVars[i] = this.buildFormComponent(i);
            this._formVars[i].setFont(ChangedCellRenderer.getNormalFont());
            this._formVars[i].setForeground(EditForm._FgColor);
            this._formPanel.add(this._formVars[i]);
        }
        this._formPanel.add((Component)new ToolBarSeparator());
    }

    protected JComponent buildFormComponent(int index) {
        return new JLabel(this.trim(this._formVariables[index]) + ": ");
    }

    protected boolean isChanged(int index) {
        if (this._formVars[index] instanceof GroupButtonPanel) {
            return ((GroupButtonPanel)this._formVars[index]).isChanged();
        }
        if (this._formVars[index] instanceof FieldPanel) {
            return ((FieldPanel)this._formVars[index]).getField().getFont() == ChangedCellRenderer.getChangeFont();
        }
        return this._formVars[index].getFont() == ChangedCellRenderer.getChangeFont();
    }

    @Override
    protected void set() throws Exception {
        boolean ok = this.formValidate();
        if (!ok) {
            return;
        }
        this.formSet();
        super.set();
    }

    @Override
    protected void get() {
        this.formGet();
        super.get();
    }

    protected void formSet() throws Exception {
    }

    protected boolean formValidate() throws Exception {
        if (this._formVars == null || this._formVariables == null) {
            return true;
        }
        return this.validateFormChanges(this._warningVars, this._warningMsg);
    }

    protected void formGet() {
        if (this._formVariables == null) {
            return;
        }
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(this._formVariables.length));
        for (int i = 0; i < this._formVariables.length; ++i) {
            if (this._formVariables[i].charAt(0) == '-') continue;
            pdu.addNull(new SnmpOID(MibNode.get((String)this._formVariables[i]).getOid(), this.getFormIndex()));
        }
        try {
            this.sendGetFormPdu(pdu);
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)DeviceManager.getInstance(), (String)ex.getMessage());
        }
    }

    protected int[] getFormIndex() {
        return this._index;
    }

    protected void sendGetFormPdu(SnmpPDU pdu) throws SnmpException {
        this.getPeer().send(pdu, (SnmpCallbackIf)this);
    }

    @Override
    protected void callbackForm(SnmpPDU pdu) {
        if (this._formPanel == null) {
            return;
        }
        for (int i = 0; i < this._formVariables.length && i < pdu.getVariables().size(); ++i) {
            this.updateFormComponent(i, pdu.getVar(i));
        }
    }

    protected void updateFormComponent(int index, SnmpVar v) {
        JLabel l = (JLabel)this._formVars[index];
        MibNode mibNode = MibNode.get((String)this._formVariables[index]);
        String value = this.getComponentValueLabel(this._formVariables[index], v, mibNode);
        String display = this.trim(this._formVariables[index]) + ": " + value + " ";
        l.setText(display);
        l.setForeground(v.getType() == 5 ? Color.red : EditForm._FgColor);
    }

    protected String getComponentValueLabel(String var, SnmpVar v, MibNode mibNode) {
        if (v.getType() == 5) {
            return "";
        }
        String tc = mibNode.getTCLabel();
        if (tc != null) {
            if (tc.equals("IdList")) {
                v = new SnmpIdList((SnmpString)v);
            } else if (v.getType() == 4) {
                ((SnmpString)v).cacheString(tc.equals("DisplayString") || tc.equals("SnmpAdminString") || tc.equals("InetAddress"));
            }
        }
        JLabel l = new JLabel();
        this.setComponentValueLabel(l, v, var, mibNode);
        return l.getText();
    }

    protected void setComponentValueLabel(JLabel l, SnmpVar v, String var, MibNode mibNode) {
        EditForm.setComponentValueLabel(l, v, var, mibNode);
    }

    public void setFormPosition(String pos) {
        this._formPos = pos;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        boolean isChanged = false;
        if (this._formVariables != null) {
            for (int i = 0; i < this._formVariables.length; ++i) {
                if (this._formVariables[i] != null && this.isEditable(MibNode.get((String)this._formVariables[i])) && this.isChanged(i)) {
                    isChanged = true;
                    break;
                }
                isChanged = this._tableModel.isEditable() && this._tableModel.isChanged();
            }
        } else {
            isChanged = this._tableModel.isEditable() && this._tableModel.isChanged();
        }
        boolean enable = e != null && (e.getType() == 0 || e.getType() == 1 || e.getType() == -1) && isChanged;
        boolean b = this._tableModel.isEditable();
        boolean a = isChanged;
        this.enableButton('A', enable);
        this.enableButton('u', enable);
    }

    protected boolean validateFormChanges(String[][] warnVars, String[] message) throws Exception {
        if (this._warningVars == null || this._warningVars.length == 0) {
            return true;
        }
        boolean needWarning = false;
        String warnMsg = "";
        int warnVarPos = 0;
        block0: for (int i = 0; i < this._formVariables.length; ++i) {
            if (this._formVariables[i] == null || !this.isEditable(MibNode.get((String)this._formVariables[i])) || !this.isChanged(i)) continue;
            for (int j = 0; j < warnVars.length; ++j) {
                if (!this.isWarnVar(this._formVariables[i], null, warnVars[j])) continue;
                needWarning = true;
                warnVarPos = i;
                warnMsg = message[j];
                continue block0;
            }
        }
        if (needWarning) {
            return this.isIgnoreWarning(warnMsg, this.getFormVar(warnVarPos));
        }
        return true;
    }

    protected Object getFormVar(int index) {
        return null;
    }

    protected boolean isIgnoreWarning(String message, Object value) {
        return this.isIgnoreWarning(message);
    }
}

