/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dm;

import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.lib.jnm.PortField;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.CheckBoxPanel;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.GroupButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InsertForm
extends EditForm {
    protected InsertDialog _parent;
    protected EditTable _table;

    public InsertForm(InsertDialog parent, EditTable table) {
        super(table._insertVars);
        this._parent = parent;
        this._table = table;
    }

    protected void removeListeners() {
        for (int i = 0; i < this._buttons.length; ++i) {
            this._buttons[i].removeActionListener(this);
        }
    }

    @Override
    protected boolean isEditable(MibNode mibNode) {
        return true;
    }

    @Override
    protected int[] getIndex() {
        return this._table.getIndex();
    }

    protected boolean isParentMultiple() {
        return this._table._parent._isMultiple;
    }

    public JLabel getStatusComponent() {
        return this._parent._status;
    }

    public void setCreateStatus(String msg) {
        this._parent._status.setText(msg);
    }

    public final String getCreateStatus() {
        return this._parent._status.getText();
    }

    @Override
    protected void addChangeListener(int index) {
    }

    @Override
    protected boolean isMultiple() {
        return false;
    }

    @Override
    public SnmpPeer getPeer() {
        return this._table.getPeer();
    }

    protected int[] getLastIndex() {
        if (this._table._tableModel.getRowCount() > 0) {
            return this._table._tableModel.getIndex(this._table._tableModel.getRowCount() - 1);
        }
        return null;
    }

    protected SnmpTableModel getTableModel() {
        return this._table._tableModel;
    }

    protected int[] getRowStatus() {
        return this._table._rowStatus;
    }

    @Override
    protected void build() {
        super.build();
        for (int i = 0; i < this._mibNodes.length; ++i) {
            int defVal;
            if (this._mibNodes[i] == null || (defVal = this._mibNodes[i].getDefVal()) == -1) continue;
            if (this._values[i] instanceof JCheckBox) {
                ((JCheckBox)this._values[i]).setSelected(defVal == 1);
                continue;
            }
            if (this._values[i] instanceof GroupButtonPanel) {
                this.setGroupButtonPanel((GroupButtonPanel)this._values[i], this._mibNodes[i].getEnums(), (SnmpVar)new SnmpInt(defVal));
                continue;
            }
            this.setComponentText(i, Integer.toString(defVal));
        }
        if (!(this._mibNodes[0].getType() != 2 && this._mibNodes[0].getType() != 66 || this._mibNodes.length <= 1 || this._mibNodes[1].isIndex() || this._values[0] instanceof PortField)) {
            if (this._table._tableModel.getRowCount() == 0) {
                if (this._values[0] instanceof JTextField) {
                    ((JTextField)this._values[0]).setText("1");
                } else if (this._values[0] instanceof FieldPanel) {
                    int lo = this._mibNodes[0].getLo();
                    if (lo == 0) {
                        ++lo;
                    }
                    ((FieldPanel)this._values[0]).setText(Integer.toString(lo));
                }
            } else if (this._values[0] instanceof JTextField || this._values[0] instanceof FieldPanel) {
                int hi;
                int[] index = this.getLastIndex();
                int nextValue = index[0] + 1;
                int n = hi = this._mibNodes[0].getHi() == 0 ? -1 : this._mibNodes[0].getHi();
                if (hi != -1 && nextValue > hi) {
                    nextValue = hi;
                }
                this.setComponentText(0, Integer.toString(nextValue));
            }
        }
        this._isEditable = false;
        this.resetChanges();
    }

    protected String[] getCreateButtons() {
        String[] btns = new String[]{"Create", "Close"};
        return btns;
    }

    @Override
    protected void buildButtons() {
        this._buttonPanel = new JPanel(new FlowLayout(2, 7, 7));
        String[] btns = this.getCreateButtons();
        this._buttons = new AbstractButton[btns.length];
        for (int i = 0; i < btns.length; ++i) {
            JButton btn = new JButton(btns[i]);
            btn.addActionListener(this);
            this._buttonPanel.add(btn);
            this._buttons[i] = btn;
        }
    }

    protected void insert() throws Exception {
        SnmpVar[] values = this.getInsertValue();
        int[] index = this.getInsertIndex(values);
        this.tableInsert(values, index);
        this.tableInsertRowFetch(index);
    }

    protected void tableInsert(SnmpVar[] values, int[] index) throws Exception {
        this.tableInsert(this.buildInsertPDU(index, values), index);
    }

    protected void tableInsert(SnmpPDU pdu, int[] index) throws Exception {
        this._table.insert(pdu, index);
    }

    protected int getTableInsertValue() {
        return this._table._insertValue;
    }

    protected void tableInsertRowFetch(int[] index) throws Exception {
        this._table.fetchRow(index);
    }

    protected void tableGet() {
        this._table.get();
    }

    protected SnmpVar[] getInsertValue() throws Exception {
        SnmpVar[] values = new SnmpVar[this._mibNodes.length];
        for (int i = 0; i < this._mibNodes.length; ++i) {
            if (this._mibNodes[i] == null || !this.toGetComponentValue(i)) continue;
            try {
                values[i] = this.getComponentValue(i);
                continue;
            }
            catch (SnmpException ex) {
                String text = this.getComponentText(i);
                if (text != null && text.equals("") && !this._mibNodes[i].isIndex() && this._mibNodes[i].getHi() == 0) {
                    values[i] = null;
                    continue;
                }
                this._values[i].requestFocus();
                throw (SnmpException)ex.fillInStackTrace();
            }
            catch (Exception ex) {
                this.postComponentErrMsg(i, ex);
            }
        }
        return values;
    }

    protected boolean toGetComponentValue(int index) {
        return this._mibNodes[index].isIndex() || this._values[index].isEnabled();
    }

    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        int varNo;
        int indexSize = 0;
        int StringVarNo = 0;
        for (varNo = 0; varNo < this._mibNodes.length && this._mibNodes[varNo] != null && this._mibNodes[varNo].isIndex(); ++varNo) {
            SnmpVar v = values[varNo];
            if (v instanceof SnmpIntList) {
                ++indexSize;
                continue;
            }
            if (v instanceof SnmpString) {
                indexSize += ((SnmpString)v).getValue().length;
                if (!this.isAddStringLength(this._mibNodes[varNo], this._values[varNo])) continue;
                ++StringVarNo;
                continue;
            }
            if (v instanceof SnmpOID) {
                indexSize += ((SnmpOID)v).getValue().length;
                continue;
            }
            ++indexSize;
        }
        int[] index = new int[indexSize += StringVarNo];
        indexSize = 0;
        for (int i = 0; i < varNo; ++i) {
            SnmpVar v = values[i];
            if (v instanceof SnmpInt) {
                index[indexSize++] = ((SnmpInt)v).getValue();
                continue;
            }
            if (v instanceof SnmpUnsignedInt) {
                index[indexSize++] = (int)((SnmpUnsignedInt)v).getValue();
                continue;
            }
            if (v instanceof SnmpIntList) {
                SnmpIntList cfr_ignored_0 = (SnmpIntList)v;
                int[] ports = SnmpIntList.valueOf((byte[])((SnmpIntList)v).getValue());
                index[indexSize++] = ports[0];
                continue;
            }
            if (v instanceof SnmpString) {
                byte[] b = ((SnmpString)v).getValue();
                if (this.isAddStringLength(this._mibNodes[i], this._values[i])) {
                    index[indexSize++] = b.length;
                }
                for (int j = 0; j < b.length; ++j) {
                    index[indexSize++] = b[j] & 0xFF;
                }
                continue;
            }
            if (!(v instanceof SnmpOID)) continue;
            int[] oidVal = ((SnmpOID)v).getValue();
            System.arraycopy(oidVal, 0, index, indexSize, oidVal.length);
            indexSize += oidVal.length;
        }
        return index;
    }

    protected boolean isAddStringLength(MibNode mibNode, JComponent value) {
        if (mibNode.getTCLabel() == null) {
            return mibNode.getType() == 4 && !(value instanceof CheckBoxPanel);
        }
        return mibNode.getType() == 4 && !mibNode.getTCLabel().equals("FcAddressId") && !mibNode.getTCLabel().equals("FcNameId");
    }

    protected SnmpPDU buildInsertPDU(int[] index, SnmpVar[] values) {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(this._mibNodes.length + 1));
        pdu.addVar(new SnmpOID(this._table._rowStatus, index), (SnmpVar)new SnmpInt(this._table._insertValue));
        for (int i = 0; i < this._mibNodes.length; ++i) {
            if (this._mibNodes[i] == null || this._mibNodes[i].isIndex() || values[i] == null) continue;
            pdu.addVar(new SnmpOID(this._mibNodes[i].getOid(), index), values[i]);
        }
        return pdu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            switch (((JButton)e.getSource()).getText().charAt(1)) {
                case 'r': {
                    this.insert();
                    return;
                }
                case 'l': {
                    this._parent.dispose();
                }
            }
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)this._parent, (String)ex.getMessage());
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this._parent, (Exception)ex);
        }
        catch (Error ex) {
            Util.errorMessage((Component)this._parent, (String)ex.getMessage());
        }
    }
}

