/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dm;

import com.cisco.dcbu.dm.DM;
import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.ClientCache;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public final class LastOpened
implements ActionListener {
    static final int USER = 0;
    static final int AUTH = 1;
    static final int PRIV = 2;
    static final int V3 = 3;
    static final String FILENAME = ClientCache.getLocation() + "dmlastopen.txt";
    static final int MAX = 31;
    static HashMap _Hash = new HashMap();
    static JMenu _Menu;
    static LastOpened _Instance;

    private LastOpened() {
    }

    static LastOpened getInstance() {
        if (_Instance == null) {
            _Instance = new LastOpened();
        }
        return _Instance;
    }

    static void setMenu(JMenu menu) {
        _Menu = menu;
        _Menu.setEnabled(false);
    }

    static JMenu getMenu() {
        return _Menu;
    }

    void save() throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(FILENAME));){
            int j = _Hash.size();
            for (int i = 0; i < j; ++i) {
                JMenuItem mi = (JMenuItem)_Menu.getMenuComponent(i);
                bw.write(mi.getText());
                bw.newLine();
            }
        }
    }

    void load() throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(FILENAME));
        int n = 0;
        String line = null;
        _Hash.clear();
        if (_Menu != null) {
            _Menu.removeAll();
        }
        try {
            while ((line = br.readLine()) != null) {
                if (line.trim().length() == 0 || line.charAt(0) == '#') continue;
                _Hash.put(line, new String[4]);
                JMenuItem mi = new JMenuItem(line);
                mi.addActionListener(this);
                _Menu.add(mi);
                ++n;
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            br.close();
        }
        br.close();
        if (n > 0) {
            _Menu.setEnabled(true);
        }
    }

    void record(String deviceName, String userName, String authPassword, String privPassword) {
        JMenuItem mi = null;
        if (_Hash.get(deviceName) == null) {
            if (_Hash.isEmpty()) {
                _Menu.setEnabled(true);
            } else if (_Hash.size() == 31) {
                mi = (JMenuItem)_Menu.getMenuComponent(_Hash.size() - 1);
                _Menu.remove(mi);
                _Hash.remove(mi.getText());
            }
            mi = new JMenuItem(deviceName);
            mi.addActionListener(this);
        } else {
            int j = _Hash.size();
            for (int i = 0; i < j && !(mi = (JMenuItem)_Menu.getMenuComponent(i)).getText().equals(deviceName); ++i) {
            }
            if (mi != null) {
                _Menu.remove(mi);
            }
        }
        _Menu.insert(mi, 0);
        String[] last = new String[]{userName, authPassword, privPassword, DM._UseV3 ? "T" : "F"};
        _Hash.put(deviceName, last);
        _Menu.validate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String deviceName = e.getActionCommand();
        String[] last = (String[])_Hash.get(deviceName);
        if (last != null) {
            DeviceManager dm = DeviceManager.getInstance();
            dm.setCursor(Cursor.getPredefinedCursor(3));
            try {
                if (last[0] != null) {
                    DM._UseV3 = last[3].equals("T");
                    InetSocketAddress add = DM._ProxyAddress == null ? null : new InetSocketAddress(DM._ProxyAddress, DM._ProxyPort);
                    dm.open(deviceName, last[0], last[1], last[2], add);
                } else {
                    dm.openAction(deviceName);
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)dm, (String)ex.getMessage());
                dm.openAction(deviceName);
            }
            dm.setCursor(Cursor.getDefaultCursor());
        }
    }
}

