/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dm;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dm.RediscoverException;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.TitleMenuItem;
import com.cisco.dcbu.lib.ui.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class PhysicalElement {
    protected static final String[] _ConfigMenu = new String[]{"Configure...", "configAction"};
    protected static final String[] _MonitorMenu = new String[]{"Monitor...", "monitorAction"};
    protected PhysicalElement _parent;
    protected Image _image;
    protected Rectangle _rect;
    protected int _statusVarBindListOffset;
    protected int[] _index;
    protected PhysicalView _view;
    protected boolean _selected;

    public final PhysicalElement getParent() {
        return this._parent;
    }

    public final Image getImage() {
        return this._image;
    }

    public final void setImage(Image image) {
        this._image = image;
    }

    public final void setSelected(boolean selected) {
        this._selected = selected;
    }

    public final boolean isSelected() {
        return this._selected;
    }

    public final Rectangle getRect() {
        return this._rect;
    }

    public boolean isMultipleInstance() {
        return false;
    }

    public int[][] getMultipleInstancesIndeces() {
        return null;
    }

    public final int[] getIndex() {
        return this._index;
    }

    public final void setIndex(int[] index) {
        this._index = index;
    }

    public final PhysicalView getView() {
        return this._view;
    }

    final void setView(PhysicalView view) {
        this._view = view;
    }

    public String getBitmap() {
        return null;
    }

    public Class[] getChildren() {
        return null;
    }

    public int[][] getChildPos(Class child) {
        return null;
    }

    public int[] getChildIndex(Class child, int index) {
        return null;
    }

    public Class[] getChildSubclass(Class child) throws Exception {
        return null;
    }

    public SnmpVarBind[] getStatusVar() {
        return null;
    }

    public SnmpVarBind[] buildStatusVar(int[][] oids) {
        SnmpVarBind[] vb = new SnmpVarBind[oids.length];
        for (int i = 0; i < vb.length; ++i) {
            vb[i] = new SnmpVarBind(new SnmpOID(oids[i], this.getStatusVarIndex(this._index)));
        }
        return vb;
    }

    public SnmpVarBind[] buildStatusVar(int[][] oids, int[] index) {
        SnmpVarBind[] vb = new SnmpVarBind[oids.length];
        for (int i = 0; i < vb.length; ++i) {
            vb[i] = new SnmpVarBind(new SnmpOID(oids[i], index));
        }
        return vb;
    }

    public int[] getStatusVarIndex(int[] index) {
        return index;
    }

    public int[] getStatusIndex(int[] index) {
        return index;
    }

    public String getToolTipText() {
        return null;
    }

    public void setStatus(VarBindList varBindList, int offset, PhysicalView view) throws RediscoverException {
    }

    public void disable() {
        this._view.updateImage(this._image, this._rect, Color.lightGray);
    }

    public boolean isSelectable() {
        return true;
    }

    public JPopupMenu getMenu() {
        return null;
    }

    public JPopupMenu buildMenu(ActionListener actionListener) {
        String[][] menuItems = new String[2][2];
        int i = 0;
        if (this.getEditDialog() != null) {
            menuItems[i++] = _ConfigMenu;
        }
        if (this.getGraphDialog() != null) {
            menuItems[i++] = _MonitorMenu;
        }
        JPopupMenu menu = new JPopupMenu();
        menu.add((JMenuItem)new TitleMenuItem());
        if (i != 0) {
            this.addMenuItems(menu, menuItems, actionListener);
        }
        return menu;
    }

    public void addMenuItems(JPopupMenu menu, String[][] menuItems, ActionListener actionListener) {
        this.addMenuItems(menu, menuItems, actionListener, -1);
    }

    public void addMenuItems(JPopupMenu menu, String[][] menuItems, ActionListener actionListener, int position) {
        for (int i = 0; i < menuItems.length; ++i) {
            if (menuItems[i][0] == null) continue;
            if (menuItems[i][0].charAt(0) == '-') {
                menu.addSeparator();
                continue;
            }
            JMenuItem mi = new JMenuItem(menuItems[i][0]);
            mi.addActionListener(actionListener);
            mi.setActionCommand(menuItems[i][1]);
            if (position != -1) {
                menu.add((Component)mi, position + i);
                continue;
            }
            menu.add(mi);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String mName = e.getActionCommand();
        PhysicalElement[] selected = this.getView().getSelected();
        if (selected.length == 0) {
            return;
        }
        try {
            Class[] types = new Class[]{selected.getClass()};
            Method m = this.getClass().getMethod(mName, types);
            Object[] args = new Object[]{selected};
            m.invoke((Object)this, args);
        }
        catch (InvocationTargetException ex) {
            Exception realEx = (Exception)ex.getTargetException();
            if (realEx == null) {
                realEx = ex;
            }
            Util.errorMessage((Component)this.getView(), (String)(mName + ": " + realEx.toString()));
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this.getView(), (Exception)ex);
        }
    }

    public void configAction(PhysicalElement[] selected) {
        this.getView().dialogAction(selected[0].getEditDialog(), selected);
    }

    public void monitorAction(PhysicalElement[] selected) {
        this.getView().dialogAction(selected[0].getGraphDialog(), selected);
    }

    public static PhysicalElement getAncestorOfClass(Class<?> ancestorClass, PhysicalElement elem) {
        PhysicalElement parent;
        if (elem == null || ancestorClass == null) {
            return null;
        }
        for (parent = elem.getParent(); parent != null && !ancestorClass.isInstance(parent); parent = parent.getParent()) {
        }
        return parent;
    }

    public void applyAll(PhysicalElement[] selected, String mibVar, SnmpVar value, boolean isIgnoreSetCount) {
        int[][] index = new int[selected.length][];
        for (int i = 0; i < selected.length; ++i) {
            index[i] = selected[i].getIndex();
        }
        PhysicalElement.applyAllInOne(null, mibVar, value, index, isIgnoreSetCount);
    }

    public void applyAll(PhysicalElement[] selected, String mibVar, SnmpVar value) {
        int[][] index = new int[selected.length][];
        for (int i = 0; i < selected.length; ++i) {
            index[i] = selected[i].getIndex();
        }
        PhysicalElement.applyAllInOne(null, mibVar, value, index, false);
    }

    public static void apply(String prompt, String mibVar, SnmpVar val, int index, boolean isIgnoreSetCount) {
        PhysicalElement.apply(prompt, mibVar, val, new int[]{index}, isIgnoreSetCount);
    }

    public static void apply(String prompt, String mibVar, SnmpVar val, int[] index, boolean isIgnoreSetCount) {
        JFrame parent = (JFrame)SwingUtilities.windowForComponent(DeviceManager.getInstance().getView());
        if (prompt != null && JOptionPane.showConfirmDialog(parent, prompt, parent.getTitle(), 0) != 0) {
            return;
        }
        try {
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(1));
            if (isIgnoreSetCount) {
                pdu.setIgnoreSetCount(true);
            }
            pdu.addVar(new SnmpOID(MibNode.get((String)mibVar).getOid(), index), val);
            Discover.getInstance();
            Discover.getPeer().set(pdu);
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)parent, (String)ex.getMessage());
        }
    }

    public static void applyAllInOne(String prompt, String mibVar, SnmpVar val, int[][] index, boolean isIgnoreSetCount) {
        JFrame parent = (JFrame)SwingUtilities.windowForComponent(DeviceManager.getInstance().getView());
        if (prompt != null && JOptionPane.showConfirmDialog(parent, prompt, parent.getTitle(), 0) != 0) {
            return;
        }
        try {
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(1));
            if (isIgnoreSetCount) {
                pdu.setIgnoreSetCount(true);
            }
            for (int i = 0; i < index.length; ++i) {
                pdu.addVar(new SnmpOID(MibNode.get((String)mibVar).getOid(), index[i]), val);
            }
            Discover.getInstance();
            Discover.getPeer().set(pdu);
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)parent, (String)ex.getMessage());
        }
    }

    public String getEditDialog() {
        return null;
    }

    public String getGraphDialog() {
        return null;
    }

    public Dimension getSize() {
        return new Dimension(0, 0);
    }

    public String getHTMLToolTipText() {
        StringBuffer sb = new StringBuffer(32);
        sb.append("<html>");
        sb.append(this.getHTMLNameAndStatus());
        sb.append("</html>");
        return sb.toString();
    }

    public final String getHTMLNameAndStatus() {
        StringBuffer sb = new StringBuffer(32);
        sb.append("<b>");
        sb.append(this.getNameForTooltip());
        sb.append("</b>.&nbsp;&nbsp;&nbsp;&nbsp;");
        sb.append("<b>Status : </b>");
        if (this.isUpStatus()) {
            sb.append("<font color=green><b>").append(this.getStatusForTooltip()).append("</b></font>");
        } else {
            sb.append("<font color=red><b>").append(this.getStatusForTooltip()).append("</b></font>");
        }
        return sb.toString();
    }

    protected String getNameForTooltip() {
        return this.toString();
    }

    protected boolean isUpStatus() {
        return false;
    }

    protected String getStatusForTooltip() {
        return "n/a";
    }
}

