/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dm;

import com.cisco.dcbu.dm.AbstractCollapseRestoreControl;
import com.cisco.dcbu.dm.AbstractPort;
import com.cisco.dcbu.dm.Controls;
import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.DialogListener;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dm.PhysicalStatus;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.channel.Channel;
import com.cisco.dcbu.lib.util.channel.ChannelConsumer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;

public final class PhysicalView
extends JComponent
implements ActionListener,
ChannelConsumer {
    static boolean _EnableTooltips = true;
    Image _offscreen;
    Dimension _size = new Dimension();
    Rectangle _lastR;
    int _origX;
    int _origY;
    boolean _isMouseDown;
    Array _elements = new Array(50);
    Class _selectionClass;
    Graphics _offscreenGraphics;
    Graphics _g;
    PhysicalElement _trackedElement;
    public static final int LABEL_PORT_FICON = 0;
    public static final int LABEL_PORT_FC = 1;
    public static int _LabelPort = 1;

    public PhysicalView() {
        this.enableEvents(56L);
        Controls._ViewAttrButton.addActionListener(this);
        this.setToolTipText("");
        this.setFocusable(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    PhysicalElement pe = PhysicalView.this._trackedElement;
                    if (pe == null) {
                        pe = (PhysicalElement)PhysicalView.this._elements.elementAt(0);
                    }
                    int pos = PhysicalView.this._elements.find((Object)pe);
                    pos = e.isShiftDown() ? (pos == 0 ? PhysicalView.this._elements.size() - 1 : --pos) : (pos == PhysicalView.this._elements.size() - 1 ? 0 : ++pos);
                    pe = (PhysicalElement)PhysicalView.this._elements.elementAt(pos);
                    if (pe != null) {
                        PhysicalView.this.selectElement(pe);
                    }
                } else if (e.getKeyCode() == 10) {
                    PhysicalElement pe = PhysicalView.this._trackedElement;
                    if (pe != null) {
                        PhysicalView.this.clearSelection();
                        PhysicalView.this.select(pe, true);
                        String method = pe.getEditDialog();
                        if (method != null) {
                            PhysicalView.this.dialogAction(method, pe);
                        }
                    }
                } else {
                    super.keyReleased(e);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PhysicalView.this.checkMouseEvent(e);
                PhysicalView.this.requestFocusInWindow();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PhysicalView.this.checkMouseEvent(e);
                PhysicalView.this.requestFocusInWindow();
            }
        });
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    private void checkMouseEvent(MouseEvent e) {
        if (e.isPopupTrigger()) {
            PhysicalElement element = this.find(e.getX(), e.getY());
            if (element != null && element.getMenu() != null) {
                if (!element.isSelected() && (e.getModifiers() & 2) == 0) {
                    this.clearSelection();
                }
                if (!element.isSelected()) {
                    this.select(element, true);
                }
                JMenuItem mi = (JMenuItem)element.getMenu().getComponent(0);
                if (this.getNumSelected() > 1) {
                    mi.setText(element.toString() + ",...");
                } else {
                    mi.setText(element.toString());
                }
                element.getMenu().show(this, e.getX(), e.getY());
            }
        } else if (e.getButton() == 1) {
            if (e.getID() == 501) {
                PhysicalElement element = this.find(e.getX(), e.getY());
                if (element == null) {
                    return;
                }
                if (element instanceof AbstractCollapseRestoreControl) {
                    ((AbstractCollapseRestoreControl)element).toggleParentState();
                    return;
                }
                this._isMouseDown = true;
                if ((e.getModifiers() & 2) != 0) {
                    this.select(element, !element.isSelected());
                } else if (e.getClickCount() == 2) {
                    String method = element.getEditDialog();
                    if (method != null) {
                        this.dialogAction(method, element);
                    }
                } else {
                    this.clearSelection();
                    this.select(element, true);
                }
            } else if (e.getID() == 502) {
                if (this._lastR != null) {
                    this._selectionClass = null;
                    for (int i = this._elements.size() - 1; i >= 0; --i) {
                        PhysicalElement el = (PhysicalElement)this._elements.elementAt(i);
                        el.setSelected(false);
                        if (!el.isSelectable() || !this._lastR.contains(el._rect.x, el._rect.y) || !this._lastR.contains(el._rect.x + el._rect.width, el._rect.y + el._rect.height)) continue;
                        if (this._selectionClass == null) {
                            this._selectionClass = el.getClass();
                        }
                        if (el.getClass() != this._selectionClass) continue;
                        el.setSelected(true);
                    }
                    this._lastR = null;
                    this.repaint();
                }
                this._isMouseDown = false;
            }
        }
    }

    public void clear() {
        this._elements.clear();
        this._offscreen = null;
        if (this._offscreenGraphics != null) {
            this._offscreenGraphics.dispose();
        }
        this._offscreenGraphics = null;
        if (this._g != null) {
            this._g = null;
        }
        this._trackedElement = null;
        this._size.height = 0;
        this._size.width = 0;
        PhysicalStatus.getInstance().clear();
    }

    @Override
    public Dimension getPreferredSize() {
        return this._size;
    }

    final void addElement(PhysicalElement e) {
        this._elements.addElement((Object)e);
    }

    public final Array getElements() {
        return this._elements;
    }

    public final void setStatusMessage(String message) {
        DeviceManager.getInstance().setStatus(message);
    }

    Graphics createOffScreenImage(int width, int height) {
        this._offscreen = this.createImage(++width, ++height);
        this._size.width = width;
        this._size.height = height;
        this.setSize(this._size);
        this._offscreenGraphics = this._offscreen.getGraphics();
        return this._offscreenGraphics;
    }

    @Override
    public Image createImage(int width, int height) {
        if (this._offscreen == null) {
            return super.createImage(width, height);
        }
        return this._offscreen;
    }

    public void consume(Channel channel, Object evtObj) {
        SnmpPDU pdu = (SnmpPDU)evtObj;
        if (!pdu.getAddress().equals(Discover._Peer.getAddress())) {
            return;
        }
        SnmpOID trapOid = (SnmpOID)pdu.getVar(1);
        if (trapOid.startsWith(SnmpPDU.getTrapPrefix())) {
            int trapType = trapOid.getValue()[SnmpPDU.getTrapPrefix().length];
            if (trapType == 3 || trapType == 4) {
                PhysicalElement e = this.find(AbstractPort.class, ((SnmpInt)pdu.getVar(2)).getValue());
                if (e != null) {
                    ((AbstractPort)e).linkTrap(trapType == 4, pdu.getVariables(), this);
                    this.repaint();
                }
            } else if (trapType == 2) {
                PhysicalStatus.getInstance().rediscover(": rebooted (warmstart).");
                Discover.getPeer().resetNumSets();
            } else if (trapType == 1) {
                PhysicalStatus.getInstance().rediscover(": booted (coldstart).");
                Discover.getPeer().resetNumSets();
            }
        }
        if (Discover._root != null) {
            Discover._root.trapListener(Discover._Peer, pdu);
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (this._trackedElement != null) {
            return this._trackedElement.getToolTipText();
        }
        return null;
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        PhysicalElement pe;
        if (this._isMouseDown && (e.getModifiers() & 2) == 0) {
            if (this._lastR == null) {
                this._origX = e.getX();
                this._origY = e.getY();
                this._lastR = new Rectangle(this._origX, this._origY, 1, 1);
            }
            Graphics g = super.getGraphics();
            g.setXORMode(Color.yellow);
            g.drawRect(this._lastR.x, this._lastR.y, this._lastR.width, this._lastR.height);
            int dx = e.getX() - this._origX;
            int dy = e.getY() - this._origY;
            this._lastR.x = dx > 0 ? this._origX : e.getX();
            this._lastR.y = dy > 0 ? this._origY : e.getY();
            this._lastR.width = Math.abs(dx);
            this._lastR.height = Math.abs(dy);
            g.drawRect(this._lastR.x, this._lastR.y, this._lastR.width, this._lastR.height);
            g.dispose();
            return;
        }
        if (_EnableTooltips && (pe = this.find(e.getX(), e.getY())) != this._trackedElement) {
            this.selectElement(pe);
            return;
        }
        super.processMouseMotionEvent(e);
    }

    public void selectElement(PhysicalElement pe) {
        Graphics g = super.getGraphics();
        g.setXORMode(Color.blue);
        if (this._trackedElement != null) {
            this.drawSelectBox(g, this._trackedElement);
        }
        this._trackedElement = pe;
        this.drawSelectBox(g, this._trackedElement);
        g.dispose();
    }

    public void dialogAction(String method, PhysicalElement e) {
        block2: {
            try {
                DialogListener.getInstance().dialogAction(method, e);
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this, (Exception)ex);
                if (!SnmpSession.isTrace()) break block2;
                ex.printStackTrace();
            }
        }
    }

    public void dialogAction(String method, PhysicalElement[] sel) {
        block7: {
            try {
                if (sel.length > 1) {
                    ArrayList<Integer> ifIndeces = new ArrayList<Integer>();
                    for (int i = 0; i < sel.length; ++i) {
                        if (sel[i].isMultipleInstance()) {
                            for (int[] index : sel[i].getMultipleInstancesIndeces()) {
                                ifIndeces.add(index[0]);
                            }
                            continue;
                        }
                        ifIndeces.add(sel[i].getIndex()[0]);
                    }
                    int[][] indeces = new int[ifIndeces.size()][];
                    for (int i = 0; i < indeces.length; ++i) {
                        indeces[i] = new int[]{(Integer)ifIndeces.get(i)};
                    }
                    DialogListener.getInstance().dialogAction(method, indeces);
                    break block7;
                }
                DialogListener.getInstance().dialogAction(method, sel[0]);
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this, (Exception)ex);
            }
        }
    }

    public PhysicalElement find(int x, int y) {
        for (int i = this._elements.size() - 1; i > 0; --i) {
            PhysicalElement e = (PhysicalElement)this._elements.elementAt(i);
            if (e._rect == null || !e._rect.contains(x, y) || !e.isSelectable()) continue;
            return e;
        }
        return (PhysicalElement)this._elements.elementAt(0);
    }

    public PhysicalElement[] findIn(PhysicalElement[] elems, Class c) {
        if (elems == null || elems.length == 0) {
            return new PhysicalElement[0];
        }
        ArrayList<PhysicalElement> elements = new ArrayList<PhysicalElement>();
        int max = this._elements.size();
        block0: for (int i = 0; i < max; ++i) {
            PhysicalElement e = (PhysicalElement)this._elements.elementAt(i);
            Rectangle eRect = e.getRect();
            if (!c.isInstance(e)) continue;
            for (int j = 0; j < elems.length; ++j) {
                if (!elems[j].getRect().contains(eRect.x, eRect.y)) continue;
                elements.add(e);
                continue block0;
            }
        }
        return elements.toArray(new PhysicalElement[0]);
    }

    public PhysicalElement[] find(Class c) {
        ArrayList<PhysicalElement> elements = new ArrayList<PhysicalElement>();
        int max = this._elements.size();
        for (int i = 0; i < max; ++i) {
            PhysicalElement e = (PhysicalElement)this._elements.elementAt(i);
            if (!c.isInstance(e)) continue;
            elements.add(e);
        }
        return elements.toArray(new PhysicalElement[0]);
    }

    public PhysicalElement find(Class c, int index) {
        for (int i = this._elements.size() - 1; i >= 0; --i) {
            PhysicalElement e = (PhysicalElement)this._elements.elementAt(i);
            if (!c.isInstance(e) || e.getIndex()[0] != index) continue;
            return e;
        }
        return null;
    }

    public PhysicalElement[] findAll(Class c, int index) {
        ArrayList<PhysicalElement> elements = new ArrayList<PhysicalElement>();
        for (int i = this._elements.size() - 1; i >= 0; --i) {
            PhysicalElement e = (PhysicalElement)this._elements.elementAt(i);
            if (!c.isInstance(e) || e.getIndex()[0] != index) continue;
            elements.add(e);
        }
        return elements.toArray(new PhysicalElement[0]);
    }

    public PhysicalElement find(Class c, int[] index) {
        for (int i = this._elements.size() - 1; i >= 0; --i) {
            PhysicalElement e = (PhysicalElement)this._elements.elementAt(i);
            if (!c.isInstance(e) || !SnmpOID.equals((int[])e.getIndex(), (int[])index)) continue;
            return e;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        PhysicalElement e = this.getFirstSelected();
        if (e != null && e.getEditDialog() != null) {
            this.dialogAction(e.getEditDialog(), this.getSelected());
        }
    }

    public PhysicalElement[] getSelected() {
        return this.getSelected(null, false);
    }

    public PhysicalElement[] getSelected(Class c, boolean enforce) {
        PhysicalElement[] selected = new PhysicalElement[this.getNumSelected()];
        int j = 0;
        int max = this._elements.size();
        for (int i = 0; i < max; ++i) {
            PhysicalElement e = (PhysicalElement)this._elements.elementAt(i);
            if (!e.isSelected()) continue;
            if (enforce && c != null) {
                if (!c.isInstance(e)) continue;
                selected[j++] = e;
                continue;
            }
            selected[j++] = e;
        }
        return selected;
    }

    public PhysicalElement[] getSelected(Class c, String name) throws Exception {
        return this.getSelected(c, name, false);
    }

    public PhysicalElement[] getSelected(Class c, String name, boolean enforce) throws Exception {
        PhysicalElement[] sel;
        PhysicalElement[] physicalElementArray = sel = enforce ? this.getSelected(c, true) : this.getSelected();
        if (sel.length == 0 || !c.isInstance(sel[0])) {
            if (!enforce) {
                this.selectAll(c);
            }
            if ((sel = this.getSelected()).length == 0 || !c.isInstance(sel[0])) {
                throw new Exception("Please select " + name);
            }
        }
        return sel;
    }

    public PhysicalElement[] getAncestorOfSelected(Class targetClass) {
        PhysicalElement[] sel = this.getSelected();
        if (sel.length > 0 && targetClass.isInstance(sel[0])) {
            return sel;
        }
        HashSet<PhysicalElement> ancestors = new HashSet<PhysicalElement>();
        if (sel.length != 0) {
            for (PhysicalElement elem : sel) {
                PhysicalElement ancestor = PhysicalElement.getAncestorOfClass(targetClass, elem);
                if (ancestor == null) continue;
                ancestors.add(ancestor);
            }
        }
        PhysicalElement[] elems = ancestors.toArray(new PhysicalElement[ancestors.size()]);
        return elems;
    }

    public PhysicalElement getFirstSelected() {
        int max = this._elements.size();
        for (int i = 0; i < max; ++i) {
            PhysicalElement e = (PhysicalElement)this._elements.elementAt(i);
            if (!e.isSelected()) continue;
            return e;
        }
        return null;
    }

    int getNumSelected() {
        int nSelected = 0;
        for (int i = this._elements.size() - 1; i >= 0; --i) {
            if (!((PhysicalElement)this._elements.elementAt(i)).isSelected()) continue;
            ++nSelected;
        }
        return nSelected;
    }

    public void clearSelection() {
        this._selectionClass = null;
        this._trackedElement = null;
        for (int i = this._elements.size() - 1; i >= 0; --i) {
            this.select((PhysicalElement)this._elements.elementAt(i), false);
        }
        Controls._ViewAttrButton.setEnabled(false);
    }

    public void selectAll(Class c) {
        this._selectionClass = c;
        for (int i = this._elements.size() - 1; i >= 0; --i) {
            PhysicalElement e = (PhysicalElement)this._elements.elementAt(i);
            if (!e.isSelectable()) continue;
            e.setSelected(c.isInstance(e));
        }
        this.repaint();
        Controls._ViewAttrButton.setEnabled(true);
    }

    public void selectMultiAll(Class[] cList) {
        this._selectionClass = cList[0];
        for (int i = this._elements.size() - 1; i >= 0; --i) {
            PhysicalElement e = (PhysicalElement)this._elements.elementAt(i);
            boolean bSel = false;
            for (int nClass = 0; nClass < cList.length; ++nClass) {
                Class c = cList[nClass];
                if (!c.isInstance(e)) continue;
                bSel = true;
                break;
            }
            e.setSelected(bSel);
        }
        this.repaint();
        Controls._ViewAttrButton.setEnabled(true);
    }

    JScrollPane getScrollPane() {
        return (JScrollPane)this.getParent().getParent();
    }

    public void select(PhysicalElement e, boolean selected) {
        boolean needRepaint;
        if (!e.isSelectable() || e.isSelected() == selected) {
            return;
        }
        Point p = this.getScrollPane().getViewport().getViewPosition();
        boolean bl = needRepaint = p.x > 0 || p.y > 0;
        if (selected) {
            if (this._selectionClass != null && e.getClass() != this._selectionClass) {
                for (int i = this._elements.size() - 1; i >= 0; --i) {
                    ((PhysicalElement)this._elements.elementAt(i)).setSelected(false);
                }
                needRepaint = true;
            }
            this._selectionClass = e.getClass();
            Controls._ViewAttrButton.setEnabled(true);
        }
        e.setSelected(selected);
        if (needRepaint) {
            this.repaint();
        } else {
            Graphics g = super.getGraphics();
            if (selected) {
                this.drawSelectBox(g, e);
            } else {
                g.clipRect(e._rect.x - 1, e._rect.y - 1, e._rect.width + 3, e._rect.height + 3);
                g.drawImage(this._offscreen, 0, 0, this);
            }
            g.dispose();
        }
    }

    void drawSelectBox(Graphics g, PhysicalElement e) {
        if (g != null && e != null && e._rect != null) {
            g.setColor(Color.yellow);
            g.drawRect(e._rect.x - 1, e._rect.y - 1, e._rect.width + 2, e._rect.height + 2);
            g.drawRect(e._rect.x, e._rect.y, e._rect.width, e._rect.height);
        }
    }

    @Override
    public final Graphics getGraphics() {
        if (this._g == null) {
            this._g = super.getGraphics();
        }
        return this._g;
    }

    public final Image getOffscreenImage() {
        return this._offscreen;
    }

    public final void updateImage(Image image, int x, int y, Color color) {
        Color c = this._offscreenGraphics.getColor();
        this._offscreenGraphics.setColor(color);
        this._offscreenGraphics.fillRect(x, y, image.getWidth(this), image.getHeight(this));
        this._offscreenGraphics.drawImage(image, x, y, color, this);
        this._offscreenGraphics.setColor(c);
    }

    public final void updateImage(Image image, Rectangle r, Color color) {
        Color c = this._offscreenGraphics.getColor();
        this._offscreenGraphics.setColor(color);
        this._offscreenGraphics.fillRect(r.x, r.y, image.getWidth(this), image.getHeight(this));
        this._offscreenGraphics.drawImage(image, r.x, r.y, color, this);
        this._offscreenGraphics.setColor(c);
    }

    public final void updateImage(Image image, int x, int y) {
        this._offscreenGraphics.drawImage(image, x, y, this);
    }

    public final void updateImage(Image image, Rectangle r) {
        this._offscreenGraphics.drawImage(image, r.x, r.y, this);
    }

    @Override
    public void paint(Graphics g) {
        if (this._offscreen != null) {
            g.drawImage(this._offscreen, 0, 0, this);
            int max = this._elements.size();
            for (int i = 0; i < max; ++i) {
                PhysicalElement e = (PhysicalElement)this._elements.elementAt(i);
                if (!e.isSelected()) continue;
                this.drawSelectBox(g, e);
            }
            if (this._trackedElement != null) {
                g.setXORMode(Color.blue);
                this.drawSelectBox(g, this._trackedElement);
            }
        }
    }
}

