/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Font;
import java.io.Serializable;
import jclass.chart.ChartText;
import jclass.chart.JCTitle;
import jclass.util.JCUtilConverter;

public class TitleWrapper
implements Serializable {
    public Font font;
    public String text;
    public int adjust;
    public Font default_font;
    public String prefix;

    public TitleWrapper() {
        this.font = this.default_font = new Font("helvetica", 0, 12);
        this.prefix = "";
    }

    public TitleWrapper(String string, String string2, String string3) {
        this.default_font = new Font("helvetica", 0, 12);
        this.font = JCUtilConverter.toFont(string);
        this.text = new String(string2);
        this.adjust = JCUtilConverter.toEnum(string3, "TitleAdjust", ChartText.adjust_strings, ChartText.adjust_values, 1);
        this.prefix = "";
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (object instanceof TitleWrapper) {
            TitleWrapper titleWrapper = (TitleWrapper)object;
            if (titleWrapper.font != null && this.font != null) {
                if (!titleWrapper.font.equals(this.font)) {
                    bl = false;
                }
            } else if (titleWrapper.font != this.font) {
                bl = false;
            }
            if (titleWrapper.text != null && this.text != null) {
                if (!titleWrapper.text.equals(this.text)) {
                    bl = false;
                }
            } else if (titleWrapper.text != this.text) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public void setPropertyValues(JCTitle jCTitle) {
        jCTitle.setAdjust(this.adjust);
        jCTitle.setText(this.text);
        jCTitle.setFont(this.font);
    }

    public void setWrapperValues(JCTitle jCTitle) {
        this.adjust = jCTitle.getAdjust();
        this.text = jCTitle.getText();
        if (this.text == null) {
            this.text = new String("");
        }
        this.font = jCTitle.getFont();
        if (this.font == null) {
            this.font = this.default_font;
        }
    }

    public String toString() {
        String string = "";
        string = String.valueOf(string) + "\"" + JCUtilConverter.fromFont(this.font) + "\"";
        string = String.valueOf(string) + ",";
        string = String.valueOf(string) + "\"" + this.text + "\"";
        string = String.valueOf(string) + ",";
        string = String.valueOf(string) + "\"" + JCUtilConverter.fromEnum(this.adjust, ChartText.adjust_strings, ChartText.adjust_values) + "\"";
        return string;
    }
}

