/*
 * Decompiled with CFR 0.152.
 */
package jclass.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import jclass.util.JCUtilConverter;

public class JCImageCreator {
    protected int curRow;
    protected int width;
    protected int height;
    protected int[] colorMap = new int[256];
    protected int[] pixels;
    protected Component comp;

    public JCImageCreator(Component component) {
        this.colorMap[32] = 0;
        this.comp = component;
    }

    public JCImageCreator(Component component, int n, int n2) {
        this(component);
        this.setSize(n, n2);
    }

    public synchronized void clear() {
        if (this.width != 0 && this.height != 0) {
            this.pixels = new int[this.width * this.height];
        }
        this.curRow = 0;
    }

    public synchronized Image create() {
        if (this.pixels == null) {
            return null;
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(this.width, this.height, this.pixels, 0, this.width);
        Image image = this.comp.createImage(memoryImageSource);
        return JCUtilConverter.waitForImage(this.comp, image) ? image : null;
    }

    public synchronized Image create(String[] stringArray) {
        this.clear();
        this.setPixels(stringArray);
        return this.create();
    }

    public static Image getImage(byte[] byArray, Component component) {
        if (byArray == null) {
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(byArray);
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Cannot load image");
        }
        return image;
    }

    public synchronized void setColor(char c, int n) {
        if (c < '\u0100') {
            this.colorMap[c] = n;
        }
    }

    public synchronized void setColor(char c, Color color) {
        this.setColor(c, color.getRGB());
    }

    public synchronized void setPixels(int n, String string) {
        if (string.length() != this.width) {
            return;
        }
        int n2 = 0;
        int n3 = n * this.width;
        while (n2 < this.width) {
            this.pixels[n2 + n3] = this.colorMap[string.charAt(n2)];
            ++n2;
        }
    }

    public synchronized void setPixels(String string) {
        this.setPixels(this.curRow++, string);
    }

    public synchronized void setPixels(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length && n < this.height) {
            this.setPixels(this.curRow++, stringArray[n]);
            ++n;
        }
    }

    public synchronized void setSize(int n, int n2) {
        if (n == this.width && n2 == this.height) {
            return;
        }
        this.width = n;
        this.height = n2;
        this.pixels = (int[])(n == 0 && n2 == 0 ? null : new int[n * n2]);
    }
}

