/*
 * Decompiled with CFR 0.152.
 */
package jclass.util;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import jclass.util.ConvertUtil;
import jclass.util.JCConverter;
import jclass.util.JCString;
import jclass.util.JCStringTokenizer;
import jclass.util.JCVector;

public class JCUtilConverter {
    public static JCConverter conv = new JCConverter();
    public static boolean reportErrors = true;
    public static final Color lightBlue = new Color(173, 216, 230);
    public static Hashtable param_source;

    public static void checkEnum(int n, String string, int[] nArray) {
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return;
            }
            ++n2;
        }
        throw new IllegalArgumentException("invalid " + string + ": " + n);
    }

    public static void error(String string) {
        System.err.println(string);
    }

    public static void error(String string, String string2) {
        JCUtilConverter.error("Error parsing '" + string2 + "' in " + string);
    }

    public static String fromColor(Color color) {
        if (color == null) {
            return null;
        }
        if (color.equals(Color.black)) {
            return "black";
        }
        if (color.equals(Color.blue)) {
            return "blue";
        }
        if (color.equals(Color.cyan)) {
            return "cyan";
        }
        if (color.equals(Color.darkGray)) {
            return "darkGray";
        }
        if (color.equals(Color.gray)) {
            return "gray";
        }
        if (color.equals(Color.green)) {
            return "green";
        }
        if (color.equals(lightBlue)) {
            return "lightBlue";
        }
        if (color.equals(Color.lightGray)) {
            return "lightGray";
        }
        if (color.equals(Color.magenta)) {
            return "magenta";
        }
        if (color.equals(Color.orange)) {
            return "orange";
        }
        if (color.equals(Color.pink)) {
            return "pink";
        }
        if (color.equals(Color.red)) {
            return "red";
        }
        if (color.equals(Color.white)) {
            return "white";
        }
        if (color.equals(Color.yellow)) {
            return "yellow";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(color.getRed());
        stringBuffer.append("-");
        stringBuffer.append(color.getGreen());
        stringBuffer.append("-");
        stringBuffer.append(color.getBlue());
        return stringBuffer.toString();
    }

    public static String fromColorList(Color[] colorArray) {
        if (colorArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < colorArray.length) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(JCUtilConverter.fromColor(colorArray[n]));
            ++n;
        }
        return new String(stringBuffer);
    }

    public static String fromEnum(int n, String string, String string2, String[][] stringArray, int[][] nArray, String string3) {
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2][0].equalsIgnoreCase(string2)) break;
            ++n2;
        }
        if (n2 == stringArray.length) {
            return null;
        }
        int n3 = 0;
        while (n3 < nArray[n2].length) {
            if (nArray[n2][n3] == n) {
                return stringArray[n2][n3 + 1];
            }
            ++n3;
        }
        try {
            return String.valueOf(n);
        }
        catch (Exception exception) {
            JCUtilConverter.error("Error converting '" + n + "' to " + string);
            return string3;
        }
    }

    public static String fromEnum(int n, String[] stringArray, int[] nArray) {
        if (nArray == null || stringArray == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n == nArray[n2] && n2 < stringArray.length) {
                return stringArray[n2];
            }
            ++n2;
        }
        return null;
    }

    public static String fromEnum(long l, String[] stringArray, long[] lArray) {
        if (lArray == null || stringArray == null) {
            return null;
        }
        int n = 0;
        while (n < lArray.length) {
            if (l == lArray[n] && n < stringArray.length) {
                return stringArray[n];
            }
            ++n;
        }
        return null;
    }

    public static String fromFont(Font font) {
        if (font == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(font.getName());
        stringBuffer.append("-");
        switch (font.getStyle()) {
            case 2: {
                stringBuffer.append("ITALIC");
                break;
            }
            case 1: {
                stringBuffer.append("BOLD");
                break;
            }
            case 3: {
                stringBuffer.append("BOLDITALIC");
                break;
            }
            default: {
                stringBuffer.append("PLAIN");
            }
        }
        stringBuffer.append("-");
        stringBuffer.append(font.getSize());
        return stringBuffer.toString();
    }

    public static String fromInsets(Insets insets) {
        return String.valueOf(insets.top) + "," + insets.left + "," + insets.bottom + "," + insets.right;
    }

    public static String fromNewLine(String string) {
        if (string == null || string.indexOf(10) == -1) {
            return string;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\n') {
                ++n;
            }
            ++n2;
        }
        char[] cArray = new char[string.length() + n];
        n2 = 0;
        int n3 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\n') {
                cArray[n3++] = 92;
                cArray[n3] = 110;
            } else {
                cArray[n3] = string.charAt(n2);
            }
            ++n2;
            ++n3;
        }
        return new String(cArray, 0, n3);
    }

    public static String getParam(Applet applet, Component component, String string) {
        Hashtable hashtable;
        String string2 = null;
        if (param_source != null && (hashtable = (Hashtable)param_source.get(component)) != null) {
            string2 = (String)hashtable.get(string.toLowerCase());
        }
        if (string2 == null && applet != null) {
            try {
                return applet.getParameter(string);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return string2;
    }

    public static String getParam(Applet applet, Component component, String string, String string2) {
        if (param_source != null && param_source.containsKey(component) && string2.equalsIgnoreCase("paramFile")) {
            return null;
        }
        String string3 = null;
        if (string != null) {
            string3 = JCUtilConverter.getParam(applet, component, String.valueOf(string) + "." + string2);
        }
        if (string3 == null) {
            string3 = JCUtilConverter.getParam(applet, component, string2);
        }
        if (string3 != null) {
            int n;
            while ((n = string3.indexOf(10)) != -1) {
                string3 = String.valueOf(string3.substring(0, n)) + string3.substring(n + 1);
            }
        }
        return string3;
    }

    public static boolean isSpace(char c) {
        return Character.isWhitespace(c);
    }

    public static void parseError(String string) {
        if (reportErrors) {
            JCUtilConverter.error("Error parsing '" + string + "'");
        }
    }

    public static String removeEscape(String string) {
        if (string == null || string.indexOf(92) == -1) {
            return string;
        }
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            cArray[n3] = n2 + 1 < n && c == '\\' ? (string.charAt(++n2) == 'n' ? 10 : string.charAt(n2)) : c;
            ++n2;
            ++n3;
        }
        return n3 > 0 ? new String(cArray, 0, n3) : null;
    }

    public static void setParamSource(Component component, String string) {
        int n;
        if (string == null) {
            if (param_source == null) {
                return;
            }
            if (param_source.containsKey(component)) {
                param_source.remove(component);
            }
            return;
        }
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        while (n2 < string.length() && (n2 = string.indexOf(60, n2)) != -1) {
            if (string.regionMatches(true, n2, "<applet", 0, 7)) {
                n3 = n2 + 7;
                while ((n3 = string.indexOf("</", n3)) != -1) {
                    if (string.regionMatches(true, n3, "</applet>", 0, 9)) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
            }
            if (bl) break;
            ++n2;
        }
        if (bl) {
            string = string.substring(n2, n3);
        }
        if (param_source == null) {
            param_source = new Hashtable();
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        param_source.put(component, hashtable);
        while ((n = string.indexOf(60)) != -1) {
            string = string.substring(n + 1);
            JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
            jCStringTokenizer.strip_esc = false;
            String string2 = JCUtilConverter.trim(jCStringTokenizer.nextToken('>'));
            if (string2 == null || string2.length() == 0) {
                return;
            }
            string = JCUtilConverter.trim(string.substring(jCStringTokenizer.getPosition()));
            if (string2.charAt(0) == '!' || string2.length() < 20 || JCUtilConverter.isSpace(string2.charAt(11)) || !string2.regionMatches(true, 0, "param name=", 0, 11)) continue;
            string2 = string2.substring(11);
            int n4 = 1;
            while (n4 < string2.length()) {
                if (JCUtilConverter.isSpace(string2.charAt(n4))) break;
                ++n4;
            }
            int n5 = n4 + 1;
            while (n5 < string2.length()) {
                if (!JCUtilConverter.isSpace(string2.charAt(n5))) break;
                ++n5;
            }
            if (n5 == string2.length() || !string2.regionMatches(true, n5, "value=", 0, 6)) continue;
            String string3 = string2.substring(n5 + 6);
            if (string3.charAt(0) == '\"') {
                if (string3.length() < 2) continue;
                if ((string3 = string3.substring(1)).charAt(string3.length() - 1) == '\"') {
                    string3 = string3.substring(0, string3.length() - 1);
                }
            }
            hashtable.put(string2.substring(0, n4).toLowerCase(), string3);
        }
    }

    public static boolean toBoolean(Applet applet, Component component, String string, String string2, boolean bl) {
        return conv.toBoolean(JCUtilConverter.getParam(applet, component, string, string2), bl);
    }

    public static boolean toBoolean(String string, boolean bl) {
        if (string == null) {
            return bl;
        }
        try {
            return Boolean.valueOf(string);
        }
        catch (Exception exception) {
            JCUtilConverter.parseError(string);
            return bl;
        }
    }

    public static Color toColor(String string) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        String string2 = jCStringTokenizer.nextToken('-');
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (string2.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (string2.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (string2.equalsIgnoreCase("darkGray")) {
            return Color.darkGray;
        }
        if (string2.equalsIgnoreCase("darkGrey")) {
            return Color.darkGray;
        }
        if (string2.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (string2.equalsIgnoreCase("grey")) {
            return Color.gray;
        }
        if (string2.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (string2.equalsIgnoreCase("lightGray")) {
            return Color.lightGray;
        }
        if (string2.equalsIgnoreCase("lightGrey")) {
            return Color.lightGray;
        }
        if (string2.equalsIgnoreCase("lightBlue")) {
            return lightBlue;
        }
        if (string2.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (string2.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (string2.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (string2.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (string2.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (string2.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        try {
            if (string2.startsWith("#")) {
                if (string2.length() >= 13) {
                    return new Color(Integer.valueOf(string2.substring(1, 5), 16) / 256, Integer.valueOf(string2.substring(5, 9), 16) / 256, Integer.valueOf(string2.substring(9, 13), 16) / 256);
                }
                if (string2.length() >= 7) {
                    return new Color(Integer.valueOf(string2.substring(1, 3), 16), Integer.valueOf(string2.substring(3, 5), 16), Integer.valueOf(string2.substring(5, 7), 16));
                }
                return new Color(Integer.valueOf(string2.substring(1), 16));
            }
            int n = Integer.parseInt(string2);
            int n2 = Integer.parseInt(jCStringTokenizer.nextToken('-'));
            int n3 = Integer.parseInt(jCStringTokenizer.nextToken('-'));
            return new Color(n, n2, n3);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Color toColor(String string, Color color) {
        Color color2 = JCUtilConverter.toColor(string);
        return string != null ? color2 : color;
    }

    public static Color[] toColorList(String string) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        Color[] colorArray = new Color[jCStringTokenizer.countTokens(',')];
        int n = 0;
        while (jCStringTokenizer.hasMoreTokens()) {
            String string2 = jCStringTokenizer.nextToken(',').trim();
            colorArray[n] = conv.toColor(string2);
            if (colorArray[n] == null) {
                JCUtilConverter.error(string, string2);
            }
            ++n;
        }
        return colorArray;
    }

    public static Color[] toColorList(String string, Color[] colorArray) {
        Color[] colorArray2 = JCUtilConverter.toColorList(string);
        return string != null ? colorArray2 : colorArray;
    }

    public static Date toDate(String string, Date date) {
        if (string == null) {
            return date;
        }
        try {
            try {
                SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(1, 1);
                simpleDateFormat.setCalendar(Calendar.getInstance());
                simpleDateFormat.setTimeZone(TimeZone.getDefault());
                return simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                return new Date(string);
            }
        }
        catch (Exception exception) {
            return date;
        }
    }

    public static Dimension toDimension(String string, Dimension dimension) {
        int[] nArray = JCUtilConverter.toIntList(string, 'x', null);
        if (nArray != null && nArray.length == 2) {
            return new Dimension(nArray[0], nArray[1]);
        }
        return dimension;
    }

    public static double toDouble(String string, double d) {
        if (string == null) {
            return d;
        }
        try {
            return Double.valueOf(string);
        }
        catch (Exception exception) {
            JCUtilConverter.parseError(string);
            return d;
        }
    }

    public static Double[] toDoubleList(String string, char c) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        Double[] doubleArray = new Double[jCStringTokenizer.countTokens(c)];
        int n = 0;
        while (jCStringTokenizer.hasMoreTokens()) {
            String string2 = jCStringTokenizer.nextToken(c).trim();
            doubleArray[n] = new Double(conv.toDouble(string2, 0.0));
            ++n;
        }
        return doubleArray;
    }

    public static Double[] toDoubleList(String string, char c, Double[] doubleArray) {
        Double[] doubleArray2 = JCUtilConverter.toDoubleList(string, c);
        return doubleArray2 != null ? doubleArray2 : doubleArray;
    }

    public static int toEnum(String string, String string2, String string3, String[][] stringArray, int[][] nArray, int n) {
        if (string3 == null) {
            string3 = string2;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2][0].equalsIgnoreCase(string2)) break;
            ++n2;
        }
        if (n2 == stringArray.length) {
            JCUtilConverter.error("Error converting '" + string + "' to " + string3);
            return n;
        }
        string = string.trim();
        int n3 = 1;
        while (n3 < stringArray[n2].length) {
            if (string.equalsIgnoreCase(stringArray[n2][n3])) {
                return nArray[n2][n3 - 1];
            }
            ++n3;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            JCUtilConverter.error("Error converting '" + string + "' to " + string3);
            return n;
        }
    }

    public static int toEnum(String string, String string2, String[] stringArray, int[] nArray, int n) {
        if (string == null) {
            return n;
        }
        string = string.trim();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n2])) {
                return nArray[n2];
            }
            ++n2;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            JCUtilConverter.error("Error converting '" + string + "' to " + string2);
            return n;
        }
    }

    public static long toEnum(String string, String string2, String[] stringArray, long[] lArray, long l) {
        if (string == null) {
            return l;
        }
        string = string.trim();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return lArray[n];
            }
            ++n;
        }
        try {
            return Long.parseLong(string);
        }
        catch (Exception exception) {
            JCUtilConverter.error("Error converting '" + string + "' to " + string2);
            return l;
        }
    }

    public static int toEnum(String string, String[] stringArray, int[] nArray, int n) {
        if (string == null) {
            return n;
        }
        string = string.trim();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n2])) {
                return nArray[n2];
            }
            ++n2;
        }
        return n;
    }

    public static int[] toEnumList(String string, String string2, String[] stringArray, int[] nArray, int[] nArray2) {
        if (string == null) {
            return nArray2;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        int[] nArray3 = new int[jCStringTokenizer.countTokens(',')];
        int n = 0;
        while (jCStringTokenizer.hasMoreTokens()) {
            String string3 = jCStringTokenizer.nextToken(',').trim();
            int n2 = nArray2 != null && n < nArray2.length ? nArray2[n] : 0;
            nArray3[n] = conv.toEnum(string3, string2, stringArray, nArray, n2);
            ++n;
        }
        return nArray3;
    }

    public static Font toFont(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        if (jCStringTokenizer.countTokens('-') != 3) {
            return null;
        }
        String string2 = jCStringTokenizer.nextToken('-');
        if (string2 == null) {
            return null;
        }
        string2 = string2.trim();
        String string3 = jCStringTokenizer.nextToken('-');
        if (string3 == null) {
            n = 0;
        } else {
            if ((string3 = string3.trim()).equalsIgnoreCase("PLAIN")) {
                n = 0;
            }
            if (string3.equalsIgnoreCase("ITALIC")) {
                n = 2;
            }
            if (string3.equalsIgnoreCase("BOLD")) {
                n = 1;
            }
            if (string3.equalsIgnoreCase("BOLDITALIC")) {
                n = 3;
            }
        }
        String string4 = jCStringTokenizer.nextToken('-');
        int n2 = 8;
        if (string4 != null) {
            n2 = Integer.parseInt(string4.trim());
        }
        return new Font(string2, n, n2);
    }

    public static Font toFont(String string, Font font) {
        Font font2 = conv.toFont(string);
        return font2 != null ? font2 : font;
    }

    public static Image toImage(Component component, String string) {
        Object object;
        Applet applet;
        if (string == null) {
            return null;
        }
        Image image = null;
        boolean bl = false;
        Applet applet2 = applet = component instanceof Applet ? (Applet)component : JCString.getApplet(component);
        if (applet != null) {
            object = null;
            try {
                object = applet.getDocumentBase();
                bl = true;
            }
            catch (Exception exception) {}
            if (bl) {
                image = applet.getImage((URL)object, string);
            }
        }
        if (!bl) {
            if (string.indexOf(":") == -1) {
                String string2;
                char c = System.getProperty("file.separator").charAt(0);
                try {
                    string2 = System.getProperty("user.dir");
                }
                catch (Exception exception) {
                    string2 = "";
                }
                string = "file:" + string2 + c + string;
                string = string.replace('/', c);
                if (c != '\\' && System.getProperty("os.name").indexOf("Windows") != -1) {
                    string = string.replace('/', '\\');
                }
            }
            try {
                object = component != null ? component.getToolkit() : Toolkit.getDefaultToolkit();
                image = ((Toolkit)object).getImage(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                JCUtilConverter.error("Error loading image " + string);
            }
        }
        if (component == null || image == null) {
            return image;
        }
        if (!JCUtilConverter.waitForImage(component, image)) {
            image = null;
        }
        if (image == null) {
            JCUtilConverter.error("Error loading image " + string);
        }
        return image;
    }

    public static Image toImage(Component component, String string, Image image) {
        Image image2 = conv.toImage(component, string);
        return image2 != null ? image2 : image;
    }

    public static Image[] toImageList(Component component, String string, Image[] imageArray) {
        if (string == null) {
            return imageArray;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        Image[] imageArray2 = new Image[jCStringTokenizer.countTokens(',')];
        int n = 0;
        while (jCStringTokenizer.hasMoreTokens()) {
            String string2 = jCStringTokenizer.nextToken(',').trim();
            Image image = imageArray != null && n < imageArray.length ? imageArray[n] : null;
            imageArray2[n] = conv.toImage(component, string2, imageArray[n]);
            ++n;
        }
        return imageArray2;
    }

    public static Insets toInsets(String string, Insets insets) {
        if (string == null) {
            return insets;
        }
        int[] nArray = JCUtilConverter.toIntList(string, ',', null);
        if (nArray != null && nArray.length == 4) {
            return new Insets(nArray[0], nArray[1], nArray[2], nArray[3]);
        }
        return insets;
    }

    public static int toInt(String string, int n) {
        if (string == null) {
            return n;
        }
        if (string.equalsIgnoreCase("maxint")) {
            return Integer.MAX_VALUE;
        }
        if (string.equalsIgnoreCase("novalue")) {
            return -999;
        }
        if (string.equalsIgnoreCase("variable")) {
            return -998;
        }
        if (string.equalsIgnoreCase("default")) {
            return -999;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            JCUtilConverter.parseError(string);
            return n;
        }
    }

    public static int[] toIntList(String string, char c) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        int[] nArray = new int[jCStringTokenizer.countTokens(c)];
        int n = 0;
        while (jCStringTokenizer.hasMoreTokens()) {
            String string2 = jCStringTokenizer.nextToken(c).trim();
            nArray[n] = conv.toInt(string2, 0);
            ++n;
        }
        return nArray;
    }

    public static int[] toIntList(String string, char c, int[] nArray) {
        int[] nArray2 = JCUtilConverter.toIntList(string, c);
        return nArray2 != null ? nArray2 : nArray;
    }

    public static Integer[] toIntegerList(String string, char c) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        Integer[] integerArray = new Integer[jCStringTokenizer.countTokens(c)];
        int n = 0;
        while (jCStringTokenizer.hasMoreTokens()) {
            String string2 = jCStringTokenizer.nextToken(c).trim();
            integerArray[n] = new Integer(conv.toInt(string2, 0));
            ++n;
        }
        return integerArray;
    }

    public static Integer[] toIntegerList(String string, char c, Integer[] integerArray) {
        Integer[] integerArray2 = JCUtilConverter.toIntegerList(string, c);
        return integerArray2 != null ? integerArray2 : integerArray;
    }

    public static String toNewLine(String string) {
        if (string == null || string.indexOf("\\n") == -1) {
            return string;
        }
        char[] cArray = new char[string.length()];
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (string.charAt(n2) == '\\' && n2 < cArray.length - 1 && string.charAt(n2 + 1) == 'n') {
                cArray[n] = 10;
                ++n2;
            } else {
                cArray[n] = string.charAt(n2);
            }
            ++n2;
            ++n;
        }
        return new String(cArray, 0, n);
    }

    public static Point toPoint(String string, Point point) {
        int[] nArray = JCUtilConverter.toIntList(string, ',', null);
        if (nArray != null && nArray.length == 2) {
            return new Point(nArray[0], nArray[1]);
        }
        return point;
    }

    public static String toString(Object object) {
        if (!(object instanceof Vector)) {
            return JCUtilConverter.fromNewLine(object != null ? object.toString() : "");
        }
        Vector vector = (Vector)object;
        StringBuffer stringBuffer = new StringBuffer(vector.size());
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            stringBuffer.append(JCUtilConverter.toString(vector.elementAt(n)));
            if (n < n2 - 1) {
                stringBuffer.append(',');
            }
            ++n;
        }
        return new String(stringBuffer);
    }

    public static String[] toStringList(String string) {
        return JCUtilConverter.toStringList(string, ',');
    }

    public static String[] toStringList(String string, char c) {
        return JCUtilConverter.toStringList(string, c, true);
    }

    public static String[] toStringList(String string, char c, boolean bl) {
        if (string == null) {
            return null;
        }
        JCStringTokenizer jCStringTokenizer = new JCStringTokenizer(string);
        String[] stringArray = new String[jCStringTokenizer.countTokens(c)];
        int n = 0;
        while (jCStringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = jCStringTokenizer.nextToken(c);
            if (string3 == null) {
                string3 = "";
            }
            if ((string2 = string3.trim()) == null) {
                string2 = "";
            }
            stringArray[n] = bl ? string2 : string3;
            ++n;
        }
        return stringArray;
    }

    public static JCVector toVector(Component component, String string, char c, boolean bl) {
        return ConvertUtil.toVector(component, string, c, bl);
    }

    public static JCVector toVector(Component component, String string, char c, boolean bl, JCVector jCVector) {
        JCVector jCVector2 = conv.toVector(component, string, c, bl);
        return jCVector2 != null ? jCVector2 : jCVector;
    }

    public static JCVector toVectorFromCSV(Component component, String string) {
        return ConvertUtil.toVectorFromCSV(component, string);
    }

    public static JCVector toVectorFromCSV(Component component, String string, JCVector jCVector) {
        JCVector jCVector2 = JCUtilConverter.toVectorFromCSV(component, string);
        return jCVector2 != null ? jCVector2 : jCVector;
    }

    public static String trim(Object object) {
        String string;
        if (object == null || (string = object.toString()) == null) {
            return null;
        }
        int n = (string = string.trim()).indexOf(0);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static boolean waitForImage(Component component, Image image) {
        MediaTracker mediaTracker = new MediaTracker(component);
        try {
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
        }
        catch (Exception exception) {
            return false;
        }
        return mediaTracker.isErrorAny() ^ true;
    }
}

