/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideScrollPaneConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.border.Border;

public class JideScrollPaneLayout
extends ScrollPaneLayout
implements JideScrollPaneConstants {
    protected JViewport _rowFoot;
    protected JViewport _subColHead;
    protected JViewport _colFoot;
    protected Component _hLeft;
    protected Component _hRight;
    protected Component _vTop;
    protected Component _vBottom;
    protected Component _subUpperLeft;
    protected Component _subUpperRight;
    private static final long serialVersionUID = 7897026041296359186L;

    public void syncWithScrollPane(JScrollPane jScrollPane) {
        super.syncWithScrollPane(jScrollPane);
        if (jScrollPane instanceof JideScrollPane) {
            this._rowFoot = ((JideScrollPane)jScrollPane).getRowFooter();
            this._colFoot = ((JideScrollPane)jScrollPane).getColumnFooter();
            this._subColHead = ((JideScrollPane)jScrollPane).getSubColumnHeader();
            this._hLeft = ((JideScrollPane)jScrollPane).getScrollBarCorner("HORIZONTAL_LEFT");
            this._hRight = ((JideScrollPane)jScrollPane).getScrollBarCorner("HORIZONTAL_RIGHT");
            this._vTop = ((JideScrollPane)jScrollPane).getScrollBarCorner("VERTICAL_TOP");
            this._vBottom = ((JideScrollPane)jScrollPane).getScrollBarCorner("VERTICAL_BOTTOM");
            this._subUpperLeft = jScrollPane.getCorner("SUB_UPPER_LEFT");
            this._subUpperRight = jScrollPane.getCorner("SUB_UPPER_RIGHT");
        }
    }

    protected boolean isHsbCoversWholeWidth(JScrollPane jScrollPane) {
        return jScrollPane instanceof JideScrollPane && ((JideScrollPane)jScrollPane).isHorizontalScrollBarCoversWholeWidth();
    }

    protected boolean isVsbCoversWholeHeight(JScrollPane jScrollPane) {
        return jScrollPane instanceof JideScrollPane && ((JideScrollPane)jScrollPane).isVerticalScrollBarCoversWholeHeight();
    }

    protected boolean isColumnHeadersHeightUnified(JScrollPane jScrollPane) {
        return jScrollPane instanceof JideScrollPane && ((JideScrollPane)jScrollPane).isColumnHeadersHeightUnified();
    }

    protected boolean isColumnFootersHeightUnified(JScrollPane jScrollPane) {
        return jScrollPane instanceof JideScrollPane && ((JideScrollPane)jScrollPane).isColumnFootersHeightUnified();
    }

    public void addLayoutComponent(String string, Component component) {
        if (string.equals("ROW_FOOTER")) {
            this._rowFoot = (JViewport)this.addSingletonComponent(this._rowFoot, component);
        } else if (string.equals("SUB_COLUMN_HEADER")) {
            this._subColHead = (JViewport)this.addSingletonComponent(this._subColHead, component);
        } else if (string.equals("COLUMN_FOOTER")) {
            this._colFoot = (JViewport)this.addSingletonComponent(this._colFoot, component);
        } else if (string.equals("HORIZONTAL_LEFT")) {
            this._hLeft = this.addSingletonComponent(this._hLeft, component);
        } else if (string.equals("HORIZONTAL_RIGHT")) {
            this._hRight = this.addSingletonComponent(this._hRight, component);
        } else if (string.equals("VERTICAL_TOP")) {
            this._vTop = this.addSingletonComponent(this._vTop, component);
        } else if (string.equals("VERTICAL_BOTTOM")) {
            this._vBottom = this.addSingletonComponent(this._vBottom, component);
        } else if (string.equals("SUB_UPPER_LEFT")) {
            this._subUpperLeft = this.addSingletonComponent(this._subUpperLeft, component);
        } else if (string.equals("SUB_UPPER_RIGHT")) {
            this._subUpperRight = this.addSingletonComponent(this._subUpperRight, component);
        } else {
            super.addLayoutComponent(string, component);
        }
    }

    public void removeLayoutComponent(Component component) {
        if (component == this._rowFoot) {
            this._rowFoot = null;
        } else if (component == this._subColHead) {
            this._subColHead = null;
        } else if (component == this._colFoot) {
            this._colFoot = null;
        } else if (component == this._hLeft) {
            this._hLeft = null;
        } else if (component == this._hRight) {
            this._hRight = null;
        } else if (component == this._vTop) {
            this._vTop = null;
        } else if (component == this._vBottom) {
            this._vBottom = null;
        } else if (component == this._subUpperLeft) {
            this._subUpperLeft = null;
        } else if (component == this._subUpperRight) {
            this._subUpperRight = null;
        } else {
            super.removeLayoutComponent(component);
        }
    }

    public JViewport getRowFooter() {
        return this._rowFoot;
    }

    public JViewport getRowSubColumnHeader() {
        return this._subColHead;
    }

    public JViewport getColumnFooter() {
        return this._colFoot;
    }

    public Component getScrollBarCorner(String string) {
        if (string.equals("HORIZONTAL_LEFT")) {
            return this._hLeft;
        }
        if (string.equals("HORIZONTAL_RIGHT")) {
            return this._hRight;
        }
        if (string.equals("VERTICAL_BOTTOM")) {
            return this._vBottom;
        }
        if (string.equals("VERTICAL_TOP")) {
            return this._vTop;
        }
        if (string.equals("SUB_UPPER_LEFT")) {
            return this._subUpperLeft;
        }
        if (string.equals("SUB_UPPER_RIGHT")) {
            return this._subUpperRight;
        }
        return super.getCorner(string);
    }

    public Dimension preferredLayoutSize(Container container) {
        boolean bl;
        Border border;
        JScrollPane jScrollPane = (JScrollPane)container;
        this.vsbPolicy = jScrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = jScrollPane.getHorizontalScrollBarPolicy();
        boolean bl2 = jScrollPane instanceof JideScrollPane && ((JideScrollPane)jScrollPane).isFlatLayout();
        Insets insets = container.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        Dimension dimension = null;
        Dimension dimension2 = null;
        Component component = null;
        if (this.viewport != null) {
            dimension = this.viewport.getPreferredSize();
            dimension2 = this.viewport.getViewSize();
            component = this.viewport.getView();
            if (bl2 && this.viewport.getView() != null) {
                dimension = this.viewport.getView().getPreferredSize();
            }
        }
        if (dimension != null) {
            n += dimension.width;
            n2 += dimension.height;
        }
        if ((border = jScrollPane.getViewportBorder()) != null) {
            Insets insets2 = border.getBorderInsets(container);
            n += insets2.left + insets2.right;
            n2 += insets2.top + insets2.bottom;
        }
        int n3 = 0;
        if (this.rowHead != null && this.rowHead.isVisible()) {
            n3 = this.rowHead.getPreferredSize().width;
        }
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            n3 = Math.max(n3, this.upperLeft.getPreferredSize().width);
        }
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            n3 = Math.max(n3, this.lowerLeft.getPreferredSize().width);
        }
        if (this._subUpperLeft != null && this._subUpperLeft.isVisible()) {
            n3 = Math.max(n3, this._subUpperLeft.getPreferredSize().width);
        }
        n += n3;
        int n4 = this.getUpperHeight();
        n2 += n4 + this.getSubUpperHeight();
        if (this._rowFoot != null && this._rowFoot.isVisible()) {
            n += this._rowFoot.getPreferredSize().width;
        }
        int n5 = this.getLowerHeight();
        n2 += n5;
        if (this.vsb != null && this.vsbPolicy != 21 && !bl2) {
            if (this.vsbPolicy == 22) {
                n += this.vsb.getPreferredSize().width;
            } else if (dimension2 != null && dimension != null) {
                bl = true;
                if (component instanceof Scrollable) {
                    boolean bl3 = bl = !((Scrollable)((Object)component)).getScrollableTracksViewportHeight();
                }
                if (bl && dimension2.height > dimension.height) {
                    n += this.vsb.getPreferredSize().width;
                }
            }
        }
        if (this.hsb != null && this.hsbPolicy != 31 && !bl2) {
            if (this.hsbPolicy == 32) {
                n2 += this.hsb.getPreferredSize().height;
            } else if (dimension2 != null && dimension != null) {
                bl = true;
                if (component instanceof Scrollable) {
                    boolean bl4 = bl = !((Scrollable)((Object)component)).getScrollableTracksViewportWidth();
                }
                if (bl && dimension2.width > dimension.width) {
                    n2 += this.hsb.getPreferredSize().height;
                }
            }
        }
        return new Dimension(n, n2);
    }

    private int getSubUpperHeight() {
        int n = 0;
        if (this._subUpperLeft != null && this._subUpperLeft.isVisible()) {
            n = this._subUpperLeft.getPreferredSize().height;
        }
        if (this._subUpperRight != null && this._subUpperRight.isVisible()) {
            n = Math.max(this._subUpperRight.getPreferredSize().height, n);
        }
        if (this._subColHead != null && this._subColHead.isVisible()) {
            n = Math.max(this._subColHead.getPreferredSize().height, n);
        }
        return n;
    }

    private int getUpperHeight() {
        int n = 0;
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            n = this.upperLeft.getPreferredSize().height;
        }
        if (this.upperRight != null && this.upperRight.isVisible()) {
            n = Math.max(this.upperRight.getPreferredSize().height, n);
        }
        if (this.colHead != null && this.colHead.isVisible()) {
            n = Math.max(this.colHead.getPreferredSize().height, n);
        }
        return n;
    }

    private int getLowerHeight() {
        int n = 0;
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            n = this.lowerLeft.getPreferredSize().height;
        }
        if (this.lowerRight != null && this.lowerRight.isVisible()) {
            n = Math.max(this.lowerRight.getPreferredSize().height, n);
        }
        if (this._colFoot != null && this._colFoot.isVisible()) {
            n = Math.max(this._colFoot.getPreferredSize().height, n);
        }
        return n;
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension;
        Object object;
        boolean bl;
        JScrollPane jScrollPane = (JScrollPane)container;
        boolean bl2 = bl = jScrollPane instanceof JideScrollPane && ((JideScrollPane)jScrollPane).isFlatLayout();
        if (bl) {
            return this.preferredLayoutSize(container);
        }
        this.vsbPolicy = jScrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = jScrollPane.getHorizontalScrollBarPolicy();
        Insets insets = container.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        if (this.viewport != null) {
            object = this.viewport.getMinimumSize();
            if (bl && this.viewport.getView() != null) {
                object = this.viewport.getView().getMinimumSize();
            }
            n += ((Dimension)object).width;
            n2 += ((Dimension)object).height;
        }
        if ((object = jScrollPane.getViewportBorder()) != null) {
            Insets insets2 = object.getBorderInsets(container);
            n += insets2.left + insets2.right;
            n2 += insets2.top + insets2.bottom;
        }
        int n3 = 0;
        if (this.rowHead != null && this.rowHead.isVisible()) {
            Dimension dimension2 = this.rowHead.getMinimumSize();
            n3 = dimension2.width;
            n2 = Math.max(n2, dimension2.height);
        }
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            n3 = Math.max(n3, this.upperLeft.getMinimumSize().width);
        }
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            n3 = Math.max(n3, this.lowerLeft.getMinimumSize().width);
        }
        if (this._subUpperLeft != null && this._subUpperLeft.isVisible()) {
            n3 = Math.max(n3, this._subUpperLeft.getMinimumSize().width);
        }
        n += n3;
        int n4 = 0;
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            n4 = this.upperLeft.getMinimumSize().height;
        }
        if (this.upperRight != null && this.upperRight.isVisible()) {
            n4 = Math.max(this.upperRight.getMinimumSize().height, n4);
        }
        if (this.colHead != null && this.colHead.isVisible()) {
            Dimension dimension3 = this.colHead.getMinimumSize();
            n = Math.max(n, dimension3.width);
            n4 = Math.max(dimension3.height, n4);
        }
        n2 += n4;
        int n5 = 0;
        if (this._subUpperLeft != null && this._subUpperLeft.isVisible()) {
            n5 = this._subUpperLeft.getMinimumSize().height;
        }
        if (this._subUpperRight != null && this._subUpperRight.isVisible()) {
            n5 = Math.max(this._subUpperRight.getMinimumSize().height, n5);
        }
        if (this._subColHead != null && this._subColHead.isVisible()) {
            Dimension dimension4 = this._subColHead.getMinimumSize();
            n = Math.max(n, dimension4.width);
            n5 = Math.max(dimension4.height, n5);
        }
        n2 += n5;
        int n6 = 0;
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            n6 = this.lowerLeft.getMinimumSize().height;
        }
        if (this.lowerRight != null && this.lowerRight.isVisible()) {
            n6 = Math.max(this.lowerRight.getMinimumSize().height, n6);
        }
        if (this._colFoot != null && this._colFoot.isVisible()) {
            dimension = this._colFoot.getMinimumSize();
            n = Math.max(n, dimension.width);
            n6 = Math.max(dimension.height, n6);
        }
        n2 += n6;
        if (this._rowFoot != null && this._rowFoot.isVisible()) {
            dimension = this._rowFoot.getMinimumSize();
            n = Math.max(n, dimension.width);
            n2 += dimension.height;
        }
        if (this.vsb != null && this.vsbPolicy != 21 && !bl) {
            dimension = this.vsb.getMinimumSize();
            n += dimension.width;
            n2 = Math.max(n2, dimension.height);
        }
        if (this.hsb != null && this.hsbPolicy != 31 && !bl) {
            dimension = this.hsb.getMinimumSize();
            n = Math.max(n, dimension.width);
            n2 += dimension.height;
        }
        return new Dimension(n, n2);
    }

    public void layoutContainer(Container container) {
        Dimension dimension;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Scrollable scrollable;
        boolean bl;
        Insets insets;
        Border border;
        int n6;
        JScrollPane jScrollPane = (JScrollPane)container;
        boolean bl2 = jScrollPane instanceof JideScrollPane && ((JideScrollPane)jScrollPane).isFlatLayout();
        this.vsbPolicy = jScrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = jScrollPane.getHorizontalScrollBarPolicy();
        Rectangle rectangle = jScrollPane.getBounds();
        rectangle.y = 0;
        rectangle.x = 0;
        Insets insets2 = container.getInsets();
        rectangle.x = insets2.left;
        rectangle.y = insets2.top;
        rectangle.width -= insets2.left + insets2.right;
        rectangle.height -= insets2.top + insets2.bottom;
        Rectangle rectangle2 = new Rectangle(0, rectangle.y, 0, 0);
        int n7 = this.getUpperHeight();
        if (this.colHead != null && this.colHead.isVisible()) {
            rectangle2.height = n6 = Math.min(rectangle.height, n7);
            rectangle.y += n6;
            rectangle.height -= n6;
        }
        n6 = this.getSubUpperHeight();
        Rectangle rectangle3 = new Rectangle(0, rectangle.y, 0, 0);
        if (this._subColHead != null && this._subColHead.isVisible()) {
            int n8;
            rectangle3.height = n8 = Math.min(rectangle.height, n6);
            rectangle.y += n8;
            rectangle.height -= n8;
        }
        Rectangle rectangle4 = new Rectangle(0, 0, 0, 0);
        if (this.rowHead != null && this.rowHead.isVisible()) {
            int n9 = this.rowHead.getPreferredSize().width;
            if (this.upperLeft != null && this.upperLeft.isVisible()) {
                n9 = Math.max(n9, this.upperLeft.getPreferredSize().width);
            }
            if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
                n9 = Math.max(n9, this.lowerLeft.getPreferredSize().width);
            }
            if (this._subUpperLeft != null && this._subUpperLeft.isVisible()) {
                n9 = Math.max(n9, this._subUpperLeft.getPreferredSize().width);
            }
            rectangle4.width = n9;
            rectangle.width -= n9;
            rectangle4.x = rectangle.x;
            rectangle.x += n9;
        }
        if ((border = jScrollPane.getViewportBorder()) != null) {
            insets = border.getBorderInsets(container);
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
        } else {
            insets = new Insets(0, 0, 0, 0);
        }
        Rectangle rectangle5 = new Rectangle(0, 0, 0, 0);
        if (this._rowFoot != null && this._rowFoot.isVisible()) {
            int n10 = this._rowFoot.getPreferredSize().width;
            if (this.upperRight != null && this.upperRight.isVisible()) {
                n10 = Math.max(n10, this.upperRight.getPreferredSize().width);
            }
            if (this._subUpperRight != null && this._subUpperRight.isVisible()) {
                n10 = Math.max(n10, this._subUpperRight.getPreferredSize().width);
            }
            if (this.lowerRight != null && this.lowerRight.isVisible()) {
                n10 = Math.max(n10, this.lowerRight.getPreferredSize().width);
            }
            rectangle5.width = n10;
            rectangle.width -= n10;
            rectangle5.x = rectangle.x + rectangle.width;
        }
        Rectangle rectangle6 = new Rectangle(0, rectangle.y, 0, 0);
        int n11 = this.getLowerHeight();
        if (this._colFoot != null && this._colFoot.isVisible()) {
            int n12;
            rectangle6.height = n12 = Math.min(rectangle.height, n11);
            rectangle.height -= n12;
            rectangle6.y = rectangle.y + rectangle.height;
        }
        Component component = this.viewport != null ? this.viewport.getView() : null;
        Dimension dimension2 = component != null ? component.getPreferredSize() : new Dimension(0, 0);
        Dimension dimension3 = this.viewport != null ? this.viewport.toViewCoordinates(rectangle.getSize()) : new Dimension(0, 0);
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = bl = rectangle.width < 0 || rectangle.height < 0;
        if (!bl && component instanceof Scrollable && !bl2) {
            scrollable = (Scrollable)((Object)component);
            bl3 = scrollable.getScrollableTracksViewportWidth();
            bl4 = scrollable.getScrollableTracksViewportHeight();
        } else {
            scrollable = null;
        }
        Rectangle rectangle7 = new Rectangle(0, this.isVsbCoversWholeHeight(jScrollPane) ? insets2.top : rectangle.y - insets.top, 0, 0);
        if (this.vsbPolicy == 22) {
            n5 = 1;
        } else if (this.vsbPolicy == 21) {
            n5 = 0;
        } else if (bl) {
            n5 = 0;
        } else {
            int n13 = n5 = !bl4 && (dimension2.height > dimension3.height || this.rowHead != null && this.rowHead.getView() != null && this.rowHead.getView().getPreferredSize().height > dimension3.height) ? 1 : 0;
            if (n5 == 0 && jScrollPane instanceof JideScrollPane && ((JideScrollPane)jScrollPane).isKeepCornerVisible() && (this._vBottom != null || this._vTop != null)) {
                n5 = 1;
            }
        }
        if (bl2) {
            n5 = 0;
        }
        if (this.vsb != null && n5 != 0) {
            this.adjustForVSB(true, rectangle, rectangle7, insets, true);
            dimension3 = this.viewport.toViewCoordinates(rectangle.getSize());
        }
        Rectangle rectangle8 = new Rectangle(this.isHsbCoversWholeWidth(jScrollPane) ? insets2.left : rectangle.x - insets.left, 0, 0, 0);
        if (this.hsbPolicy == 32) {
            n4 = 1;
        } else if (this.hsbPolicy == 31) {
            n4 = 0;
        } else if (bl) {
            n4 = 0;
        } else {
            int n14 = n4 = !bl3 && (dimension2.width > dimension3.width || this.colHead != null && this.colHead.getView() != null && this.colHead.getView().getPreferredSize().width > dimension3.width) ? 1 : 0;
            if (n4 == 0 && jScrollPane instanceof JideScrollPane && ((JideScrollPane)jScrollPane).isKeepCornerVisible() && (this._hLeft != null || this._hRight != null)) {
                n4 = 1;
            }
        }
        if (bl2) {
            n4 = 0;
        }
        if (this.hsb != null && n4 != 0) {
            this.adjustForHSB(true, rectangle, rectangle8, insets);
            if (this.vsb != null && n5 == 0 && this.vsbPolicy != 21) {
                dimension3 = this.viewport.toViewCoordinates(rectangle.getSize());
                int n15 = n5 = dimension2.height > dimension3.height ? 1 : 0;
                if (n5 == 0 && jScrollPane instanceof JideScrollPane && ((JideScrollPane)jScrollPane).isKeepCornerVisible() && (this._vBottom != null || this._vTop != null)) {
                    n5 = 1;
                }
                if (n5 != 0) {
                    this.adjustForVSB(true, rectangle, rectangle7, insets, true);
                }
            }
        }
        boolean bl6 = jScrollPane.getComponentOrientation().isLeftToRight();
        if (this.viewport != null) {
            this.viewport.setBounds(this.adjustBounds(container, rectangle, bl6));
            if (scrollable != null) {
                dimension3 = this.viewport.toViewCoordinates(rectangle.getSize());
                n3 = n4;
                n2 = n5;
                bl3 = scrollable.getScrollableTracksViewportWidth();
                bl4 = scrollable.getScrollableTracksViewportHeight();
                if (this.vsb != null && this.vsbPolicy == 20 && !bl2) {
                    int n16 = n = !bl4 && (dimension2.height > dimension3.height || this.rowHead != null && this.rowHead.getView() != null && this.rowHead.getView().getPreferredSize().height > dimension3.height) ? 1 : 0;
                    if (n == 0 && jScrollPane instanceof JideScrollPane && ((JideScrollPane)jScrollPane).isKeepCornerVisible() && (this._vBottom != null || this._vTop != null)) {
                        n = 1;
                    }
                    if (n != n5) {
                        n5 = n;
                        this.adjustForVSB(n5 != 0, rectangle, rectangle7, insets, true);
                        dimension3 = this.viewport.toViewCoordinates(rectangle.getSize());
                    }
                }
                if (this.hsb != null && this.hsbPolicy == 30 && !bl2) {
                    int n17 = n = !bl3 && (dimension2.width > dimension3.width || this.colHead != null && this.colHead.getView() != null && this.colHead.getView().getPreferredSize().width > dimension3.width) ? 1 : 0;
                    if (n == 0 && jScrollPane instanceof JideScrollPane && ((JideScrollPane)jScrollPane).isKeepCornerVisible() && (this._hLeft != null || this._hRight != null)) {
                        n = 1;
                    }
                    if (n != n4) {
                        n4 = n;
                        this.adjustForHSB(n4 != 0, rectangle, rectangle8, insets);
                        if (this.vsb != null && n5 == 0 && this.vsbPolicy != 21) {
                            dimension3 = this.viewport.toViewCoordinates(rectangle.getSize());
                            int n18 = n5 = dimension2.height > dimension3.height ? 1 : 0;
                            if (n5 == 0 && jScrollPane instanceof JideScrollPane && ((JideScrollPane)jScrollPane).isKeepCornerVisible() && (this._vBottom != null || this._vTop != null)) {
                                n5 = 1;
                            }
                            if (n5 != 0) {
                                this.adjustForVSB(true, rectangle, rectangle7, insets, true);
                            }
                        }
                        if (this._rowFoot != null && this._rowFoot.isVisible()) {
                            rectangle7.x += rectangle5.width;
                        }
                    }
                }
                if (n3 != n4 || n2 != n5) {
                    this.viewport.setBounds(this.adjustBounds(container, rectangle, bl6));
                }
            }
        }
        rectangle7.height = this.isVsbCoversWholeHeight(jScrollPane) ? jScrollPane.getHeight() - insets2.bottom - insets2.top : rectangle.height + insets.top + insets.bottom;
        rectangle8.width = this.isHsbCoversWholeWidth(jScrollPane) ? jScrollPane.getWidth() - rectangle7.width - insets2.left - insets2.right : rectangle.width + insets.left + insets.right;
        rectangle4.height = rectangle.height + insets.top + insets.bottom;
        rectangle4.y = rectangle.y - insets.top;
        rectangle2.width = rectangle.width + insets.left + insets.right;
        rectangle2.x = rectangle.x - insets.left;
        rectangle3.width = rectangle2.width;
        rectangle3.x = rectangle2.x;
        rectangle6.x = rectangle.x;
        rectangle6.y = rectangle4.y + rectangle4.height;
        rectangle6.width = rectangle.width;
        rectangle5.x = rectangle.x + rectangle.width;
        rectangle5.y = rectangle.y;
        rectangle5.height = rectangle.height;
        rectangle7.x += rectangle5.width;
        rectangle8.y += rectangle6.height;
        if (this.rowHead != null) {
            this.rowHead.setBounds(this.adjustBounds(container, rectangle4, bl6));
        }
        if (this._rowFoot != null) {
            this._rowFoot.setBounds(this.adjustBounds(container, rectangle5, bl6));
        }
        int n19 = this.isColumnHeadersHeightUnified(jScrollPane) ? Math.max(rectangle2.height, Math.max(this.upperLeft == null ? 0 : this.upperLeft.getPreferredSize().height, this.upperRight == null ? 0 : this.upperRight.getPreferredSize().height)) : (n3 = 0);
        int n20 = this.isColumnFootersHeightUnified(jScrollPane) ? Math.max(rectangle6.height, Math.max(this.lowerLeft == null ? 0 : this.lowerLeft.getPreferredSize().height, this.lowerRight == null ? 0 : this.lowerRight.getPreferredSize().height)) : (n2 = 0);
        if (this.colHead != null) {
            n = this.isColumnHeadersHeightUnified(jScrollPane) ? n3 : Math.min(rectangle2.height, this.colHead.getPreferredSize().height);
            this.colHead.setBounds(this.adjustBounds(container, new Rectangle(rectangle2.x, rectangle2.y + rectangle2.height - n, rectangle2.width, n), bl6));
        }
        if (this._subColHead != null) {
            this._subColHead.setBounds(this.adjustBounds(container, rectangle3, bl6));
        }
        if (this._colFoot != null) {
            n = this.isColumnFootersHeightUnified(jScrollPane) ? n2 : Math.min(rectangle6.height, this._colFoot.getPreferredSize().height);
            this._colFoot.setBounds(this.adjustBounds(container, new Rectangle(rectangle6.x, rectangle6.y, rectangle6.width, n), bl6));
        } else if (this.isColumnFootersHeightUnified(jScrollPane)) {
            n2 = rectangle8.height;
        }
        if (this.vsb != null) {
            if (n5 != 0) {
                this.vsb.setVisible(true);
                if (this.vsbPolicy == 20 && !bl && (bl4 || dimension2.height <= dimension3.height && (this.rowHead == null || this.rowHead.getView() == null || this.rowHead.getView().getPreferredSize().height <= dimension3.height))) {
                    this.vsb.setVisible(false);
                }
                if (this._vTop == null && this._vBottom == null) {
                    this.vsb.setBounds(this.adjustBounds(container, rectangle7, bl6));
                } else {
                    Rectangle rectangle9 = new Rectangle(rectangle7);
                    if (this._vTop != null) {
                        dimension = this._vTop.getPreferredSize();
                        rectangle9.y += dimension.height;
                        rectangle9.height -= dimension.height;
                        this._vTop.setVisible(true);
                        this._vTop.setBounds(this.adjustBounds(container, new Rectangle(rectangle7.x, rectangle7.y, rectangle7.width, dimension.height), bl6));
                    }
                    if (this._vBottom != null) {
                        dimension = this._vBottom.getPreferredSize();
                        rectangle9.height -= dimension.height;
                        this._vBottom.setVisible(true);
                        this._vBottom.setBounds(this.adjustBounds(container, new Rectangle(rectangle7.x, rectangle7.y + rectangle7.height - dimension.height, rectangle7.width, dimension.height), bl6));
                    }
                    this.vsb.setBounds(this.adjustBounds(container, rectangle9, bl6));
                }
            } else {
                if (dimension2.height > dimension3.height && !bl2) {
                    this.vsb.setVisible(true);
                    this.vsb.setBounds(this.adjustBounds(container, new Rectangle(rectangle7.x, rectangle7.y, 0, rectangle7.height), bl6));
                } else {
                    this.vsb.setVisible(false);
                }
                if (this._vTop != null) {
                    this._vTop.setVisible(false);
                }
                if (this._vBottom != null) {
                    this._vBottom.setVisible(false);
                }
            }
        }
        if (this.hsb != null) {
            if (n4 != 0) {
                this.hsb.setVisible(true);
                if (this.hsbPolicy == 30 && !bl && (bl3 || dimension2.width <= dimension3.width && (this.colHead == null || this.colHead.getView() == null || this.colHead.getView().getPreferredSize().width <= dimension3.width))) {
                    this.hsb.setVisible(false);
                }
                if (this._hLeft == null && this._hRight == null) {
                    this.hsb.setBounds(this.adjustBounds(container, rectangle8, bl6));
                } else {
                    Rectangle rectangle10 = new Rectangle(rectangle8);
                    if (this._hLeft != null) {
                        dimension = this._hLeft.getPreferredSize();
                        rectangle10.x += dimension.width;
                        rectangle10.width -= dimension.width;
                        this._hLeft.setVisible(true);
                        this._hLeft.setBounds(this.adjustBounds(container, new Rectangle(rectangle8.x, rectangle8.y, dimension.width, rectangle8.height), bl6));
                        this._hLeft.doLayout();
                    }
                    if (this._hRight != null) {
                        dimension = this._hRight.getPreferredSize();
                        rectangle10.width -= dimension.width;
                        this._hRight.setVisible(true);
                        this._hRight.setBounds(this.adjustBounds(container, new Rectangle(rectangle8.x + rectangle8.width - dimension.width, rectangle8.y, dimension.width, rectangle8.height), bl6));
                    }
                    this.hsb.setBounds(this.adjustBounds(container, rectangle10, bl6));
                }
            } else {
                if (dimension2.width > dimension3.width && !bl2) {
                    this.hsb.setVisible(true);
                    this.hsb.setBounds(this.adjustBounds(container, new Rectangle(rectangle8.x, rectangle8.y, rectangle8.width, 0), bl6));
                } else {
                    this.hsb.setVisible(false);
                }
                if (this._hLeft != null) {
                    this._hLeft.setVisible(false);
                }
                if (this._hRight != null) {
                    this._hRight.setVisible(false);
                }
            }
        }
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            int n21 = this.isColumnFootersHeightUnified(jScrollPane) ? n2 : Math.min(this.lowerLeft.getPreferredSize().height, rectangle6.height);
            this.lowerLeft.setBounds(this.adjustBounds(container, new Rectangle(rectangle4.x, rectangle6.y != 0 ? rectangle6.y : rectangle8.y, rectangle4.width, n21), bl6));
        }
        if (this.lowerRight != null && this.lowerRight.isVisible()) {
            int n22 = this.isColumnFootersHeightUnified(jScrollPane) ? n2 : Math.min(this.lowerRight.getPreferredSize().height, rectangle6.height);
            this.lowerRight.setBounds(this.adjustBounds(container, new Rectangle(rectangle5.x, rectangle6.y != 0 ? rectangle6.y : rectangle8.y, rectangle5.width + (this.isVsbCoversWholeHeight(jScrollPane) || rectangle5.width != 0 ? 0 : rectangle7.width), n22), bl6));
        }
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            int n23 = this.isColumnHeadersHeightUnified(jScrollPane) ? n3 : Math.min(this.upperLeft.getPreferredSize().height, rectangle2.height);
            this.upperLeft.setBounds(this.adjustBounds(container, new Rectangle(rectangle4.x, rectangle2.y + rectangle2.height - n23, rectangle4.width, n23), bl6));
        }
        if (this.upperRight != null && this.upperRight.isVisible()) {
            int n24 = this.isColumnHeadersHeightUnified(jScrollPane) ? n3 : Math.min(this.upperRight.getPreferredSize().height, rectangle2.height);
            this.upperRight.setBounds(this.adjustBounds(container, new Rectangle(rectangle5.x, rectangle2.y + rectangle2.height - n24, rectangle5.width + (this.isVsbCoversWholeHeight(jScrollPane) || rectangle5.width != 0 ? 0 : rectangle7.width), n24), bl6));
        }
        if (this._subUpperLeft != null && this._subUpperLeft.isVisible()) {
            int n25 = Math.min(this._subUpperLeft.getPreferredSize().height, this.getSubUpperHeight());
            this._subUpperLeft.setBounds(this.adjustBounds(container, new Rectangle(rectangle4.x, rectangle3.y + rectangle3.height - n25, rectangle4.width, n25), bl6));
        }
        if (this._subUpperRight != null && this._subUpperRight.isVisible()) {
            int n26 = Math.min(this._subUpperRight.getPreferredSize().height, this.getSubUpperHeight());
            this._subUpperRight.setBounds(this.adjustBounds(container, new Rectangle(rectangle5.x, rectangle3.y + rectangle3.height - n26, rectangle5.width + (this.isVsbCoversWholeHeight(jScrollPane) || rectangle5.width != 0 ? 0 : rectangle7.width), n26), bl6));
        }
    }

    private Rectangle adjustBounds(Container container, Rectangle rectangle, boolean bl) {
        if (bl) {
            return rectangle;
        }
        Rectangle rectangle2 = new Rectangle(rectangle);
        int n = container.getWidth();
        rectangle2.x = n - (rectangle.x + rectangle.width);
        return rectangle2;
    }

    private void adjustForVSB(boolean bl, Rectangle rectangle, Rectangle rectangle2, Insets insets, boolean bl2) {
        int n = rectangle2.width;
        if (bl) {
            int n2 = Math.max(0, this.vsb.getPreferredSize().width);
            rectangle.width -= n2;
            rectangle2.width = n2;
            if (bl2) {
                rectangle2.x = rectangle.x + rectangle.width + insets.right;
            } else {
                rectangle2.x = rectangle.x - insets.left;
                rectangle.x += n2;
            }
        } else {
            rectangle.width += n;
        }
    }

    private void adjustForHSB(boolean bl, Rectangle rectangle, Rectangle rectangle2, Insets insets) {
        int n = rectangle2.height;
        if (bl) {
            int n2 = Math.max(0, this.hsb.getPreferredSize().height);
            rectangle.height -= n2;
            rectangle2.y = rectangle.y + rectangle.height + insets.bottom;
            rectangle2.height = n2;
        } else {
            rectangle.height += n;
        }
    }

    static class UIResource
    extends JideScrollPaneLayout
    implements javax.swing.plaf.UIResource {
        private static final long serialVersionUID = 1057343395078846689L;

        UIResource() {
        }
    }
}

