/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.jms.management;

import javax.jms.JMSException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.jms.client.HornetQMessage;

public class JMSManagementHelper {
    private static Message getCoreMessage(javax.jms.Message jmsMessage) {
        if (!(jmsMessage instanceof HornetQMessage)) {
            throw new IllegalArgumentException("Cannot send a non HornetQ message as a management message " + jmsMessage.getClass().getName());
        }
        return ((HornetQMessage)jmsMessage).getCoreMessage();
    }

    public static void putAttribute(javax.jms.Message message, String resourceName, String attribute) throws JMSException {
        ManagementHelper.putAttribute(JMSManagementHelper.getCoreMessage(message), resourceName, attribute);
    }

    public static void putOperationInvocation(javax.jms.Message message, String resourceName, String operationName) throws JMSException {
        try {
            ManagementHelper.putOperationInvocation(JMSManagementHelper.getCoreMessage(message), resourceName, operationName);
        }
        catch (Exception e) {
            throw JMSManagementHelper.convertFromException(e);
        }
    }

    private static JMSException convertFromException(Exception e) {
        JMSException jmse = new JMSException(e.getMessage());
        jmse.initCause(e);
        return jmse;
    }

    public static void putOperationInvocation(javax.jms.Message message, String resourceName, String operationName, Object ... parameters) throws JMSException {
        try {
            ManagementHelper.putOperationInvocation(JMSManagementHelper.getCoreMessage(message), resourceName, operationName, parameters);
        }
        catch (Exception e) {
            throw JMSManagementHelper.convertFromException(e);
        }
    }

    public static boolean isOperationResult(javax.jms.Message message) throws JMSException {
        return ManagementHelper.isOperationResult(JMSManagementHelper.getCoreMessage(message));
    }

    public static boolean isAttributesResult(javax.jms.Message message) throws JMSException {
        return ManagementHelper.isAttributesResult(JMSManagementHelper.getCoreMessage(message));
    }

    public static boolean hasOperationSucceeded(javax.jms.Message message) throws JMSException {
        return ManagementHelper.hasOperationSucceeded(JMSManagementHelper.getCoreMessage(message));
    }

    public static Object[] getResults(javax.jms.Message message) throws Exception {
        return ManagementHelper.getResults(JMSManagementHelper.getCoreMessage(message));
    }

    public static Object getResult(javax.jms.Message message) throws Exception {
        return ManagementHelper.getResult(JMSManagementHelper.getCoreMessage(message));
    }

    private JMSManagementHelper() {
    }
}

