/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.core.journal.impl.SyncIOCompletion;
import org.hornetq.journal.HornetQJournalLogger;

public class SimpleWaitIOCallback
extends SyncIOCompletion {
    private final CountDownLatch latch = new CountDownLatch(1);
    private volatile String errorMessage;
    private volatile int errorCode = 0;

    public String toString() {
        return SimpleWaitIOCallback.class.getName();
    }

    @Override
    public void done() {
        this.latch.countDown();
    }

    @Override
    public void onError(int errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        HornetQJournalLogger.LOGGER.errorOnIOCallback(errorMessage);
        this.latch.countDown();
    }

    @Override
    public void waitCompletion() throws Exception {
        while (!this.latch.await(2L, TimeUnit.SECONDS)) {
        }
        if (this.errorMessage != null) {
            throw HornetQExceptionType.createException(this.errorCode, this.errorMessage);
        }
    }

    public boolean waitCompletion(long timeout) throws Exception {
        boolean retValue = this.latch.await(timeout, TimeUnit.MILLISECONDS);
        if (this.errorMessage != null) {
            throw HornetQExceptionType.createException(this.errorCode, this.errorMessage);
        }
        return retValue;
    }

    @Override
    public void storeLineUp() {
    }
}

