/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class HornetQExceptionMessage
extends PacketImpl {
    private HornetQException exception;

    public HornetQExceptionMessage(HornetQException exception) {
        super((byte)20);
        this.exception = exception;
    }

    public HornetQExceptionMessage() {
        super((byte)20);
    }

    @Override
    public boolean isResponse() {
        return true;
    }

    public HornetQException getException() {
        return this.exception;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeInt(this.exception.getType().getCode());
        buffer.writeNullableString(this.exception.getMessage());
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        int code = buffer.readInt();
        String msg = buffer.readNullableString();
        this.exception = HornetQExceptionType.createException(code, msg);
    }

    @Override
    public String toString() {
        return this.getParentString() + ", exception= " + this.exception + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.exception == null ? 0 : this.exception.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof HornetQExceptionMessage)) {
            return false;
        }
        HornetQExceptionMessage other = (HornetQExceptionMessage)obj;
        return !(this.exception == null ? other.exception != null : !this.exception.equals(other.exception));
    }
}

