/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import java.util.Enumeration;
import java.util.Vector;
import javax.jms.ConnectionMetaData;
import javax.jms.JMSException;
import org.hornetq.core.version.Version;

public class HornetQConnectionMetaData
implements ConnectionMetaData {
    private static final String HORNETQ = "HornetQ";
    private final Version serverVersion;

    public HornetQConnectionMetaData(Version serverVersion) {
        this.serverVersion = serverVersion;
    }

    @Override
    public String getJMSVersion() throws JMSException {
        return "1.1";
    }

    @Override
    public int getJMSMajorVersion() throws JMSException {
        return 1;
    }

    @Override
    public int getJMSMinorVersion() throws JMSException {
        return 1;
    }

    @Override
    public String getJMSProviderName() throws JMSException {
        return HORNETQ;
    }

    @Override
    public String getProviderVersion() throws JMSException {
        return this.serverVersion.getFullVersion();
    }

    @Override
    public int getProviderMajorVersion() throws JMSException {
        return this.serverVersion.getMajorVersion();
    }

    @Override
    public int getProviderMinorVersion() throws JMSException {
        return this.serverVersion.getMinorVersion();
    }

    @Override
    public Enumeration getJMSXPropertyNames() throws JMSException {
        Vector<String> v = new Vector<String>();
        v.add("JMSXGroupID");
        v.add("JMSXGroupSeq");
        v.add("JMSXDeliveryCount");
        return v.elements();
    }
}

