/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.lang.reflect.Method;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBClientContextIdentifier;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBHomeLocator;
import org.jboss.ejb.client.EJBLocator;

final class EJBHomeCreateInterceptor
implements EJBClientInterceptor {
    EJBHomeCreateInterceptor() {
    }

    @Override
    public void handleInvocation(EJBClientInvocationContext invocationContext) throws Exception {
        invocationContext.sendRequest();
    }

    @Override
    public Object handleInvocationResult(EJBClientInvocationContext invocationContext) throws Exception {
        Object originalResult = invocationContext.getResult();
        if (originalResult == null) {
            return originalResult;
        }
        if (!this.isEJBHomeInvocation(invocationContext)) {
            return originalResult;
        }
        if (!this.isCreateMethodInvocation(invocationContext)) {
            return originalResult;
        }
        if (!EJBClient.isEJBProxy(originalResult)) {
            return originalResult;
        }
        Object ejbProxy = originalResult;
        EJBLocator<Object> ejbLocator = EJBClient.getLocatorFor(ejbProxy);
        EJBClientContextIdentifier ejbClientContextIdentifier = invocationContext.getInvocationHandler().getEjbClientContextIdentifier();
        return EJBClient.createProxy(ejbLocator, ejbClientContextIdentifier);
    }

    private boolean isEJBHomeInvocation(EJBClientInvocationContext invocationContext) {
        EJBLocator<?> locator = invocationContext.getLocator();
        return locator instanceof EJBHomeLocator;
    }

    private boolean isCreateMethodInvocation(EJBClientInvocationContext invocationContext) {
        Method invokedMethod = invocationContext.getInvokedMethod();
        return invokedMethod.getName().startsWith("create");
    }
}

