/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.logging;

import org.jboss.netty.logging.InternalLogLevel;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.JdkLoggerFactory;
import org.jboss.netty.util.internal.StackTraceSimplifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InternalLoggerFactory {
    private static volatile InternalLoggerFactory defaultFactory = new JdkLoggerFactory();

    public static InternalLoggerFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static void setDefaultFactory(InternalLoggerFactory defaultFactory) {
        if (defaultFactory == null) {
            throw new NullPointerException("defaultFactory");
        }
        InternalLoggerFactory.defaultFactory = defaultFactory;
    }

    public static InternalLogger getInstance(Class<?> clazz) {
        return InternalLoggerFactory.getInstance(clazz.getName());
    }

    public static InternalLogger getInstance(String name) {
        final InternalLogger logger2 = InternalLoggerFactory.getDefaultFactory().newInstance(name);
        return new InternalLogger(){

            public void debug(String msg) {
                logger2.debug(msg);
            }

            public void debug(String msg, Throwable cause) {
                StackTraceSimplifier.simplify(cause);
                logger2.debug(msg, cause);
            }

            public void error(String msg) {
                logger2.error(msg);
            }

            public void error(String msg, Throwable cause) {
                StackTraceSimplifier.simplify(cause);
                logger2.error(msg, cause);
            }

            public void info(String msg) {
                logger2.info(msg);
            }

            public void info(String msg, Throwable cause) {
                StackTraceSimplifier.simplify(cause);
                logger2.info(msg, cause);
            }

            public boolean isDebugEnabled() {
                return logger2.isDebugEnabled();
            }

            public boolean isErrorEnabled() {
                return logger2.isErrorEnabled();
            }

            public boolean isInfoEnabled() {
                return logger2.isInfoEnabled();
            }

            public boolean isWarnEnabled() {
                return logger2.isWarnEnabled();
            }

            public void warn(String msg) {
                logger2.warn(msg);
            }

            public void warn(String msg, Throwable cause) {
                StackTraceSimplifier.simplify(cause);
                logger2.warn(msg, cause);
            }

            public boolean isEnabled(InternalLogLevel level) {
                return logger2.isEnabled(level);
            }

            public void log(InternalLogLevel level, String msg) {
                logger2.log(level, msg);
            }

            public void log(InternalLogLevel level, String msg, Throwable cause) {
                StackTraceSimplifier.simplify(cause);
                logger2.log(level, msg, cause);
            }
        };
    }

    public abstract InternalLogger newInstance(String var1);

    static {
        StackTraceSimplifier.simplify(new Exception());
    }
}

