/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.management.MBeanServer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jgroups.Address;
import org.jgroups.MembershipListener;
import org.jgroups.View;
import org.jgroups.blocks.Cache;
import org.jgroups.blocks.ReplCache;
import org.jgroups.jmx.JmxConfigurator;

public class ReplCacheDemo
extends JPanel
implements ActionListener {
    private ReplCache<String, String> cache;
    private static final String BASENAME = "replcache";
    private JFrame frame;
    private JTabbedPane root_pane = new JTabbedPane();
    private JTable table;
    private JTextField key_field = ReplCacheDemo.createTextField(null, 10);
    private JTextField value_field = ReplCacheDemo.createTextField(null, 10);
    private JTextField repl_count_field = ReplCacheDemo.createTextField("1", 3);
    private JTextField timeout_field = ReplCacheDemo.createTextField("0", 5);
    private JTextField perf_key_prefix = ReplCacheDemo.createTextField("key", 5);
    private JTextField perf_num_keys = ReplCacheDemo.createTextField("1000", 5);
    private JTextField perf_size = ReplCacheDemo.createTextField("1000", 5);
    private JTextField perf_repl_count_field = ReplCacheDemo.createTextField("1", 3);
    private JTextField perf_timeout_field = ReplCacheDemo.createTextField("0", 5);
    private JTextArea status = new JTextArea("Status area", 10, 5);
    private JLabel num_elements = new JLabel("0 elements");
    private MyTableModel model = null;

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("Put")) {
            String key = this.key_field.getText();
            String value = this.value_field.getText();
            String repl_count = this.repl_count_field.getText();
            String timeout = this.timeout_field.getText();
            if (key == null || value == null) {
                return;
            }
            if (repl_count == null) {
                repl_count = "1";
            }
            if (timeout == null) {
                timeout = "0";
            }
            this.cache.put(key, value, Short.valueOf(repl_count), Long.valueOf(timeout));
        } else if (command.equals("Remove")) {
            int[] rows = this.table.getSelectedRows();
            if (rows != null) {
                for (int row : rows) {
                    String key = (String)this.model.getValueAt(row, 0);
                    if (key == null) continue;
                    this.cache.remove(key);
                }
            }
        } else if (command.equals("Clear")) {
            this.clear();
        } else if (command.equals("Rebalance")) {
            this.cache.mcastEntries();
        } else if (command.equals("Reset")) {
            this.status.setText("");
        } else if (command.equals("Start")) {
            this.startPerfTest();
        } else if (!command.equals("Stop") && command.equals("Exit")) {
            if (this.cache != null) {
                this.cache.stop();
            }
            this.frame.dispose();
            System.exit(1);
        }
    }

    private void clear() {
        this.cache.clear();
    }

    private void startPerfTest() {
        int num_puts = 1000;
        int size = 1000;
        short repl_count = 1;
        long timeout = 0L;
        String key_prefix = "key";
        String tmp = this.perf_key_prefix.getText();
        if (tmp != null) {
            key_prefix = tmp;
        }
        if ((tmp = this.perf_num_keys.getText()) != null) {
            num_puts = Integer.valueOf(tmp);
        }
        if ((tmp = this.perf_size.getText()) != null) {
            size = Integer.valueOf(tmp);
        }
        if ((tmp = this.perf_repl_count_field.getText()) != null) {
            repl_count = Short.valueOf(tmp);
        }
        if ((tmp = this.perf_timeout_field.getText()) != null) {
            timeout = Long.valueOf(tmp);
        }
        long start = System.currentTimeMillis();
        for (int i = 0; i < num_puts; ++i) {
            String key = key_prefix + "-" + i;
            String value = "val-" + i;
            this.cache.put(key, value, repl_count, timeout);
        }
        long diff = System.currentTimeMillis() - start;
        this.status.setText("It took " + diff + " ms to insert " + num_puts + " elements");
    }

    private void start(String props, String cluster_name, long rpc_timeout, long caching_time, boolean migrate_data, boolean use_l1_cache, int l1_max_entries, long l1_reaping_interval, int l2_max_entries, long l2_reaping_interval) throws Exception {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        this.cache = new ReplCache(props, cluster_name);
        this.cache.setCallTimeout(rpc_timeout);
        this.cache.setCachingTime(caching_time);
        this.cache.setMigrateData(migrate_data);
        JmxConfigurator.register(this.cache, server, "replcache:name=cache");
        JmxConfigurator.register(this.cache.getL2Cache(), server, "replcache:name=l2-cache");
        if (use_l1_cache) {
            Cache l1_cache = new Cache();
            this.cache.setL1Cache(l1_cache);
            if (l1_reaping_interval > 0L) {
                l1_cache.enableReaping(l1_reaping_interval);
            }
            if (l1_max_entries > 0) {
                l1_cache.setMaxNumberOfEntries(l1_max_entries);
            }
            JmxConfigurator.register(this.cache.getL1Cache(), server, "replcache:name=l1-cache");
        }
        if (l2_max_entries > 0 || l2_reaping_interval > 0L) {
            Cache<String, ReplCache.Value<String>> l2_cache = this.cache.getL2Cache();
            if (l2_max_entries > 0) {
                l2_cache.setMaxNumberOfEntries(l2_max_entries);
            }
            if (l2_reaping_interval > 0L) {
                l2_cache.enableReaping(l2_reaping_interval);
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ReplCacheDemo.this.cache.stop();
            }
        });
        this.cache.start();
        this.model = new MyTableModel();
        this.model.setMap(this.cache.getL2Cache().getInternalMap());
        this.cache.addChangeListener(this.model);
        this.frame = new JFrame("ReplCacheDemo");
        this.frame.setDefaultCloseOperation(3);
        this.setLayout(new BoxLayout(this, 1));
        this.table = new MyTable((TableModel)this.model);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 200));
        this.table.setShowGrid(false);
        this.table.setFont(this.table.getFont().deriveFont(1));
        this.add(new JScrollPane(this.table));
        JPanel key = new JPanel(new FlowLayout(0));
        key.add(new JLabel("Key  "));
        key.add(this.key_field);
        this.add(key);
        JPanel value = new JPanel(new FlowLayout(0));
        value.add(new JLabel("Value"));
        value.add(this.value_field);
        this.add(value);
        JPanel repl_count = new JPanel(new FlowLayout(0));
        repl_count.add(new JLabel("Replication count"));
        repl_count.add(this.repl_count_field);
        this.add(repl_count);
        JPanel timeout = new JPanel(new FlowLayout(0));
        timeout.add(new JLabel("Timeout"));
        timeout.add(this.timeout_field);
        this.add(timeout);
        JPanel buttons = new JPanel();
        JButton put_button = this.createButton("Put");
        buttons.add(this.createButton("Put"));
        buttons.add(this.createButton("Remove"));
        buttons.add(this.createButton("Clear"));
        buttons.add(this.createButton("Rebalance"));
        buttons.add(this.createButton("Exit"));
        buttons.add(this.num_elements);
        this.add(buttons);
        this.setOpaque(true);
        this.root_pane.addTab("Data", this);
        JPanel perf_panel = new JPanel();
        perf_panel.setLayout(new BoxLayout(perf_panel, 1));
        perf_panel.setOpaque(true);
        this.root_pane.addTab("Perf test", perf_panel);
        perf_panel.add(this.status);
        this.status.setForeground(Color.BLUE);
        JPanel prefix = new JPanel(new FlowLayout(0));
        prefix.add(new JLabel("Key prefix"));
        prefix.add(this.perf_key_prefix);
        perf_panel.add(prefix);
        JPanel keys = new JPanel(new FlowLayout(0));
        keys.add(new JLabel("Number of keys to insert"));
        keys.add(this.perf_num_keys);
        perf_panel.add(keys);
        JPanel size = new JPanel(new FlowLayout(0));
        size.add(new JLabel("Size of each key (bytes)"));
        size.add(this.perf_size);
        size.add(new JLabel("    (ignored for now)"));
        perf_panel.add(size);
        JPanel perf_repl_count = new JPanel(new FlowLayout(0));
        perf_repl_count.add(new JLabel("Replication count"));
        perf_repl_count.add(this.perf_repl_count_field);
        perf_panel.add(perf_repl_count);
        JPanel perf_timeout = new JPanel(new FlowLayout(0));
        perf_timeout.add(new JLabel("Timeout"));
        perf_timeout.add(this.perf_timeout_field);
        perf_panel.add(perf_timeout);
        JPanel perf_buttons = new JPanel(new FlowLayout(0));
        perf_buttons.add(this.createButton("Start"));
        perf_buttons.add(this.createButton("Stop"));
        perf_buttons.add(this.createButton("Reset"));
        perf_buttons.add(this.createButton("Exit"));
        perf_panel.add(perf_buttons);
        this.frame.setContentPane(this.root_pane);
        this.frame.pack();
        this.frame.getRootPane().setDefaultButton(put_button);
        this.frame.setVisible(true);
        this.setTitle("ReplCacheDemo");
        this.cache.addMembershipListener(new MembershipListener(){

            @Override
            public void viewAccepted(View new_view) {
                ReplCacheDemo.this.setTitle("ReplCacheDemo");
            }

            @Override
            public void suspect(Address suspected_mbr) {
            }

            @Override
            public void block() {
            }

            @Override
            public void unblock() {
            }
        });
    }

    private JButton createButton(String text) {
        JButton retval = new JButton(text);
        retval.addActionListener(this);
        return retval;
    }

    private static JTextField createTextField(String name, int length) {
        JTextField retval = new JTextField(name, length);
        retval.addFocusListener(new MyFocusListener(retval));
        return retval;
    }

    public static void main(String[] args) throws Exception {
        String props = "udp.xml";
        String cluster_name = "replcache-cluster";
        long rpc_timeout = 1500L;
        long caching_time = 30000L;
        boolean migrate_data = true;
        boolean use_l1_cache = true;
        int l1_max_entries = 5000;
        int l2_max_entries = -1;
        long l1_reaping_interval = -1L;
        long l2_reaping_interval = 30000L;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-cluster_name")) {
                cluster_name = args[++i];
                continue;
            }
            if (args[i].equals("-rpc_timeout")) {
                rpc_timeout = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-caching_time")) {
                caching_time = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-migrate_data")) {
                migrate_data = Boolean.parseBoolean(args[++i]);
                continue;
            }
            if (args[i].equals("-use_l1_cache")) {
                use_l1_cache = Boolean.parseBoolean(args[++i]);
                continue;
            }
            if (args[i].equals("-l1_max_entries")) {
                l1_max_entries = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-l1_reaping_interval")) {
                l1_reaping_interval = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-l2_max_entries")) {
                l2_max_entries = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-l2_reaping_interval")) {
                l2_reaping_interval = Long.parseLong(args[++i]);
                continue;
            }
            ReplCacheDemo.help();
            return;
        }
        ReplCacheDemo demo = new ReplCacheDemo();
        demo.start(props, cluster_name, rpc_timeout, caching_time, migrate_data, use_l1_cache, l1_max_entries, l1_reaping_interval, l2_max_entries, l2_reaping_interval);
    }

    void setTitle(String title) {
        String local_addr = this.cache != null ? this.cache.getLocalAddressAsString() : null;
        int num_nodes = this.cache != null ? this.cache.getClusterSize() : 0;
        this.frame.setTitle(title + ": " + local_addr + " (" + num_nodes + ")");
    }

    private static void help() {
        System.out.println("ReplCacheServer [-help] [-props <props>] [-cluster_name <name>][-rpc_timeout <ms>] [-caching_time <ms>] [-migrate_data <true|false>] [-use_l1_cache <true|false>] [-l1_max_entries <num>] [-l1_reaping_interval <ms>] [-l2_max_entries <num>] [-l2_reaping_interval <ms>] ");
    }

    private class MyTableModel<K, V>
    extends AbstractTableModel
    implements ReplCache.ChangeListener {
        private ConcurrentMap<K, Cache.Value<ReplCache.Value<V>>> map;
        private final String[] columnNames = new String[]{"Key", "Value", "Replication Count", "Timeout"};
        private static final long serialVersionUID = 1314724464389654329L;

        private MyTableModel() {
        }

        public void setMap(ConcurrentMap<K, Cache.Value<ReplCache.Value<V>>> map) {
            this.map = map;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.map.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            int count = 0;
            for (Map.Entry entry : this.map.entrySet()) {
                if (count++ < row) continue;
                Object key = entry.getKey();
                Cache.Value val = (Cache.Value)entry.getValue();
                ReplCache.Value tmp = (ReplCache.Value)val.getValue();
                switch (col) {
                    case 0: {
                        return key;
                    }
                    case 1: {
                        Object value = tmp.getVal();
                        return value instanceof byte[] ? ((byte[])value).length + " bytes" : value;
                    }
                    case 2: {
                        return tmp.getReplicationCount();
                    }
                    case 3: {
                        return val.getTimeout();
                    }
                }
                return "n/a";
            }
            throw new IllegalArgumentException("row=" + row + ", col=" + col);
        }

        @Override
        public void changed() {
            this.fireTableDataChanged();
            ReplCacheDemo.this.num_elements.setText(ReplCacheDemo.this.cache.getL2Cache().getSize() + " elements");
        }
    }

    private static class MyTable
    extends JTable {
        private MyTable(TableModel dm) {
            super(dm);
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            Container viewport = this.getParent();
            return viewport instanceof JViewport && this.getPreferredSize().height < viewport.getHeight();
        }
    }

    private static class MyFocusListener
    implements FocusListener {
        private final JTextField field;

        public MyFocusListener(JTextField field) {
            this.field = field;
        }

        @Override
        public void focusGained(FocusEvent e) {
            String value = this.field.getText();
            if (value != null && value.length() > 0) {
                this.field.selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

