/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import org.jgroups.util.Util;

public class Bsh {
    String host = "localhost";
    int port = 0;
    long timeout = 0L;

    public void start(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            String tmp = args[i];
            if ("-host".equals(tmp)) {
                this.host = args[++i];
                continue;
            }
            if ("-port".equals(tmp)) {
                this.port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-timeout".equals(tmp)) {
                this.timeout = Long.parseLong(args[++i]);
                continue;
            }
            Bsh.help();
            return;
        }
        this.runClient();
    }

    void runClient() throws Exception {
        final Socket sock = new Socket(this.host, this.port);
        final InputStream in = sock.getInputStream();
        OutputStream out = sock.getOutputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        new Thread(){

            @Override
            public void run() {
                byte[] buf = new byte[1024];
                while (!sock.isClosed()) {
                    try {
                        int num = in.read(buf, 0, buf.length);
                        String str = new String(buf, 0, num);
                        System.out.println(str);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        break;
                    }
                }
            }
        }.start();
        while (true) {
            System.out.print("> ");
            String line = reader.readLine();
            if (line.startsWith("quit") || line.startsWith("exit")) {
                Util.close(sock);
                return;
            }
            line = line + "\n";
            byte[] buf = line.getBytes();
            out.write(buf, 0, buf.length);
            out.flush();
        }
    }

    static void help() {
        System.out.println("Bsh [-help] [-host <host>] [-port <port>] [-timeout <timeout>]");
    }

    public static void main(String[] args) {
        try {
            new Bsh().start(args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

