/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.concurrent.CountDownLatch;
import org.jgroups.util.Util;

public class bla6 {
    protected static final int MEMBERS = 4;
    protected static final int MAX_AMOUNT = 500;
    protected static final int THRESHOLD = 100;
    protected Credits[] credits = new Credits[4];
    protected static final int[] amounts = new int[]{30, 40, 20, 30};
    protected static final String[] names = new String[]{"A", "B", "C", "D"};

    public static void main(String[] args) throws Exception {
        new bla6().start();
    }

    protected void start() {
        for (int i = 0; i < 4; ++i) {
            this.credits[i] = new Credits(500, names[i]);
        }
        CountDownLatch latch = new CountDownLatch(1);
        RandomSender[] senders = new RandomSender[4];
        for (int i = 0; i < 4; ++i) {
            senders[i] = new RandomSender(latch, this.credits[i], 10);
            senders[i].start();
        }
        Util.sleep(200L);
        latch.countDown();
        for (RandomSender sender : senders) {
            try {
                sender.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (Credits credit : this.credits) {
            System.out.println(credit);
        }
    }

    protected void sendMessage(Credits sender, int amount) {
        for (Credits credit : this.credits) {
            int replenish;
            if (credit == sender || (replenish = credit.remove(amount)) <= 0) continue;
            this.sendReplenish(replenish);
        }
    }

    protected void sendReplenish(int amount) {
        for (Credits credit : this.credits) {
            credit.add(amount);
        }
    }

    protected static class Credits {
        int credits;
        final String name;

        public Credits(int credits, String name) {
            this.credits = credits;
            this.name = name;
        }

        public synchronized void add(int num) {
            int old = this.credits;
            this.credits += num;
            if (this.credits > 500) {
                this.credits = 500;
            }
            System.out.println("[" + this.name + "] " + old + " --> " + this.credits);
        }

        public synchronized int remove(int num) {
            int old = this.credits;
            this.credits -= num;
            if (this.credits < 0) {
                this.credits = 0;
            }
            if (this.credits > 100) {
                System.out.println("[" + this.name + "] " + this.credits + " <-- " + old);
                return 0;
            }
            int replenish = (500 - this.credits) / 4;
            System.out.println("[" + this.name + "] " + this.credits + " <-- " + old + ", replenish " + replenish);
            return replenish;
        }

        public String toString() {
            return String.valueOf(this.credits);
        }
    }

    protected class RandomSender
    extends Thread {
        protected final CountDownLatch latch;
        protected final Credits credit;
        protected final int num_times;

        public RandomSender(CountDownLatch latch, Credits credit, int num_times) {
            this.latch = latch;
            this.credit = credit;
            this.num_times = num_times;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.num_times; ++i) {
                int amount = (int)(Util.random(500L) / 10L % 500L);
                amount = Math.max(1, amount);
                amount = Math.min(500, amount);
                this.credit.remove(amount);
                bla6.this.sendMessage(this.credit, amount);
                Util.sleepRandom(500L, 3000L);
            }
        }
    }

    protected class Sender
    extends Thread {
        protected final CountDownLatch latch;
        protected final Credits credit;
        protected final int amount;

        public Sender(CountDownLatch latch, Credits credit, int amount) {
            this.latch = latch;
            this.credit = credit;
            this.amount = amount;
        }

        @Override
        public void run() {
            try {
                this.latch.await();
                this.credit.remove(this.amount);
                bla6.this.sendMessage(this.credit, this.amount);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

