/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.Options;
import org.xnio.XnioExecutor;
import org.xnio.XnioWorker;
import org.xnio.channels.MulticastMessageChannel;
import org.xnio.channels.SocketAddressBuffer;
import org.xnio.channels.UnsupportedOptionException;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioXnio;
import org.xnio.nio.NioXnioWorker;
import org.xnio.nio.SelectorUtils;
import org.xnio.nio.WorkerThread;

class NioUdpChannel
implements MulticastMessageChannel {
    private static final Logger log = Logger.getLogger("org.xnio.nio.udp.server.channel");
    private final NioXnioWorker worker;
    private final NioHandle<NioUdpChannel> readHandle;
    private final NioHandle<NioUdpChannel> writeHandle;
    private final ChannelListener.SimpleSetter<NioUdpChannel> readSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<NioUdpChannel> writeSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<NioUdpChannel> closeSetter = new ChannelListener.SimpleSetter();
    private final DatagramChannel datagramChannel;
    private final AtomicBoolean callFlag = new AtomicBoolean(false);
    private static final Set<Option<?>> OPTIONS = Option.setBuilder().add(Options.BROADCAST).add(Options.RECEIVE_BUFFER).add(Options.SEND_BUFFER).add(Options.IP_TRAFFIC_CLASS).create();

    NioUdpChannel(NioXnioWorker worker, DatagramChannel datagramChannel) throws ClosedChannelException {
        this.worker = worker;
        WorkerThread readThread = worker.chooseOptional(false);
        WorkerThread writeThread = worker.chooseOptional(true);
        this.readHandle = readThread == null ? null : readThread.addChannel(datagramChannel, this, 0, this.readSetter);
        this.writeHandle = writeThread == null ? null : writeThread.addChannel(datagramChannel, this, 0, this.writeSetter);
        this.datagramChannel = datagramChannel;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.datagramChannel.socket().getLocalSocketAddress();
    }

    @Override
    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return (A)(type.isInstance(this.getLocalAddress()) ? (SocketAddress)type.cast(this.getLocalAddress()) : null);
    }

    @Override
    public int receiveFrom(SocketAddressBuffer addressBuffer, ByteBuffer buffer) throws IOException {
        SocketAddress sourceAddress;
        int o = buffer.remaining();
        try {
            sourceAddress = this.datagramChannel.receive(buffer);
        }
        catch (ClosedChannelException e) {
            return -1;
        }
        if (sourceAddress == null) {
            return 0;
        }
        int t = o - buffer.remaining();
        if (addressBuffer != null) {
            addressBuffer.setSourceAddress(sourceAddress);
            addressBuffer.setDestinationAddress(null);
        }
        return t;
    }

    @Override
    public long receiveFrom(SocketAddressBuffer addressBuffer, ByteBuffer[] buffers) throws IOException {
        return this.receiveFrom(addressBuffer, buffers, 0, buffers.length);
    }

    @Override
    public long receiveFrom(SocketAddressBuffer addressBuffer, ByteBuffer[] buffers, int offs, int len) throws IOException {
        SocketAddress sourceAddress;
        if (len == 0) {
            return 0L;
        }
        if (len == 1) {
            return this.receiveFrom(addressBuffer, buffers[offs]);
        }
        int o = (int)Math.min(Buffers.remaining(buffers, offs, len), 65536L);
        ByteBuffer buffer = ByteBuffer.allocate(o);
        try {
            sourceAddress = this.datagramChannel.receive(buffer);
        }
        catch (ClosedChannelException e) {
            return -1L;
        }
        if (sourceAddress == null) {
            return 0L;
        }
        int t = o - buffer.remaining();
        buffer.flip();
        Buffers.copy(buffers, offs, len, buffer);
        if (addressBuffer != null) {
            addressBuffer.setSourceAddress(sourceAddress);
            addressBuffer.setDestinationAddress(null);
        }
        return t;
    }

    @Override
    public boolean sendTo(SocketAddress target, ByteBuffer buffer) throws IOException {
        return this.datagramChannel.send(buffer, target) != 0;
    }

    @Override
    public boolean sendTo(SocketAddress target, ByteBuffer[] buffers) throws IOException {
        return this.sendTo(target, buffers, 0, buffers.length);
    }

    @Override
    public boolean sendTo(SocketAddress target, ByteBuffer[] buffers, int offset, int length) throws IOException {
        if (length == 0) {
            return false;
        }
        if (length == 1) {
            return this.sendTo(target, buffers[offset]);
        }
        long o = Buffers.remaining(buffers, offset, length);
        if (o > 65535L) {
            throw new IllegalArgumentException("Too may bytes written");
        }
        ByteBuffer buffer = ByteBuffer.allocate((int)o);
        Buffers.copy(buffer, buffers, offset, length);
        buffer.flip();
        return this.datagramChannel.send(buffer, target) != 0;
    }

    public ChannelListener.Setter<NioUdpChannel> getReadSetter() {
        return this.readSetter;
    }

    public ChannelListener.Setter<NioUdpChannel> getWriteSetter() {
        return this.writeSetter;
    }

    public ChannelListener.Setter<NioUdpChannel> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public boolean flush() throws IOException {
        return true;
    }

    @Override
    public boolean isOpen() {
        return this.datagramChannel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.callFlag.getAndSet(true)) {
            log.tracef("Closing %s", (Object)this);
            try {
                this.datagramChannel.close();
            }
            finally {
                this.cancelKeys();
                ChannelListeners.invokeChannelListener(this, this.closeSetter.get());
            }
        }
    }

    private void cancelKeys() {
        if (this.readHandle != null) {
            this.readHandle.cancelKey();
        }
        if (this.writeHandle != null) {
            this.writeHandle.cancelKey();
        }
    }

    @Override
    public void suspendReads() {
        NioHandle<NioUdpChannel> handle = this.readHandle;
        if (handle != null) {
            try {
                handle.suspend();
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
        }
    }

    @Override
    public void suspendWrites() {
        NioHandle<NioUdpChannel> handle = this.writeHandle;
        if (handle != null) {
            try {
                handle.suspend();
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
        }
    }

    @Override
    public void resumeReads() {
        NioHandle<NioUdpChannel> handle = this.readHandle;
        if (handle == null) {
            throw new IllegalArgumentException("No read thread configured");
        }
        try {
            handle.resume(1);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    @Override
    public void resumeWrites() {
        NioHandle<NioUdpChannel> handle = this.writeHandle;
        if (handle == null) {
            throw new IllegalArgumentException("No read thread configured");
        }
        try {
            handle.resume(4);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    @Override
    public boolean isReadResumed() {
        NioHandle<NioUdpChannel> handle = this.readHandle;
        return handle != null && handle.isResumed(1);
    }

    @Override
    public boolean isWriteResumed() {
        NioHandle<NioUdpChannel> handle = this.writeHandle;
        return handle != null && handle.isResumed(4);
    }

    @Override
    public void wakeupReads() {
        this.resumeReads();
        NioHandle<NioUdpChannel> readHandle = this.readHandle;
        if (readHandle == null) {
            throw new IllegalArgumentException("No thread configured");
        }
        readHandle.execute();
    }

    @Override
    public void wakeupWrites() {
        this.resumeWrites();
        NioHandle<NioUdpChannel> writeHandle = this.writeHandle;
        if (writeHandle == null) {
            throw new IllegalArgumentException("No thread configured");
        }
        writeHandle.execute();
    }

    @Override
    public void shutdownReads() throws IOException {
        throw new UnsupportedOperationException("Shutdown reads");
    }

    @Override
    public void shutdownWrites() throws IOException {
        throw new UnsupportedOperationException("Shutdown writes");
    }

    @Override
    public void awaitReadable() throws IOException {
        SelectorUtils.await(this.worker.getXnio(), this.datagramChannel, 1);
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.worker.getXnio(), this.datagramChannel, 1, time, timeUnit);
    }

    @Override
    public XnioExecutor getReadThread() {
        NioHandle<NioUdpChannel> handle = this.readHandle;
        return handle == null ? null : handle.getWorkerThread();
    }

    @Override
    public void awaitWritable() throws IOException {
        SelectorUtils.await(this.worker.getXnio(), this.datagramChannel, 4);
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.worker.getXnio(), this.datagramChannel, 4, time, timeUnit);
    }

    @Override
    public XnioExecutor getWriteThread() {
        NioHandle<NioUdpChannel> handle = this.writeHandle;
        return handle == null ? null : handle.getWorkerThread();
    }

    @Override
    public MulticastMessageChannel.Key join(InetAddress group, NetworkInterface iface) throws IOException {
        return new NioKey(this.datagramChannel.join(group, iface));
    }

    @Override
    public MulticastMessageChannel.Key join(InetAddress group, NetworkInterface iface, InetAddress source) throws IOException {
        return new NioKey(this.datagramChannel.join(group, iface, source));
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return OPTIONS.contains(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws UnsupportedOptionException, IOException {
        DatagramChannel channel = this.datagramChannel;
        DatagramSocket socket = channel.socket();
        if (option == Options.RECEIVE_BUFFER) {
            return option.cast(socket.getReceiveBufferSize());
        }
        if (option == Options.SEND_BUFFER) {
            return option.cast(socket.getSendBufferSize());
        }
        if (option == Options.BROADCAST) {
            return option.cast(socket.getBroadcast());
        }
        if (option == Options.IP_TRAFFIC_CLASS) {
            return option.cast(socket.getTrafficClass());
        }
        if (NioXnio.NIO2) {
            if (option == Options.MULTICAST_TTL) {
                return option.cast(channel.getOption(StandardSocketOptions.IP_MULTICAST_TTL));
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        void var5_10;
        DatagramChannel channel = this.datagramChannel;
        DatagramSocket socket = channel.socket();
        if (option == Options.RECEIVE_BUFFER) {
            Integer n = socket.getReceiveBufferSize();
            socket.setReceiveBufferSize((Integer)value);
            return option.cast(var5_10);
        } else if (option == Options.SEND_BUFFER) {
            Integer n = socket.getSendBufferSize();
            socket.setSendBufferSize((Integer)value);
            return option.cast(var5_10);
        } else if (option == Options.IP_TRAFFIC_CLASS) {
            Integer n = socket.getTrafficClass();
            socket.setTrafficClass((Integer)value);
            return option.cast(var5_10);
        } else if (option == Options.BROADCAST) {
            Boolean bl = socket.getBroadcast();
            socket.setBroadcast((Boolean)value);
            return option.cast(var5_10);
        } else {
            if (!NioXnio.NIO2) return null;
            if (option != Options.MULTICAST_TTL) return null;
            T t = option.cast(channel.getOption(StandardSocketOptions.IP_MULTICAST_TTL));
            channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Integer)value);
        }
        return option.cast(var5_10);
    }

    public String toString() {
        return String.format("UDP socket channel (NIO) <%h>", this);
    }

    @Override
    public XnioWorker getWorker() {
        return this.worker;
    }

    class NioKey
    implements MulticastMessageChannel.Key {
        private final MembershipKey key;

        NioKey(MembershipKey key) {
            this.key = key;
        }

        @Override
        public MulticastMessageChannel.Key block(InetAddress source) throws IOException, UnsupportedOperationException, IllegalStateException, IllegalArgumentException {
            this.key.block(source);
            return this;
        }

        @Override
        public MulticastMessageChannel.Key unblock(InetAddress source) throws IOException, IllegalStateException, UnsupportedOperationException {
            this.key.unblock(source);
            return this;
        }

        @Override
        public MulticastMessageChannel getChannel() {
            return NioUdpChannel.this;
        }

        @Override
        public InetAddress getGroup() {
            return this.key.group();
        }

        @Override
        public NetworkInterface getNetworkInterface() {
            return this.key.networkInterface();
        }

        @Override
        public InetAddress getSourceAddress() {
            return this.key.sourceAddress();
        }

        @Override
        public boolean isOpen() {
            return this.key.isValid();
        }

        @Override
        public void close() throws IOException {
            this.key.drop();
        }
    }
}

