/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dm;

import com.cisco.dcbu.dm.DMPanel;
import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.dm.EditFormTable;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.GraphTable;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.MnemonicTabbedPane;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.util.Array;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class DMDialog
extends JDialog
implements SnmpCallbackIf,
ChangeListener {
    public static boolean _IsJava1_4 = System.getProperty("java.version").startsWith("1.4");
    static final int INSETS = 2;
    public static Insets _Insets = new Insets(6, 6, 2, 6);
    public static Insets _BottomInsets = new Insets(4, 0, 0, 0);
    static DateFormat _TimeFormat = new SimpleDateFormat("HH:mm:ss");
    static Date _cachedTime = new Date();
    protected SnmpPeer _peer;
    protected int[] _index;
    boolean _isMultiple;
    boolean _isSpecificInstance;
    public int[][] _multipleIndeces;
    JPanel _main;
    JPanel _bottom;
    protected MnemonicTabbedPane _tab;
    static int _TabHeight;
    JLabel _status;
    Array _tabPanels = new Array();
    Array _tooltips = new Array();
    DMPanel _currentPanel;
    int _minTabWidth;
    int[][] _enableTabs;
    int[] _cfsStatus;
    String _dialogTitle;

    public DMDialog(JFrame parent, SnmpPeer peer) {
        super(parent);
        this._peer = peer;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DMDialog.this.dispose();
            }
        });
    }

    public void setDialogTitle(String title) {
        this._dialogTitle = title;
    }

    public void setBusy(boolean busy) {
        Util.setBusy(busy, this.getRootPane());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (this._currentPanel != null) {
            this._currentPanel.pause();
        }
        for (int i = 0; i < this._tabPanels.size(); ++i) {
            DMPanel p = (DMPanel)this._tabPanels.elementAt(i);
            DMDialog dMDialog = p._parent;
            synchronized (dMDialog) {
                p.dispose();
                p._parent = null;
                continue;
            }
        }
        this._tabPanels.clear();
        super.dispose();
        this._tab = null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.gc();
            }
        });
    }

    public void setAttr(DMPanel ep, String title, String[] prefixes, String help, String tooltip) {
        this.setAttr(ep, title, prefixes, help);
        this._tooltips.addElement(tooltip);
    }

    public void setAttr(DMPanel ep, String title, String[] prefixes) {
        this.setAttr(ep, title, prefixes, prefixes[0]);
    }

    public void setAttr(DMPanel ep, String title, String[] prefixes, String help) {
        this._tabPanels.addElement(ep);
        ep._title = title;
        ep._prefixes = prefixes;
        ep._help = help;
        ep._parent = this;
        this._enableTabs = null;
        this._tooltips.addElement(null);
    }

    public void setAttr(DMPanel ep, String title, String[] prefixes, String help, int[][] enableTabs) {
        this.setAttr(ep, title, prefixes, help);
        this._enableTabs = enableTabs;
    }

    protected void setIndex(int[] index) {
        this._index = index;
        for (int i = 0; i < this._tabPanels.size(); ++i) {
            ((DMPanel)this._tabPanels.elementAt(i)).setIndex(index);
        }
    }

    public int[] getIndex() {
        return this._index;
    }

    protected void setMultipleIndeces(int[][] indeces) {
        this._multipleIndeces = indeces;
        this.setIsMultiple(true);
    }

    public void setIsMultiple(boolean isMultiple) {
        this._isMultiple = isMultiple;
    }

    public void setIsSpecificInstance(boolean isSpecificInstance) {
        this._isSpecificInstance = isSpecificInstance;
    }

    public void setParentTable(DMPanel panel) {
        for (int i = 0; i < this._tabPanels.size(); ++i) {
            this.getPanel(0).setParentPanel(panel);
        }
    }

    public JProgressBar createProgressBar() {
        JProgressBar pb = new JProgressBar();
        pb.setIndeterminate(true);
        this._bottom.add(pb);
        return pb;
    }

    public void removeProgressBar(JProgressBar pb) {
        this._bottom.remove(pb);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            if (this._main == null) {
                this._main = new JPanel(new BorderLayout());
                this._main.setBorder(new EmptyBorder(_Insets));
                this._bottom = new JPanel(new BorderLayout());
                this._status = new JLabel(" ");
                this._status.setFont(ChangedCellRenderer.getNormalFont());
                this._status.setBorder(null);
                this._bottom.setBorder(new EmptyBorder(_BottomInsets));
                this._bottom.add((Component)this._status, "South");
                this._main.add((Component)this._bottom, "South");
                this.getContentPane().add(this._main);
                if (this._tabPanels.size() == 1) {
                    this._currentPanel = (DMPanel)this._tabPanels.elementAt(0);
                    if (!this._currentPanel.isBuilt()) {
                        try {
                            this._currentPanel.build();
                        }
                        catch (Exception ex) {
                            Util.errorMessage((Component)DeviceManager.getInstance(), ex);
                            if (SnmpSession.isTrace()) {
                                ex.printStackTrace();
                            }
                            this._currentPanel.closeAction();
                            return;
                        }
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    this._main.add((Component)this._currentPanel._container, "Center");
                    this._bottom.add((Component)this._currentPanel._buttonPanel, "North");
                    this._currentPanel.get();
                    this.pack();
                    if (this._currentPanel instanceof EditForm && !this._isMultiple) {
                        this.setResizable(false);
                    }
                } else {
                    int i;
                    this._tab = new MnemonicTabbedPane();
                    this._tab.setTabLayoutPolicy(1);
                    boolean isMetal = UIManager.getLookAndFeel().getClass() == MetalLookAndFeel.class;
                    int tabMargin = _IsJava1_4 && isMetal ? 23 : 13;
                    FontMetrics fm = this._tab.getFontMetrics(this._tab.getFont());
                    for (int i2 = 0; i2 < this._tabPanels.size(); ++i2) {
                        DMPanel p = (DMPanel)this._tabPanels.elementAt(i2);
                        if (this._isMultiple && p._noMultiple) continue;
                        this._minTabWidth += fm.stringWidth(p.toString()) + tabMargin;
                    }
                    Dimension d = this._tab.getPreferredSize();
                    d.width = this._minTabWidth;
                    this._tab.setPreferredSize(d);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    this._main.add((Component)((Object)this._tab), "Center");
                    for (i = 0; i < this._tabPanels.size(); ++i) {
                        DMPanel p = (DMPanel)this._tabPanels.elementAt(i);
                        if (this._isMultiple && p._noMultiple) continue;
                        String title = p._title;
                        int mnemonic = title.lastIndexOf(38);
                        if (mnemonic == -1) {
                            mnemonic = 0;
                        } else {
                            title = Util.removeMnemonic(title, mnemonic);
                        }
                        String tooltip = i > this._tooltips.size() ? null : (String)this._tooltips.elementAt(i);
                        this._tab.addTab(title, null, p._container, tooltip);
                        this._tab.setMnemonicAt(i, title.charAt(mnemonic));
                    }
                    if (_TabHeight == 0) {
                        _TabHeight = this._tab.getBoundsAt((int)0).height;
                        _TabHeight += isMetal ? 10 : 4;
                    }
                    if (!this._isMultiple) {
                        this.evaluateUse();
                    }
                    this._tab.addChangeListener(this);
                    this.stateChanged(new ChangeEvent((Object)this._tab));
                    if (this._enableTabs != null) {
                        for (i = 0; i < this._enableTabs[0].length; ++i) {
                            this._tab.setEnabledAt(this._enableTabs[0][i], this._enableTabs[1][i] == 1);
                        }
                    }
                }
            }
            if (_IsJava1_4) {
                int y;
                Dimension d = this.getPreferredSize();
                Rectangle r = DeviceManager.getInstance().getBounds();
                int x = r.x + (r.width - d.width) / 2;
                int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
                int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
                if (x + d.width > screenWidth) {
                    x = screenWidth - d.width;
                }
                if (x < 0) {
                    x = 0;
                }
                if ((y = r.y + (r.height - d.height) / 2) + d.height > screenHeight) {
                    y = screenHeight - d.height;
                }
                if (y < 0) {
                    y = 0;
                }
                this.setLocation(x, y);
            }
        }
        super.setVisible(visible);
    }

    protected void evaluateUse() {
        SnmpPDU pdu = null;
        for (int i = 1; i < this._tabPanels.size(); ++i) {
            DMPanel p = (DMPanel)this._tabPanels.elementAt(i);
            if (this._isMultiple && p._noMultiple || p._useVar == null) continue;
            if (pdu == null) {
                pdu = new SnmpPDU(-96, new VarBindList());
            }
            pdu.addNull(new SnmpOID(MibNode.get(p._useVar).getOid(), p.getUseIndex()));
        }
        if (pdu == null) {
            this.addAllCategories();
        } else {
            try {
                this.sendEvaluatePDU(pdu);
            }
            catch (SnmpException ex) {
                DefaultLogger._DefLogger.debug((Object)(pdu.getHostAddress() + ": " + ex));
            }
        }
    }

    protected void sendEvaluatePDU(SnmpPDU pdu) throws SnmpException {
        this._peer.send(pdu, this);
    }

    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        if (timedOut) {
            DefaultLogger._DefLogger.debug((Object)(pdu.getHostAddress() + ": timeout"));
            this.addAllCategories();
        } else {
            int i;
            int[] results = new int[pdu.getVariables().size()];
            for (i = 0; i < pdu.getVariables().size(); ++i) {
                SnmpVar v = pdu.getVar(i);
                if (v.getType() == 5) {
                    results[i] = -1;
                    continue;
                }
                if (v.getType() != 2) continue;
                results[i] = ((SnmpInt)v).getValue();
            }
            int j = 1;
            int r = 0;
            for (i = 1; i < this._tabPanels.size(); ++i) {
                DMPanel p = (DMPanel)this._tabPanels.elementAt(i);
                if (this._isMultiple && p._noMultiple) continue;
                if (p._useVar == null) {
                    if (p.isEnabled()) {
                        this._tab.setEnabledAt(j, true);
                    }
                } else {
                    switch (p._useOp) {
                        case 0: {
                            this._tab.setEnabledAt(i, results[r] == p._useValue);
                            break;
                        }
                        case 1: {
                            this._tab.setEnabledAt(i, results[r] != p._useValue);
                            break;
                        }
                        case 2: {
                            this._tab.setEnabledAt(i, results[r] < p._useValue);
                            break;
                        }
                        default: {
                            this._tab.setEnabledAt(i, true);
                        }
                    }
                    ++r;
                }
                ++j;
            }
            if (!this._tab.isEnabledAt(this._tab.getSelectedIndex())) {
                this._tab.setSelectedIndex(0);
            } else if (this._currentPanel != null) {
                try {
                    this._currentPanel.checkAvailability();
                }
                catch (SnmpException ex) {
                    Util.errorMessage((Component)this, ex.getMessage());
                    this._tab.setSelectedIndex(0);
                }
            }
        }
    }

    void addAllCategories() {
        int j = 1;
        for (int i = 1; i < this._tabPanels.size(); ++i) {
            DMPanel p = (DMPanel)this._tabPanels.elementAt(i);
            if (this._isMultiple && p._noMultiple) continue;
            if (p.isEnabled()) {
                this._tab.setEnabledAt(j, true);
            }
            ++j;
        }
    }

    public void get() {
        this._currentPanel.get();
    }

    public String getCurrentPanelTitle() {
        return this._currentPanel._title;
    }

    public DMPanel getCurrentPanel() {
        return this._currentPanel;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        MnemonicTabbedPane tab = (MnemonicTabbedPane)((Object)e.getSource());
        DMPanel dmPanel = this.getPanelFromComponent(this._tab.getSelectedComponent());
        if (dmPanel == null) {
            DefaultLogger._DefLogger.debug((Object)"stateChanged() dmPanel null");
            return;
        }
        if (!this._isMultiple) {
            try {
                dmPanel.checkAvailability();
            }
            catch (SnmpException ex) {
                Util.errorMessage((Component)this, ex.getMessage());
                if (this._currentPanel == null) {
                    Runnable doClose = new Runnable(){

                        @Override
                        public void run() {
                            DMDialog.this.dispatchEvent(new WindowEvent(SwingUtilities.windowForComponent((Component)((Object)DMDialog.this._tab)), 201));
                        }
                    };
                    SwingUtilities.invokeLater(doClose);
                } else {
                    tab.setSelectedComponent(this._currentPanel._container);
                }
                return;
            }
        }
        if (this._currentPanel != null) {
            this._currentPanel.pause();
            this._main.remove(this._currentPanel._container);
            this._bottom.remove(this._currentPanel._buttonPanel);
        }
        this._status.setText(" ");
        boolean needPack = true;
        if (!dmPanel.isBuilt()) {
            try {
                dmPanel.build();
                dmPanel.get();
            }
            catch (SnmpException ex) {
                Util.errorMessage((Component)this, ex.getMessage());
                if (this._currentPanel != null) {
                    tab.setSelectedComponent(this._currentPanel._container);
                } else {
                    this._tab.setPreferredSize(new Dimension(200, 200));
                    this.invalidate();
                    this.pack();
                }
                return;
            }
            if (dmPanel instanceof EditTable) {
                needPack = false;
            }
        } else {
            dmPanel.resume();
            if (!(dmPanel instanceof GraphTable) && !dmPanel._needsRefresh) {
                _cachedTime.setTime(dmPanel._timeStamp);
                this.showStatus("Data retrieved at " + _TimeFormat.format(_cachedTime), 1);
            }
        }
        this._bottom.add((Component)dmPanel._buttonPanel, "North");
        this._currentPanel = dmPanel;
        if (needPack) {
            this.repack(dmPanel);
        }
        this.repaint();
    }

    public final void showStatus(String msg, int level) {
        if (level == 1) {
            this._status.setForeground(Color.black);
        } else {
            this._status.setForeground(Color.red);
        }
        this._status.setText(msg);
    }

    public void repack(DMPanel p) {
        if (this._tab != null && !this._tab.isEnabledAt(this._tab.indexOfComponent(p._container))) {
            return;
        }
        Dimension d = p instanceof EditForm && ((EditForm)p)._size != null ? new Dimension(((EditForm)p)._size) : new Dimension(p._container.getPreferredSize());
        Dimension db = p._buttonPanel.getPreferredSize();
        if (db.width > d.width) {
            d.width = db.width + 8;
        }
        d.width += 2;
        if (p instanceof EditForm) {
            d.width += 20;
        }
        if (p instanceof EditFormTable) {
            Dimension fp = p._formPanel.getPreferredSize();
            if (fp.width > d.width) {
                d.width = fp.width + 4;
            }
        }
        if (this._tab != null) {
            if (d.width < this._minTabWidth) {
                d.width = this._minTabWidth;
            }
            d.height += _TabHeight;
            this._tab.setPreferredSize(d);
        } else {
            ((JComponent)p._container).setPreferredSize(d);
        }
        this.validate();
        this.invalidate();
        this.pack();
    }

    DMPanel getPanelFromComponent(Component c) {
        for (int i = 0; i < this._tabPanels.size(); ++i) {
            DMPanel p = (DMPanel)this._tabPanels.elementAt(i);
            if (p._container != c) continue;
            return p;
        }
        return null;
    }

    public DMPanel getPanel(int i) {
        if (this._tabPanels == null || this._tabPanels.size() < i) {
            return null;
        }
        return (DMPanel)this._tabPanels.elementAt(i);
    }

    public int getTabFromTitle(String title) {
        for (int i = 0; i < this._tabPanels.size(); ++i) {
            DMPanel p = (DMPanel)this._tabPanels.elementAt(i);
            if (!p._title.equals(title)) continue;
            return i;
        }
        return -1;
    }

    public void setTab(int index) {
        if (this._tab != null) {
            this._tab.setSelectedIndex(index);
        }
    }

    public int getTabCount() {
        return this._tab.getTabCount();
    }

    public void setTabEnabled(int index, boolean enabled) {
        if (this._tab != null && this._tabPanels.size() > index) {
            this._tab.setEnabledAt(index, enabled);
        }
    }

    public void setVisibleButton4AllTabs(String button, boolean visible) {
        for (int i = 0; i < this._tabPanels.size(); ++i) {
            DMPanel p = (DMPanel)this._tabPanels.elementAt(i);
            AbstractButton btn = p.getButton(button);
            if (btn == null) continue;
            btn.setVisible(visible);
        }
    }

    public void setParentTable(EditTable table) {
        for (int i = 0; i < this._tabPanels.size(); ++i) {
            DMPanel p = (DMPanel)this._tabPanels.elementAt(i);
            p.setParentTable(table);
        }
    }

    @Override
    public void setPreferredSize(Dimension d) {
        if (this._tab != null) {
            this._tab.setPreferredSize(d);
        } else {
            ((JComponent)this._currentPanel._container).setPreferredSize(d);
        }
    }
}

