/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dm;

import com.cisco.dcbu.dm.DMDialog;
import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.PhysicalStatus;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.dialogs.CfsStatusCache;
import com.cisco.dcbu.lib.jnm.IndexCellRenderer;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.mds.Panel;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.PerspectiveIf;
import com.cisco.dcbu.lib.ui.PerspectiveManager;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public abstract class DMPanel
implements Panel {
    public static final int EQUALS = 0;
    public static final int NEQUALS = 1;
    public static final int GREATER = 2;
    static final int APPLY = 0;
    public static final int INSERT = 1;
    public static final int DELETE = 2;
    static final int COPY = 3;
    static final int PASTE = 4;
    static final int UNDO = 5;
    static final int SAVE = 6;
    static final int PRINT = 7;
    static final int REFRESH = 8;
    static final int HELP = 9;
    static final int CHART = 10;
    static final String[][] _ButtonAttr = new String[][]{{"Check", "Apply Changes", "A", "Apply"}, {"NewRow", "Insert Row... Ins", "I", "Insert"}, {"DeleteRow", "Delete Row(s)  Del", "D", "Delete"}, {"Copy16", "Copy Ctrl+C", "c", null}, {"Paste16", "Paste  Ctrl+V", "P", null}, {"undo", "Undo Changes (In Bold) Ctrl+Z", "u", "Undo"}, {"Save16", "Export to File...", "E", null}, {"print16", "Print...", "p", null}, {"reload", "Refresh Values", "R", "Refresh"}, {"Help", "Show Help for this Feature", "H", null}, {"BarGraph", "Create Chart from Selected Cells", "B", "Bar"}};
    static final int CFS_ABORT = 5;
    static boolean _ShowIconLabel;
    static HashMap _MibVariableFormatMethods;
    static Class _MibVariableFormatClass;
    static HashMap _MibVariableSetMethods;
    static Class _MibVariableSetClass;
    protected static Insets _Insets;
    protected boolean _needsRefresh;
    protected AbstractButton[] _buttons;
    protected AbstractButton[] _custombuttons;
    protected String[] _vars;
    protected MibNode[] _mibNodes;
    protected Container _container;
    protected JPanel _buttonPanel;
    protected HeaderListener _headerListener;
    protected DMDialog _parent;
    protected boolean _isEditable;
    protected long _timeStamp;
    String _useVar;
    int _useValue;
    int _useOp;
    int[] _useIndex;
    String[] _prefixes;
    String _help;
    protected String _title;
    IndexCellRenderer _indexColumnRenderer;
    protected String[] _formVariables;
    protected JPanel _formPanel;
    protected boolean _isFormEditable;
    protected DMPanel _parentPanel;
    String[] _helpIndeces;
    public String[] _colHeaders;
    public int _colHeadersOffset;
    public int[][] _colSuperRanges;
    public String[] _colSuperGroup;
    public String[] _colGroup;
    public int[][] _colGroupRanges;
    public String[][] _multiLineHeaders;
    public int[] _multiLineRanges;
    protected String _indexTitle = "Id";
    boolean _indexVisible = true;
    public EditTable _parentTable;
    public int[][] _cfsFeatureIndex;
    public int[][] _cfsFeatureViewIndex;
    protected Set<String> _removeMibVarsSet = Collections.emptySet();
    protected Set<Integer> _removeMibVarIndicesSet = Collections.emptySet();
    boolean _findMode = false;
    protected String[] _indexTitles;
    protected IndexCellRenderer[] _indexColsRenderers;
    int[] _index;
    protected String[][] _warningVars;
    protected String[] _warningMsg;
    protected int[] _setCols;
    protected int[] _fetchCols;
    protected boolean _needRefreshTable = false;
    protected boolean _isValidateVbl = false;
    protected boolean _needFetchSetRows = true;
    protected boolean _isCFSSupport = true;
    protected boolean _noMultiple;

    public DMPanel(String[] vars) {
        this._vars = vars;
    }

    public void setRemoveMibVars(String[] mibVars) {
        if (mibVars == null) {
            this._removeMibVarsSet = Collections.emptySet();
        } else if (mibVars.length > 0) {
            if (this._removeMibVarsSet == Collections.EMPTY_SET) {
                this._removeMibVarsSet = new HashSet<String>();
            }
            for (String mibVar : mibVars) {
                this._removeMibVarsSet.add(mibVar);
            }
        }
    }

    public void addRemoveMibVars(String[] mibVars) {
        if (mibVars == null || this._removeMibVarsSet == null) {
            this._removeMibVarsSet = Collections.emptySet();
        }
        if (mibVars != null && mibVars.length > 0) {
            if (this._removeMibVarsSet == Collections.EMPTY_SET) {
                this._removeMibVarsSet = new HashSet<String>();
            }
            for (String mibVar : mibVars) {
                this._removeMibVarsSet.add(mibVar);
            }
        }
    }

    public void setRemoveMibVarIndices(int[] mibVarIndicesToRemove) {
        if (mibVarIndicesToRemove == null) {
            this._removeMibVarIndicesSet = Collections.emptySet();
        } else if (mibVarIndicesToRemove.length > 0) {
            if (this._removeMibVarIndicesSet == Collections.EMPTY_SET) {
                this._removeMibVarIndicesSet = new HashSet<Integer>();
            }
            for (int colIndex : mibVarIndicesToRemove) {
                this._removeMibVarIndicesSet.add(colIndex);
            }
        }
    }

    public final void setErrorStatus(String msg) {
        this._parent.showStatus(msg, 0);
    }

    public void setIndexTitle(String indexTitle) {
        this._indexTitle = indexTitle;
    }

    public void setIndexTitles(String[] indexTitles, IndexCellRenderer[] indexColsRenderers) {
        this._indexTitles = indexTitles;
        this._indexColsRenderers = indexColsRenderers;
        if (this._indexColsRenderers != null && this._indexColsRenderers.length > 1 && this._indexColsRenderers[0] != null) {
            this._indexColumnRenderer = this._indexColsRenderers[0];
        }
    }

    protected void separateIndexCol(Object[] newRow, int[] index) {
        for (int j = 1; j < this._indexTitles.length; ++j) {
            newRow[j] = new SnmpOID(index, j, 1);
        }
    }

    protected void setParentPanel(DMPanel panel) {
    }

    public final void setStatus(String msg) {
        this._parent._status.setText(msg);
    }

    public final String getStatus() {
        return this._parent._status.getText();
    }

    public SnmpPeer getPeer() {
        return this._parent._peer;
    }

    public DMDialog getParent() {
        return this._parent;
    }

    public String[] getPrefix() {
        return this._prefixes;
    }

    public HashMap getMibVariableSet() {
        return _MibVariableSetMethods;
    }

    public Class getMibVariableSetClass() {
        return _MibVariableSetClass;
    }

    protected void setIndex(int[] index) {
        this._index = index;
        if (this.isBuilt()) {
            this._needsRefresh = true;
        }
    }

    protected int[] getIndex() {
        return this._index;
    }

    protected int[] getMultipleIndex(int row) {
        return this._parent._multipleIndeces[row];
    }

    protected boolean isMultiple() {
        return this._parent._isMultiple;
    }

    public void setHelpIndeces(String[] helpIndeces) {
        this._helpIndeces = helpIndeces;
    }

    public void setFindMode(boolean findMode) {
        this._findMode = findMode;
    }

    public boolean getFindMode() {
        return this._findMode;
    }

    protected void fetchAllSetRows(Array cells, DmTableModel model) throws SnmpException {
        if (cells == null || cells.size() == 0 || !this._needFetchSetRows) {
            return;
        }
        Array<Cell> changedCells = new Array<Cell>();
        Array<Integer> changedRows = new Array<Integer>();
        VarBindList vbl = new VarBindList();
        int preRow = -1;
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            if (cell._row == preRow) continue;
            for (int j = 1; j < this._mibNodes.length; ++j) {
                int[] index = model.getIndex(cell._row, j);
                this.addVarfetchAllSetRows(vbl, index, cell._row, j);
                changedCells.addElement(new Cell(cell._row, j));
            }
            preRow = cell._row;
            changedRows.addElement(new Integer(cell._row));
        }
        SnmpPDU respPDU = null;
        if (vbl.size() > 0) {
            respPDU = this.sendFetchAllSetRowsPDU(vbl);
        }
        if (respPDU == null) {
            return;
        }
        this.updateFetchAllSetRowsPDU(model, changedCells, respPDU);
        this.postProcessFetchAllSetRowsPDU(changedRows, respPDU);
    }

    protected void updateFetchAllSetRowsPDU(DmTableModel model, Array changedCells, SnmpPDU respPDU) {
        for (int i = 0; i < changedCells.size() && i < respPDU.getVariables().size(); ++i) {
            SnmpVarBind vb = respPDU.getVariables().get(i);
            Cell fetchCell = (Cell)changedCells.elementAt(i);
            Object fetchObject = model.toCellEditTable(this._mibNodes[fetchCell._col], respPDU, vb, this._vars[fetchCell._col - 1], null, fetchCell._row, fetchCell._col);
            Object[] row = (Object[])model.getData().elementAt(fetchCell._row);
            row[fetchCell._col] = fetchObject;
            model.setNoSuchInstance(i, fetchCell._col - 1, false);
        }
    }

    protected void addVarfetchAllSetRows(VarBindList vbl, int[] index, int row, int col) {
        vbl.add(new SnmpVarBind(new SnmpOID(this._mibNodes[col].getOid(), index)));
    }

    protected SnmpPDU sendFetchAllSetRowsPDU(VarBindList vbl) throws SnmpException {
        return SnmpFetch.get(this.getPeer(), vbl);
    }

    protected void postProcessFetchAllSetRowsPDU(Array changedRows, SnmpPDU pdu) {
    }

    protected void fetchSetRows(Array cells, SnmpTableModel model, int[] setCols, int[] fetchCols) throws SnmpException {
        if (cells == null || cells.size() == 0 || setCols == null || setCols.length == 0 || fetchCols == null || fetchCols.length == 0) {
            return;
        }
        Array<Cell> changedCells = new Array<Cell>();
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            for (int j = 0; j < setCols.length; ++j) {
                if (cell._col != setCols[j]) continue;
                int[] index = model.getIndex(cell._row);
                for (int k = 0; k < fetchCols.length; ++k) {
                    pdu.addVar(new SnmpOID(this._mibNodes[fetchCols[k]].getOid(), index));
                    changedCells.addElement(new Cell(cell._row, fetchCols[k]));
                }
            }
        }
        SnmpPDU respPDU = null;
        if (pdu.getVariables().size() > 0) {
            respPDU = this.getPeer().send(pdu);
        }
        if (respPDU == null) {
            return;
        }
        for (int i = 0; i < respPDU.getVariables().size(); ++i) {
            SnmpVarBind vb = respPDU.getVariables().get(i);
            Cell fetchCell = (Cell)changedCells.elementAt(i);
            Object fetchObject = model.toCell(this._mibNodes[fetchCell._col], vb.getVar(), this._vars[fetchCell._col - 1], fetchCell._col - 1);
            Object[] row = (Object[])model.getData().elementAt(fetchCell._row);
            row[fetchCell._col] = fetchObject;
        }
    }

    protected boolean validateChanges(Array cells, SnmpTableModel model, String[][] warningVars, String[] message, int offset) {
        if (this._warningVars == null || this._warningVars.length == 0 || cells == null || cells.size() == 0) {
            return true;
        }
        boolean needWarning = false;
        StringBuffer warnMsg = new StringBuffer();
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            for (int j = 0; j < this._warningVars.length; ++j) {
                if (!this.isWarnVar(this._vars[cell._col + offset], model.getValueAt(cell._row, cell._col), warningVars[j])) continue;
                if (warnMsg.toString().length() > 0) {
                    boolean msgExist;
                    String msg = message[j];
                    int trimOffset = message[j].indexOf("Continue?");
                    if (trimOffset != -1) {
                        msg = message[j].substring(0, trimOffset);
                    }
                    boolean bl = msgExist = warnMsg.indexOf(msg) != -1;
                    if (msgExist) continue;
                    trimOffset = warnMsg.indexOf("Continue?");
                    if (trimOffset != -1) {
                        warnMsg = new StringBuffer(warnMsg.substring(0, trimOffset));
                    } else {
                        warnMsg.append('\n');
                    }
                    warnMsg.append(message[j]);
                    continue;
                }
                warnMsg.append(message[j]);
                needWarning = true;
            }
        }
        if (needWarning) {
            return this.isIgnoreWarning(warnMsg.toString());
        }
        return true;
    }

    protected boolean isIgnoreWarning(String message) {
        return JOptionPane.showOptionDialog(this.getParent(), message, this._parent.getTitle(), 0, 2, null, new String[]{"Yes", "No"}, "No") == 0;
    }

    protected boolean isWarnVar(String mibVar, Object value, String[] warningVars) {
        for (int i = 0; i < warningVars.length; ++i) {
            if (!mibVar.equals(warningVars[i])) continue;
            return this.checkWarnVar(mibVar, value, warningVars);
        }
        return false;
    }

    protected boolean checkWarnVar(String mibVar, Object value, String[] warningVars) {
        return true;
    }

    public void setCheckForWarning(String[] mibVars, String message) {
        this._warningVars = new String[][]{mibVars};
        this._warningMsg = new String[]{message};
    }

    public void setCheckForWarning(String[][] mibVars, String[] message) {
        this._warningVars = mibVars;
        this._warningMsg = message;
    }

    public void setFetchVars(int[] setCols, int[] fetchCols) {
        this._setCols = setCols;
        this._fetchCols = fetchCols;
    }

    public void setRefreshTable(boolean needRefreshTable) {
        this._needRefreshTable = needRefreshTable;
    }

    public void setValidateVbl(boolean isValidateVbl) {
        this._isValidateVbl = isValidateVbl;
    }

    public void setFetchSetRows(boolean needFetchSetRows) {
        this._needFetchSetRows = needFetchSetRows;
    }

    public void setCFSSupport(boolean isCFSSupport) {
        this._isCFSSupport = isCFSSupport;
    }

    public int[] getCFSStatus() {
        if (this._cfsFeatureIndex == null) {
            return null;
        }
        int[] cfsStatus = new int[this._cfsFeatureIndex.length];
        for (int i = 0; i < this._cfsFeatureIndex.length; ++i) {
            cfsStatus[i] = CfsStatusCache.getInstance().getCFSStatus(this._cfsFeatureIndex[i]);
        }
        return cfsStatus;
    }

    public void setCFSFeature(int[][] index) {
        this._cfsFeatureIndex = index;
        this._cfsFeatureViewIndex = new int[index.length][];
        System.arraycopy(index, 0, this._cfsFeatureViewIndex, 0, index.length);
    }

    public void setCFSFeatureView(int[][] index) {
        this._cfsFeatureViewIndex = index;
    }

    public void setCFSButton() {
        this.setCFSButton(this.isCFSEnabled(false));
    }

    public void setCFSButton(boolean[] enable) {
        boolean isBtnEnable = false;
        for (int i = 0; i < enable.length; ++i) {
            if (!enable[i]) continue;
            isBtnEnable = true;
        }
        AbstractButton b = this.getButton("FabricWide");
        if (b != null) {
            b.setVisible(isBtnEnable);
        }
        if (this instanceof EditForm) {
            this._parent.repack(this);
            this._parent.repaint();
        }
    }

    public boolean[] isCFSEnabled(boolean isRefresh) {
        boolean isPromptErr = false;
        if (this._cfsFeatureIndex == null) {
            return new boolean[]{false};
        }
        if (isRefresh) {
            DmSystem.isCFSEnabled(DeviceManager.getInstance(), this.getPeer(), this._cfsFeatureIndex, null, !this._isCFSSupport);
        }
        boolean[] isEnabled = new boolean[this._cfsFeatureIndex.length];
        if (this.getCFSStatus() != null) {
            for (int i = 0; i < this._cfsFeatureIndex.length; ++i) {
                if (this.getCFSStatus().length > i && (this.getCFSStatus()[i] == 1 || this.getCFSStatus()[i] == 2) && this._cfsFeatureIndex[i] != null) {
                    isEnabled[i] = true;
                    if (this._isCFSSupport) continue;
                    isPromptErr = true;
                    break;
                }
                isEnabled[i] = false;
            }
        }
        if (isPromptErr) {
            Util.errorMessage((Component)DeviceManager.getInstance(), "You can't configure this feature if CFS is enabled. Please disable CFS first.");
            this.closeAction();
        }
        return isEnabled;
    }

    public void setCFSPending(SnmpPeer peer) throws SnmpException {
        this.setCFSView(peer, 1, 2);
    }

    public void setCFSRunning(SnmpPeer peer) throws SnmpException {
        this.setCFSView(peer, 2, 1);
    }

    public void setCFSView(SnmpPeer peer, int fromView, int toView) throws SnmpException {
        int i;
        SnmpPDU cfsPDU = new SnmpPDU(-93, new VarBindList());
        if (this._cfsFeatureViewIndex != null && this._cfsFeatureIndex != null) {
            for (i = 0; i < this._cfsFeatureViewIndex.length; ++i) {
                if (this.getCFSStatus().length <= i || this.getCFSStatus()[i] != fromView || this._cfsFeatureViewIndex == null || this._cfsFeatureViewIndex[i] == null) continue;
                cfsPDU.addVar(new SnmpOID(MibNode.get("cfsFeatureOpShowCfgOption").getOid(), this._cfsFeatureViewIndex[i]), new SnmpInt(toView));
            }
        }
        if (cfsPDU.getVariables().size() > 0) {
            cfsPDU.setIgnoreSetCount(true);
            peer.set(cfsPDU);
        }
        if (this._cfsFeatureViewIndex != null) {
            for (i = 0; i < this._cfsFeatureViewIndex.length; ++i) {
                if (this.getCFSStatus() == null || this.getCFSStatus().length <= i || this.getCFSStatus()[i] != fromView || this._cfsFeatureViewIndex == null || this._cfsFeatureViewIndex[i] == null) continue;
                CfsStatusCache.getInstance().setCFSStatus(this._cfsFeatureViewIndex[i], toView);
            }
        }
    }

    protected void cfsAction(int action) throws SnmpException {
        this.cfsAction(action, null);
    }

    protected void cfsAction(int action, int[] index) throws SnmpException {
        if (this._cfsFeatureIndex == null || this._cfsFeatureIndex.length <= 0) {
            return;
        }
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        SnmpPDU fetchPdu = new SnmpPDU(-96, new VarBindList());
        for (int i = 0; i < this._cfsFeatureIndex.length; ++i) {
            if (index != null && this._cfsFeatureIndex[i] != null && !SnmpOID.equals(this._cfsFeatureIndex[i], index) || this._cfsFeatureIndex[i] == null || this.getCFSStatus().length <= i || this.getCFSStatus()[i] != 1 && this.getCFSStatus()[i] != 2) continue;
            pdu.addVar(new SnmpOID(MibNode.get("cfsFeatureOpAction").getOid(), this._cfsFeatureIndex[i]), new SnmpInt(action));
            fetchPdu.addNull(new SnmpOID(MibNode.get("cfsFeatureOpLastAction").getOid(), this._cfsFeatureIndex[i]));
            fetchPdu.addNull(new SnmpOID(MibNode.get("cfsFeatureOpLastActionResult").getOid(), this._cfsFeatureIndex[i]));
            fetchPdu.addNull(new SnmpOID(MibNode.get("cfsFeatureOpLastFailureReason").getOid(), this._cfsFeatureIndex[i]));
        }
        if (pdu.getVariables().size() > 0) {
            try {
                this.getPeer().set(pdu);
                this.setCFSRunning(this.getPeer());
            }
            catch (SnmpException ex) {
                this.setStatus("failed");
                throw new SnmpException(ex.getMessage());
            }
            pdu.reset();
            pdu.setCommand((byte)-93);
            String status = this.fetchStatus(fetchPdu, action);
            this.setStatus(status);
        }
        this.setCFSFeatureView(this._cfsFeatureIndex);
        if (action == 5) {
            this.get();
        }
    }

    private String fetchStatus(SnmpPDU pdu, int action) {
        try {
            SnmpPDU resp = this.getPeer().set(pdu);
            VarBindList vbl = resp.getVariables();
            int i = 0;
            if (i < vbl.size()) {
                int lastAction = vbl.intValue(i);
                if (lastAction != action) {
                    String currentAction = MibEnum.getLabel(MibVariableFormat._cfsFeatureOpLastAction, lastAction);
                    return "failed to varify status: currentAction is " + currentAction;
                }
                String status = (String)MibVariableFormat.cfsFeatureOpLastActionResultAdv(vbl.getVb(i).getVar(), vbl.getVb(i + 1).getVar(), vbl.stringValue(i + 2));
                if (status.startsWith("inProgress")) {
                    return "cfs operation in progress; check status later using Admin-> CFS to show all cfs status";
                }
                return status;
            }
        }
        catch (SnmpException ex) {
            return "failed to retrieve status";
        }
        return "failed";
    }

    public void setUse(String useVar, int useValue, int useOp) {
        this._useVar = useVar;
        this._useValue = useValue;
        this._useOp = useOp;
    }

    public void setUse(String useVar, int useValue, int useOp, int[] useIndex) {
        this._useVar = useVar;
        this._useValue = useValue;
        this._useOp = useOp;
        this._useIndex = useIndex;
    }

    public void setUse(String useVar, int useValue, int useOp, int useIndex) {
        int[] index = new int[]{useIndex};
        this.setUse(useVar, useValue, useOp, index);
    }

    public void setNoMultiple(boolean noMultiple) {
        this._noMultiple = noMultiple;
    }

    protected int[] getUseIndex() {
        if (this._useIndex != null) {
            return this._useIndex;
        }
        return this._index;
    }

    protected int[] getIndex(int varIndex) {
        return this._index;
    }

    protected boolean isEnabled() {
        return true;
    }

    protected void buildButtons() {
        if (this._buttonPanel == null) {
            this._buttonPanel = new JPanel(new FlowLayout(2, 6, 0));
        }
        Array buttons = this.getButtons();
        buttons.addElement("Help");
        buttons.addElement("Close");
        this._buttons = new AbstractButton[buttons.size()];
        for (int i = 0; i < buttons.size(); ++i) {
            Object o = buttons.elementAt(i);
            if (o instanceof String[]) {
                String[] attr = (String[])buttons.elementAt(i);
                this._buttons[i] = Util.createButton(this.getButtonPath(attr[0]), attr[1], attr[2], (ActionListener)((Object)this));
                if (_ShowIconLabel && attr[3] != null) {
                    this._buttons[i].setText(attr[3]);
                }
                this._formPanel.add(this._buttons[i]);
                continue;
            }
            if (o instanceof JButton) {
                this._buttons[i] = (JButton)o;
                this._buttons[i].addActionListener((ActionListener)((Object)this));
                this._buttonPanel.add(this._buttons[i]);
                continue;
            }
            this._buttons[i] = new JButton(o.toString());
            this._buttons[i].addActionListener((ActionListener)((Object)this));
            this._buttonPanel.add(this._buttons[i]);
        }
        this.setCFSButton();
    }

    protected String getButtonPath(String name) {
        return "icons/" + name + ".gif";
    }

    protected JButton[] createCustomButtons(String[] labels, ActionListener listener) {
        if (this._buttonPanel == null) {
            this._buttonPanel = new JPanel(new FlowLayout(1, 2, 5));
        }
        this._custombuttons = new AbstractButton[labels.length];
        JButton[] button = new JButton[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            button[i] = new JButton(labels[i]);
            button[i].addActionListener(listener);
            button[i].setEnabled(false);
            button[i].setMargin(_Insets);
            this._custombuttons[i] = button[i];
            this._buttonPanel.add(button[i]);
        }
        return button;
    }

    protected void enableButton(char index, boolean enabled) {
        AbstractButton b = this.getButton(index);
        if (b != null) {
            b.setEnabled(enabled);
        }
    }

    protected void enableButton(String index, boolean enabled) {
        AbstractButton b = this.getButton(index);
        if (b != null) {
            b.setEnabled(enabled);
        }
    }

    protected AbstractButton getButton(char index) {
        int i;
        if (this._buttons == null) {
            return null;
        }
        for (i = 0; i < this._buttons.length; ++i) {
            if (this._buttons[i].getActionCommand().charAt(0) != index) continue;
            return this._buttons[i];
        }
        if (this._custombuttons != null) {
            for (i = 0; i < this._custombuttons.length; ++i) {
                if (this._custombuttons[i].getActionCommand().charAt(0) != index) continue;
                return this._custombuttons[i];
            }
        }
        return null;
    }

    protected AbstractButton getButton(String index) {
        int i;
        if (this._buttons == null) {
            return null;
        }
        for (i = 0; i < this._buttons.length; ++i) {
            if (!this._buttons[i].getActionCommand().startsWith(index)) continue;
            return this._buttons[i];
        }
        if (this._custombuttons != null) {
            for (i = 0; i < this._custombuttons.length; ++i) {
                if (!this._custombuttons[i].getActionCommand().startsWith(index)) continue;
                return this._custombuttons[i];
            }
        }
        return null;
    }

    protected String trim(String mibVar) {
        return SnmpTableModel.trim(mibVar, this._prefixes);
    }

    protected int getVarIndex(String var) {
        for (int i = 0; i < this._vars.length; ++i) {
            if (!this._vars[i].equals(var)) continue;
            return i;
        }
        return -1;
    }

    protected int getVarIndex(String var, boolean skipPatition) {
        int j = 0;
        for (int i = 0; i < this._vars.length; ++i) {
            if (this._vars[i].equals(var)) {
                return j;
            }
            if (this._vars[i].equals("-")) continue;
            ++j;
        }
        return -1;
    }

    protected void helpAction() throws Exception {
        DeviceManager._Instance.helpDialog(this._help);
    }

    protected void closeAction() {
        this._parent.dispatchEvent(new WindowEvent(this._parent, 201));
    }

    protected void pause() {
    }

    protected void resume() {
        if (this._needsRefresh) {
            this.get();
        }
    }

    protected void checkAvailability() throws SnmpException {
    }

    protected boolean checkForWarning(String mibVar, String Message) throws SnmpException {
        return true;
    }

    protected boolean isEditable(MibNode mibNode) {
        return mibNode.getAccess() == 2 || mibNode.getAccess() == 5;
    }

    static void initProperties(String directory) throws IOException {
        Util.load(SnmpTableModel._Units, directory + "units.properties");
        Util.load(SnmpTableModel._Aliases, directory + "alias.properties");
    }

    static void initMibVariableFormat(Class c) {
        _MibVariableFormatClass = c;
        if (_MibVariableFormatMethods == null) {
            _MibVariableFormatMethods = new HashMap();
        } else {
            _MibVariableFormatMethods.clear();
        }
        try {
            if (_MibVariableFormatClass != null) {
                Method[] methods = _MibVariableFormatClass.getDeclaredMethods();
                for (int i = 0; i < methods.length; ++i) {
                    _MibVariableFormatMethods.put(methods[i].getName(), methods[i]);
                }
            }
        }
        catch (Exception ex) {
            DefaultLogger._DefLogger.debug((Object)("initMibVariableFormat: " + ex));
        }
        SnmpTableModel._MibVariableFormatMethods = _MibVariableFormatMethods;
        SnmpTableModel._MibVariableFormatClass = _MibVariableFormatClass;
        SnmpTableModel._SysUpTimeIf = PhysicalStatus.getInstance();
        SnmpTableModel._IfIndexIf = Discover.getRoot();
    }

    static void initMibVariableSet(Class c) {
        _MibVariableSetClass = c;
        if (_MibVariableSetMethods == null) {
            _MibVariableSetMethods = new HashMap();
        } else {
            _MibVariableSetMethods.clear();
        }
        try {
            if (_MibVariableSetClass != null) {
                Method[] methods = _MibVariableSetClass.getDeclaredMethods();
                for (int i = 0; i < methods.length; ++i) {
                    _MibVariableSetMethods.put(methods[i].getName(), methods[i]);
                }
            }
        }
        catch (Exception ex) {
            DefaultLogger._DefLogger.debug((Object)("initMibVariableSet: " + ex));
        }
        SnmpTableModel._MibVariableSetMethods = _MibVariableSetMethods;
        SnmpTableModel._MibVariableSetClass = _MibVariableSetClass;
    }

    protected final int getNumSelections() {
        return this._parent._multipleIndeces.length;
    }

    protected abstract boolean isBuilt();

    protected abstract void build() throws SnmpException;

    protected abstract void removeMibVars();

    public void panelGet() {
        this.get();
    }

    protected abstract void get();

    protected abstract Array getButtons();

    protected MibEnum[] getApplicableEnums(MibNode mibNode) {
        return mibNode.getEnums();
    }

    public void addRemoveColumnUsingPerspective() {
        PerspectiveIf view = PerspectiveManager.getInstance().getView();
        if (view != null) {
            String nodeName;
            String[] exclusiveList;
            int offset;
            String dialogTitle = this._parent == null ? "" : this._parent.getTitle();
            String tabTitle = this._title == null ? "" : this._title;
            int n = offset = dialogTitle == null ? -1 : dialogTitle.indexOf(" - ");
            if (offset != -1) {
                dialogTitle = dialogTitle.substring(offset + 3);
            }
            int n2 = offset = tabTitle != null ? tabTitle.indexOf(38) : -1;
            if (offset != -1) {
                tabTitle = tabTitle.substring(0, offset).concat(tabTitle.substring(offset + 1));
            }
            if ((exclusiveList = view.getExcludedList("column", nodeName = dialogTitle == null || dialogTitle.length() == 0 ? tabTitle : dialogTitle + "\\/" + tabTitle)) == null || exclusiveList.length == 0) {
                return;
            }
            String[] mibVars = new String[exclusiveList.length];
            for (int i = 0; i < exclusiveList.length; ++i) {
                offset = exclusiveList[i].lastIndexOf(47);
                mibVars[i] = exclusiveList[i];
                if (offset == 0) continue;
                mibVars[i] = exclusiveList[i].substring(offset + 1);
            }
            this.addRemoveMibVars(mibVars);
        }
    }

    public void removeColumnsUsingMibVars(JTable table) {
        this.addRemoveColumnUsingPerspective();
        if (table == null || this._removeMibVarsSet.isEmpty() && this._removeMibVarIndicesSet.isEmpty()) {
            return;
        }
        TreeSet<Integer> finalViewColIndicesToRemoveSet = this.createDescendingIntegerTreeSet();
        this.addViewColumnIndicesToSet(finalViewColIndicesToRemoveSet, table);
        this.removeTableColumns(finalViewColIndicesToRemoveSet, table);
    }

    private TreeSet<Integer> createDescendingIntegerTreeSet() {
        Comparator<Integer> intReverseComparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o2.compareTo(o1);
            }
        };
        return new TreeSet<Integer>(intReverseComparator);
    }

    private void addViewColumnIndicesToSet(Set<Integer> viewColIndicesSet, JTable table) {
        TableModel model;
        if (table != null && (model = table.getModel()) != null && model instanceof SnmpTableModel) {
            int viewColumnIndex;
            SnmpTableModel snmpTableModel = (SnmpTableModel)model;
            if (!this._removeMibVarsSet.isEmpty()) {
                for (String removeMibVar : this._removeMibVarsSet) {
                    viewColumnIndex = table.convertColumnIndexToView(snmpTableModel.getModelColumnIndex(removeMibVar));
                    if (viewColumnIndex < 0) continue;
                    viewColIndicesSet.add(viewColumnIndex);
                }
            }
            if (this._removeMibVarIndicesSet != null) {
                Iterator<Object> i$ = this._removeMibVarIndicesSet.iterator();
                while (i$.hasNext()) {
                    int mibVarIndex = (Integer)i$.next();
                    viewColumnIndex = table.convertColumnIndexToView(snmpTableModel.getModelColumnIndex(mibVarIndex));
                    if (viewColumnIndex < 0) continue;
                    viewColIndicesSet.add(viewColumnIndex);
                }
            }
        }
    }

    private void removeTableColumns(Set<Integer> viewColIndicesSet, JTable table) {
        for (int viewColumnIndexToRemove : viewColIndicesSet) {
            if (viewColumnIndexToRemove < 0 || viewColumnIndexToRemove >= table.getModel().getColumnCount()) continue;
            table.removeColumn(table.getColumnModel().getColumn(viewColumnIndexToRemove));
        }
    }

    public void dispose() {
    }

    public void setIndexRenderer(IndexCellRenderer renderer) {
        this._indexColumnRenderer = renderer;
    }

    public IndexCellRenderer getIndexRenderer() {
        return this._indexColumnRenderer;
    }

    public void setIndexVisible(boolean visible) {
        this._indexVisible = visible;
    }

    public void setColHeaderAttr(int offset, String[] headers, String[] group, int[][] ranges, int[] multiLineRanges, String[][] multiLineHeaders) {
        this._colHeadersOffset = offset;
        this._colHeaders = headers;
        this._colGroup = group;
        this._colGroupRanges = ranges;
        this._multiLineRanges = multiLineRanges;
        this._multiLineHeaders = multiLineHeaders;
    }

    public void setColHeaderAttr(int offset, String[] headers, String[] group, int[][] ranges) {
        this._colHeadersOffset = offset;
        this._colHeaders = headers;
        this._colGroup = group;
        this._colGroupRanges = ranges;
    }

    public void setColHeader(int offset, String[] headers) {
        this._colHeadersOffset = offset;
        this._colHeaders = headers;
    }

    public void setColHeaderAttr(int offset, String[] headers, String[] superGroup, int[][] superRanges, String[] group, int[][] ranges) {
        this._colHeadersOffset = offset;
        this._colHeaders = headers;
        this._colSuperGroup = superGroup;
        this._colSuperRanges = superRanges;
        this._colGroup = group;
        this._colGroupRanges = ranges;
    }

    public String toString() {
        return this._title;
    }

    public void setParentTable(EditTable table) {
        this._parentTable = table;
    }

    public EditTable getParentTable() {
        return this._parentTable;
    }

    @Override
    public void setChanged(JComponent c) {
        c.setFont(ChangedCellRenderer.getChangeFont());
        this.enableButton('A', true);
    }

    protected void clearChanged(JComponent c) {
        c.setFont(null);
    }

    public AbstractButton[] getBuiltButtons() {
        return this._buttons;
    }

    static {
        _Insets = new Insets(3, 1, 3, 1);
    }

    public class ChangedFieldListener
    implements ItemListener,
    KeyListener {
        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                DMPanel.this.setChanged((JComponent)e.getSource());
            } else if (e.getSource() instanceof JCheckBox) {
                DMPanel.this.setChanged((JComponent)e.getSource());
            } else {
                ((JComponent)e.getSource()).setFont(null);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            DMPanel.this.setChanged((JComponent)e.getSource());
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }
    }
}

