/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dm;

import com.cisco.dcbu.dm.GraphTable;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;

public class GraphBulkTable
extends GraphTable {
    public GraphBulkTable(String[] vars) {
        super(vars);
    }

    @Override
    protected int getNumObjects() {
        return this._data.size();
    }

    @Override
    protected int[] getMultipleIndex(int row) {
        SnmpOID oid = (SnmpOID)((Object[])this._data.elementAt(row))[0];
        return oid.getValue();
    }

    @Override
    protected Array buildData() {
        Array data;
        block5: {
            data = null;
            try {
                VarBindList vbl = new VarBindList();
                int oidLen = this._mibNodes[1].getOid().length;
                if (this._parent._isMultiple) {
                    data = new Array();
                    for (int i = 0; i < this._parent._multipleIndeces.length; ++i) {
                        vbl.add(new SnmpVarBind(new SnmpOID(this._mibNodes[1].getOid(), this._parent._multipleIndeces[i])));
                        SnmpPDU resp = SnmpFetch.getBulk(this.getPeer(), vbl);
                        this.buildDataVbl(data, resp.getVariables(), oidLen);
                        vbl.clear();
                    }
                } else {
                    vbl.add(new SnmpVarBind(new SnmpOID(this._mibNodes[1].getOid(), this.getIndex())));
                    SnmpPDU resp = SnmpFetch.getBulk(this.getPeer(), vbl);
                    vbl = resp.getVariables();
                    data = new Array(vbl.size());
                    this.buildDataVbl(data, vbl, oidLen);
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this.getParent(), ex);
                if (!SnmpSession.isTrace()) break block5;
                ex.printStackTrace();
            }
        }
        return data;
    }

    private void buildDataVbl(Array data, VarBindList vbl, int oidLen) {
        for (int i = 0; i < vbl.size(); ++i) {
            Object[] row = new Object[this._vars.length + 1];
            int[] oid = vbl.getVb(i).getOid().getValue();
            row[0] = new SnmpOID(oid, oidLen, oid.length - oidLen);
            data.addElement(row);
        }
    }
}

