/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dm;

import com.cisco.dcbu.dm.DM;
import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmPreferences;
import com.cisco.dcbu.dm.LastOpened;
import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.snmp.SnmpCrypto;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.JFork;
import com.cisco.dcbu.lib.util.JavaVersionCheck;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class OpenDialog
implements ActionListener,
KeyListener {
    public static final String[] SNMP_V3_PARAMS = new String[]{"MD5", "SHA", "MD5-DES", "MD5-AES", "SHA-DES", "SHA-AES"};
    public static final int V3_SEC_MD5 = 0;
    public static final int V3_SEC_SHA = 1;
    public static final int V3_SEC_MD5_DES = 2;
    public static final int V3_SEC_MD5_AES = 3;
    public static final int V3_SEC_SHA_DES = 4;
    public static final int V3_SEC_SHA_AES = 5;
    static String[] _Labels = new String[]{"Device Name:", "User Name:", "Password:", "Privacy Password:", null, null, null, "DCNM Server:"};
    static OpenDialog _Instance;
    JFrame _frame;
    JDialog _dialog;
    boolean _visible;
    JPanel _main;
    JLabel[] _labels;
    JComponent[] _value;
    JButton[] _buttons;
    private JLabel _status;
    JCheckBox _useSNMPv3;
    JCheckBox _openNewWindow;
    JCheckBox _useProxy;
    JComboBox _v3Protocol;
    JLabel _v3ProtocolLabel;
    JTextField _proxyAddr;
    private Properties _dmProperties;
    public static final String USER = "User";
    public static final String V3 = "UseV3";
    private static final String V3_PROTOCOL = "Auth-Privacy";
    public static final String SHOW_OPTIONS = "ShowOptions";
    private static final int DEVICE_NAME = 0;
    private static final int USER_NAME = 1;
    private static final int AUTH_PASSWD = 2;
    private static final int PRIV_PASSWD = 3;
    private static final int SNMP_PANEL = 4;
    private static final int OPEN_NEW_WINDOW = 5;
    private static final int USE_PROXY = 6;
    private static final int PROXY = 7;
    private boolean _showOptions;
    private boolean _firstShown = true;
    private char defaultEcho = (char)42;
    public static boolean FIRST_TIME_OPENING;
    public static boolean IsEnablePriavcyInput;

    public static OpenDialog getInstance(JFrame parent, boolean isEnablePrivcyInput) {
        IsEnablePriavcyInput = isEnablePrivcyInput;
        if (_Instance == null) {
            _Instance = new OpenDialog(parent);
        }
        if (parent != null && OpenDialog._Instance._dialog == null) {
            OpenDialog._Instance._dialog = new JDialog((Frame)parent, DeviceManager._AppName + " - Open");
            DialogUtil.addKeyListener(OpenDialog._Instance._dialog.getContentPane(), _Instance);
            OpenDialog._Instance._dialog.getRootPane().setDefaultButton(OpenDialog._Instance._buttons[0]);
            OpenDialog._Instance._frame.getContentPane().remove(OpenDialog._Instance._main);
            OpenDialog._Instance._dialog.getContentPane().add(OpenDialog._Instance._main);
            OpenDialog._Instance._dialog.pack();
            OpenDialog._Instance._dialog.setResizable(false);
            OpenDialog._Instance._dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    _Instance.closeAction();
                }
            });
            OpenDialog._Instance._frame = null;
        }
        return _Instance;
    }

    private OpenDialog(JFrame parent) {
        String userName;
        this._frame = new JFrame(DeviceManager._AppName + " - Open");
        this._value = new JComponent[_Labels.length];
        this._main = new JPanel(new BorderLayout());
        this._main.setBorder(DialogUtil._Margin);
        JComboBox cb = new JComboBox(this.buildMenu());
        cb.setEditable(true);
        this._value[0] = cb;
        this._dmProperties = OpenDialog.loadProperties(DmPreferences.PROPERTY_FILENAME);
        JPanel snmpPanel = new JPanel(new FlowLayout(0, 0, 0));
        String str = this._dmProperties.getProperty(V3);
        boolean useV3 = true;
        if (str != null && str.length() > 0) {
            useV3 = Boolean.valueOf(str);
        }
        if (System.getProperty("snmp.v3only") == null) {
            this._useSNMPv3 = new JCheckBox("SNMPv3", useV3);
            this._useSNMPv3.addActionListener(this);
            snmpPanel.add(this._useSNMPv3);
        } else {
            useV3 = true;
        }
        String string = userName = DM._UseV3 != useV3 ? "" : this._dmProperties.getProperty(USER);
        if ((userName == null || userName.length() == 0) && DM._UseV3 == useV3 && useV3) {
            userName = "admin";
        }
        if (!DM._UseV3) {
            useV3 = DM._UseV3;
        }
        this._value[1] = new JPasswordField(userName);
        this.defaultEcho = ((JPasswordField)this._value[1]).getEchoChar();
        ((JPasswordField)this._value[1]).setEchoChar('\u0000');
        this._value[2] = new JPasswordField();
        this._value[3] = new JPasswordField();
        this._value[3].setToolTipText("Optional for users with V3 authPriv (encryption) security");
        int v3Protocol = 0;
        str = this._dmProperties.getProperty(V3_PROTOCOL);
        if (str != null && str.length() > 0) {
            v3Protocol = Integer.parseInt(str);
        }
        this._v3ProtocolLabel = new JLabel("    Auth-Privacy:");
        snmpPanel.add(this._v3ProtocolLabel);
        this._v3Protocol = new JComboBox<String>(SNMP_V3_PARAMS);
        snmpPanel.add(this._v3Protocol);
        this._v3Protocol.setSelectedIndex(v3Protocol);
        this._value[4] = snmpPanel;
        this._openNewWindow = new JCheckBox("Open in New Window", false);
        this._openNewWindow.setVisible(false);
        this._value[5] = this._openNewWindow;
        GridBagConstraints gbc = new GridBagConstraints();
        boolean flag = false;
        str = this._dmProperties.getProperty("UseSNMPProxy");
        if (str != null && str.length() > 0) {
            flag = Boolean.valueOf(str);
        }
        this._useProxy = new JCheckBox("Proxy SNMP through DCNM Server (client can't directly communicate)", flag);
        this._value[6] = this._useProxy;
        this._useProxy.addActionListener(this);
        String proxyAddr = "";
        str = this._dmProperties.getProperty("SNMPProxy");
        if (str != null && str.length() > 0) {
            proxyAddr = str;
        }
        this._proxyAddr = new JTextField();
        this._value[7] = this._proxyAddr;
        this._proxyAddr.setText(proxyAddr);
        this._useProxy.setEnabled(FIRST_TIME_OPENING);
        this._proxyAddr.setEnabled(this._useProxy.isSelected() && this._useProxy.isEnabled());
        this._labels = DialogUtil.buildLabels(_Labels);
        JPanel p = DialogUtil.buildPanel(this._labels, this._value);
        this._labels[7].setEnabled(this._useProxy.isSelected() && this._useProxy.isEnabled());
        JLabel logo = new JLabel(Util.loadIcon("icons/logo.gif"));
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.insets = DialogUtil._MarginInsets;
        DialogUtil.extend(gbc, p, logo);
        gbc.insets = DialogUtil.getInsets();
        DialogUtil.constrain(p, cb, gbc, 1, 1, 2, 17);
        boolean shOptions = false;
        str = this._dmProperties.getProperty(SHOW_OPTIONS);
        if (str != null && str.length() > 0) {
            shOptions = Boolean.valueOf(str);
        }
        this._main.add((Component)p, "Center");
        String[] buttons = new String[]{"Open", "Options >>", "Close"};
        this._buttons = DialogUtil.buildButtons(buttons, (ActionListener)this);
        this._status = new JLabel(" ");
        JPanel bottom = DialogUtil.buildStatusPanel(this._buttons, this._status);
        this._main.add((Component)bottom, "South");
        DialogUtil.addKeyListener(this._frame.getContentPane(), this);
        this._frame.getRootPane().setDefaultButton(this._buttons[0]);
        this._frame.getContentPane().add(this._main);
        this.showOptions(shOptions);
        this.setVersionLabels(useV3);
        if (!JavaVersionCheck.isJVMCompatible()) {
            this._status.setIcon(Util.loadIcon("icons/warning.png"));
            this.setStatus("Java version " + System.getProperties().getProperty("java.version") + " detected.  " + "DCNM-SAN is tested with Java " + JavaVersionCheck.getSupportedVersion() + ".");
        }
        if (this._dialog != null) {
            this._dialog.pack();
        }
        this._frame.pack();
        this._frame.setResizable(false);
        this._frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                OpenDialog.this.closeAction();
            }
        });
        this._frame.setIconImage(Util.loadIcon("icons/LogoIcon.gif").getImage());
        FIRST_TIME_OPENING = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector buildMenu() {
        Vector<String> items = new Vector<String>();
        BufferedReader br = null;
        String line = null;
        try {
            br = new BufferedReader(new FileReader(LastOpened.FILENAME));
            while ((line = br.readLine()) != null) {
                if (line.trim().length() == 0 || line.charAt(0) == '#') continue;
                items.addElement(line);
            }
        }
        catch (IOException ex) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {}
            }
        }
        return items;
    }

    private boolean useSnmpV3() {
        if (this._useSNMPv3 == null) {
            return true;
        }
        return this._useSNMPv3.isSelected();
    }

    private void showOptions(boolean show) {
        boolean useV3 = this.useSnmpV3();
        this._labels[3].setVisible(show && useV3 && IsEnablePriavcyInput);
        this._value[3].setVisible(show && useV3 && IsEnablePriavcyInput);
        this._value[4].setVisible(show);
        this._useProxy.setVisible(show);
        this._proxyAddr.setVisible(show);
        this._labels[7].setVisible(show);
        this._buttons[this._buttons.length - 2].setText(show ? "Options <<" : "Options >>");
        if (this._frame != null) {
            this._frame.invalidate();
            this._frame.pack();
        } else if (this._dialog != null) {
            this._dialog.pack();
        }
        this._showOptions = show;
    }

    void setVersionLabels(boolean bUseV3) {
        this._labels[1].setText(bUseV3 ? _Labels[1] : "Community:");
        this._labels[2].setText(bUseV3 ? _Labels[2] : "Write Community:");
        this._labels[2].setVisible(bUseV3 || IsEnablePriavcyInput);
        this._value[2].setVisible(bUseV3 || IsEnablePriavcyInput);
        this._labels[3].setVisible(IsEnablePriavcyInput && this._showOptions && bUseV3);
        this._value[3].setVisible(IsEnablePriavcyInput && this._showOptions && bUseV3);
        if (this._useSNMPv3 != null) {
            this._useSNMPv3.setSelected(bUseV3);
        }
        this._v3ProtocolLabel.setVisible(bUseV3);
        this._v3Protocol.setVisible(bUseV3);
        if (this._frame != null) {
            this._frame.invalidate();
            this._frame.pack();
        } else if (this._dialog != null) {
            this._dialog.pack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String fileName) {
        Properties properties = new Properties();
        FileInputStream fsm = null;
        try {
            fsm = new FileInputStream(fileName);
            properties.load(fsm);
        }
        catch (IOException ex) {
        }
        finally {
            if (fsm != null) {
                try {
                    fsm.close();
                }
                catch (IOException ex1) {}
            }
        }
        return properties;
    }

    private static void saveProperties(String fileName, Properties prop) throws IOException {
        if (prop != null && prop.size() > 0) {
            FileOutputStream fos = new FileOutputStream(fileName);
            prop.store(fos, "");
        }
    }

    void setDeviceName(String deviceName) {
        ((JComboBox)this._value[0]).setSelectedItem(deviceName);
    }

    String getDeviceName() throws Exception {
        String deviceName = ((JComboBox)this._value[0]).getSelectedItem().toString().trim();
        if (deviceName.equals("")) {
            throw new Exception("Please enter a device name");
        }
        return deviceName;
    }

    String getUsername() throws Exception {
        String userName = ((JTextField)this._value[1]).getText().trim();
        if (userName.length() == 0) {
            String msg = DM._UseV3 ? " user name" : " read community";
            throw new Exception("Please enter a" + msg);
        }
        return userName;
    }

    void setUsername(String userName) {
        ((JTextField)this._value[1]).setText(userName);
    }

    String getAuthPassword() throws Exception {
        if (this._value[2].isVisible()) {
            String authPassword = ((JTextField)this._value[2]).getText();
            if (authPassword.length() == 0 && DM._UseV3) {
                throw new Exception("Please enter an authentication password");
            }
            return authPassword;
        }
        return this.getUsername();
    }

    void setAuthPassword(String authPassword) {
        ((JTextField)this._value[2]).setText(authPassword);
    }

    boolean isPrivProtocol() {
        int v3Protocol = this._v3Protocol.getSelectedIndex();
        return v3Protocol == 2 || v3Protocol == 3 || v3Protocol == 5 || v3Protocol == 4;
    }

    String getPrivPassword() {
        if (this._value[3].isVisible()) {
            String privPassword = ((JTextField)this._value[3]).getText();
            return privPassword.length() == 0 ? null : privPassword;
        }
        if (this.isPrivProtocol()) {
            try {
                return this.getAuthPassword();
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public final void setStatus(String msg) {
        this._status.setText(msg);
    }

    public final String getStatus() {
        return this._status.getText();
    }

    public static InetSocketAddress getProxyAddress(boolean isUseProxy, String sv) throws Exception {
        if (!isUseProxy) {
            return null;
        }
        if (sv.trim().length() != 0) {
            InetAddress addr = null;
            int port = 9198;
            int del = sv.indexOf(58);
            try {
                String address;
                String string = address = del == -1 ? sv.trim() : sv.substring(0, del).trim();
                if (address.equals("localhost")) {
                    address = InetAddress.getLocalHost().getHostAddress();
                }
                if (del == -1) {
                    addr = InetAddress.getByName(address);
                } else {
                    addr = InetAddress.getByName(address);
                    port = Integer.parseInt(sv.substring(del + 1));
                    if (port < 1 || port > 65535) {
                        throw new Exception("Invalid Proxy port range (1-65535)");
                    }
                }
            }
            catch (Exception ex) {
                throw new Exception("Invalid DCNM Server Proxy: " + sv);
            }
            return new InetSocketAddress(addr, port);
        }
        throw new Exception("Please enter proxy server address.");
    }

    public void setVisible(boolean visible) {
        if (visible && this._visible) {
            if (this._frame != null) {
                this._frame.toFront();
            }
            return;
        }
        this._visible = visible;
        if (this._frame != null) {
            this._frame.setVisible(this._visible);
        } else {
            this._useProxy.setSelected(Discover._UseProxy);
            this._useProxy.setEnabled(FIRST_TIME_OPENING);
            this._proxyAddr.setText(Discover._ProxyAddrString);
            this._proxyAddr.setEnabled(Discover._UseProxy && this._useProxy.isEnabled());
            this._labels[7].setEnabled(Discover._UseProxy && this._useProxy.isEnabled());
            this._firstShown = false;
            this.showOptions(this._showOptions);
            this._openNewWindow.setVisible(false);
            if (!this._openNewWindow.isVisible()) {
                this._openNewWindow.setSelected(false);
                this._dialog.pack();
            } else if (this._openNewWindow.isSelected()) {
                this._openNewWindow.setSelected(false);
                this._dialog.pack();
            }
            this._dialog.setVisible(this._visible);
        }
    }

    public void setLocation(int x, int y) {
        if (this._frame != null) {
            this._frame.setLocation(x, y);
        } else {
            this._dialog.setLocation(x, y);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JComboBox) {
            return;
        }
        String cmdString = ((AbstractButton)e.getSource()).getActionCommand();
        switch (cmdString.charAt(0)) {
            case 'S': {
                DM._UseV3 = this.useSnmpV3();
                ((JTextField)this._value[1]).setText("");
                if (DM._UseV3) {
                    ((JPasswordField)this._value[1]).setEchoChar('\u0000');
                } else {
                    ((JPasswordField)this._value[1]).setEchoChar(this.defaultEcho);
                }
                ((JTextField)this._value[2]).setText("");
                ((JTextField)this._value[3]).setText("");
                this.setVersionLabels(DM._UseV3);
                break;
            }
            case 'P': {
                Discover._UseProxy = this._useProxy.isSelected();
                this._proxyAddr.setText("");
                this._proxyAddr.setEnabled(Discover._UseProxy && this._useProxy.isEnabled());
                this._labels[7].setEnabled(Discover._UseProxy && this._useProxy.isEnabled());
                break;
            }
            case 'C': {
                this.closeAction();
                break;
            }
            case 'O': {
                if (cmdString.charAt(2) == 't') {
                    this._showOptions = !this._showOptions;
                    this.showOptions(this._showOptions);
                    return;
                }
                if (this._v3Protocol.isVisible() && this.isPrivProtocol() && this.getPrivPassword() == null) {
                    Util.errorMessage((Component)this._buttons[0], "Please provide Privacy password.");
                    return;
                }
                DM._UseV3 = this.useSnmpV3();
                Discover._UseProxy = this._useProxy.isSelected();
                int v3Protocol = this._v3Protocol.getSelectedIndex();
                DM._AuthProtocol = v3Protocol == 1 || v3Protocol == 5 || v3Protocol == 4 ? 1 : 0;
                DM._PrivProtocol = v3Protocol == 3 || v3Protocol == 5 ? 1 : 0;
                try {
                    String userName = this.getUsername();
                    try {
                        this._dmProperties.setProperty(USER, userName);
                        this._dmProperties.setProperty(V3, Boolean.toString(this.useSnmpV3()));
                        this._dmProperties.setProperty(V3_PROTOCOL, Integer.toString(this._v3Protocol.getSelectedIndex()));
                        this._dmProperties.setProperty(SHOW_OPTIONS, Boolean.toString(this._showOptions));
                        this._dmProperties.setProperty("UseSNMPProxy", Boolean.toString(this._useProxy.isSelected()));
                        this._dmProperties.setProperty("SNMPProxy", this._proxyAddr.getText());
                        OpenDialog.saveProperties(DmPreferences.PROPERTY_FILENAME, this._dmProperties);
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    if (this._openNewWindow.isSelected()) {
                        this.forkNewDM();
                    } else {
                        DeviceManager.getInstance().open(this.getDeviceName(), userName, this.getAuthPassword(), this.getPrivPassword(), OpenDialog.getProxyAddress(this._useProxy.isSelected(), this._proxyAddr.getText()));
                    }
                    if (this._frame != null) {
                        DeviceManager.getInstance().setVisible(true);
                    }
                    this.setVisible(false);
                }
                catch (SnmpException ex) {
                    Util.errorMessage((Component)this._buttons[0], ex.getMessage());
                }
                catch (Exception ex) {
                    Util.errorMessage((Component)this._buttons[0], ex.getMessage());
                }
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void setCursor(Cursor cursor) {
        if (this._frame != null) {
            this._frame.setCursor(cursor);
        } else {
            this._dialog.setCursor(cursor);
        }
    }

    void forkNewDM() throws Exception, IOException {
        String localIf;
        if (DeviceManager.getInstance()._prefDialog != null) {
            DeviceManager deviceManager = DeviceManager.getInstance();
            deviceManager._prefDialog.save();
        }
        int dmLen = 6;
        if (DM._UseV3) {
            dmLen += 2;
            if (this.getPrivPassword() != null) {
                dmLen += 4;
            }
        } else {
            dmLen = this.getAuthPassword().trim().length() > 0 ? dmLen : dmLen - 2;
        }
        String[] dmArgs = new String[dmLen];
        dmArgs[0] = this.getDeviceName();
        int index = 1;
        if (DM._UseV3) {
            dmArgs[index] = "-v3";
            dmArgs[index + 1] = "-user";
            dmArgs[index + 2] = this.getUsername();
            dmArgs[index + 3] = "-auth";
            dmArgs[index + 4] = this.getAuthPassword();
            index += 5;
            if (this.getPrivPassword() != null) {
                dmArgs[index] = "-priv";
                dmArgs[index + 1] = this.getPrivPassword();
                dmArgs[index + 2] = "-r";
                dmArgs[index + 3] = DM._PrivProtocol == 0 ? "DES" : "AES";
                index += 4;
            }
            dmArgs[index] = "-digest";
            dmArgs[index + 1] = SnmpCrypto.getDigestName(DM._AuthProtocol);
            index += 2;
        } else {
            dmArgs[index] = "-v2c";
            dmArgs[index + 1] = "-user";
            dmArgs[index + 2] = this.getUsername();
            if (this.getAuthPassword().trim().length() > 0) {
                dmArgs[index + 3] = "-auth";
                dmArgs[index + 4] = this.getAuthPassword();
                index += 2;
            } else {
                index += 3;
            }
        }
        ArrayList<String> vmArgs = new ArrayList<String>();
        String laf = System.getProperty("swing.defaultlaf");
        if (laf != null) {
            vmArgs.add("-Dswing.defaultlaf=" + laf);
        }
        if ((localIf = System.getProperty("mds.nmsAddress")) != null) {
            vmArgs.add("-Dmds.nmsAddress=" + localIf);
        }
        JFork.fork("com.cisco.dcbu.dm.DM", new String[]{System.getProperty("java.class.path")}, vmArgs.toArray(new String[vmArgs.size()]), dmArgs);
    }

    void closeAction() {
        if (this._frame != null) {
            Vsh.close();
            System.exit(0);
        } else {
            this.setVisible(false);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.setVisible(false);
        }
    }

    static {
        FIRST_TIME_OPENING = true;
        IsEnablePriavcyInput = false;
    }
}

