/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dm;

import com.cisco.dcbu.dm.DM;
import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dmdb.andiamo.dialogs.zeroTouch.ZeroTouchWizard;
import com.cisco.dcbu.lib.jnm.LogWriter;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.ClientCache;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.office2003.Office2003Painter;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Component;
import java.io.File;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.log4j.LogManager;
import org.apache.log4j.xml.DOMConfigurator;

public final class ZeroTouchLaunch {
    public static String _AppName = "Zero Touch 6.3(1)";
    static final String USAGE = "[-t {std} -socket <num> -out {c|l}]";
    static boolean _ConsoleOut;
    static boolean _UseV3;
    public static boolean _IsWindows;
    public static LogWriter _logWriter;
    static final String OS;
    static final boolean ONWINDOWS;
    static final boolean ONMAC;

    public static void main(String[] argv) {
        String logConfFile;
        if (ONWINDOWS) {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new WindowsLookAndFeel());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Util.errorMessage((Component)DeviceManager.getInstance(), "Unable to set L&F: " + ex.getMessage());
            }
        } else if (ONMAC) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "DM");
        }
        LookAndFeelFactory.installJideExtension((int)3);
        ((Office2003Painter)Office2003Painter.getInstance()).setColorName("Default");
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].charAt(0) != '-') continue;
            switch (argv[i].charAt(1)) {
                case 'o': {
                    _ConsoleOut = argv[++i].charAt(0) == 'c';
                }
            }
        }
        _logWriter = new LogWriter();
        if (!DM._ConsoleOut) {
            System.setOut(_logWriter);
            System.setErr(_logWriter);
        }
        if ((logConfFile = System.getProperty("org.apache.log4j.file")) == null) {
            logConfFile = ClientCache.getConfDir() + "log4j_dm.xml";
        }
        if (logConfFile != null) {
            try {
                System.setProperty("log.dir", ClientCache.getInstallLocation() + File.separator + "logs");
                DOMConfigurator.configure((String)logConfFile);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        DefaultLogger._DefLogger = LogManager.getLogger((String)DM.class.getName());
        block14: for (int i = 0; i < argv.length; ++i) {
            if (argv[i].charAt(0) != '-') continue;
            switch (argv[i].charAt(1)) {
                case 't': {
                    String cmd = argv[++i];
                    SnmpSession.setTrace(cmd.indexOf(115) != -1);
                    SnmpPDU.setIsTclPrint(cmd.indexOf(116) != -1);
                    Discover.setTrace(cmd.indexOf(100) != -1);
                    continue block14;
                }
                case 'o': {
                    ++i;
                    continue block14;
                }
                default: {
                    DefaultLogger._DefLogger.debug((Object)("unknown option: " + argv[i] + USAGE));
                }
            }
        }
        try {
            ZeroTouchWizard zeroTouch = new ZeroTouchWizard(null);
            zeroTouch.setVisible(true);
        }
        catch (Exception ex) {
            if (ex.getMessage() == null) {
                Util.errorMessage((Component)DeviceManager.getInstance(), ex);
            } else {
                Util.errorMessage((Component)DeviceManager.getInstance(), ex);
            }
            System.exit(0);
        }
    }

    static {
        _UseV3 = true;
        _IsWindows = System.getProperty("os.name").startsWith("Win");
        OS = System.getProperty("os.name");
        ONWINDOWS = OS.startsWith("Windows");
        ONMAC = OS.startsWith("Mac");
    }
}

