/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb;

import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpVar;

public final class DmId {
    static final int[] _SysIdAndiamo = new int[]{1, 3, 6, 1, 4, 1, 9, 12, 3, 1, 3};

    public static String get(SnmpOID sysObjectId, String sysDescr, SnmpVar vendorId) throws SnmpException {
        if (sysObjectId.startsWith(_SysIdAndiamo)) {
            int[] oid = sysObjectId.getValue();
            switch (oid[oid.length - 1]) {
                case 375: {
                    return "com.cisco.dcbu.dmdb.andiamo.System9506";
                }
                case 376: {
                    return "com.cisco.dcbu.dmdb.andiamo.System9509";
                }
                case 377: {
                    return "com.cisco.dcbu.dmdb.andiamo.System9513";
                }
                case 380: 
                case 442: 
                case 472: 
                case 651: {
                    return "com.cisco.dcbu.dmdb.andiamo.System9216";
                }
                case 411: {
                    return "com.cisco.dcbu.dmdb.andiamo.System91x0";
                }
                case 414: 
                case 587: 
                case 616: {
                    return "com.cisco.dcbu.dmdb.andiamo.System91x0";
                }
                case 841: {
                    return "com.cisco.dcbu.dmdb.andiamo.System91x0_Huashan";
                }
                case 606: 
                case 773: {
                    return "com.cisco.dcbu.dmdb.andiamo.System91x0_Chester";
                }
                case 843: {
                    return "com.cisco.dcbu.dmdb.andiamo.System91x0_Cassino";
                }
                case 601: {
                    return DmId.getInagua(vendorId);
                }
                case 514: {
                    return "com.cisco.dcbu.dmdb.andiamo.System9020";
                }
                case 719: 
                case 935: 
                case 936: {
                    return "com.cisco.dcbu.portland.dmdb.SystemEugene";
                }
                case 798: 
                case 934: {
                    return "com.cisco.dcbu.portland.dmdb.SystemBend";
                }
                case 1008: 
                case 1084: {
                    return "com.cisco.dcbu.portland.dmdb.SystemOxygen";
                }
                case 1038: 
                case 1175: {
                    return "com.cisco.dcbu.portland.dmdb.SystemOxygen96";
                }
                case 1410: {
                    return "com.cisco.dcbu.portland.dmdb.SystemNorcal72";
                }
                case 1409: {
                    return "com.cisco.dcbu.portland.dmdb.SystemNorcal128";
                }
                case 1237: 
                case 1489: {
                    return "com.cisco.dcbu.portland.dmdb.SystemNorcal96";
                }
                case 1308: 
                case 1340: {
                    return "com.cisco.dcbu.portland.dmdb.SystemNorcal64";
                }
                case 847: {
                    return "com.cisco.dcbu.portland.dmdb.ca.SystemUCS6120XP";
                }
                case 899: {
                    return "com.cisco.dcbu.portland.dmdb.ca.SystemUCS6220XP";
                }
                case 932: {
                    return "com.cisco.dcbu.dmdb.andiamo.System7009";
                }
                case 612: {
                    return "com.cisco.dcbu.dmdb.andiamo.System7010";
                }
                case 777: {
                    return "com.cisco.dcbu.dmdb.andiamo.System7018";
                }
                case 1147: {
                    return "com.cisco.dcbu.dmdb.andiamo.System7004";
                }
                case 1327: {
                    return "com.cisco.dcbu.dmdb.andiamo.System7010_XBOW_9710";
                }
                case 1420: {
                    return "com.cisco.dcbu.dmdb.andiamo.System7006_XBOW_9706";
                }
                case 1353: {
                    return "com.cisco.dcbu.dmdb.andiamo.System7010_XBOW";
                }
                case 1352: {
                    return "com.cisco.dcbu.dmdb.andiamo.System7018_XBOW";
                }
                case 1354: {
                    return "com.cisco.dcbu.dmdb.andiamo.System7006_XBOW";
                }
                case 1326: {
                    return "com.cisco.dcbu.dmdb.andiamo.SystemAlishan";
                }
                case 1491: {
                    return "com.cisco.dcbu.dmdb.andiamo.SystemMinishan";
                }
            }
        }
        throw new SnmpException("Unsupported device (sysObjectID = " + sysObjectId + ")");
    }

    private static String getInagua(SnmpVar vendorId) throws SnmpException {
        if (vendorId.getType() == 6) {
            int[] vendorOid = ((SnmpOID)vendorId).getValue();
            if (vendorOid[vendorOid.length - 2] == 601) {
                int chassisType = vendorOid[vendorOid.length - 1];
                switch (chassisType) {
                    case 0: {
                        return "com.cisco.dcbu.dmdb.andiamo.System91x0_Inagua";
                    }
                    case 1: {
                        return "com.cisco.dcbu.dmdb.andiamo.System91x0_Inagua_H";
                    }
                    case 2: {
                        return "com.cisco.dcbu.dmdb.andiamo.System91x0_Inagua_T";
                    }
                    case 3: {
                        return "com.cisco.dcbu.dmdb.andiamo.System91x0_Inagua_TH";
                    }
                    case 4: {
                        return "com.cisco.dcbu.dmdb.andiamo.System91x0_Inagua_S";
                    }
                }
                throw new SnmpException("MDS IBM-FC Subchassis type " + chassisType + " is unsupported");
            }
            throw new SnmpException("MDS IBM-FC chassis type " + vendorOid[vendorOid.length - 2] + " is unsupported");
        }
        return "com.cisco.dcbu.dmdb.andiamo.System91x0_Inagua";
    }

    public static boolean is9700(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 1327 || id == 1420;
    }

    public static boolean is9200(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 380 || id == 411 || id == 414 || id == 442 || id == 472 || id == 587 || id == 601 || id == 606 || id == 773 || id == 651 || id == 616 || id == 841 || id == 843 || id == 1326 || id == 1491;
    }

    public static boolean is9100(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 411 || id == 414 || id == 1491;
    }

    public static boolean is9120(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 414;
    }

    public static boolean is9500(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 376 || id == 375;
    }

    public static boolean is9509(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 376;
    }

    public static boolean is9506(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 375;
    }

    public static boolean is9216(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 380 || id == 442 || id == 472;
    }

    public static boolean is9216i(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 472;
    }

    public static boolean is9222i(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 651;
    }

    public static boolean isQuail(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 514;
    }

    public static boolean is9513(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 377;
    }

    public static boolean is9124(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 587 || id == 606 || id == 601 || id == 616 || id == 773 || id == 843 || id == 841;
    }

    public static boolean is9124SupportFICON(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 616;
    }

    public static boolean isParadise(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 587;
    }

    public static boolean isHuashan(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 841;
    }

    public static boolean isBladeServer(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 606 || id == 601 || id == 773 || id == 843;
    }

    public static boolean isInagua(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 601;
    }

    public static boolean isChester(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 606 || id == 773;
    }

    public static boolean isCassino(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 843;
    }

    public static boolean isN7K(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 612 || id == 932 || id == 777 || id == 1147 || id == 1353 || id == 1352 || id == 1354;
    }

    public static boolean isN7K_C7009(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 932;
    }

    public static boolean isN7K_horizontal(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 932 || id == 777 || id == 1147 || id == 1353 || id == 1352 || id == 1354;
    }

    public static boolean isXBOW(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 1327 || id == 1353 || id == 1352 || id == 1354 || id == 1420;
    }

    public static boolean isAlishan(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 1326;
    }

    public static boolean isMinishan(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 1491;
    }

    public static boolean isChassisGrayBackGound(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 1327 || id == 1326 || id == 1491 || id == 1353 || id == 1352 || id == 932 || id == 612 || id == 777 || id == 1147 || id == 1354 || id == 1420;
    }

    public static boolean isSupportFICON(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        if (FRUConstants.isN5K(id)) {
            return false;
        }
        return id != 587 && id != 601 && id != 606 && id != 514 && id != 773 && id != 843 && id != 612 && id != 777 && id != 932 && id != 1147 && id != 1353 && id != 1352 && id != 1354;
    }

    public static boolean isNonFCoEN5K(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return id == 936;
    }

    public static boolean isN5K(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return FRUConstants.isN5K(id);
    }

    public static boolean isNuovaFamily(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return FRUConstants.isNuovaFamily(id);
    }

    public static boolean isUCS(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return FRUConstants.isUCS(id);
    }

    public static boolean isIPStorageCapablePlatform(int[] sysObjectId) {
        int id = sysObjectId[sysObjectId.length - 1];
        return FRUConstants.isIPStorageCapablePlatform(id);
    }

    public static int getModelType(int[] sysObjectId) {
        return sysObjectId[sysObjectId.length - 1];
    }
}

