/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo;

import com.cisco.dcbu.dm.DM;
import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dm.PhysicalStatus;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.dialogs.admin.SaveConfiguration;
import com.cisco.dcbu.dmdb.andiamo.dialogs.admin.ShowTech;
import com.cisco.dcbu.dmdb.andiamo.dialogs.mds9020.Dialogs;
import com.cisco.dcbu.dmdb.andiamo.dialogs.mds9020.QlogicCommandHandlerDM;
import com.cisco.dcbu.dmdb.andiamo.elements.mds9020.Card;
import com.cisco.dcbu.dmdb.andiamo.elements.mds9020.Chassis;
import com.cisco.dcbu.dmdb.andiamo.elements.mds9020.Port;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.InterfacePortsCellEditor;
import com.cisco.dcbu.lib.mds.PortEditorCardAttribute;
import com.cisco.dcbu.lib.mds.TrapRegister;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpNull;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.MnemonicTabbedPane;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class System9020
extends DmSystem {
    private static final int EQUALS = 0;
    private static final int GREATER_EQUALs = 1;
    private static final int ADMIN_MENU = 5;
    private static final int LOG_MENU = 6;
    static int[] _SlotMembers;
    static PortEditorCardAttribute[] _cardAttributes;
    static int[] _cardTypes;
    static int[][] _IfNameTypes;
    static ShowTech _showTech;
    static int[] _UnitId;
    static int _CardId;

    @Override
    public Class getRoot() {
        return Chassis.class;
    }

    @Override
    public Class getDialogClass() {
        return Dialogs.class;
    }

    @Override
    public int getMaxVarBindInPDU() {
        return 50;
    }

    public int nameToIfIndex(int card, int port) {
        return port;
    }

    @Override
    public int nameToIfIndex(String ifName) {
        try {
            char c = ifName.charAt(0);
            if (!Character.isDigit(c) || Character.toLowerCase(c) != 'f') {
                throw new SnmpException("bad interface " + ifName);
            }
            int pos = ifName.indexOf(47);
            if (pos == -1) {
                throw new SnmpException("bad interface " + ifName);
            }
            int card = System9020.getNum(ifName.substring(0, pos));
            int port = System9020.getNum(ifName.substring(pos + 1));
            if (card > 1) {
                throw new SnmpException("bad interface " + ifName);
            }
            return port;
        }
        catch (SnmpException ex) {
            DefaultLogger._DefLogger.debug((Object)ex);
            return 0;
        }
    }

    private static int getNum(String ifName) throws SnmpException {
        int ifIndex = Integer.parseInt(ifName);
        if (ifIndex < 0) {
            throw new SnmpException("bad interface " + ifName);
        }
        return ifIndex;
    }

    @Override
    public int getType(int ifIndex) {
        return IfIndexUtil.getType(ifIndex);
    }

    @Override
    public int getActualType(int type) {
        return type;
    }

    @Override
    public String ifTypeToifName(int ifType) {
        return IfIndexUtil.ifTypeToifName(ifType);
    }

    @Override
    public String ifIndexToName(int ifIndex) {
        return "fc1/" + ifIndex;
    }

    @Override
    public int ifIndex2Card(int ifIndex) {
        return 1;
    }

    @Override
    public int ifIndex2Port(int ifIndex) {
        return ifIndex;
    }

    @Override
    public void discoverySetup(boolean isRediscover) throws SnmpException {
        MnemonicTabbedPane tabs = DeviceManager.getInstance().getViewTabs();
        tabs.setEnabledAt(1, false);
        if (isRediscover) {
            SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(3));
            pdu.addNull(Discover._SysObjectIDOid);
            pdu.addNull(Discover._SysDescrOid);
            pdu.addNull(Discover._SysNameOid);
            Discover.getInstance();
            SnmpPDU response = Discover.getPeer().send(pdu);
            if (response.getVar(0) instanceof SnmpNull) {
                throw new SnmpException("Can't read SysObjectID");
            }
            Discover.getInstance();
            Discover.setSysVersion(response.getVar(1).toString());
            Discover.getInstance();
            Discover.setSysObjectID((SnmpOID)response.getVar(0));
            Discover.getInstance();
            Discover.setSysDescr(response.getVar(1).toString());
            Discover.getInstance();
            Discover.setSystemName(response.getVar(2).toString());
        }
        PhysicalStatus.getInstance().setMaxVbl(15);
        _UnitId = new int[0];
    }

    @Override
    public void endDiscovery(boolean isRediscover) throws SnmpException {
        DeviceManager.getInstance().reSetLogTitle();
        Discover.testVPN();
        if (InterfacePortsCellEditor._PortChooser != null) {
            InterfacePortsCellEditor._PortChooser.dispose();
        }
        if (InterfacePortsCellEditor._interfaceEditor != null) {
            InterfacePortsCellEditor._interfaceEditor.dispose();
        }
    }

    @Override
    public void trapRegister(SnmpPeer peer) throws Exception {
        TrapRegister.getInstance().setStatusLine(DeviceManager.getInstance().getStatusLine());
        InetAddress adr = InetAddress.getLocalHost();
        if (Discover.getLocalVPNAddress() != null) {
            adr = InetAddress.getByName(Discover.getLocalVPNAddress());
        }
        TrapRegister.getInstance().asyncRegisterQuail(peer, adr, DM._Port);
    }

    @Override
    public boolean closeDevice() {
        boolean isCancel = super.closeDevice();
        if (isCancel) {
            return true;
        }
        QlogicCommandHandlerDM.close();
        return false;
    }

    @Override
    public void addUI(JMenuBar menubar, JPanel toolbar, ActionListener listener) {
        JMenu mE = Util.createMenu("Physical");
        menubar.add(mE);
        mE.add(Util.createMenuItem("Modules...", "deviceAction editCards", listener));
        mE.add(Util.createMenuItem("S&ensors...", "dialogAction Sensors", listener));
        mE.addSeparator();
        mE.add(Util.createMenuItem("System...", "dialogAction System", listener));
        JMenu mEP = Util.createMenu("I&nterface");
        menubar.add(mEP);
        mEP.add(Util.createMenuItem("FC F/FL...", "deviceAction editFPorts", listener));
        mEP.add(Util.createMenuItem("FC &E...", "deviceAction editEPorts", listener));
        mEP.add(Util.createMenuItem("FC Ena&bled...", "deviceAction editEnabledPorts", listener));
        mEP.add(Util.createMenuItem("FC &All...", "deviceAction editPorts", listener));
        mEP.addSeparator();
        JMenu mEPm = Util.createMenu("Mgmt");
        mEP.add(mEPm);
        mEPm.add(Util.createMenuItem("Mgmt0...", "deviceAction editMgmtPort", listener));
        mEPm.add(Util.createMenuItem("TCP/UDP...", "dialogAction TCP_UDP", listener));
        mEPm.add(Util.createMenuItem("Statistics...", "dialogAction IP_Statistics", listener));
        mEP.addSeparator();
        JMenu mEPM = Util.createMenu("Mo&nitor");
        mEP.add(mEPM);
        mEPM.add(Util.createMenuItem("FC Enabled...", "deviceAction graphFCPorts", listener));
        JMenu mEPS = Util.createMenu("Select By Speed");
        mEP.add(mEPS);
        mEPS.add(Util.createMenuItem("1G", "deviceAction select1G", listener));
        mEPS.add(Util.createMenuItem("2G+", "deviceAction select2GPlus", listener));
        mEPS.add(Util.createMenuItem("4G+", "deviceAction select4GPlus", listener));
        JMenu mF = Util.createMenu("FC");
        menubar.add(mF);
        mF.add(Util.createMenuItem("Name Server...", "dialogAction Name_Server", listener));
        mF.add(Util.createMenuItem("F&C Timers...", "dialogAction FC_Timers", listener));
        JMenu ms = Util.createMenu("Security");
        menubar.add(ms);
        ms.add(Util.createMenuItem("Radius...", "dialogAction Radius", listener));
        JMenu mS = Util.createMenu("Admin");
        menubar.add(mS);
        mS.add(Util.createMenuItem("Events Destinations...", "dialogAction Event_Destinations", listener));
        JMenu mL = Util.createMenu("Logs");
        menubar.add(mL);
        JMenuItem mi = Util.createMenuItem("Message...", "errorLogAction", DeviceManager.getInstance()._listener);
        mi.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        mL.add(mi);
        mL.addSeparator();
        JMenu mSlog = Util.createMenu("FM Server Events");
        mL.add(mSlog);
        mSlog.add(Util.createMenuItem("Current...", "sysLogAction Events Recent", listener));
        mSlog.add(Util.createMenuItem("Older...", "sysLogAction Events File", listener));
        mL.addSeparator();
        JMenu mLS = Util.createMenu("S&witch Resident");
        mL.add(mLS);
        JMenuItem mLSS = Util.createMenuItem("SysLog", "vshAction com.cisco.dcbu.dmdb.andiamo.dialogs.syslog.SysLogQuail Show Log\n #sysLogVshQuail !Show SysLog", DeviceManager.getInstance()._listener);
        mLSS.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        mLS.add(mLSS);
        mLS.add(Util.createMenuItem("Accounting...", "vshAction com.cisco.dcbu.dmdb.andiamo.dialogs.syslog.SysLogQuail Show Accounting Log\n #ActLogVshQuail !Show Accounting Log", listener));
        mL.addSeparator();
        JMenu mSyslog = Util.createMenu("SysLog");
        mL.add(mSyslog);
        mSyslog.add(Util.createMenuItem("Setup...", "dialogAction Syslog", listener));
        mSyslog.add(Util.createMenuItem("Verify...", "deviceAction syslogVerification", listener));
        mS.addSeparator();
        mS.add(Util.createMenuItem("Copy Configuration...", "dialogAction Copy_Configuration", listener));
        mS.add(Util.createMenuItem("Save Configuration", "deviceAction saveConfiguration", listener));
        mS.add(Util.createMenuItem("Flash Files...", "deviceAction showFlashFiles", listener));
        mS.addSeparator();
        mS.add(Util.createMenuItem("Show &Tech Support...", "deviceAction showTechAction", listener));
        mS.add(Util.createMenuItem("Running &Processes...", "deviceAction showProcess", listener));
        mS.add(Util.createMenuItem("Show &User Accounts...", "deviceAction showUsers", listener));
        mS.addSeparator();
        mS.add(Util.createMenuItem("Erase Start&up Configuration", "deviceAction erase_Startup_Configuration", listener));
        mS.add(Util.createMenuItem("Reset Switch", "deviceAction resetSwitch", listener));
        toolbar.add(Util.createButton("icons/log16.gif", "Syslog...", "vshAction com.cisco.dcbu.dmdb.andiamo.dialogs.syslog.SysLog Show Logging Log\n #sysLogVsh", listener));
        toolbar.add(Util.createButton("icons/file16_save.gif", "Save Configuration", "deviceAction saveConfiguration", listener));
        toolbar.add(Util.createButton("icons/export_policyconfig_16.gif", "Copy Configuration File between Server and Switch", "dialogAction Copy_Configuration", listener));
    }

    @Override
    public void updateMenu(boolean isAdvancedMode) {
        JMenu adminMenu = DeviceManager.getInstance()._menubar.getMenu(5);
        this.setVisibleMenuItem(System9020.getMenuItem(adminMenu, "Events Destinations"), isAdvancedMode);
        this.setVisibleMenuItem(System9020.getMenuItem(adminMenu, "Running Processes"), isAdvancedMode);
        this.setVisibleMenuItem(System9020.getMenuItem(adminMenu, "Erase Startup Configuration"), isAdvancedMode);
        this.setVisibleMenuItem(System9020.getMenuItem(adminMenu, "Reset Switch"), isAdvancedMode);
        JMenu logMenu = DeviceManager.getInstance()._menubar.getMenu(6);
        this.setVisibleMenuItem(System9020.getMenuItem(logMenu, "FM Server"), isAdvancedMode);
        this.setVisibleMenuItem(System9020.getMenuItem(logMenu, "SysLog"), isAdvancedMode);
    }

    public static void editCards(JFrame parent, SnmpPeer peer) throws Exception {
        PhysicalElement[] sel = DeviceManager.getInstance().getView().getSelected(Card.class, "Modules");
        DeviceManager.getInstance().getView().dialogAction("Module", sel);
    }

    public static void select1G(JFrame parent, SnmpPeer peer) {
        System9020.selectSpeed(parent, peer, 1, 0);
    }

    public static void select2GPlus(JFrame parent, SnmpPeer peer) {
        System9020.selectSpeed(parent, peer, 2, 1);
    }

    public static void select4GPlus(JFrame parent, SnmpPeer peer) {
        System9020.selectSpeed(parent, peer, 4000, 1);
    }

    static void selectSpeed(JFrame parent, SnmpPeer peer, int speedMbps, int operator) {
        HashMap<Integer, PhysicalElement> ports = new HashMap<Integer, PhysicalElement>();
        PhysicalView view = DeviceManager.getInstance().getView();
        Array elements = view.getElements();
        VarBindList vbl = new VarBindList();
        int[] connUnitPortSpeed = MibNode.get("connUnitPortSpeed").getOid();
        int[] unitId = System9020.getUnitId();
        for (int i = elements.size() - 1; i >= 0; --i) {
            PhysicalElement e = (PhysicalElement)elements.elementAt(i);
            e.setSelected(false);
            if (!(e instanceof Port) || ((Port)e)._status != 1) continue;
            ports.put(new Integer(e.getIndex()[1]), e);
            int[] portIndex = new int[unitId.length + 9];
            System.arraycopy(unitId, 0, portIndex, 0, unitId.length);
            portIndex[portIndex.length - 1] = e.getIndex()[1];
            vbl.add(new SnmpVarBind(new SnmpOID(connUnitPortSpeed, portIndex)));
        }
        if (vbl.size() == 0) {
            return;
        }
        try {
            SnmpPDU resp = SnmpFetch.get(peer, vbl);
            vbl = resp.getVariables();
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)parent, ex.getMessage());
            return;
        }
        int numPorts = 0;
        int max = vbl.size();
        for (int i = 0; i < max; ++i) {
            PhysicalElement p;
            boolean match;
            SnmpVarBind vb = vbl.get(i);
            int[] oid = vb.getOid().getValue();
            int ifIndex = oid[oid.length - 1];
            int speed = ((SnmpInt)vb.getVar()).getValue() / 100000;
            switch (operator) {
                case 0: {
                    match = speed == speedMbps;
                    break;
                }
                case 1: {
                    match = speed >= speedMbps;
                    break;
                }
                default: {
                    match = false;
                }
            }
            if (!match || (p = (PhysicalElement)ports.get(new Integer(ifIndex))) == null) continue;
            p.setSelected(true);
            ++numPorts;
        }
        view.repaint();
        DeviceManager.getInstance().setStatus(numPorts + " port(s) selected");
    }

    public static void showFlashFiles(JFrame parent, SnmpPeer peer) {
        try {
            QlogicCommandHandlerDM cmdHandler = QlogicCommandHandlerDM.getInstance(DeviceManager.getInstance(), Discover.getPeer());
            cmdHandler.showFlash(peer);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)DeviceManager.getInstance(), ex.getMessage());
        }
    }

    public static void showProcess(JFrame parent, SnmpPeer peer) {
        try {
            QlogicCommandHandlerDM cmdHandler = QlogicCommandHandlerDM.getInstance(DeviceManager.getInstance(), Discover.getPeer());
            cmdHandler.showProcess(peer);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)DeviceManager.getInstance(), ex.getMessage());
        }
    }

    public static void showUsers(JFrame parent, SnmpPeer peer) {
        try {
            QlogicCommandHandlerDM cmdHandler = QlogicCommandHandlerDM.getInstance(DeviceManager.getInstance(), Discover.getPeer());
            cmdHandler.showUsers(peer);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)DeviceManager.getInstance(), ex.getMessage());
        }
    }

    public static void erase_Startup_Configuration(JFrame parent, SnmpPeer peer) throws SnmpException {
        Object[] possibleValues = new Object[]{"Yes", "No"};
        if (JOptionPane.showOptionDialog(parent, "Erase Startup Configuration will clear all configuration, this command cannot be undone.\nContinue?", parent.getTitle(), 0, 2, null, possibleValues, possibleValues[1]) == 0) {
            try {
                QlogicCommandHandlerDM cmdHandler = QlogicCommandHandlerDM.getInstance(DeviceManager.getInstance(), Discover.getPeer());
                cmdHandler.writeErase();
            }
            catch (Exception ex) {
                Util.errorMessage((Component)DeviceManager.getInstance(), ex.getMessage());
            }
        }
    }

    public static void resetSwitch(JFrame parent, SnmpPeer peer) throws SnmpException {
        if (Discover.getPeer().getNumSets() > 0) {
            System9020.SaveConfig(DeviceManager.getInstance(), Discover.getPeer());
        }
        if (DmId.is9200(Discover.getSysObjectID()) || !System9020.hasDualSups()) {
            Object[] options = new String[]{"Yes", "No"};
            if (JOptionPane.showOptionDialog(parent, "Reset will disrupt traffic and lose any unsaved configuration changes.\nContinue?", parent.getTitle(), 0, 3, null, options, "No") == 0) {
                try {
                    QlogicCommandHandlerDM cmdHandler = QlogicCommandHandlerDM.getInstance(DeviceManager.getInstance(), Discover.getPeer());
                    cmdHandler.resetSwitch();
                }
                catch (Exception ex) {
                    Util.errorMessage((Component)DeviceManager.getInstance(), ex.getMessage());
                }
            }
            return;
        }
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        MibNode cRFStatusPeerUnitState = MibNode.get("cRFStatusPeerUnitState");
        pdu.addVar(new SnmpOID(cRFStatusPeerUnitState.getOid(), 0));
        SnmpPDU resp = peer.send(pdu);
        String standbyState = MibEnum.getLabel(cRFStatusPeerUnitState.getEnums(), ((SnmpInt)resp.getVar(0)).getValue());
        Object[] possibleValues = new Object[]{"Reset Standby", "Reset System", "Switch to Standby", "Cancel"};
        int v = JOptionPane.showOptionDialog(parent, "Standby State is " + standbyState + ".  What would you like to do?", parent.getTitle(), -1, 2, null, possibleValues, possibleValues[3]);
        if (v < possibleValues.length - 1 && v > -1) {
            pdu = new SnmpPDU(-93, new VarBindList());
            pdu.addVar(new SnmpOID(MibNode.get("cRFCfgAdminAction").getOid(), 0), new SnmpInt(v + 1));
            pdu.setIgnoreSetCount(true);
            peer.set(pdu);
            peer.resetNumSets();
        }
    }

    public static int[] getUnitId() {
        return _UnitId;
    }

    public static void setUnitId(int[] unitId) {
        _UnitId = unitId;
    }

    public static int getCardId() {
        return _CardId;
    }

    public static void setCardId(int cardId) {
        _CardId = cardId;
    }

    public static boolean saveConfiguration(JFrame parent, SnmpPeer peer) {
        _SaveConfiguration = new SaveConfiguration(parent, peer, 1, true);
        _SaveConfiguration.setVisible(true);
        return _SaveConfiguration.isCancel();
    }

    public static boolean SaveConfig(JFrame parent, SnmpPeer peer) {
        _SaveConfiguration = new SaveConfiguration(parent, peer, 2, true);
        _SaveConfiguration.setVisible(true);
        return _SaveConfiguration.isCancel();
    }
}

