/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs;

import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;

public class InsertInetAddrIn
extends InsertForm {
    private int _addrType;
    private int _inetAddrPos;
    private int _inetAddrTypePos;
    private String _inetAddrVar;
    private String _inetAddrTypeVar;
    private boolean _isIPV4Only;

    public InsertInetAddrIn(InsertDialog parent, EditTable table, Object inetAddrVar, Object inetAddrTypeVar) {
        this(parent, table, inetAddrVar, inetAddrTypeVar, false);
    }

    public InsertInetAddrIn(InsertDialog parent, EditTable table, Object inetAddrVar, Object inetAddrTypeVar, boolean isIPV4Only) {
        super(parent, table);
        this._inetAddrVar = (String)inetAddrVar;
        this._inetAddrTypeVar = (String)inetAddrTypeVar;
        this._isIPV4Only = isIPV4Only;
        this._inetAddrPos = this.getVarIndex(this._inetAddrVar);
        this._inetAddrTypePos = this.getVarIndex(this._inetAddrTypeVar);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == this._inetAddrTypePos) {
            SnmpVar var = super.getComponentValue(index);
            this._addrType = ((SnmpInt)var).getValue();
            return var;
        }
        if (index == this._inetAddrPos) {
            String addr = this.getComponentText(index);
            if (this._mibNodes[index].getMaxWidth() < addr.length()) {
                throw new NumberFormatException(this.trim(this._vars[index]) + " maximum length is " + this._mibNodes[index].getMaxWidth());
            }
            if (this._mibNodes[index].getMinWidth() > addr.length()) {
                throw new NumberFormatException(this.trim(this._vars[index]) + " minimum length is " + this._mibNodes[index].getMinWidth());
            }
            if (this._addrType == 1 || this._addrType == 2) {
                byte[] addrB = SnmpIpAddress.parse(addr);
                return new SnmpString(addrB);
            }
            return new SnmpString(addr);
        }
        return super.getComponentValue(index);
    }
}

