/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs;

import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.util.Array;
import java.awt.event.ActionEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class ModuleIdMenuButton
extends MenuButton {
    SnmpPeer _peer;
    EditForm _parent;
    String _modName;
    int _type;
    Array _slotList;

    public ModuleIdMenuButton(JMenu menu) {
        this(menu, (SnmpPeer)null);
    }

    public ModuleIdMenuButton(JMenu menu, SnmpPeer peer) {
        this(menu, null, null);
    }

    public ModuleIdMenuButton(JMenu menu, SnmpPeer peer, String modName) {
        super(menu);
        this._peer = peer;
        this._parent = null;
        this._modName = modName;
        this._slotList = null;
    }

    public ModuleIdMenuButton(JMenu menu, SnmpPeer peer, String modName, Array slotList) {
        super(menu);
        this._peer = peer;
        this._parent = null;
        this._modName = modName;
        this._slotList = slotList;
    }

    public void setParent(EditForm parent) {
        this._parent = parent;
    }

    public void setPeer(SnmpPeer peer) {
        this._peer = peer;
        this._menu = null;
    }

    public static Array getASMSlots() {
        Array<Integer> asmCards = new Array<Integer>();
        int[] cardTypes = DmSystem.getCardTypes();
        for (int i = 0; i < cardTypes.length; ++i) {
            if (cardTypes[i] != 20 && cardTypes[i] != 5 && cardTypes[i] != 39) continue;
            asmCards.addElement(new Integer(i + 1));
        }
        return asmCards;
    }

    public Array getModules() {
        Array<Integer> slots = new Array<Integer>();
        int[] cardTypes = DmSystem.getCardTypes();
        int length = DmSystem.getCoreSwitchChassis().getNumberOfSlot();
        for (int i = 0; i < length && i < cardTypes.length; ++i) {
            if (cardTypes[i] == 0) continue;
            slots.addElement(new Integer(i + 1));
        }
        return slots;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._menu == null) {
            this._menu = new JMenu();
            Array slotList = this._slotList != null ? this._slotList : this.getModules();
            Object[] names = new String[slotList.size()];
            for (int i = 0; i < names.length; ++i) {
                names[i] = Integer.toString((Integer)slotList.elementAt(i));
            }
            if (names.length == 0) {
                this.setEnabled(false);
                return;
            }
            this.buildMenu(names);
        }
        super.actionPerformed(e);
        if (e.getSource() instanceof JMenuItem && this._parent != null) {
            this._parent.setChanged((FieldPanel)this.getParent());
        }
    }
}

