/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.GraphTable;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.vsif.VSifObj;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class VSifGraphTable
extends GraphTable {
    protected static final int NO_FILTER = 1;
    protected static final int FILTER_ON_BOUND_ETH_IFINDICES = 2;
    protected static final int FILTER_ON_VSIF_IFINDICES = 3;
    int[][] mFilterOnIfIndices;
    protected int mFilterType;
    int[][] mEthIfIndices;
    int mVSifIfType;

    public VSifGraphTable(String[] vars, int pVSifIfType) {
        super(vars);
        this.mVSifIfType = pVSifIfType;
    }

    @Override
    protected void doPoll() {
        this.prePoll();
        this._data = this.buildData();
        this._model.setData(this._data);
        this._pollVbl = this.buildPollPDU();
        super.doPoll();
    }

    public void prePoll() {
        block12: {
            if (this.mFilterType == 0) {
                int ifIndex = this._parent._multipleIndeces[0][0];
                if (ifIndex == 0) {
                    this.mFilterType = 1;
                } else {
                    int type = Discover.getRoot().getType(ifIndex);
                    if (2 == type || 26 == type || 31 == type) {
                        this.mFilterType = 2;
                    } else if (30 == type || 28 == type) {
                        this.mFilterType = 3;
                    } else {
                        throw new IllegalArgumentException("No support for filter on ifindex :" + ifIndex);
                    }
                    this.mFilterOnIfIndices = this._parent._multipleIndeces;
                }
            }
            try {
                int[][] ethIfIndices = this.mFilterType == 2 ? this.mFilterOnIfIndices : (int[][])null;
                List<Integer> vsifIfIndices = VSifObj.getVSifIfIndices(this.getPeer(), Discover.getRoot(), this.mVSifIfType, ethIfIndices);
                if (this.mFilterType == 3) {
                    ArrayList<Integer> tempVsifIfIndices = new ArrayList<Integer>();
                    int size = this.mFilterOnIfIndices.length;
                    for (int i = 0; i < size; ++i) {
                        if (!vsifIfIndices.contains(this.mFilterOnIfIndices[i][0])) continue;
                        tempVsifIfIndices.add(this.mFilterOnIfIndices[i][0]);
                    }
                    vsifIfIndices = tempVsifIfIndices;
                }
                int count = vsifIfIndices.size();
                this._parent._multipleIndeces = new int[count][1];
                for (int i = 0; i < count; ++i) {
                    this._parent._multipleIndeces[i][0] = vsifIfIndices.get(i);
                }
            }
            catch (SnmpException ex) {
                this._parent._multipleIndeces = new int[0][0];
                Util.errorMessage((Component)DeviceManager.getInstance(), ex.getMessage());
                if (!SnmpSession.isTrace()) break block12;
                DefaultLogger._DefLogger.debug((Object)ex);
            }
        }
    }
}

