/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.admin;

import com.cisco.dcbu.dm.DMDialog;
import com.cisco.dcbu.dm.DMPanel;
import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.DialogListener;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditFormTable;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.dialogs.ActionRenderer;
import com.cisco.dcbu.lib.jnm.IndexCellRenderer;
import com.cisco.dcbu.lib.jnm.JnmMibEnum;
import com.cisco.dcbu.lib.jnm.SnmpLongList;
import com.cisco.dcbu.lib.jnm.VshDumpAdv;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.mds.renderers.BackgroundRenderer;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellRenderer;

public class EditCFSTable
extends EditFormTable {
    private static final int NAME = 0;
    private static final int STATUS = 1;
    private static final int ACTION = 2;
    private static final int TYPE = 3;
    private static final int VSANID = 4;
    private static final int SHOW_CONFIG = 5;
    private static final int LAST_ACTION_STATUS = 6;
    private static final int ACTION_STATUS = 7;
    private static final int FAILURE_REASON = 8;
    static final int ACTION_RESULT_INPROGRESS = 4;
    static final int[] _cfsFeatureOpLastActionResultOid = MibNode.get("cfsFeatureOpLastActionResult").getOid();
    static final int[] _cfsFeatureOpLastFailureReasonOid = MibNode.get("cfsFeatureOpLastFailureReason").getOid();
    static final int[] _cfsFeatureOpStatusOid = MibNode.get("cfsFeatureOpStatus").getOid();
    static final int[] _cfsFeatureOpLastActionOid = MibNode.get("cfsFeatureOpLastAction").getOid();
    static final MibEnum[] _cfsFeatureOpShowCfgOptionEnum = MibNode.get("cfsFeatureOpShowCfgOption").getEnums();
    static final int SHOW_CONFIG_AS_RUNNING = 1;
    static final int SHOW_CONFIG_AS_PENDING = 2;
    Array _actionChangedCells = new Array();
    Array _otherChangedCells = new Array();
    boolean _isPolling = false;
    Timer _statusTimer;
    VshDumpAdv _showDiff;
    VshDumpAdv _showPending;
    private String[] _supportedFeatures = new String[]{"tacacs", "device-alias", "syslogd", "vsan"};
    private String[] _supported_CLIName_2x = new String[]{"tacacs+", "device-alias database", "logging", "fctimer"};
    private String[] _supported_CLIName = new String[]{"tacacs+", "device-alias", "logging", "fctimer"};
    private String[] _vsanCentricFeatures = new String[]{"port-security", "fc-port-security"};

    public EditCFSTable(String[] vars, String[] formVars) {
        super(vars, formVars);
    }

    @Override
    protected JComponent buildFormComponent(int index) {
        JCheckBox cb = new JCheckBox("Globally Enabled");
        cb.addItemListener(new DMPanel.ChangedFieldListener());
        return cb;
    }

    @Override
    protected void updateFormComponent(int index, SnmpVar v) {
        if (this._formVars == null) {
            return;
        }
        boolean isEnabled = ((SnmpInt)v).getValue() == 1;
        JCheckBox cb = (JCheckBox)this._formVars[index];
        cb.setSelected(isEnabled);
        cb.setFont(null);
    }

    @Override
    protected void formSet() throws Exception {
        if (this._formVars == null) {
            return;
        }
        boolean isSelected = ((JCheckBox)this._formVars[0]).isSelected();
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.addVar(new SnmpOID(MibNode.get("cfsDistCtrl").getOid(), 0), new SnmpInt(isSelected ? 1 : 2));
        this.sendPdu(pdu);
        ((JCheckBox)this._formVars[0]).setFont(null);
    }

    @Override
    protected boolean isWarnVar(String mibVar, Object value, String[] warningVars) {
        boolean ok = super.isWarnVar(mibVar, value, warningVars);
        return ok && !((JCheckBox)this._formVars[0]).isSelected();
    }

    @Override
    protected void build() {
        super.build();
        this._table.getColumnModel().getColumn(1).setCellRenderer(new BackgroundRenderer());
        this._table.removeColumn(this._table.getColumnModel().getColumn(8));
    }

    @Override
    protected void preGet() {
        this._actionChangedCells = null;
    }

    @Override
    protected Object[] buildRow(SnmpPDU pdu, int[] responseOid, int rowNo) {
        SnmpVar LastActionV = pdu.getVariables().get(5).getVar();
        SnmpVar actionStatusV = pdu.getVariables().get(6).getVar();
        String failureReason = pdu.getVariables().stringValue(7);
        Object[] row = super.buildRow(pdu, responseOid, rowNo);
        row[7] = MibVariableFormat.cfsFeatureOpLastActionResultAdv(LastActionV, actionStatusV, failureReason);
        return row;
    }

    @Override
    protected boolean isSkip(SnmpPDU pdu) {
        int[] oid = pdu.getVariables().get(0).getOid().getValue();
        if (SnmpOID.startsWith(oid, this._firstOid)) {
            return SnmpOID.equals(oid, this._firstOid.length, DmSystem.CFS_PORT_SECURITY_INDEX, 0) || SnmpOID.equals(oid, this._firstOid.length, DmSystem.CFS_PORT_SECURITY_INDEX_N7K, 0) || SnmpOID.equals(oid, this._firstOid.length, DmSystem.CFS_RSCN_INDEX, 0) || SnmpOID.equals(oid, this._firstOid.length, DmSystem.CFS_DMMGR_INDEX, 0) || SnmpOID.equals(oid, this._firstOid.length, DmSystem.CFS_SDV_INDEX, 0);
        }
        return false;
    }

    @Override
    protected Array getButtons() {
        Array btns = super.getButtons();
        btns.insertElementAt("Details...", 0);
        btns.insertElementAt("Pending Differences...", 1);
        btns.insertElementAt("Pending...", 2);
        return btns;
    }

    @Override
    protected void buildButtons() {
        super.buildButtons();
        this._buttons[0].setActionCommand("OW");
        this._buttons[1].setActionCommand("FD");
        this._buttons[2].setActionCommand("P");
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        boolean isSingleRowSelected = this._table.getSelectedRowCount() == 1;
        this.enableButton('O', isSingleRowSelected);
        if (DmSystem.getIsNPVMode()) {
            int row;
            TableCellRenderer renderer;
            Component component;
            if (isSingleRowSelected && (component = this._table.prepareRenderer(renderer = this._table.getCellRenderer(row = this._table.getSelectedRow(), 0), row, 0)) instanceof IndexCellRenderer) {
                this.enableButton('F', !((IndexCellRenderer)component).getText().equals("fctimer"));
            }
        } else {
            this.enableButton('F', isSingleRowSelected);
        }
        this.enableButton('P', isSingleRowSelected);
    }

    @Override
    protected void updateTable() {
        super.updateTable();
        this.enableButton('O', false);
        this.enableButton('F', false);
        this.enableButton('P', false);
    }

    @Override
    protected void buildTable() {
        super.buildTable();
        this._table.getColumnModel().getColumn(7).setCellRenderer(new ActionRenderer());
    }

    @Override
    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (ch == 'A') {
            if (this._table.isEditing()) {
                this._table.editingStopped(null);
            }
            if (this._actionChangedCells != null) {
                this._actionChangedCells.clear();
            }
            if (this._otherChangedCells != null) {
                this._otherChangedCells.clear();
            }
            this._otherChangedCells = this._tableModel.getChanged();
            if (this._otherChangedCells == null || this._otherChangedCells.size() == 0) {
                if (this._formVars != null && this._formVars[0].getFont() == ChangedCellRenderer.getChangeFont()) {
                    this.set();
                }
                return;
            }
            Array<Cell> prunedCells = new Array<Cell>();
            for (int i = this._otherChangedCells.size() - 1; i >= 0; --i) {
                Cell changedCell = (Cell)this._otherChangedCells.elementAt(i);
                if (changedCell._col != 2) continue;
                prunedCells.addElement(changedCell);
            }
            this._actionChangedCells = prunedCells;
            if (prunedCells.size() > 0) {
                if (this._statusTimer == null) {
                    this._statusTimer = new Timer(1000, this);
                }
                if (this._statusTimer.isRunning()) {
                    this._statusTimer.restart();
                } else {
                    this._statusTimer.start();
                }
                super.doIt(ch, e);
                this.doPoll();
                this._isPolling = true;
            } else {
                super.doIt(ch, e);
            }
        } else if (ch == 'F') {
            if (this._table.getSelectedRowCount() == 0 || this._table.getSelectedRow() == -1) {
                this.enableButton('F', false);
                return;
            }
            int[] oid = ((SnmpOID)this._tableModel.getValueAt(this._table.getSelectedRow(), 0)).getValue();
            String feature = SnmpString.toString(oid, 1, oid.length);
            if (Discover.isSysVersionlessThan("3.3(1)") && (feature.equals("isns") || feature.equals("ivr_du"))) {
                Util.errorMessage((Component)this._parent, feature + " does not support pending-diff.");
                return;
            }
            String cliCommand = feature;
            for (int i = 0; i < this._supportedFeatures.length; ++i) {
                if (!this._supportedFeatures[i].equals(feature)) continue;
                cliCommand = Discover.isSysVersionGreaterThanEqual("3.0(0)") ? this._supported_CLIName[i] : this._supported_CLIName_2x[i];
                break;
            }
            String[] cmds = new String[]{"show " + cliCommand + " pending-diff\n"};
            if (this._showDiff == null) {
                try {
                    this._showDiff = new VshDumpAdvShowDiff(DeviceManager.getInstance(), Discover.getDeviceName() + " - Show " + cliCommand + " pending-diff", cmds, Discover.getPeer());
                }
                catch (IOException ex) {
                    Util.errorMessage((Component)DeviceManager.getInstance(), ex);
                }
                this._showDiff.setLocation(DialogUtil.getPointOnScreen(new Point(0, 0), (JComponent)e.getSource(), this._showDiff.getSize()));
            } else {
                this._showDiff.setCmds(cmds);
            }
            this._showDiff.showDialog(this.getPeer(), "Show " + feature + " pending-diff");
        } else if (ch == 'P') {
            if (this._table.getSelectedRowCount() == 0 || this._table.getSelectedRow() == -1) {
                this.enableButton('P', false);
                return;
            }
            int[] oid = ((SnmpOID)this._tableModel.getValueAt(this._table.getSelectedRow(), 0)).getValue();
            String feature = SnmpString.toString(oid, 1, oid.length);
            if (Discover.isSysVersionlessThan("3.3(1)") && !feature.equals("dpvm") && !feature.equals("flex-attach")) {
                Util.errorMessage((Component)this._parent, feature + " does not support pending.");
                return;
            }
            String cliCommand = feature;
            for (int i = 0; i < this._supportedFeatures.length; ++i) {
                if (!this._supportedFeatures[i].equals(feature)) continue;
                cliCommand = Discover.isSysVersionGreaterThanEqual("3.0(0)") ? this._supported_CLIName[i] : this._supported_CLIName_2x[i];
                break;
            }
            String[] cmds = new String[]{"show " + cliCommand + " pending\n"};
            if (Discover.isSysVersionGreaterThanEqual("3.3(1)") && feature.equals("ntp")) {
                cmds[0] = "show ntp pending peers\n";
            }
            if (this._showPending == null) {
                try {
                    this._showPending = new VshDumpAdvShowDiff(DeviceManager.getInstance(), Discover.getDeviceName() + " - Show " + feature + " diff", cmds, Discover.getPeer());
                }
                catch (IOException ex) {
                    Util.errorMessage((Component)DeviceManager.getInstance(), ex);
                }
                this._showPending.setLocation(DialogUtil.getPointOnScreen(new Point(0, 0), (JComponent)e.getSource(), this._showPending.getSize()));
            } else {
                this._showPending.setCmds(cmds);
            }
            this._showPending.showDialog(this.getPeer(), "Show " + feature + " diff");
        } else if (ch == 'O') {
            int[] index = ((SnmpOID)this._tableModel.getValueAt(this._table.getSelectedRow(), 0)).getValue();
            String feature = SnmpString.toString(index, 1, index.length);
            DMDialog d = DialogListener.getInstance().dialogAction("CFS_Details", index);
            if (d != null) {
                d.setTitle(Discover.getDeviceName() + " - " + feature + " CFS");
            }
        } else {
            super.doIt(ch, e);
        }
    }

    @Override
    public void dispose() {
        this.stopPoll();
        if (this._showDiff != null) {
            this._showDiff.dispose();
        }
        if (this._showPending != null) {
            this._showPending.dispose();
        }
        super.dispose();
        DMDialog d = DialogListener.getInstance().getDialog("CFS_Details");
        if (d != null) {
            DialogListener.getInstance().remove("CFS_Details");
            d.dispose();
        }
    }

    private void stopPoll() {
        if (this._isPolling) {
            this._statusTimer.stop();
            this._isPolling = false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._statusTimer) {
            if (this._isPolling) {
                this.doPoll();
                return;
            }
        } else {
            super.actionPerformed(e);
        }
    }

    private void doPoll() {
        SnmpPDU respPDU;
        block10: {
            if (this._parent == null) {
                this.stopPoll();
                return;
            }
            if (this._actionChangedCells == null || this._actionChangedCells.size() == 0) {
                this.stopPoll();
                return;
            }
            SnmpPDU getPDU = new SnmpPDU(-96, new VarBindList());
            for (int i = this._actionChangedCells.size() - 1; i >= 0; --i) {
                Cell thisCell = (Cell)this._actionChangedCells.elementAt(i);
                if (thisCell == null || thisCell._row == -1 || thisCell._row >= this._data.size()) {
                    this._actionChangedCells.removeElementAt(i);
                    continue;
                }
                int[] index = this._tableModel.getIndex(thisCell._row, thisCell._col);
                getPDU.addVar(new SnmpVarBind(new SnmpOID(_cfsFeatureOpLastActionResultOid, index)));
                getPDU.addVar(new SnmpVarBind(new SnmpOID(_cfsFeatureOpLastFailureReasonOid, index)));
                getPDU.addVar(new SnmpVarBind(new SnmpOID(_cfsFeatureOpStatusOid, index)));
                getPDU.addVar(new SnmpVarBind(new SnmpOID(_cfsFeatureOpLastActionOid, index)));
            }
            respPDU = null;
            try {
                respPDU = this.getPeer().send(getPDU);
            }
            catch (SnmpException se) {
                if (!SnmpSession.isTrace()) break block10;
                se.printStackTrace();
            }
        }
        if (respPDU == null) {
            return;
        }
        VarBindList respList = respPDU.getVariables();
        for (int i = 0; i < respList.size(); i += 4) {
            int[] cellIndex;
            SnmpVarBind resp = respList.getVb(i);
            int actionResult = respList.intValue(i);
            int[] oid = resp.getOid().getValue();
            int[] index = new int[oid.length - _cfsFeatureOpLastActionResultOid.length];
            System.arraycopy(oid, _cfsFeatureOpLastActionResultOid.length, index, 0, index.length);
            Cell actionChangedCell = null;
            int j = 0;
            for (j = 0; !(j >= this._actionChangedCells.size() || (actionChangedCell = (Cell)this._actionChangedCells.elementAt(j)) != null && actionChangedCell._row != -1 && actionChangedCell._row < this._data.size() && SnmpOID.equals(index, cellIndex = this._tableModel.getIndex(actionChangedCell._row))); ++j) {
            }
            if (actionChangedCell == null) {
                return;
            }
            this._tableModel.setValueAt(MibEnum.getLabel(MibNode.get("cfsFeatureOpStatus").getEnums(), respList.intValue(i + 2)), actionChangedCell._row, 1);
            this._tableModel.setValueAt(MibVariableFormat.cfsFeatureOpLastAction(respList.getVb(i + 3).getVar()), actionChangedCell._row, 6);
            this._tableModel.setValueAt(MibVariableFormat.cfsFeatureOpLastActionResultAdv(respList.getVb(i + 3).getVar(), respList.getVb(i).getVar(), respList.stringValue(i + 1)), actionChangedCell._row, 7);
            this._table.calcPreferredSize();
            if (actionResult == 4) continue;
            this._actionChangedCells.removeElementAt(j);
            if (this._actionChangedCells.size() != 0) continue;
            this.stopPoll();
        }
    }

    @Override
    protected DmTableModel buildTableModel() {
        return new FeatureControlTableModel();
    }

    class VshDumpAdvShowDiff
    extends VshDumpAdv {
        public VshDumpAdvShowDiff(JFrame parent, String title, String[] cmds, SnmpPeer peer) throws IOException {
            super(parent, title, cmds, peer);
        }

        @Override
        public void dispose() {
            super.dispose();
            EditCFSTable.this._showDiff = null;
            EditCFSTable.this._showPending = null;
        }
    }

    class FeatureControlTableModel
    extends DmTableModel {
        boolean _isLastActionNone;

        FeatureControlTableModel() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isCellActive(int row, int col) {
            if (col == 3 || col == 4) {
                MibEnum action = (MibEnum)EditCFSTable.this._tableModel.getValueAt(row, 2);
                if (action.getLabel().equals("enable")) return false;
                if (action.getLabel().equals("disable")) {
                    return false;
                }
                int[] oid = ((SnmpOID)EditCFSTable.this._tableModel.getValueAt(row, 0)).getValue();
                String feature = SnmpString.toString(oid, 1, oid.length);
                if (!feature.equals("port-security")) {
                    if (!feature.equals("fcdomain")) return false;
                }
                if (col != 4) return super.isCellActive(row, col);
                Object o = this.getValueAt(row, 3);
                if (o == null) return false;
                if (((JnmMibEnum)o).getValue() != 2) return false;
                return true;
            }
            if (col != 5) return super.isCellActive(row, col);
            int[] oid = ((SnmpOID)EditCFSTable.this._tableModel.getValueAt(row, 0)).getValue();
            String feature = SnmpString.toString(oid, 1, oid.length);
            if (feature.equals("isns")) return false;
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            String action;
            if (col == 2 && ((action = ((MibEnum)aValue).getLabel()).equals("commit") || action.equals("abort") || action.equals("clear"))) {
                int value = 1;
                Object[] rows = (Object[])EditCFSTable.this._data.elementAt(row);
                this.setValueAt(new JnmMibEnum(_cfsFeatureOpShowCfgOptionEnum[value - 1].getLabel(), value, _cfsFeatureOpShowCfgOptionEnum), row, 5);
            }
            super.setValueAt(aValue, row, col);
        }

        @Override
        protected void assignCellValueSameClass(Object aValue, int row, int col, Object[] values) {
            if (col == 4) {
                byte[] b = ((SnmpLongList)aValue).getValue();
                if (b.length > 4) {
                    String msg = "(row=" + (row + 1) + ",col=" + (col + 1) + ")  Bad assignment: not a list";
                    Util.errorMessage((Component)EditCFSTable.this._parent, msg);
                } else {
                    super.assignCellValueSameClass(aValue, row, col, values);
                }
            } else if (col == 2) {
                int[] oid = ((SnmpOID)EditCFSTable.this._tableModel.getValueAt(row, 0)).getValue();
                String feature = SnmpString.toString(oid, 1, oid.length);
                if (feature.equals("isns") && !((MibEnum)aValue).getLabel().equals("enable") && !((MibEnum)aValue).getLabel().equals("disable")) {
                    String msg = "(row=" + (row + 1) + ",col=" + (col + 1) + ")  isns only support enable/disable";
                    Util.errorMessage((Component)EditCFSTable.this._parent, msg);
                } else {
                    super.assignCellValueSameClass(aValue, row, col, values);
                }
            } else {
                super.assignCellValueSameClass(aValue, row, col, values);
            }
        }

        @Override
        public SnmpPDU setChangedCells() throws Exception {
            if (EditCFSTable.this._otherChangedCells == null || EditCFSTable.this._otherChangedCells.size() == 0) {
                return null;
            }
            int preRow = -1;
            boolean setType = false;
            boolean setVSAN = false;
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(EditCFSTable.this._otherChangedCells.size()));
            for (int i = EditCFSTable.this._otherChangedCells.size() - 1; i >= 0; --i) {
                Cell cell = (Cell)EditCFSTable.this._otherChangedCells.elementAt(i);
                if (!this._mibNodes[cell._col].isEditable()) continue;
                int[] index = this.getIndex(cell._row, cell._col);
                SnmpOID oid = new SnmpOID(this._mibNodes[cell._col].getOid(), index);
                pdu.addVar(oid, this.getChangedCell(cell._row, cell._col));
                if (cell._row != preRow) {
                    setVSAN = false;
                    setType = false;
                }
                boolean bl = setType ? setType : (setType = cell._col == 3);
                boolean bl2 = setVSAN ? setVSAN : (setVSAN = cell._col == 4);
                if (cell._col == 2 && !((MibEnum)this.getValueAt(cell._row, 2)).getLabel().equals("enable") && !((MibEnum)this.getValueAt(cell._row, 2)).getLabel().equals("disable")) {
                    if (!setType) {
                        oid = new SnmpOID(this._mibNodes[3].getOid(), index);
                        pdu.addVar(oid, this.getChangedCell(cell._row, 3));
                    }
                    if (!setVSAN) {
                        oid = new SnmpOID(this._mibNodes[4].getOid(), index);
                        pdu.addVar(oid, this.getChangedCell(cell._row, 4));
                    }
                }
                preRow = cell._row;
            }
            return pdu;
        }
    }
}

