/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.admin;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.lib.mds.flash.FlashFileDialog;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.util.NetUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.Timer;

public class EditCopyImageBothWayForm
extends EditForm
implements ItemListener {
    static final int DIRECTION = 0;
    static final int SEPARATOR = 1;
    static final int PROTOCOL = 2;
    static final int SERVER = 3;
    static final int USER = 4;
    static final int PASS = 5;
    public static final int SRC = 6;
    static final int DEST = 7;
    public static final int RUNNING = 1;
    public static final int SUCCESSFUL = 2;
    public static final int FLASHTOFLASH = 4;
    static final String SRVER_LABEL = "Server File:";
    static final String SWITCH_LABEL = "Switch File:";
    static final String SWITCH_SRC_LABEL = "Switch Source File:";
    static final String SWITCH_DEST_LABEL = "Switch Destination File:";
    protected FlashFileDialog _fileDialog;
    SnmpPDU _ccStatusPDU;
    String _sourceFile = null;
    String _destDevice = null;
    int[] _index;
    protected Timer _statusTimer;
    int _elapsedPollTime;
    JLabel _sourceFileLabel;
    JLabel _destFileLabel;
    boolean _is6dot2_1 = Discover.isSysVersionGreaterThanEqual("6.2(0)");
    static final int[] ciscoFlashCopyRemotePasswordOid_pre_6_2_1 = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 10, 1, 2, 1, 1, 12};

    public EditCopyImageBothWayForm(String[] vars) {
        super(vars);
    }

    @Override
    protected void build() {
        super.build();
        RadioButtonPanel rbp = (RadioButtonPanel)this.getComponentAt(2);
        rbp.setSelected(0);
        rbp.addChangeListener(this);
        rbp.setFont(ChangedCellRenderer.getNormalFont());
        try {
            Discover.getInstance();
            String localAddr = NetUtil.detectSourceAddress(Discover.getPeer().getAddress()).getHostAddress();
            this.setComponentText(3, localAddr);
        }
        catch (Exception ex) {
            this.setComponentText(3, "");
        }
        this.getButton('R').setVisible(false);
        this.getButton('A').setEnabled(true);
        this.setEnabled(4, false);
        this.setEnabled(5, false);
        ((RadioButtonPanel)this.getComponentAt(0)).setSelected(0);
    }

    public void setFlashFile(FlashFileDialog dlg) {
        this._fileDialog = dlg;
    }

    public FlashFileDialog getFlashFile() {
        return this._fileDialog;
    }

    void setDefaultDest(String addr) {
        int splash = addr.lastIndexOf(47);
        if (splash == -1) {
            splash = addr.lastIndexOf(92);
        }
        if (splash != -1) {
            String fileName = addr.substring(splash + 1, addr.length());
            this.setComponentText(7, "bootflash:/" + fileName);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        int proto = ((RadioButtonPanel)this.getComponentAt(2)).getSelected();
        boolean b = proto > 0 && proto < 4;
        this.setEnabled(3, true);
        this.setEnabled(4, b);
        this.setEnabled(5, b);
        if (proto == 4) {
            this.setEnabled(3, false);
            if (this._sourceFile != null) {
                this.setComponentText(6, this._sourceFile);
            }
            FieldPanel srcField = (FieldPanel)this.getComponentAt(6);
            JPanel panel = (JPanel)srcField.getComponent();
            Component[] comps = panel.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                comps[i].setEnabled(false);
            }
            this._sourceFileLabel.setText(SWITCH_SRC_LABEL);
            this._destFileLabel.setText(SWITCH_DEST_LABEL);
            RadioButtonPanel rbdirection = (RadioButtonPanel)this.getComponentAt(0);
            rbdirection.getComponent(0).setEnabled(false);
            rbdirection.getComponent(1).setEnabled(false);
        } else {
            this.setComponentText(6, "");
            FieldPanel srcField = (FieldPanel)this.getComponentAt(6);
            JPanel panel = (JPanel)srcField.getComponent();
            Component[] comps = panel.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                comps[i].setEnabled(true);
            }
            this._sourceFileLabel.setText(SRVER_LABEL);
            this._destFileLabel.setText(SWITCH_LABEL);
            RadioButtonPanel rbdirection = (RadioButtonPanel)this.getComponentAt(0);
            rbdirection.getComponent(0).setEnabled(true);
            rbdirection.getComponent(1).setEnabled(true);
        }
    }

    public void setDestinationDevice(String str) {
        this._destDevice = str;
        this.setComponentText(7, this._destDevice);
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (mibVar.equals("ciscoFlashCopySourceName")) {
            this._sourceFileLabel = super.createFormLabel(mibVar, index);
            return this._sourceFileLabel;
        }
        if (mibVar.equals("ciscoFlashCopyDestinationName")) {
            this._destFileLabel = super.createFormLabel(mibVar, index);
            return this._destFileLabel;
        }
        if (index == 0) {
            return new JLabel("Direction:", 4);
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 0) {
            MibEnum[] enums = mibNode.getEnums();
            Object[] finalArr = new Object[2];
            enums[0].setLabel("Server -> Switch");
            enums[2].setLabel("Switch -> Server");
            finalArr[0] = enums[0];
            finalArr[1] = enums[2];
            int grid = this.getEnumGrid(index);
            if (finalArr.length < grid * 2) {
                grid = finalArr.length;
            }
            return new RadioButtonPanel(finalArr, grid);
        }
        if (index == 6) {
            JButton browse = new JButton("...");
            browse.addActionListener(this);
            browse.setMargin(DialogUtil.getInsets());
            JPanel pp = new JPanel();
            pp.add(browse);
            pp.add(new JLabel("(Path may need to be relative to xFTP root)"));
            FieldPanel fp = new FieldPanel(20, (JComponent)pp);
            fp.getField().addFocusListener(new SourceAdrListener());
            return fp;
        }
        if (index == 7) {
            JLabel eg = new JLabel("[device:][//partition][path]");
            FieldPanel fp = new FieldPanel(20, (JComponent)eg);
            fp.setText(this._destDevice == null || this._destDevice.length() == 0 ? "bootflash:/" : this._destDevice);
            return fp;
        }
        if (index == 5) {
            return new JPasswordField();
        }
        if (index == 2) {
            MibEnum[] enums = mibNode.getEnums();
            Object[] finalArr = new Object[enums.length + 1];
            System.arraycopy(enums, 0, finalArr, 0, enums.length);
            finalArr[finalArr.length - 1] = "flashToFlash";
            int grid = this.getEnumGrid(index);
            if (finalArr.length < grid * 2) {
                grid = finalArr.length;
            }
            return new RadioButtonPanel(finalArr, grid);
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected void get() {
    }

    @Override
    protected void addChangeListener(int index) {
    }

    @Override
    protected void set() throws Exception {
        this._index = new int[1];
        this._index[0] = (int)(Math.random() * 2.14748364E8) + 1;
        this._ccStatusPDU = null;
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.addVar(new SnmpOID(MibNode.get("ciscoFlashCopyEntryStatus").getOid(), this._index), new SnmpInt(5));
        int selected = ((RadioButtonPanel)this._values[0]).getSelected();
        for (int i = 0; i < this._mibNodes.length; ++i) {
            if (this._mibNodes[i] == null || !this._mibNodes[i].isEditable() || !this.getComponentAt(i).isEnabled()) continue;
            if (selected == 1 && i == 6) {
                pdu.addVar(new SnmpOID(this._mibNodes[i].getOid(), this._index), this.getComponentValue(7));
                continue;
            }
            if (selected == 1 && i == 7) {
                pdu.addVar(new SnmpOID(this._mibNodes[i].getOid(), this._index), this.getComponentValue(6));
                continue;
            }
            if (i == 5) {
                pdu.addVar(new SnmpOID(this._is6dot2_1 ? this._mibNodes[i].getOid() : ciscoFlashCopyRemotePasswordOid_pre_6_2_1, this._index), this.getComponentValue(i));
                pdu.setVarBindMask(new int[]{pdu.getVariables().size() - 1});
                continue;
            }
            pdu.addVar(new SnmpOID(this._mibNodes[i].getOid(), this._index), this.getComponentValue(i));
        }
        pdu.setIgnoreSetCount(true);
        this.sendPdu(pdu);
        pdu = new SnmpPDU(-93, new VarBindList());
        pdu.addVar(new SnmpOID(MibNode.get("ciscoFlashCopyEntryStatus").getOid(), this._index), new SnmpInt(1));
        pdu.setIgnoreSetCount(true);
        this.sendPdu(pdu);
        this._parent.setCursor(Cursor.getPredefinedCursor(3));
        this._ccStatusPDU = new SnmpPDU(-96, new VarBindList());
        this._ccStatusPDU.addNull(new SnmpOID(MibNode.get("ciscoFlashCopyStatus").getOid(), this._index));
        this._elapsedPollTime = 0;
        this._statusTimer = new Timer(3000, this);
        this._statusTimer.start();
        this.enableButton('A', false);
    }

    void pollSwitch() throws Exception {
        if (this._parent == null) {
            return;
        }
        SnmpPDU resp = this.getPeer().send(this._ccStatusPDU);
        if (resp.getVar(0).getType() == 5) {
            throw new Exception("Copy Config failed: unknown");
        }
        int state = ((SnmpInt)resp.getVar(0)).getValue();
        if (state == 1) {
            this.setStatus(this._elapsedPollTime + " secs");
            return;
        }
        this.stopPolling();
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.addVar(new SnmpOID(MibNode.get("ciscoFlashCopyEntryStatus").getOid(), this._index), new SnmpInt(6));
        pdu.setIgnoreSetCount(true);
        this.getPeer().set(pdu);
        if (state != 2) {
            this.setStatus(" ");
            throw new Exception("Failed: " + MibEnum.getLabel(MibNode.get("ciscoFlashCopyStatus").getEnums(), state));
        }
        this.setStatus("File transfer successful [" + this._elapsedPollTime + " secs]");
    }

    void stopPolling() {
        this._statusTimer.stop();
        this._parent.setCursor(Cursor.getDefaultCursor());
        this.enableButton('A', true);
    }

    @Override
    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (e.getSource() == this._statusTimer) {
            try {
                this._elapsedPollTime += 3;
                this.pollSwitch();
            }
            catch (Exception ex) {
                this.stopPolling();
                throw ex;
            }
        } else if (ch == '.') {
            String fName = Util.getFileName(DeviceManager.getInstance(), "*.*", 0, true);
            if (fName != null) {
                this.setComponentText(6, fName);
            }
        } else if (ch == 'A') {
            int proto;
            if (this._fileDialog != null && (proto = ((RadioButtonPanel)this.getComponentAt(2)).getSelected()) == 4) {
                String dest;
                String source = this.getComponentText(6);
                ArrayList result = this._fileDialog.copy(source, dest = this.getComponentText(7));
                String resultString = result.get(1).toString();
                if (resultString != null && resultString.trim().length() == 0) {
                    resultString = "File copy failed.";
                }
                if (!((Boolean)result.get(0)).booleanValue()) {
                    this.setStatus("Success");
                } else {
                    this.setStatus("");
                    Util.errorMessage((Component)this._parent, resultString);
                }
                return;
            }
            super.doIt(ch, e);
        } else {
            super.doIt(ch, e);
        }
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        try {
            if (index == 0) {
                int selected = ((RadioButtonPanel)this._values[index]).getSelected();
                if (selected == 0) {
                    return new SnmpInt(1);
                }
                return new SnmpInt(3);
            }
            if (index == 6 && ((FieldPanel)this._values[index]).getText().equals("")) {
                throw new Exception("Please provide Source Name.");
            }
            return super.getComponentValue(index);
        }
        catch (Exception ex) {
            if (index == 3) {
                String server = ((JTextField)this._values[index]).getText();
                try {
                    InetAddress addr = InetAddress.getByName(server);
                    return new SnmpIpAddress(addr.getHostAddress());
                }
                catch (Exception ex2) {
                    throw ex;
                }
            }
            if (index == 2) {
                int selected = ((RadioButtonPanel)this._values[index]).getSelected();
                if (selected == 4) {
                    return new SnmpInt(1);
                }
                throw ex;
            }
            throw ex;
        }
    }

    public void setSource(String text) {
        this._sourceFile = text;
    }

    class SourceAdrListener
    extends FocusAdapter {
        SourceAdrListener() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            String addr = EditCopyImageBothWayForm.this.getComponentText(6);
        }
    }
}

