/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.admin;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dmdb.andiamo.dialogs.mds9020.QlogicCommandHandlerDM;
import com.cisco.dcbu.lib.jnm.VshDumpAdv;
import com.cisco.dcbu.lib.mds.CopyConfigUtil;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.InetAddress;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class SaveConfiguration
extends JDialog
implements ActionListener {
    static final int POLL_INTERVAL = 3000;
    int _elapsedSecs;
    SnmpPeer _peer;
    JFrame _parent;
    InetAddress _address;
    SnmpPDU _ccStatusPDU;
    int[] _index;
    protected Timer _statusTimer;
    JLabel _message;
    JButton[] _buttons;
    boolean _isQuail;
    private boolean _isCancel;
    private boolean _showConfirmationDlg;

    public SaveConfiguration(JFrame parent, SnmpPeer peer, int messageLevel, boolean isQuail) {
        this(parent, peer, messageLevel, isQuail, true);
    }

    public SaveConfiguration(JFrame parent, SnmpPeer peer, int messageLevel, boolean isQuail, boolean showConfirmationDlg) {
        super(parent, Discover.getDeviceName() + " - Save Configuration", true);
        this._parent = parent;
        this._peer = peer;
        this._address = peer.getAddress();
        this._isQuail = isQuail;
        this._showConfirmationDlg = showConfirmationDlg;
        JPanel main = new JPanel(new BorderLayout());
        main.setBorder(DialogUtil._Margin);
        this._message = messageLevel == 1 ? new JLabel("Really save running to startup configuration?", Util.loadIcon("icons/Warn.gif"), 0) : new JLabel("<html>You have made changes that may change the running configuration.<br>Do you want to save those changes to startup configuration?</html>", Util.loadIcon("icons/Warn.gif"), 0);
        this._message.setBorder(DialogUtil._Margin);
        main.add((Component)this._message, "West");
        String[] bLabels = new String[]{"Yes", "No", "Cancel", "Details..."};
        JPanel btnPanel = new JPanel(new FlowLayout(1, 6, 3));
        this._buttons = DialogUtil.buildButtons(bLabels, (ActionListener)this);
        for (int i = 0; i < this._buttons.length; ++i) {
            btnPanel.add(this._buttons[i]);
        }
        main.add((Component)btnPanel, "South");
        this.getContentPane().add(main);
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(this._parent);
        this.setResizable(true);
        if (!this._showConfirmationDlg) {
            this.saveConfig();
        }
    }

    @Override
    public void dispose() {
        if (this._statusTimer != null) {
            this._statusTimer.stop();
        }
        super.dispose();
    }

    void saveConfig() {
        boolean failed = false;
        try {
            this._message.setText("Saving...");
            this._buttons[0].setVisible(false);
            if (!this._showConfirmationDlg) {
                this._buttons[1].setVisible(false);
                this._buttons[2].setVisible(false);
                this._buttons[3].setVisible(false);
            }
            if (this._isQuail) {
                QlogicCommandHandlerDM cmdHandler = QlogicCommandHandlerDM.getInstance(DeviceManager.getInstance(), Discover.getPeer());
                cmdHandler.saveConfig();
            } else {
                Discover.getInstance();
                this._index = CopyConfigUtil.CopyConfig(this._peer, 4, 3, null, null, -1, null, null, Discover.getSysVersionWithMinor());
                this._ccStatusPDU = CopyConfigUtil.getCopyConfigStatusPDU(this._index);
                this._statusTimer = new Timer(3000, this);
                this._statusTimer.start();
            }
        }
        catch (Exception ex) {
            this._message.setText(ex.getMessage());
            failed = true;
        }
        if (this._isQuail && !failed) {
            this._peer.resetNumSets();
            this._message.setText("Success. Please close dialog.");
        }
    }

    void pollSwitch() throws Exception {
        if (!this._peer.getAddress().equals(this._address)) {
            this._statusTimer.stop();
            return;
        }
        SnmpPDU resp = this._peer.send(this._ccStatusPDU);
        int state = ((SnmpInt)resp.getVar(0)).getValue();
        if (state == 1 || state == 2) {
            this._message.setText("Saving... [" + this._elapsedSecs + " secs]");
            return;
        }
        this._statusTimer.stop();
        CopyConfigUtil.deleteCopyConfigEntry(this._peer, this._index);
        if (state == 3) {
            this._message.setText("Success.  Please close dialog.");
            this._buttons[1].setText("Close");
            this._peer.resetNumSets();
            if (!this._showConfirmationDlg) {
                this._buttons[1].doClick();
            }
        } else if (state == 4) {
            String msg = "Failed: " + MibEnum.getLabel(MibNode.get("ccCopyFailCause").getEnums(), ((SnmpInt)resp.getVar(1)).getValue());
            this._message.setText(msg);
        }
    }

    public boolean isCancel() {
        return this._isCancel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof AbstractButton) {
            String cmd = ((AbstractButton)e.getSource()).getActionCommand();
            switch (cmd.charAt(0)) {
                case 'Y': {
                    this._isCancel = false;
                    this.saveConfig();
                    this._buttons[1].setText(this._isQuail ? "Close" : "Cancel");
                    this._buttons[2].setVisible(false);
                    this._buttons[3].setVisible(false);
                    break;
                }
                case 'N': {
                    this._isCancel = false;
                    this.dispose();
                    break;
                }
                case 'C': {
                    this._isCancel = !cmd.equals("Close");
                    this.dispose();
                    break;
                }
                case 'D': {
                    this._isCancel = true;
                    String[] cmds = new String[]{"Show running diff\n"};
                    try {
                        VshDumpAdv showRunningDiff = new VshDumpAdv(DeviceManager.getInstance(), Discover.getDeviceName() + " - Show Running and Startup Config Differences", cmds, Discover.getPeer());
                        showRunningDiff.showDialog(this._peer, "Show Running and Startup Config Differences");
                    }
                    catch (IOException ex) {
                        Util.errorMessage((Component)DeviceManager.getInstance(), ex);
                        ex.printStackTrace();
                    }
                    this.dispose();
                }
            }
        } else {
            try {
                this._elapsedSecs += 3;
                this.pollSwitch();
            }
            catch (Exception ex) {
                this._statusTimer.stop();
                this._isCancel = true;
                this._message.setText(ex.getMessage());
            }
        }
    }
}

