/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.event;

import com.cisco.dcbu.dmdb.andiamo.dialogs.EditCFSFuncForm;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import javax.swing.JTextField;

public class EditCallHomeForm
extends EditCFSFuncForm {
    int _addrPos;
    int _addrTypePos;
    int _addrType = 1;
    int[] _AddrTypeOid = MibNode.get("callHomeSmtpServerAddrType").getOid();

    public EditCallHomeForm(String[] vars) {
        super(vars);
        this._addrPos = this.getVarIndex("callHomeSmtpServerAddr");
        this._addrTypePos = this.getVarIndex("callHomeSmtpServerAddrType");
    }

    @Override
    protected void setComponentValue(int i, SnmpVar v) {
        if (i == this._addrPos) {
            if (this._addrType == 1 || this._addrType == 2) {
                ((JTextField)this._values[i]).setText(SnmpIpAddress.toString(((SnmpString)v).getValue()));
            } else {
                ((JTextField)this._values[i]).setText(v.toString());
            }
        } else {
            if (i == this._addrTypePos) {
                this._addrType = ((SnmpInt)v).getValue();
            }
            super.setComponentValue(i, v);
        }
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == this._addrPos) {
            String serverAddr = this.getComponentText(index);
            if (this._mibNodes[index].getMaxWidth() < serverAddr.length()) {
                throw new NumberFormatException(this.trim(this._vars[index]) + " maximum length is " + this._mibNodes[index].getMaxWidth());
            }
            if (this._mibNodes[index].getMinWidth() > serverAddr.length()) {
                throw new NumberFormatException(this.trim(this._vars[index]) + " minimum length is " + this._mibNodes[index].getMinWidth());
            }
            this._addrType = ((SnmpInt)this.getComponentValue(this._addrTypePos)).getValue();
            if (this._addrType == 1 || this._addrType == 2) {
                byte[] addrB = SnmpIpAddress.parse(serverAddr);
                return new SnmpString(addrB);
            }
            return new SnmpString(serverAddr);
        }
        return super.getComponentValue(index);
    }
}

