/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.fc;

import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import javax.swing.JOptionPane;

public class EditTimersTable
extends EditTable {
    static final int RATOV = 1;
    static final int DSTOV = 2;
    static final int EDTOV = 3;
    private static final int NETWORK_LATENCY = 4;
    int[] _forceFlag = new int[]{0, 1, 3, 2};
    int[] _vsanFcTimerForceFlagOid = MibNode.get("vsanFcTimerForceFlag").getOid();

    public EditTimersTable(String[] vars) {
        super(vars);
    }

    protected boolean validateChanges(Array cells, String[] mibVars, String message) {
        Object[] options = new String[]{"Continue", "Cancel"};
        int[] ratovVar = MibNode.get(mibVars[0]).getOid();
        int[] dstovVar = MibNode.get(mibVars[1]).getOid();
        int[] edtovVar = MibNode.get(mibVars[2]).getOid();
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            int[] index = this._tableModel.getIndex(cell._row);
            SnmpOID oid = new SnmpOID(this._mibNodes[cell._col].getOid(), index);
            if (!oid.startsWith(ratovVar) && !oid.startsWith(edtovVar) && !oid.startsWith(dstovVar)) continue;
            return JOptionPane.showOptionDialog(this.getParent(), message, this.getParent().getTitle(), -1, 2, null, options, options[0]) != 1;
        }
        return true;
    }

    @Override
    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        int i;
        Array changedCells = this._tableModel.getChanged();
        Array<SnmpVarBind> swapVarBind = new Array<SnmpVarBind>();
        int preRow = -1;
        byte[] b = new byte[1];
        SnmpVarBind flagVb = null;
        boolean isCFObjects = false;
        for (i = pdu.getVariables().size() - 1; i >= 0; --i) {
            SnmpVarBind vb = pdu.getVariables().get(i);
            Cell cell = (Cell)changedCells.elementAt(i);
            Object[] values = (Object[])this._data.elementAt(cell._row);
            Object[] changed = (Object[])values[this._tableModel.getHeaders().length];
            boolean isSwap = false;
            if (cell._col < 4) {
                isCFObjects = true;
            }
            if (cell._col == 3 && i > 0) {
                int[] index = this._tableModel.getIndex(cell._row);
                Cell nextCell = (Cell)changedCells.elementAt(i - 1);
                int[] nextIndex = this._tableModel.getIndex(nextCell._row);
                SnmpVarBind nextVb = pdu.getVariables().get(i - 1);
                if (nextCell._col == 2 && SnmpOID.equals(index, nextIndex)) {
                    SnmpVar oldEdtov;
                    SnmpVar newDstov = (SnmpVar)this._tableModel.getValueAt(cell._row, 2);
                    SnmpVar snmpVar = oldEdtov = (SnmpVar)changed[3] != null ? (SnmpVar)changed[3] : (SnmpVar)this._tableModel.getValueAt(cell._row, 3);
                    if (this.isSwap(newDstov, oldEdtov)) {
                        swapVarBind.addElement(vb);
                        swapVarBind.addElement(nextVb);
                        pdu.removeVarAt(i--);
                        pdu.removeVarAt(i);
                        isSwap = true;
                    }
                }
            }
            if (cell._col != 1 && cell._col != 3 && cell._col != 2) continue;
            if (cell._row != preRow && preRow != -1) {
                pdu.getVariables().add(0, flagVb);
                b = new byte[1];
            }
            SnmpString.setBit(b, this._forceFlag[cell._col]);
            if (cell._col == 3 && isSwap) {
                SnmpString.setBit(b, this._forceFlag[2]);
            }
            flagVb = new SnmpVarBind(new SnmpOID(this._vsanFcTimerForceFlagOid, this._tableModel.getIndex(cell._row)), new SnmpString(b));
            preRow = cell._row;
        }
        if (flagVb != null) {
            pdu.getVariables().add(0, flagVb);
        }
        if (swapVarBind.size() > 0) {
            for (i = 0; i < swapVarBind.size(); ++i) {
                pdu.addVar((SnmpVarBind)swapVarBind.elementAt(i));
            }
        }
        super.sendPdu(pdu);
        if (isCFObjects) {
            this.setCFSPending(this.getPeer());
        }
    }

    boolean isSwap(SnmpVar newDstov, SnmpVar oldEdtov) {
        return ((SnmpUnsignedInt)newDstov).getValue() < ((SnmpUnsignedInt)oldEdtov).getValue();
    }

    @Override
    protected boolean isSkip(SnmpPDU pdu) {
        int[] oid = pdu.getVariables().get(0).getOid().getValue();
        return oid[oid.length - 1] == 4094;
    }

    @Override
    protected DmTableModel buildTableModel() {
        return new SnmpFCTimerTableModel();
    }

    static class SnmpFCTimerTableModel
    extends DmTableModel {
        SnmpFCTimerTableModel() {
        }

        @Override
        protected SnmpVar getChangedCell(int row, int col) throws Exception {
            if (col == 3) {
                Object edtov = this.getValueAt(row, col);
                Object dstov = this.getValueAt(row, 2);
                if (((SnmpGauge)edtov).getValue() < ((SnmpGauge)dstov).getValue()) {
                    return super.getChangedCell(row, col);
                }
                throw new Exception(this.getHeaders()[col] + " not in range");
            }
            return super.getChangedCell(row, col);
        }
    }
}

