/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.fc;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.lib.mds.MdsPortChooser;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.mds.VsanIdMenuButton;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.FieldPanel;
import javax.swing.JComponent;

public class InsertFCRoute
extends InsertForm {
    private static final int VSANID = 0;
    private static final int INTERFACE = 3;
    private static final int ADDRESS = 1;
    private static final int MASK = 2;
    MdsPortChooser _ports;

    public InsertFCRoute(InsertDialog parent, EditTable table) {
        super(parent, table);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 0) {
            FieldPanel f = new FieldPanel(5, (JComponent)new VsanIdMenuButton(null, this.getPeer(), Discover.getRoot()));
            f.setRange(1, 4093);
            return f;
        }
        if (index == 3) {
            this._ports = new MdsPortChooser(Discover.getDeviceName(), 3, true, Discover.getRoot(), DmSystem.getCardAttributes(), new PortEditorFilter(new int[]{1, 153, 152}), this.getPeer(), 6);
            return this._ports;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        int[] index = super.getInsertIndex(values);
        int[] newIndex = new int[index.length + 1];
        System.arraycopy(index, 0, newIndex, 0, index.length - 1);
        newIndex[index.length - 1] = 3;
        System.arraycopy(index, index.length - 1, newIndex, newIndex.length - 1, 1);
        return newIndex;
    }

    @Override
    protected SnmpVar[] getInsertValue() throws Exception {
        SnmpVar[] returnArr = super.getInsertValue();
        String destAdd = ((SnmpString)returnArr[1]).toString();
        String destMask = ((SnmpString)returnArr[2]).toString();
        byte[] b = this.returnMaskArray(destMask, new byte[]{-1, -1, -1});
        returnArr[1] = new SnmpString(this.returnMaskArray(destAdd, b));
        return returnArr;
    }

    private byte[] returnMaskArray(String toMask, byte[] maskWith) throws Exception {
        int toMaskInt = Integer.parseInt(toMask.startsWith("0x") ? toMask.substring(2) : toMask, 16);
        if (toMaskInt < 0 || toMaskInt > 0xFFFFFF) {
            throw new NumberFormatException("Invalid input");
        }
        byte[] returnMask = new byte[3];
        returnMask[2] = (byte)(toMaskInt & maskWith[2]);
        returnMask[1] = (byte)(toMaskInt >> 8 & maskWith[1]);
        returnMask[0] = (byte)(toMaskInt >> 16 & maskWith[0]);
        return returnMask;
    }

    @Override
    public void dispose() {
        if (this._ports != null) {
            this._ports.dismiss();
        }
        super.dispose();
    }
}

