/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.fc;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.lib.jnm.SnmpFcAddressId;
import com.cisco.dcbu.lib.mds.VsanIdMenuButton;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.FieldPanel;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class InsertRouteFlow
extends InsertForm {
    private static final int MODULE = 0;
    private static final int IS_USE_DESTID = 2;
    private static final int VSANID = 3;

    public InsertRouteFlow(InsertDialog parent, EditTable table) {
        super(parent, table);
    }

    @Override
    protected void build() {
        super.build();
        this.setComponentText(1, "1");
        this.setComponentText(3, "1");
        this.setComponentText(6, "0xffffff");
        ((JCheckBox)this.getComponentAt(2)).addActionListener(this);
        for (int i = 4; i <= 6; ++i) {
            this.setEnabled(i, false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JCheckBox) {
            boolean isSelected = ((JCheckBox)e.getSource()).isSelected();
            this.setEnabled(4, isSelected);
            this.setEnabled(5, isSelected);
            this.setEnabled(6, isSelected);
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        int numberOfSlot = DmSystem.getCoreSwitchChassis().getNumberOfSlot();
        if (index == 0) {
            return new FieldPanel(3, 1, numberOfSlot, null);
        }
        if (index == 2) {
            return new JCheckBox("Use DestId, SrcId");
        }
        if (index == 3) {
            FieldPanel f = new FieldPanel(5, (JComponent)new VsanIdMenuButton(null, this.getPeer(), Discover.getRoot()));
            f.setRange(1, 4093);
            return f;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 2) {
            byte[] b = new byte[1];
            int len = ((JCheckBox)this._values[index]).isSelected() ? 3 : 1;
            int[] selected = new int[len];
            selected[0] = 1;
            if (len > 1) {
                selected[1] = 2;
                selected[2] = 3;
            }
            for (int i = 0; i < selected.length; ++i) {
                SnmpString.setBit(b, selected[i]);
            }
            return new SnmpString(b);
        }
        return super.getComponentValue(index);
    }

    @Override
    protected SnmpVar getVarFromString(String text, int index) throws Exception, NumberFormatException {
        SnmpVar v = index == 4 || index == 5 || index == 6 ? new SnmpFcAddressId(text) : super.getVarFromString(text, index);
        if (index == 0) {
            SnmpInt i = (SnmpInt)v;
            i.setValue(i.getValue() + 21);
        }
        return v;
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 0) {
            return new JLabel("Module:", 4);
        }
        return super.createFormLabel(mibVar, index);
    }
}

