/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.fcip;

import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dmdb.andiamo.dialogs.fc.EditIfPortForm;
import com.cisco.dcbu.dmdb.andiamo.dialogs.fcip.EditFcipIfTable;
import com.cisco.dcbu.lib.mds.renderers.PortIndexRenderer;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;

public class EditFcipIfConfigTable
extends EditFcipIfTable {
    static final int TRUNKADMIN = 1;
    static final int TRUNKOPER = 2;
    static final int ALLOWVSAN = 3;
    static final int ACTIVEVSAN = 4;

    public EditFcipIfConfigTable(String[] vars) {
        super(vars);
    }

    public EditFcipIfConfigTable(String[] vars, boolean isGigEFcip) {
        super(vars);
        this._isGigEFcip = isGigEFcip;
    }

    @Override
    protected void build() {
        super.build();
        this._table.getColumnModel().getColumn(0).setCellRenderer(new PortIndexRenderer(this.getPeer()));
    }

    @Override
    protected void sendGetPdu(SnmpPDU pdu) throws SnmpException {
        int[] oid = pdu.getVariables().get(3).getOid().getValue();
        int[] index = new int[]{oid[EditIfPortForm._allowed2kOid.length]};
        pdu = EditIfPortForm.addVsan4kVar(pdu, index, 3);
        super.sendGetPdu(pdu);
    }

    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        if (!timedOut) {
            SnmpVarBind vb = pdu.getVariables().get(0);
            if (this._state == -95 && !this.isEnd(this._firstOid, vb) || this._state == -96) {
                pdu = EditIfPortForm.appendVsan4kTo2kVar(pdu, 1, 2, pdu.getVariables().size() - 2, 3, pdu.getVariables().size() - 1, true);
            }
        }
        super.callback(session, reqid, pdu, timedOut);
    }

    @Override
    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        pdu = EditIfPortForm.splitVar2k4k(pdu, 1);
        this.getPeer().set(pdu);
    }

    @Override
    protected DmTableModel buildTableModel() {
        return new SnmpFcipInterfaceTableModel();
    }

    static class SnmpFcipInterfaceTableModel
    extends DmTableModel {
        SnmpFcipInterfaceTableModel() {
        }

        @Override
        public boolean isCellActive(int row, int col) {
            if (col == 3 || col == 4) {
                Object trunkAdmin = this.getValueAt(row, 1);
                return trunkAdmin != null && (trunkAdmin.toString().charAt(0) == 't' || trunkAdmin.toString().charAt(0) == 'a');
            }
            return super.isCellActive(row, col);
        }
    }
}

