/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.ficon;

import com.cisco.dcbu.dm.DMDialog;
import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.DialogListener;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.ficon.EditFICONPortTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.ficon.InsertFICONFile;
import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.InetAddress;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;

public class EditFICONFileTable
extends EditTable {
    private static final String[][] BTNS = new String[][]{{"Open...", "X"}, {"Apply File", "x"}, {"Copy...", "1"}};
    private static final int FILE_DESCR = 1;
    public static final int MAX_FILES = 16;
    static final int DISCRIPTION = 1;
    static final int CUP_NAME = 2;
    static final int STATUS = 3;
    static final int USER_ALERT_MODE = 5;
    static final int[] _cficonVsanUserAlertModeOid = MibNode.get("cficonVsanUserAlertMode").getOid();
    static final int[] _cficonCfgFileCupNameOid = MibNode.get("cficonCfgFileCupName").getOid();
    protected Timer _statusTimer;
    static final int POLL_INTERVAL = 3000;
    int _elapsedSecs;
    InetAddress _address;
    SnmpPDU _ccStatusPDU;
    static final int SUCCESS = 1;
    static final int INPROGRESS = 2;
    static final int FAILED = 3;
    static final int NOTAPPLICABLE = 4;
    int[] _cficonCfgFileCmdStatusOid = MibNode.get("cficonCfgFileCmdStatus").getOid();
    int[] _cficonCfgFileCmdErrorStringOid = MibNode.get("cficonCfgFileCmdErrorString").getOid();

    public EditFICONFileTable(String[] vars) {
        super(vars);
    }

    @Override
    protected void buildTable() {
        super.buildTable();
        boolean[] isEditable = this._tableModel.getEditable();
        isEditable[5] = false;
        isEditable[2] = true;
        this._tableModel.setEditable(isEditable);
        this._address = this.getPeer().getAddress();
    }

    @Override
    protected Array getButtons() {
        Array btns = super.getButtons();
        for (int i = BTNS.length - 1; i >= 0; --i) {
            btns.insertElementAt(BTNS[i][0], 0);
        }
        return btns;
    }

    @Override
    protected void buildButtons() {
        super.buildButtons();
        for (int i = 0; i < BTNS.length; ++i) {
            this._buttons[i].setActionCommand(BTNS[i][1]);
        }
    }

    @Override
    protected void updateTable() {
        super.updateTable();
        this.valueChanged(null);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        boolean isSingleRowSelected = this._table.getSelectedRow() != -1 && this._table.getSelectedRowCount() == 1;
        this.enableButton('X', isSingleRowSelected);
        this.enableButton('x', isSingleRowSelected);
        this.enableButton('1', isSingleRowSelected);
        if (this.getStatus().startsWith("Apply")) {
            this.setStatus(" ");
        }
    }

    @Override
    protected void postProcessing() throws SnmpException {
        int i;
        Array<SnmpPDU> pduArray = new Array<SnmpPDU>();
        Array<SnmpPDU> cpuNamePduArray = new Array<SnmpPDU>();
        int preVsan = -1;
        for (int i2 = 0; i2 < this._data.size(); ++i2) {
            SnmpPDU pdu;
            Object[] row = (Object[])this._data.elementAt(i2);
            int vsan = ((SnmpOID)row[0]).getValue()[0];
            if (vsan != preVsan) {
                pdu = new SnmpPDU(-96, new VarBindList(1));
                pdu.addVar(new SnmpVarBind(new SnmpOID(_cficonVsanUserAlertModeOid, vsan), null));
                pduArray.addElement(pdu);
                preVsan = vsan;
            }
            pdu = new SnmpPDU(-96, new VarBindList(1));
            pdu.addVar(new SnmpVarBind(new SnmpOID(_cficonCfgFileCupNameOid, ((SnmpOID)row[0]).getValue()), null));
            cpuNamePduArray.addElement(pdu);
            row[5] = "false";
            row[2] = new SnmpString("");
        }
        VarBindList vbl = new VarBindList(pduArray.size());
        for (int i3 = 0; i3 < pduArray.size(); ++i3) {
            SnmpPDU resp = this.getPeer().send((SnmpPDU)pduArray.elementAt(i3));
            vbl.add(resp.getVariables().get(0));
        }
        VarBindList cupNameVbl = new VarBindList(cpuNamePduArray.size());
        for (i = 0; i < cpuNamePduArray.size(); ++i) {
            SnmpPDU resp = this.getPeer().send((SnmpPDU)cpuNamePduArray.elementAt(i));
            cupNameVbl.add(resp.getVariables().get(0));
        }
        for (i = 0; i < vbl.size(); ++i) {
            int reqVsan = vbl.get(i).getOid().getValue()[_cficonVsanUserAlertModeOid.length];
            for (int j = 0; j < this._data.size(); ++j) {
                Object[] row = (Object[])this._data.elementAt(j);
                int rowVsan = ((SnmpOID)row[0]).getValue()[0];
                if (rowVsan == reqVsan) {
                    row[5] = vbl.intValue(i) == 1 ? "true" : "false";
                }
                this._tableModel.setNoSuchInstance(j, 5, false);
            }
        }
        for (i = 0; i < this._data.size() && i < cupNameVbl.size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            row[2] = new SnmpString(cupNameVbl.stringValue(i).trim());
            this._tableModel.setNoSuchInstance(i, 2, false);
        }
    }

    @Override
    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        int i;
        Array<SnmpPDU> cupNamePduList = new Array<SnmpPDU>();
        for (i = pdu.getVariables().size() - 1; i >= 0; --i) {
            SnmpOID oid = pdu.getVariables().get(i).getOid();
            if (!oid.startsWith(this._cficonCfgFileCmdErrorStringOid)) continue;
            SnmpPDU cupNamePDU = new SnmpPDU(-93, new VarBindList(1));
            SnmpVar var = pdu.getVariables().get(i).getVar();
            int[] varOid = pdu.getVariables().get(i).getOid().getValue();
            int[] index = new int[varOid.length - this._cficonCfgFileCmdErrorStringOid.length];
            System.arraycopy(varOid, this._cficonCfgFileCmdErrorStringOid.length, index, 0, index.length);
            cupNamePDU.addVar(new SnmpOID(_cficonCfgFileCupNameOid, index), var);
            cupNamePduList.addElement(cupNamePDU);
            pdu.getVariables().remove(i);
        }
        if (pdu.getVariables().size() > 0) {
            this.getPeer().set(pdu);
        }
        for (i = 0; i < cupNamePduList.size(); ++i) {
            this.getPeer().set((SnmpPDU)cupNamePduList.elementAt(i));
        }
    }

    @Override
    protected boolean validateChanges(Array cells, SnmpTableModel model, String[][] mibVars, String[] message, int offset) {
        boolean isUserAlertEnabled = false;
        int preRow = -1;
        for (int i = 0; i < cells.size(); ++i) {
            Object userAlertMode;
            Cell cell = (Cell)cells.elementAt(i);
            if (cell._row != preRow && ((String)(userAlertMode = this._tableModel.getValueAt(cell._row, 5))).equals("true")) {
                isUserAlertEnabled = true;
                break;
            }
            preRow = cell._row;
        }
        if (isUserAlertEnabled && JOptionPane.showConfirmDialog(this.getParent(), "User Alert Mode is enabled.\nContinue?", this._parent.getTitle(), 0) != 0) {
            return false;
        }
        return super.validateChanges(cells, model, mibVars, message, offset);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._statusTimer) {
            try {
                this._elapsedSecs += 3;
                this.pollSwitch();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        super.actionPerformed(e);
    }

    @Override
    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (ch == 'X') {
            int[] instance = this._tableModel.getIndex(this._table.getSelectedRows()[0]);
            String fileName = SnmpString.toString(instance, 2, instance[1] + 2).trim();
            try {
                EditFICONPortTable.fileCmd(this.getPeer(), instance, 3);
                EditFICONPortTable.fileCmd(this.getPeer(), instance, 4);
            }
            catch (SnmpException ex) {
                Util.errorMessage((Component)this.getParent(), ex.getMessage() + " (" + fileName + ")");
                return;
            }
            DMDialog portConfigDialog = DialogListener.getInstance().dialogAction("ficonPortConfigTable", instance);
            portConfigDialog.setTitle(Discover.getDeviceName() + " - VSAN " + instance[0] + " File " + fileName + " Port Configuration");
        } else if (ch == 'x') {
            boolean isUserAlertEnabled = ((String)this._tableModel.getValueAt(this._table.getSelectedRows()[0], 5)).equals("true");
            if (isUserAlertEnabled && JOptionPane.showConfirmDialog(this.getParent(), "User Alert Mode is enabled.\nContinue?", this._parent.getTitle(), 0) != 0) {
                return;
            }
            this.fileCommand(new SnmpInt(1));
            VarBindList vbl = new VarBindList(2);
            int[] selected = this._table.getSelectedRows();
            this._ccStatusPDU = new SnmpPDU(-96, vbl);
            vbl.add(new SnmpVarBind(new SnmpOID(this._cficonCfgFileCmdStatusOid, this._tableModel.getIndex(selected[0]))));
            vbl.add(new SnmpVarBind(new SnmpOID(this._cficonCfgFileCmdErrorStringOid, this._tableModel.getIndex(selected[0]))));
            this.setStatus("Applying file...");
            this._buttons[1].setEnabled(false);
            if (this._statusTimer == null) {
                this._statusTimer = new Timer(3000, this);
            }
            if (!this._statusTimer.isRunning()) {
                this._statusTimer.start();
            } else {
                this._statusTimer.restart();
            }
            this._elapsedSecs += 3;
            this._parent.setCursor(Cursor.getPredefinedCursor(3));
        } else if (ch == 'C') {
            if (e.getActionCommand().charAt(1) == 'l') {
                this.closeAction();
                return;
            }
            try {
                InsertFICONFile.getFiconVsans(this.getPeer());
            }
            catch (SnmpException ex) {
                Util.errorMessage((Component)this.getParent(), ex.getMessage());
                return;
            }
            super.doIt(ch, e);
        } else if (ch == '1') {
            int[] index = this._tableModel.getIndex(this._table.getSelectedRows()[0]);
            int fileCount = 0;
            for (int i = 0; i < this._data.size(); ++i) {
                if (this._tableModel.getIndex(i)[0] != index[0]) continue;
                ++fileCount;
            }
            if (fileCount >= 16) {
                Util.errorMessage((Component)this.getParent(), "Max number of files is 16.");
                return;
            }
            String source = SnmpString.toString(index, 2, index[1] + 2);
            String target = JOptionPane.showInputDialog(this.getParent(), "Enter target file name.", source, 3);
            if (target != null) {
                this.copyCommand("ficon vsan " + index[0] + " copy file " + source + " " + target + "\n");
                int[] fileIndex = new int[target.length() + 2];
                fileIndex[0] = index[0];
                fileIndex[1] = target.length();
                for (int i = 0; i < target.length(); ++i) {
                    fileIndex[i + 2] = target.charAt(i);
                }
                this.fetchRow(fileIndex);
            }
        } else {
            super.doIt(ch, e);
        }
    }

    void pollSwitch() throws Exception {
        if (!this.getPeer().getAddress().equals(this._address)) {
            this._buttons[1].setEnabled(true);
            this._statusTimer.stop();
            return;
        }
        SnmpPDU resp = this.getPeer().send(this._ccStatusPDU);
        VarBindList vbl = resp.getVariables();
        if (resp.getVar(0).getType() == 5) {
            SwingUtilities.invokeLater(new UpdateStatusWorker("Apply file Failed : n/a"));
            this._statusTimer.stop();
            this._parent.setCursor(Cursor.getDefaultCursor());
            return;
        }
        int state = ((SnmpInt)resp.getVar(0)).getValue();
        if (state == 2) {
            SwingUtilities.invokeLater(new UpdateStatusWorker("Applying file... [" + this._elapsedSecs + " secs]"));
            return;
        }
        this._statusTimer.stop();
        this._buttons[1].setEnabled(true);
        if (state == 1) {
            SwingUtilities.invokeLater(new UpdateStatusWorker("Apply file Success"));
        } else if (state == 3) {
            SwingUtilities.invokeLater(new UpdateStatusWorker("Apply file Failed : " + vbl.stringValue(1)));
        } else if (state == 4) {
            SwingUtilities.invokeLater(new UpdateStatusWorker("Apply file Failed : not applicable"));
        }
        this._parent.setCursor(Cursor.getDefaultCursor());
    }

    private void copyCommand(String cmd) throws IOException {
        Vsh vsh = Vsh.get(DeviceManager.getInstance(), Discover.getPeer(), ExternalTools.isUseSSH());
        vsh.sendAndReply(cmd);
        String reply = vsh.getReply();
        if (reply.toLowerCase().indexOf("unable to get allegiance") != -1) {
            throw new IOException(reply);
        }
        if (reply.indexOf("%") != -1) {
            int detected = reply.indexOf("detected") == -1 ? reply.length() : reply.indexOf("detected");
            throw new IOException(reply.substring(reply.indexOf("%") + 1, detected));
        }
    }

    private void fileCommand(SnmpInt op) throws SnmpException {
        int[] cficonCfgFileCmd = MibNode.get("cficonCfgFileCmd").getOid();
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        int[] selected = this._table.getSelectedRows();
        for (int i = 0; i < selected.length; ++i) {
            pdu.addVar(new SnmpOID(cficonCfgFileCmd, this._tableModel.getIndex(selected[i])), op);
        }
        pdu.setIgnoreSetCount(true);
        this.getPeer().set(pdu);
    }

    @Override
    protected DmTableModel buildTableModel() {
        return new FiconFileTableModel();
    }

    static class FiconFileTableModel
    extends DmTableModel {
        FiconFileTableModel() {
        }

        @Override
        protected SnmpVar getChangedCell(int row, int col) throws Exception {
            SnmpVar superValue = super.getChangedCell(row, col);
            if (col == 1) {
                return new SnmpString(superValue.toString().trim());
            }
            return superValue;
        }

        @Override
        public boolean isCellActive(int row, int col) {
            if (col == 1 || col == 2) {
                Object status = this.getValueAt(row, 3);
                return status != null && ((String)status).equals("unlocked");
            }
            return super.isCellActive(row, col);
        }
    }

    class UpdateStatusWorker
    implements Runnable {
        String _message;

        public UpdateStatusWorker(String message) {
            this._message = message;
        }

        @Override
        public void run() {
            EditFICONFileTable.this.setStatus(this._message);
        }
    }
}

