/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.ficon;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.dm.PhysicalStatus;
import com.cisco.dcbu.lib.jnm.SnmpFcAddressId;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.mds.ficon.FiconPortByIfIndexCache;
import com.cisco.dcbu.lib.mds.renderers.PortIndexRenderer;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.BorderCellRenderer;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;

public class EditFiconPortAttrForm
extends EditForm {
    static final int PORT_NUM = 0;
    static final int TYPENUM = 1;
    static final int SERIALNUM = 2;
    static final int PORT_ID = 3;
    static final int FCID = 4;
    static final int STATUS = 5;
    static final int NAME = 6;
    static final int UNIT_TYPE = 10;
    static final int ALERT = 11;
    static final int ALERTTIME = 12;
    static final int VSAN = 14;
    static final int IFOPERSTATUS = 15;
    int _vsan;
    SnmpVar _fcid;
    MibEnum[] _alertEnums = MibNode.get("cficonLinkIncident").getEnums();
    int[] cficonRunCfgStatusOid = MibNode.get("fcIfRNIDInfoStatus").getOid();
    int[] fcIfNxPortAddressOid = MibNode.get("fcIfNxPortAddress").getOid();
    protected Timer _statusTimer;

    public EditFiconPortAttrForm(String[] vars) {
        super(vars);
        this.setFindMode(true);
    }

    @Override
    protected Array getButtons() {
        Array btns = super.getButtons();
        btns.insertElementAt(new ClearMenuButton(null, "Clear", this.getPeer()), 0);
        return btns;
    }

    @Override
    protected void buildButtons() {
        super.buildButtons();
        this._buttons[0].setActionCommand("1");
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        boolean isEnabled = this._table.getSelectedRow() != -1;
        this.enableButton('1', isEnabled);
    }

    @Override
    protected void updateTable() {
        super.updateTable();
        this.enableButton('1', false);
    }

    @Override
    protected int[] getIndex(int varIndex) {
        if (varIndex == 5) {
            int index = super.getIndex()[0];
            int[] newIndex = new int[]{this._vsan, FiconPortByIfIndexCache.getInstance(this.getPeer()).getFiconPort(index)};
            return newIndex;
        }
        if (varIndex == 10 || varIndex == 11) {
            return super.getIndex();
        }
        int index = super.getIndex()[0];
        int[] newIndex = new int[]{index, this._vsan};
        return newIndex;
    }

    @Override
    protected void build() {
        super.build();
        this._statusTimer = new Timer(PhysicalStatus._StatusPollInterval * 1000, this);
        this._statusTimer.start();
    }

    @Override
    protected void buildTable() {
        super.buildTable();
        this._table.getColumnModel().getColumn(0).setCellRenderer(new PortVsanIndexRenderer(this.getPeer()));
        this._table.getColumnModel().getColumn(11).setCellRenderer(new AlertRenderer());
        this._table.removeColumn(this._table.getColumnModel().getColumn(12));
        boolean[] isEditable = this._tableModel.getEditable();
        isEditable[5] = false;
        this._tableModel.setEditable(isEditable);
        this._table.getSelectionModel().setSelectionMode(2);
    }

    @Override
    protected Object[] buildTableRow(int[] index) {
        Object[] row = new Object[this._vars.length + 4];
        row[0] = new SnmpOID(index);
        return row;
    }

    @Override
    protected void buildForm() {
        super.buildForm();
        this._values[11].setVisible(false);
        this._labels[11].setVisible(false);
    }

    @Override
    protected boolean isEditable(MibNode mibNode) {
        if (SnmpOID.equals(mibNode.getOid(), this.cficonRunCfgStatusOid)) {
            return false;
        }
        return super.isEditable(mibNode);
    }

    @Override
    protected void showError(int index, boolean isError) {
        if (index == 3) {
            return;
        }
        super.showError(index, isError);
    }

    @Override
    protected void setComponentValue(int i, SnmpVar v) {
        if (i == 11) {
            String alert = ((JLabel)this._values[10]).getText();
            if (alert.equals("none")) {
                ((JLabel)this._values[10]).setText("");
            } else {
                ((JLabel)this._values[10]).setText(alert + " @ " + v.toString());
            }
        } else {
            super.setComponentValue(i, v);
        }
    }

    @Override
    protected void setComponentLabel(JLabel l, SnmpVar v, String var, MibNode mibNode) {
        if (var.equals("fcIfRNIDInfoUnitType") && ((SnmpInt)v).getValue() == 4) {
            l.setText("");
            return;
        }
        super.setComponentLabel(l, v, var, mibNode);
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 10) {
            return new JLabel("Alert:", 4);
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    protected void preGet() throws SnmpException {
        block12: {
            int[] selected;
            int selectedVsan = -1;
            if (this._parentTable != null && (selected = this._parentTable.getSelectedRows()) != null) {
                selectedVsan = this._parentTable.getTableModel().getIndex(selected[0])[0];
            }
            try {
                if (this.isMultiple()) {
                    VarBindList vbl = new VarBindList();
                    for (int i = 0; i < this._parent._multipleIndeces.length; ++i) {
                        if (selectedVsan == -1) {
                            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cdpvmDynPortVsan").getOid(), this.getMultipleIndex(i)[0]), null));
                            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("vsanIfVsan").getOid(), this.getMultipleIndex(i)[0]), null));
                        }
                        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("ifOperStatus").getOid(), this.getMultipleIndex(i)[0]), null));
                    }
                    SnmpPDU resp = SnmpFetch.get(this.getPeer(), vbl);
                    if (resp == null || resp.getVariables().size() == 0) {
                        return;
                    }
                    vbl = resp.getVariables();
                    for (int i = 0; i < vbl.size(); ++i) {
                        int currRow;
                        int n = currRow = selectedVsan == -1 ? i / 3 : i;
                        if (currRow < this._data.size()) {
                            Object[] row = (Object[])this._data.elementAt(currRow);
                            int vsan = selectedVsan;
                            if (selectedVsan == -1) {
                                int dynamicVsan = vbl.intValue(i++);
                                int staticVsan = vbl.intValue(i++);
                                vsan = dynamicVsan == 0 ? staticVsan : dynamicVsan;
                            }
                            row[14] = new Integer(vsan);
                            int[] rowIndex = ((SnmpOID)row[0]).getValue();
                            int[] portVsanIndex = new int[rowIndex.length + 1];
                            System.arraycopy(rowIndex, 0, portVsanIndex, 0, rowIndex.length);
                            portVsanIndex[rowIndex.length] = vsan;
                            row[0] = new SnmpOID(portVsanIndex);
                            row[15] = new Integer(vbl.intValue(i));
                            continue;
                        }
                        break block12;
                    }
                    break block12;
                }
                if (selectedVsan == -1) {
                    SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
                    pdu.addNull(new SnmpOID(MibNode.get("cdpvmDynPortVsan").getOid(), this.getIndex()));
                    pdu.addNull(new SnmpOID(MibNode.get("vsanIfVsan").getOid(), this.getIndex()));
                    SnmpPDU resp = this.getPeer().send(pdu);
                    int dynamicVSAN = resp.getVariables().intValue(0);
                    this._vsan = dynamicVSAN == 0 ? resp.getVariables().intValue(1) : dynamicVSAN;
                } else {
                    this._vsan = selectedVsan;
                }
            }
            catch (SnmpException snmpException) {
                // empty catch block
            }
        }
    }

    @Override
    protected boolean isSkip(SnmpVar v, int rowNo) {
        Object[] row = (Object[])this._data.elementAt(rowNo);
        return v.getType() == 5 || (Integer)row[14] == 0;
    }

    @Override
    protected void updateForm(SnmpPDU pdu) {
        VarBindList vbl = new VarBindList();
        SnmpPDU fcidPdu = new SnmpPDU(-95, vbl);
        int[] fcidIndex = new int[]{this.getIndex()[0], this._vsan};
        vbl.add(new SnmpVarBind(new SnmpOID(this.fcIfNxPortAddressOid, fcidIndex), null));
        try {
            SnmpPDU response = this.getPeer().send(fcidPdu);
            this._fcid = response.getVariables().get(0).getVar();
            if (!(this._fcid instanceof SnmpString)) {
                this._fcid = new SnmpFcAddressId(new byte[0]);
            } else {
                int[] oid = response.getVariables().get(0).getOid().getValue();
                if (!SnmpOID.startsWith(oid, this.fcIfNxPortAddressOid) || oid[this.fcIfNxPortAddressOid.length] != fcidIndex[0]) {
                    this._fcid = new SnmpFcAddressId(new byte[0]);
                }
            }
        }
        catch (SnmpException ex) {
            this._fcid = new SnmpFcAddressId(new byte[0]);
        }
        super.updateForm(pdu);
        JLabel l = (JLabel)this._values[3];
        l.setText(SnmpFcAddressId.toHexString(((SnmpString)this._fcid).getValue()));
    }

    @Override
    protected void postProcessing() throws SnmpException {
        int[] index;
        if (!this.isMultiple()) {
            return;
        }
        VarBindList vbl = new VarBindList();
        VarBindList ficonVbl = new VarBindList();
        for (int i = 0; i < this._data.size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            if (((String)row[10]).startsWith("-")) {
                row[10] = "";
            }
            row[4] = new SnmpFcAddressId(new byte[0]);
            this._tableModel.setNoSuchInstance(i, 6, false);
            this._tableModel.setNoSuchInstance(i, 4, false);
            int[] fcidIndex = new int[2];
            int[] ficonIndex = new int[2];
            index = this._tableModel.getIndex(i);
            fcidIndex[0] = index[0];
            fcidIndex[1] = (Integer)row[14];
            ficonIndex[0] = (Integer)row[14];
            ficonIndex[1] = FiconPortByIfIndexCache.getInstance(this.getPeer()).getFiconPort(index[0]);
            vbl.add(new SnmpVarBind(new SnmpOID(this.fcIfNxPortAddressOid, fcidIndex), null));
            ficonVbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cficonPortRunCfgName").getOid(), ficonIndex), null));
        }
        if (vbl.size() > 0) {
            SnmpPDU resp = SnmpFetch.get(this.getPeer(), ficonVbl);
            if (resp != null && resp.getVariables().size() > 0) {
                ficonVbl = resp.getVariables();
                for (int i = 0; i < ficonVbl.size(); ++i) {
                    Object[] row = (Object[])this._data.elementAt(i);
                    row[6] = MibVariableFormat.cficonPortRunCfgName(ficonVbl.get(i).getVar());
                }
            }
            if ((resp = SnmpFetch.next(this.getPeer(), vbl)) != null && resp.getVariables().size() > 0) {
                vbl = resp.getVariables();
                for (int i = 0; i < vbl.size(); ++i) {
                    int[] oid = vbl.get(i).getOid().getValue();
                    if (!SnmpOID.startsWith(this._mibNodes[4].getOid(), oid)) continue;
                    Object[] row = (Object[])this._data.elementAt(i);
                    index = this._tableModel.getIndex(i);
                    int[] returnIndex = new int[3];
                    System.arraycopy(oid, this._mibNodes[4].getOid().length, returnIndex, 0, 3);
                    if (returnIndex[0] != index[0] || returnIndex[1] != (Integer)row[14]) continue;
                    row[4] = new SnmpFcAddressId(vbl.byteValue(i));
                }
            }
        }
    }

    @Override
    protected void postProcessFetchAllSetRowsPDU(Array changedRows, SnmpPDU pdu) {
        int[] index;
        VarBindList vbl = new VarBindList();
        VarBindList ficonVbl = new VarBindList();
        for (int i = 0; i < changedRows.size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(((Cell)changedRows.elementAt((int)i))._row);
            if (((String)row[10]).startsWith("-")) {
                row[10] = "";
            }
            row[4] = new SnmpFcAddressId(new byte[0]);
            int[] fcidIndex = new int[2];
            int[] ficonIndex = new int[2];
            index = this._tableModel.getIndex(((Cell)changedRows.elementAt((int)i))._row);
            fcidIndex[0] = index[0];
            fcidIndex[1] = (Integer)row[14];
            ficonIndex[0] = (Integer)row[14];
            ficonIndex[1] = FiconPortByIfIndexCache.getInstance(this.getPeer()).getFiconPort(index[0]);
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("fcIfNxPortAddress").getOid(), fcidIndex), null));
            ficonVbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cficonPortRunCfgName").getOid(), ficonIndex), null));
        }
        if (vbl.size() > 0) {
            try {
                SnmpPDU resp = SnmpFetch.get(this.getPeer(), ficonVbl);
                if (resp != null && resp.getVariables().size() > 0) {
                    ficonVbl = resp.getVariables();
                    for (int i = 0; i < ficonVbl.size(); ++i) {
                        Object[] row = (Object[])this._data.elementAt(((Cell)changedRows.elementAt((int)i))._row);
                        row[6] = MibVariableFormat.cficonPortRunCfgName(ficonVbl.get(i).getVar());
                    }
                }
                if ((resp = SnmpFetch.next(this.getPeer(), vbl)) != null && resp.getVariables().size() > 0) {
                    vbl = resp.getVariables();
                    for (int i = 0; i < vbl.size(); ++i) {
                        int[] oid = vbl.get(i).getOid().getValue();
                        if (!SnmpOID.startsWith(this._mibNodes[4].getOid(), oid)) continue;
                        Object[] row = (Object[])this._data.elementAt(((Cell)changedRows.elementAt((int)i))._row);
                        index = this._tableModel.getIndex(((Cell)changedRows.elementAt((int)i))._row);
                        int[] returnIndex = new int[3];
                        System.arraycopy(oid, this._mibNodes[4].getOid().length, returnIndex, 0, 3);
                        if (returnIndex[0] != index[0] || returnIndex[1] != (Integer)row[14]) continue;
                        row[4] = new SnmpFcAddressId(vbl.byteValue(i));
                        this._tableModel.setNoSuchInstance(i, 4, false);
                    }
                }
            }
            catch (SnmpException ex) {
                // empty catch block
            }
        }
    }

    @Override
    protected void fetchAllSetRows(Array cells, DmTableModel model) throws SnmpException {
        Array<Cell> changedRows = new Array<Cell>();
        VarBindList vbl = new VarBindList();
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            for (int j = 1; j < this._mibNodes.length; ++j) {
                int[] index = model.getIndex(cell._row, j);
                this.addVarfetchAllSetRows(vbl, index, cell._row, j);
                changedRows.addElement(new Cell(cell._row, j));
            }
        }
        SnmpPDU respPDU = null;
        if (vbl.size() > 0) {
            respPDU = this.sendFetchAllSetRowsPDU(vbl);
        }
        if (respPDU == null) {
            return;
        }
        for (int i = 0; i < changedRows.size() && i < respPDU.getVariables().size(); ++i) {
            SnmpVarBind vb = respPDU.getVariables().get(i);
            Cell fetchCell = (Cell)changedRows.elementAt(i);
            Object fetchObject = model.toCellEditTable(this._mibNodes[fetchCell._col], respPDU, vb, this._vars[fetchCell._col - 1], null, fetchCell._row, fetchCell._col);
            Object[] row = (Object[])model.getData().elementAt(fetchCell._row);
            row[fetchCell._col] = fetchObject;
        }
        this.postProcessFetchAllSetRowsPDU(changedRows, respPDU);
    }

    boolean isOldEntrySelected() {
        if (this.isMultiple()) {
            int[] rows = this._table.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                Object status = this._tableModel.getValueAt(rows[i], 5);
                if (status == null || !((String)status).equals("old")) continue;
                return true;
            }
        } else {
            return ((JLabel)this._values[4]).getText().equals("old");
        }
        return false;
    }

    int[] getOldEntrySelected(int[] selectedRows) {
        Array<Integer> list = new Array<Integer>();
        for (int i = 0; i < selectedRows.length; ++i) {
            Object status = this._tableModel.getValueAt(selectedRows[i], 5);
            if (status == null || !((String)status).equals("old")) continue;
            list.addElement(new Integer(selectedRows[i]));
        }
        int[] newList = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            newList[i] = (Integer)list.elementAt(i);
        }
        return newList;
    }

    void clearStatus() throws Exception {
        int[] rows = new int[]{};
        if (this.isMultiple()) {
            rows = this.getOldEntrySelected(this._table.getSelectedRows());
        }
        Array<Cell> changedCells = new Array<Cell>(rows.length);
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        if (this.isMultiple()) {
            for (int i = 0; i < rows.length; ++i) {
                pdu.addVar(new SnmpOID(this.cficonRunCfgStatusOid, this._tableModel.getIndex(rows[i], 5)), new SnmpInt(2));
                changedCells.addElement(new Cell(rows[i], 5));
            }
        } else {
            pdu.addVar(new SnmpOID(this.cficonRunCfgStatusOid, this.getIndex(4)), new SnmpInt(2));
        }
        this.getPeer().set(pdu);
        if (this.isMultiple()) {
            this.fetchAllSetRows(changedCells, this._tableModel);
            this.postProcessFetchAllSetRowsPDU(changedCells, null);
            this.updateTable();
        } else {
            this.get();
        }
    }

    void clearAlert() throws Exception {
        int i;
        int[] rows = new int[]{};
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        if (this.isMultiple()) {
            rows = this._table.getSelectedRows();
            for (i = 0; i < rows.length; ++i) {
                int ifIndex = ((SnmpOID)this._tableModel.getValueAt(rows[i], 0)).getValue()[0];
                pdu.addVar(new SnmpOID(MibNode.get("cficonLinkIncidentClear").getOid(), ifIndex), new SnmpInt(1));
            }
        } else {
            pdu.addVar(new SnmpOID(MibNode.get("cficonLinkIncidentClear").getOid(), this.getIndex()), new SnmpInt(1));
        }
        this.getPeer().set(pdu);
        if (this.isMultiple()) {
            for (i = 0; i < rows.length; ++i) {
                Object[] cols = (Object[])this._data.elementAt(rows[i]);
                cols[11] = "";
            }
        } else {
            ((JLabel)this._values[11]).setText("");
        }
    }

    void pollAlert() throws Exception {
        int i;
        if (this._parent == null) {
            this._statusTimer.stop();
            return;
        }
        String[] vars = new String[]{"cficonLinkIncident", "cficonLinkIncidentTime"};
        VarBindList vbl = new VarBindList();
        int[][] oids = new int[vars.length][];
        for (i = 0; i < vars.length; ++i) {
            oids[i] = MibNode.get(vars[i]).getOid();
        }
        if (this.isMultiple()) {
            for (i = 0; i < this._tableModel.getRowCount(); ++i) {
                int ifIndex = ((SnmpOID)this._tableModel.getValueAt(i, 0)).getValue()[0];
                for (int j = 0; j < oids.length; ++j) {
                    vbl.add(oids[j], ifIndex);
                }
            }
        } else {
            for (int j = 0; j < oids.length; ++j) {
                vbl.add(oids[j], this.getIndex());
            }
        }
        if (vbl.size() == 0) {
            return;
        }
        SnmpPDU resp = SnmpFetch.get(this.getPeer(), vbl);
        vbl = resp.getVariables();
        if (this.isMultiple()) {
            Array data = this._tableModel.getData();
            int i2 = 0;
            int row = 0;
            while (i2 < vbl.size()) {
                Object[] cols = (Object[])data.elementAt(row);
                int alert = vbl.intValue(i2);
                cols[11] = alert == 1 ? null : MibEnum.getEnum(this._alertEnums, alert) + " @ " + vbl.stringValue(i2 + 1);
                i2 += vars.length;
                ++row;
            }
        } else {
            int alert = vbl.intValue(0);
            ((JLabel)this._values[11]).setText(alert == 1 ? "" : MibEnum.getEnum(this._alertEnums, alert) + " @ " + vbl.stringValue(1));
        }
    }

    @Override
    public void dispose() {
        if (this._statusTimer != null) {
            this._statusTimer.stop();
        }
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._statusTimer) {
            try {
                this.pollAlert();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        super.actionPerformed(e);
    }

    @Override
    protected DmTableModel buildTableModel() {
        return new SnmpFiconPortAttrTableModel();
    }

    class ClearMenuButton
    extends MenuButton {
        SnmpPeer _peer;
        String[] _clearMenu;

        public ClearMenuButton(JMenu menu, String name, SnmpPeer peer) {
            super(menu, name);
            this._clearMenu = new String[]{"Old Attributes", "Alert"};
            this._peer = peer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block9: {
                if (this._menu == null) {
                    this._menu = new JMenu();
                    this.buildMenu(this._clearMenu);
                }
                if (e.getSource() instanceof JMenuItem) {
                    try {
                        if (((JMenuItem)e.getSource()).getText().startsWith("Old")) {
                            EditFiconPortAttrForm.this.clearStatus();
                            break block9;
                        }
                        EditFiconPortAttrForm.this.clearAlert();
                    }
                    catch (SnmpException ex) {
                        Util.errorMessage((Component)DeviceManager.getInstance(), ex.getMessage());
                    }
                    catch (Exception ex) {
                        if (SnmpSession.isTrace()) {
                            ex.printStackTrace();
                        }
                        Util.errorMessage((Component)DeviceManager.getInstance(), ex.getMessage());
                    }
                    catch (Error ex) {
                        Util.errorMessage((Component)EditFiconPortAttrForm.this._parent, ex.getMessage());
                    }
                } else {
                    super.actionPerformed(e);
                    JMenuItem item = this._menu.getItem(0);
                    item.setEnabled(EditFiconPortAttrForm.this.isOldEntrySelected());
                }
            }
        }
    }

    static class PortVsanIndexRenderer
    extends PortIndexRenderer {
        SnmpPeer _peer;

        public PortVsanIndexRenderer(SnmpPeer peer) {
            super(peer);
            this._peer = peer;
        }

        @Override
        public String getLabel(int[] index) {
            String portString = super.getLabel(index);
            if (index.length <= 1) {
                return portString;
            }
            StringBuffer sb = new StringBuffer();
            sb.append(portString);
            sb.append(", ");
            sb.append(Integer.toString(index[1]));
            return sb.toString();
        }
    }

    static class AlertRenderer
    extends BorderCellRenderer {
        AlertRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null && value.toString().length() > 0) {
                this.setBackground(Color.yellow);
            } else {
                this.setBackground(table.getBackground());
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    class SnmpFiconPortAttrTableModel
    extends DmTableModel {
        SnmpFiconPortAttrTableModel() {
        }

        @Override
        public int[] getIndex(int row, int col) {
            if (col == 11 || col == 12) {
                int[] newIndex = new int[]{super.getIndex(row, col)[0]};
                return newIndex;
            }
            if (col == 6) {
                if (row >= EditFiconPortAttrForm.this._data.size() || ((Object[])EditFiconPortAttrForm.this._data.elementAt(row))[14] == null) {
                    return super.getIndex(row, col);
                }
                int[] index = super.getIndex(row, col);
                int[] newIndex = new int[]{(Integer)((Object[])EditFiconPortAttrForm.this._data.elementAt(row))[14], FiconPortByIfIndexCache.getInstance(EditFiconPortAttrForm.this.getPeer()).getFiconPort(index[0])};
                return newIndex;
            }
            return super.getIndex(row, col);
        }

        @Override
        public Object toCellEditTable(MibNode mibNode, SnmpPDU pdu, SnmpVarBind vb, String var, SnmpOID index, int row, int col) {
            if (col == 12) {
                Object[] cols = (Object[])EditFiconPortAttrForm.this._data.elementAt(row);
                Object alert = this.getValueAt(row, 11);
                cols[11] = alert == null || ((String)alert).equals("none") ? null : (String)alert + " @ " + vb.getVar().toString();
                return null;
            }
            if (col == 5) {
                Object[] cols = (Object[])EditFiconPortAttrForm.this._data.elementAt(row);
                if (((SnmpInt)vb.getVar()).getValue() == 2) {
                    cols[3] = null;
                    return null;
                }
                return super.toCellEditTable(mibNode, pdu, vb, var, index, row, col);
            }
            if (col == 10) {
                Object[] cols = (Object[])EditFiconPortAttrForm.this._data.elementAt(row);
                if (cols[5] == null) {
                    return "";
                }
                return super.toCellEditTable(mibNode, pdu, vb, var, index, row, col);
            }
            return super.toCellEditTable(mibNode, pdu, vb, var, index, row, col);
        }
    }
}

