/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.ficon;

import com.cisco.dcbu.dm.DMDialog;
import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.DialogListener;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dmdb.andiamo.elements.Port;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.mds.ficon.FiconPortByIfIndexCache;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;

public class EditFiconVsanTable
extends EditTable {
    static final int DOMAIN_ID = 7;
    static final int USER_ALERT_MODE = 11;
    static final int[] _dmDomainIdOid = MibNode.get("dmDomainId").getOid();
    static final int[] _rscnMultiPidEnableOid = MibNode.get("rscnMultiPidEnable").getOid();
    static final int[] _cficonVsanAutoSavePortAddrCfgOid = MibNode.get("cficonVsanAutoSavePortAddrCfg").getOid();
    private static final String[][] BTNS = new String[][]{{"Port Configuration...", "x"}, {"Port Attributes...", "1"}, {"Director History...", "2"}};

    public EditFiconVsanTable(String[] vars) {
        super(vars);
    }

    @Override
    protected void postProcessing() throws SnmpException {
        VarBindList vbl = new VarBindList();
        for (int i = 0; i < this._data.size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            int vsan = ((SnmpOID)row[0]).getValue()[0];
            vbl.add(new SnmpVarBind(new SnmpOID(_dmDomainIdOid, vsan), null));
            row[7] = "";
        }
        SnmpPDU resp = SnmpFetch.get(this.getPeer(), vbl);
        if (resp == null || resp.getVariables().size() == 0) {
            return;
        }
        vbl = resp.getVariables();
        for (int i = 0; i < vbl.size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            row[7] = this._tableModel.toCellEditTable(this._mibNodes[7], resp, vbl.get(i), "dmDomainId", null, i, 7);
        }
    }

    @Override
    protected Array getButtons() {
        Array btns = super.getButtons();
        for (int i = 0; i < BTNS.length; ++i) {
            btns.insertElementAt(BTNS[i][0], i);
        }
        return btns;
    }

    @Override
    protected void buildButtons() {
        super.buildButtons();
        for (int i = 0; i < BTNS.length; ++i) {
            this._buttons[i].setActionCommand(BTNS[i][1]);
        }
        this.valueChanged(null);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        for (int i = 0; i < BTNS.length; ++i) {
            this._buttons[i].setEnabled(this._table.getSelectedRowCount() == 1);
        }
    }

    @Override
    protected boolean validateChanges(Array cells, SnmpTableModel model, String[][] mibVars, String[] message, int offset) {
        boolean isUserAlertEnabled = false;
        int preRow = -1;
        for (int i = 0; i < cells.size(); ++i) {
            Object userAlertMode;
            Cell cell = (Cell)cells.elementAt(i);
            if (cell._row != preRow && ((Boolean)(userAlertMode = this._tableModel.getValueAt(cell._row, 11))).booleanValue()) {
                isUserAlertEnabled = true;
                break;
            }
            preRow = cell._row;
        }
        if (isUserAlertEnabled && JOptionPane.showConfirmDialog(this.getParent(), "User Alert Mode is enabled.\nContinue?", this._parent.getTitle(), 0) != 0) {
            return false;
        }
        return super.validateChanges(cells, model, mibVars, message, offset);
    }

    @Override
    protected void updateTable() {
        super.updateTable();
        FiconPortByIfIndexCache.getInstance(this.getPeer()).setIsFiconEnabled(this._data.size() > 0, Discover.isSysVersionGreaterThanEqual("3.0(0)"));
    }

    @Override
    protected void delete() throws SnmpException {
        super.delete();
        FiconPortByIfIndexCache.getInstance(this.getPeer()).setIsFiconEnabled(this._data.size() > 0, Discover.isSysVersionGreaterThanEqual("3.0(0)"));
    }

    @Override
    public void dispose() {
        String[] dList;
        super.dispose();
        DMDialog d = DialogListener.getInstance().getDialog("ficonActivePorts");
        if (d != null) {
            DialogListener.getInstance().remove("ficonActivePorts");
            d.dispose();
        }
        if ((dList = DialogListener.getInstance().getDialogAll("FICON_Ports")) != null) {
            for (int i = 0; i < dList.length; ++i) {
                DMDialog ed = DialogListener.getInstance().getDialog(dList[i]);
                if (ed == null) continue;
                ed.dispose();
            }
        }
        if ((d = DialogListener.getInstance().getDialog("ficonDirectorHistory")) != null) {
            DialogListener.getInstance().remove("ficonDirectorHistory");
            d.dispose();
        }
    }

    @Override
    protected void doIt(char ch, ActionEvent e) throws Exception {
        int[] instance;
        int[] selected = this._table.getSelectedRows();
        int[] nArray = instance = this._table.getSelectedRowCount() > 0 ? this._tableModel.getIndex(selected[0]) : null;
        if (ch == 'x') {
            DMDialog dlg = DialogListener.getInstance().dialogAction("ficonActivePorts", instance);
            if (dlg != null) {
                dlg.setTitle(Discover.getDeviceName() + " - VSAN " + instance[0] + " Port Configuration");
            }
        } else if (ch == '1') {
            VarBindList vbl = new VarBindList();
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("vsanMembershipSummaryInterface").getOid(), instance[0])));
            SnmpPDU resp = SnmpFetch.getBulk(this.getPeer(), vbl);
            vbl = resp.getVariables();
            if (vbl.size() == 0) {
                Util.errorMessage((Component)this.getParent(), "No ports on VSAN " + instance[0]);
                return;
            }
            int[][] ifIndeces = new int[vbl.size()][1];
            for (int i = 0; i < vbl.size(); ++i) {
                ifIndeces[i][0] = vbl.intValue(i);
            }
            PhysicalView view = DeviceManager.getInstance().getView();
            Array elements = view.getElements();
            block1: for (int i = elements.size() - 1; i >= 0; --i) {
                PhysicalElement element = (PhysicalElement)elements.elementAt(i);
                if (!(element instanceof Port)) continue;
                element.setSelected(false);
                for (int j = 0; j < ifIndeces.length; ++j) {
                    if (element.getIndex()[0] != ifIndeces[j][0]) continue;
                    element.setSelected(true);
                    continue block1;
                }
            }
            view.repaint();
            DMDialog dlg = DialogListener.getInstance().dialogAction("FICON_Ports", ifIndeces);
            if (dlg != null) {
                dlg.setParentTable(this);
                int tabNo = dlg.getTabFromTitle("FICON");
                dlg.setTab(tabNo);
            }
        } else if (ch == '2') {
            DMDialog dlg = DialogListener.getInstance().dialogAction("ficonDirectorHistory", instance);
            if (dlg != null) {
                dlg.setTitle(Discover.getDeviceName() + " - VSAN " + instance[0] + " Director History");
            }
        } else {
            super.doIt(ch, e);
        }
    }
}

