/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.ficon;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.lib.jnm.SnmpFiconPort;
import com.cisco.dcbu.lib.mds.PortChooser;
import com.cisco.dcbu.lib.mds.ficon.FiconPortByIfIndexCache;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.util.Array;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class FiconLogicalMenuButton
extends MenuButton {
    SnmpPeer _peer;
    EditForm _parent;
    static final int[] cficonLogicReservedPNOid = MibNode.get("cficonLogicReservedPN").getOid();

    public FiconLogicalMenuButton(JMenu menu, SnmpPeer peer) {
        super(menu);
        this._peer = peer;
        this._parent = null;
    }

    public void setParent(EditForm parent) {
        this._parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._menu == null) {
            this._menu = new JMenu();
            Object[] names = FiconLogicalMenuButton.getLogicalFiconPorts(this._peer);
            if (names == null || names.length == 0) {
                this.setEnabled(false);
                return;
            }
            this.buildMenu(names);
        }
        if (e.getSource() instanceof JMenuItem) {
            ((FieldPanel)this.getParent()).setText(Integer.toString(SnmpFiconPort.parse(((JMenuItem)e.getSource()).getText(), true)));
            if (this._parent != null) {
                this._parent.setChanged((FieldPanel)this.getParent());
            }
        }
        super.actionPerformed(e);
    }

    public static String[] getLogicalFiconPorts(SnmpPeer peer) {
        return FiconLogicalMenuButton.getLogicalFiconPorts(peer, false);
    }

    public static String[] getLogicalFiconPorts(SnmpPeer peer, boolean checkFiconAssigned) {
        int i;
        Array<String> ficonPortList = new Array<String>();
        if (Discover.isSysVersionGreaterThanEqual("3.0(0)")) {
            byte[] ports = FiconLogicalMenuButton.getLogicalReserved(peer);
            for (i = 0; i < ports.length; ++i) {
                int ficonPortNum = ports[i] & 0xFF;
                boolean found = true;
                if (checkFiconAssigned) {
                    int ficonPortAddr = FiconPortByIfIndexCache.getInstance(peer).getFiconPortAddr(ficonPortNum);
                    Array list = FiconPortByIfIndexCache.getInstance(peer).getFiconIfIndexByPortAddr(ficonPortAddr);
                    if (list != null && list.size() > 0) {
                        found = false;
                    }
                }
                if (!found) continue;
                ficonPortList.addElement(SnmpString.toHexString(ports, i, i + 1).toUpperCase());
            }
        } else {
            int[] range = DmSystem.getFiconPortLogicMinMax();
            for (i = range[0]; i <= range[1]; ++i) {
                Array list = FiconPortByIfIndexCache.getInstance(peer).getFiconIfIndexByPortAddr(i);
                if (list != null) continue;
                ficonPortList.addElement(SnmpFiconPort.toString(i));
            }
        }
        if (ficonPortList.size() == 0) {
            return null;
        }
        String[] names = new String[ficonPortList.size()];
        for (i = 0; i < names.length; ++i) {
            names[i] = (String)ficonPortList.elementAt(i);
        }
        return names;
    }

    public static String[] getLogicalInterfaces(SnmpPeer peer, boolean checkFiconAssigned) throws SnmpException {
        int[] logicalInterfaceList = PortChooser.fetchInterfaces(peer, 6, Discover.getRoot());
        Array<String> ficonPortList = new Array<String>();
        for (int i = 0; i < logicalInterfaceList.length; ++i) {
            if (checkFiconAssigned) {
                int ficonPort = FiconPortByIfIndexCache.getInstance(peer).getFiconPort(logicalInterfaceList[i]);
                if (ficonPort != -1) continue;
                ficonPortList.addElement(Discover.getRoot().ifIndexToName(logicalInterfaceList[i]));
                continue;
            }
            ficonPortList.addElement(Discover.getRoot().ifIndexToName(logicalInterfaceList[i]));
        }
        if (ficonPortList.size() == 0) {
            return null;
        }
        Object[] names = new String[ficonPortList.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)ficonPortList.elementAt(i);
        }
        Arrays.sort(names);
        return names;
    }

    public static byte[] getLogicalReserved(SnmpPeer peer) {
        byte[] ports = new byte[]{};
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        pdu.addVar(new SnmpOID(cficonLogicReservedPNOid, 0));
        try {
            SnmpPDU response = peer.set(pdu);
            ports = response.getVariables().byteValue(0);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
        return ports;
    }
}

