/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.ip;

import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;

public class InsertAddrTypeAddr
extends InsertForm {
    static final int ADDR_TYPE = 0;
    static final int ADDRESS = 1;
    byte[] _ipAddr;
    String _dnsAddr;
    int _addrType;

    public InsertAddrTypeAddr(InsertDialog parent, EditTable table) {
        super(parent, table);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 1) {
            SnmpInt var = (SnmpInt)super.getComponentValue(0);
            this._addrType = var.getValue();
            String addr = this.getComponentText(1);
            if (this._addrType == 1 || this._addrType == 2) {
                this._ipAddr = SnmpIpAddress.parse(addr);
                return new SnmpString(this._ipAddr);
            }
            return this.getDnsAddress(addr);
        }
        return super.getComponentValue(index);
    }

    protected SnmpVar getDnsAddress(String addr) throws NumberFormatException, Exception {
        this._addrType = 16;
        this._dnsAddr = new SnmpString(addr).toString();
        return new SnmpString(addr);
    }

    public static byte[] checkIpAddress(String addr) throws SnmpException {
        byte[] ipAddr = SnmpIpAddress.parse(addr);
        return ipAddr;
    }

    @Override
    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        if (this._addrType == 16) {
            int[] index = new int[this._dnsAddr.length() + 2];
            index[0] = this._addrType;
            int[] ipAddress = SnmpString.valueOf(this._dnsAddr.getBytes(), true);
            System.arraycopy(ipAddress, 0, index, 1, ipAddress.length);
            return index;
        }
        int[] index = new int[this._ipAddr.length + 2];
        index[0] = this._addrType;
        index[1] = this._addrType == 16 ? this._dnsAddr.length() : this._ipAddr.length;
        int[] ipAddress = SnmpString.valueOf(this._ipAddr, false);
        System.arraycopy(ipAddress, 0, index, 2, ipAddress.length);
        return index;
    }
}

