/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.ip;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.lib.mds.VsanIdMenuButton;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.FieldPanel;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class InsertIPRoute
extends InsertForm {
    static final int GATEWAY = 2;
    static final int METRIC = 3;
    static final int INTERFACE = 4;

    public InsertIPRoute(InsertDialog parent, EditTable table) {
        super(parent, table);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 4) {
            FieldPanel f = new FieldPanel(mibNode.getMaxWidth(), (JComponent)new VsanIdMenuButton(null, this.getPeer(), 2, Discover.getRoot()));
            return f;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected void buildForm() {
        super.buildForm();
        this.setComponentText(1, "255.255.255.0");
        this.setComponentText(2, "0.0.0.0");
        this.setComponentText(3, "-1");
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 4) {
            String ifName = ((FieldPanel)this._values[index]).getText();
            return new SnmpInt(Discover.getRoot().nameToIfIndex(ifName));
        }
        return super.getComponentValue(index);
    }

    @Override
    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        int[] index = super.getInsertIndex(values);
        byte[] addrB = SnmpIpAddress.parse(((JTextField)this._values[2]).getText());
        int[] newIndex = new int[index.length + 1];
        System.arraycopy(index, 0, newIndex, 0, index.length - addrB.length);
        newIndex[newIndex.length - addrB.length - 1] = 0;
        System.arraycopy(index, index.length - addrB.length, newIndex, newIndex.length - addrB.length, addrB.length);
        return newIndex;
    }
}

